/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.Tools;

import deadbeef.Tools.PngEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PngEncoderB
extends PngEncoder {
    private static final byte[] PLTE = new byte[]{80, 76, 84, 69};
    private static final byte[] TRNS = new byte[]{116, 82, 78, 83};
    protected BufferedImage image;
    protected WritableRaster wRaster;
    protected int tType;

    public PngEncoderB() {
        this(null, false, 0, 0);
    }

    public PngEncoderB(BufferedImage image) {
        this(image, false, 0, 0);
    }

    public PngEncoderB(BufferedImage image, boolean encodeAlpha) {
        this(image, encodeAlpha, 0, 0);
    }

    public PngEncoderB(BufferedImage image, boolean encodeAlpha, int whichFilter) {
        this(image, encodeAlpha, whichFilter, 0);
    }

    public PngEncoderB(BufferedImage image, boolean encodeAlpha, int whichFilter, int compLevel) {
        this.image = image;
        this.encodeAlpha = encodeAlpha;
        this.setFilter(whichFilter);
        if (compLevel >= 0 && compLevel <= 9) {
            this.compressionLevel = compLevel;
        }
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.pngBytes = null;
    }

    @Override
    public byte[] pngEncode(boolean encodeAlpha) {
        byte[] pngIdBytes = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        if (this.image == null) {
            System.err.println("pngEncode: image is null; returning null");
            return null;
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        if (!this.establishStorageInfo()) {
            System.err.println("pngEncode: cannot establish storage info");
            return null;
        }
        this.pngBytes = new byte[(this.width + 1) * this.height * 3 + 200];
        this.maxPos = 0;
        this.bytePos = this.writeBytes(pngIdBytes, 0);
        this.writeHeader();
        if (this.writeImageData()) {
            this.writeEnd();
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.maxPos);
        } else {
            System.err.println("pngEncode: writeImageData failed => null");
            this.pngBytes = null;
        }
        return this.pngBytes;
    }

    @Override
    public byte[] pngEncode() {
        return this.pngEncode(this.encodeAlpha);
    }

    protected boolean establishStorageInfo() {
        this.wRaster = this.image.getRaster();
        int dataBytes = this.wRaster.getNumDataElements();
        this.tType = this.wRaster.getTransferType();
        if (this.tType == 0 && dataBytes == 4 || this.tType == 3 && dataBytes == 1 || this.tType == 1 && dataBytes == 1) {
            this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        } else if (this.tType == 0 && dataBytes == 1) {
            this.bytesPerPixel = 1;
            this.encodeAlpha = false;
        } else {
            System.err.println("PNG encoder cannot establish storage info:");
            System.err.println("  TransferType == " + this.tType);
            System.err.println("  NumDataElements == " + dataBytes);
            return false;
        }
        return true;
    }

    @Override
    protected void writeHeader() {
        int startPos = this.bytePos = this.writeInt4(13, this.bytePos);
        this.bytePos = this.writeBytes(IHDR, this.bytePos);
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.bytePos = this.writeInt4(this.width, this.bytePos);
        this.bytePos = this.writeInt4(this.height, this.bytePos);
        this.bytePos = this.writeByte(8, this.bytePos);
        this.bytePos = this.bytesPerPixel != 1 ? this.writeByte(this.encodeAlpha ? 6 : 2, this.bytePos) : this.writeByte(3, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.crc.reset();
        this.crc.update(this.pngBytes, startPos, this.bytePos - startPos);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected void writePalette(IndexColorModel icm) {
        byte[] redPal = new byte[256];
        byte[] greenPal = new byte[256];
        byte[] bluePal = new byte[256];
        byte[] allPal = new byte[768];
        icm.getReds(redPal);
        icm.getGreens(greenPal);
        icm.getBlues(bluePal);
        int i = 0;
        while (i < 256) {
            allPal[i * 3] = redPal[i];
            allPal[i * 3 + 1] = greenPal[i];
            allPal[i * 3 + 2] = bluePal[i];
            ++i;
        }
        this.bytePos = this.writeInt4(768, this.bytePos);
        this.bytePos = this.writeBytes(PLTE, this.bytePos);
        this.crc.reset();
        this.crc.update(PLTE);
        this.bytePos = this.writeBytes(allPal, this.bytePos);
        this.crc.update(allPal);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected void writeAlpha(IndexColorModel icm) {
        byte[] alpha = new byte[256];
        icm.getAlphas(alpha);
        this.bytePos = this.writeInt4(256, this.bytePos);
        this.bytePos = this.writeBytes(TRNS, this.bytePos);
        this.crc.reset();
        this.crc.update(TRNS);
        this.bytePos = this.writeBytes(alpha, this.bytePos);
        this.crc.update(alpha);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    @Override
    protected boolean writeImageData() {
        int rowsLeft = this.height;
        int startRow = 0;
        int type = this.image.getType();
        Deflater scrunch = new Deflater(this.compressionLevel);
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream(1024);
        DeflaterOutputStream compBytes = new DeflaterOutputStream((OutputStream)outBytes, scrunch);
        if (this.bytesPerPixel == 1) {
            this.writePalette((IndexColorModel)this.image.getColorModel());
            this.writeAlpha((IndexColorModel)this.image.getColorModel());
        }
        try {
            while (rowsLeft > 0) {
                int nRows = Math.min(Short.MAX_VALUE / (this.width * (this.bytesPerPixel + 1)), rowsLeft);
                nRows = Math.max(nRows, 1);
                byte[] scanLines = new byte[this.width * nRows * this.bytesPerPixel + nRows];
                if (this.filter == 1) {
                    this.leftBytes = new byte[16];
                }
                if (this.filter == 2) {
                    this.priorRow = new byte[this.width * this.bytesPerPixel];
                }
                Object data = this.wRaster.getDataElements(0, startRow, this.width, nRows, null);
                byte[] pixels = null;
                int[] iPixels = null;
                short[] sPixels = null;
                if (this.tType == 0) {
                    pixels = (byte[])data;
                } else if (this.tType == 3) {
                    iPixels = (int[])data;
                } else if (this.tType == 1) {
                    sPixels = (short[])data;
                }
                int scanPos = 0;
                int readPos = 0;
                int startPos = 1;
                int i = 0;
                while (i < this.width * nRows) {
                    int pxl;
                    if (i % this.width == 0) {
                        scanLines[scanPos++] = (byte)this.filter;
                        startPos = scanPos;
                    }
                    if (this.bytesPerPixel == 1) {
                        scanLines[scanPos++] = pixels[readPos++];
                    } else if (this.tType == 0) {
                        scanLines[scanPos++] = pixels[readPos++];
                        scanLines[scanPos++] = pixels[readPos++];
                        scanLines[scanPos++] = pixels[readPos++];
                        if (this.encodeAlpha) {
                            scanLines[scanPos++] = pixels[readPos++];
                        } else {
                            ++readPos;
                        }
                    } else if (this.tType == 1) {
                        pxl = sPixels[readPos++];
                        if (type == 8) {
                            scanLines[scanPos++] = (byte)(pxl >> 8 & 0xF8);
                            scanLines[scanPos++] = (byte)(pxl >> 2 & 0xFC);
                        } else {
                            scanLines[scanPos++] = (byte)(pxl >> 7 & 0xF8);
                            scanLines[scanPos++] = (byte)(pxl >> 2 & 0xF8);
                        }
                        scanLines[scanPos++] = (byte)(pxl << 3 & 0xF8);
                    } else {
                        pxl = iPixels[readPos++];
                        scanLines[scanPos++] = (byte)(pxl >> 16 & 0xFF);
                        scanLines[scanPos++] = (byte)(pxl >> 8 & 0xFF);
                        scanLines[scanPos++] = (byte)(pxl & 0xFF);
                        if (this.encodeAlpha) {
                            scanLines[scanPos++] = (byte)(pxl >> 24 & 0xFF);
                        }
                    }
                    if (i % this.width == this.width - 1 && this.filter != 0) {
                        if (this.filter == 1) {
                            this.filterSub(scanLines, startPos, this.width);
                        }
                        if (this.filter == 2) {
                            this.filterUp(scanLines, startPos, this.width);
                        }
                    }
                    ++i;
                }
                compBytes.write(scanLines, 0, scanPos);
                startRow += nRows;
                rowsLeft -= nRows;
            }
            compBytes.close();
            byte[] compressedLines = outBytes.toByteArray();
            int nCompressed = compressedLines.length;
            this.crc.reset();
            this.bytePos = this.writeInt4(nCompressed, this.bytePos);
            this.bytePos = this.writeBytes(IDAT, this.bytePos);
            this.crc.update(IDAT);
            this.bytePos = this.writeBytes(compressedLines, nCompressed, this.bytePos);
            this.crc.update(compressedLines, 0, nCompressed);
            this.crcValue = this.crc.getValue();
            this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
            scrunch.finish();
            return true;
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
    }
}

