/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.Tools;

import deadbeef.Tools.OctTreeQuantizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class QuantizeFilter {
    protected static final int[] matrix;
    private final int sum = 16;
    private boolean dither;
    private int numColors = 255;
    private boolean serpentine = true;

    static {
        int[] nArray = new int[9];
        nArray[5] = 7;
        nArray[6] = 3;
        nArray[7] = 5;
        nArray[8] = 1;
        matrix = nArray;
    }

    public void setNumColors(int numColors) {
        this.numColors = Math.min(Math.max(numColors, 8), 256);
    }

    private static int clamp(int c) {
        if (c < 0) {
            return 0;
        }
        if (c > 255) {
            return 255;
        }
        return c;
    }

    public int getNumColors() {
        return this.numColors;
    }

    public void setDither(boolean dither) {
        this.dither = dither;
    }

    public boolean getDither() {
        return this.dither;
    }

    public void setSerpentine(boolean serpentine) {
        this.serpentine = serpentine;
    }

    public boolean getSerpentine() {
        return this.serpentine;
    }

    public int[] quantize(int[] inPixels, byte[] outPixels, int width, int height, int numColors, boolean dither, boolean serpentine) {
        int count = width * height;
        OctTreeQuantizer quantizer = new OctTreeQuantizer();
        quantizer.setup(numColors);
        quantizer.addPixels(inPixels, 0, count);
        int[] table = quantizer.buildColorTable();
        if (dither) {
            int index = 0;
            int y = 0;
            while (y < height) {
                int direction;
                boolean reverse;
                boolean bl = reverse = serpentine && (y & 1) == 1;
                if (reverse) {
                    index = y * width + width - 1;
                    direction = -1;
                } else {
                    index = y * width;
                    direction = 1;
                }
                int x = 0;
                while (x < width) {
                    int rgb1 = inPixels[index];
                    int idx = quantizer.getIndexForColor(rgb1);
                    int rgb2 = table[idx];
                    outPixels[index] = (byte)(idx & 0xFF);
                    int a1 = rgb1 >> 24 & 0xFF;
                    int r1 = rgb1 >> 16 & 0xFF;
                    int g1 = rgb1 >> 8 & 0xFF;
                    int b1 = rgb1 & 0xFF;
                    int a2 = rgb2 >> 24 & 0xFF;
                    int r2 = rgb2 >> 16 & 0xFF;
                    int g2 = rgb2 >> 8 & 0xFF;
                    int b2 = rgb2 & 0xFF;
                    int ea = a1 - a2;
                    int er = r1 - r2;
                    int eg = g1 - g2;
                    int eb = b1 - b2;
                    int i = -1;
                    while (i <= 1) {
                        int iy = i + y;
                        if (iy >= 0 && iy < height) {
                            int j = -1;
                            while (j <= 1) {
                                int w;
                                int jx = j + x;
                                if (jx >= 0 && jx < width && (w = reverse ? matrix[(i + 1) * 3 - j + 1] : matrix[(i + 1) * 3 + j + 1]) != 0) {
                                    int k = reverse ? index - j : index + j;
                                    rgb1 = inPixels[k];
                                    a1 = rgb1 >> 24 & 0xFF;
                                    r1 = rgb1 >> 16 & 0xFF;
                                    g1 = rgb1 >> 8 & 0xFF;
                                    b1 = rgb1 & 0xFF;
                                    inPixels[k] = QuantizeFilter.clamp(a1 += ea * w / 16) << 24 | QuantizeFilter.clamp(r1 += er * w / 16) << 16 | QuantizeFilter.clamp(g1 += eg * w / 16) << 8 | QuantizeFilter.clamp(b1 += eb * w / 16);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    index += direction;
                    ++x;
                }
                ++y;
            }
        }
        HashMap<Integer, Integer> p = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < count) {
            int color = dither ? table[outPixels[i] & 0xFF] : table[quantizer.getIndexForColor(inPixels[i])];
            int idx = p.size();
            Integer idxEx = (Integer)p.get(color);
            if (idxEx == null) {
                p.put(color, idx);
            } else {
                idx = idxEx;
            }
            outPixels[i] = (byte)idx;
            ++i;
        }
        Set keys = p.keySet();
        int[] pal = new int[p.size()];
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int k;
            pal[((Integer)p.get((Object)Integer.valueOf((int)k))).intValue()] = k = ((Integer)iterator.next()).intValue();
        }
        return pal;
    }
}

