/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.Tools;

import deadbeef.Tools.JFileFilter;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ToolBox {
    private static final DecimalFormatSymbols dfSym = new DecimalFormatSymbols();
    private static DecimalFormat dot3 = null;
    private static final Pattern timePattern = Pattern.compile("(\\d+):(\\d+):(\\d+)[:\\.](\\d+)");

    public static String zeroTrim(int i, int digits) {
        String s = String.valueOf(i);
        int l = s.length();
        if (l < digits) {
            s = String.valueOf("0000000000".substring(0, digits - l)) + s;
        }
        return s;
    }

    public static String hex(long val, int digits) {
        String s = Long.toString(val, 16);
        int l = s.length();
        if (l < digits) {
            s = String.valueOf("00000000".substring(0, digits - l)) + s;
        }
        return "0x" + s;
    }

    public static String hex(int val, int digits) {
        String s = Integer.toString(val, 16);
        int l = s.length();
        if (l < digits) {
            s = String.valueOf("00000000".substring(0, digits - l)) + s;
        }
        return "0x" + s;
    }

    public static String formatDouble(double d) {
        if (dot3 == null) {
            dfSym.setDecimalSeparator('.');
            dot3 = new DecimalFormat("##.###", dfSym);
        }
        return dot3.format(d);
    }

    public static int[] msToTime(long ms) {
        int[] time;
        time = new int[]{(int)(ms / 3600000L), (int)((ms -= (long)(time[0] * 60 * 60 * 1000)) / 60000L), (int)((ms -= (long)(time[1] * 60 * 1000)) / 1000L), (int)(ms -= (long)(time[2] * 1000))};
        return time;
    }

    public static String ptsToTimeStr(long pts) {
        int[] time = ToolBox.msToTime((pts + 45L) / 90L);
        return String.valueOf(ToolBox.zeroTrim(time[0], 2)) + ":" + ToolBox.zeroTrim(time[1], 2) + ":" + ToolBox.zeroTrim(time[2], 2) + "." + ToolBox.zeroTrim(time[3], 3);
    }

    public static String ptsToTimeStrIdx(long pts) {
        int[] time = ToolBox.msToTime((pts + 45L) / 90L);
        return String.valueOf(ToolBox.zeroTrim(time[0], 2)) + ":" + ToolBox.zeroTrim(time[1], 2) + ":" + ToolBox.zeroTrim(time[2], 2) + ":" + ToolBox.zeroTrim(time[3], 3);
    }

    public static String ptsToTimeStrXml(long pts, double fps) {
        int[] time = ToolBox.msToTime((pts + 45L) / 90L);
        return String.valueOf(ToolBox.zeroTrim(time[0], 2)) + ":" + ToolBox.zeroTrim(time[1], 2) + ":" + ToolBox.zeroTrim(time[2], 2) + ":" + ToolBox.zeroTrim((int)(fps * (double)time[3] / 1000.0 + 0.5), 2);
    }

    public static long timeStrToPTS(String s) {
        Matcher m = timePattern.matcher(s);
        if (m.matches()) {
            long hour = Integer.parseInt(m.group(1));
            long min = Integer.parseInt(m.group(2));
            long sec = Integer.parseInt(m.group(3));
            long ms = Integer.parseInt(m.group(4));
            long temp = hour * 60L;
            temp += min;
            temp *= 60L;
            temp += sec;
            return ((temp *= 1000L) + ms) * 90L;
        }
        return -1L;
    }

    public static long timeStrXmlToPTS(String s, double fps) {
        Matcher m = timePattern.matcher(s);
        if (m.matches()) {
            long hour = Integer.parseInt(m.group(1));
            long min = Integer.parseInt(m.group(2));
            long sec = Integer.parseInt(m.group(3));
            long frames = Integer.parseInt(m.group(4));
            long temp = hour * 60L;
            temp += min;
            temp *= 60L;
            temp += sec;
            return ((temp *= 1000L) + (long)((int)((double)frames / fps * 1000.0 + 0.5))) * 90L;
        }
        return -1L;
    }

    public static int getByte(byte[] buffer, int index) throws ArrayIndexOutOfBoundsException {
        return buffer[index] & 0xFF;
    }

    public static int getWord(byte[] buffer, int index) throws ArrayIndexOutOfBoundsException {
        return buffer[index + 1] & 0xFF | (buffer[index] & 0xFF) << 8;
    }

    public static void setByte(byte[] buffer, int index, int val) throws ArrayIndexOutOfBoundsException {
        buffer[index] = (byte)val;
    }

    public static void setWord(byte[] buffer, int index, int val) throws ArrayIndexOutOfBoundsException {
        buffer[index] = (byte)(val >> 8);
        buffer[index + 1] = (byte)val;
    }

    public static void setDWord(byte[] buffer, int index, int val) throws ArrayIndexOutOfBoundsException {
        buffer[index] = (byte)(val >> 24);
        buffer[index + 1] = (byte)(val >> 16);
        buffer[index + 2] = (byte)(val >> 8);
        buffer[index + 3] = (byte)val;
    }

    public static void setString(byte[] buffer, int index, String s) throws ArrayIndexOutOfBoundsException {
        int i = 0;
        while (i < s.length()) {
            buffer[index + i] = (byte)s.charAt(i);
            ++i;
        }
    }

    public static void showException(Throwable ex) {
        String m = "<html>";
        m = String.valueOf(m) + ex.getClass().getName() + "<p>";
        if (ex.getMessage() != null) {
            m = String.valueOf(m) + ex.getMessage() + "<p>";
        }
        StackTraceElement[] ste = ex.getStackTrace();
        int i = 0;
        while (i < ste.length) {
            m = String.valueOf(m) + ste[i].toString() + "<p>";
            ++i;
        }
        m = String.valueOf(m) + "</html>";
        ex.printStackTrace();
        JOptionPane.showMessageDialog(null, m, "Error", 0);
    }

    public static String getFileName(String path, String fn, String[] ext, boolean load, Component parent) {
        int returnVal;
        File f;
        String p = path;
        if (p.length() == 0) {
            p = ".";
        }
        JFileChooser jf = new JFileChooser(p);
        if (ext != null) {
            JFileFilter filter = new JFileFilter();
            int i = 0;
            while (i < ext.length) {
                filter.addExtension(ext[i]);
                ++i;
            }
            jf.setFileFilter(filter);
        }
        jf.setFileSelectionMode(0);
        if (fn != null) {
            f = new File(String.valueOf(ToolBox.addSeparator(path)) + fn);
            jf.setSelectedFile(f);
        }
        if (!load) {
            jf.setDialogType(1);
        }
        if ((returnVal = jf.showDialog(parent, null)) == 0 && (f = jf.getSelectedFile()) != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public static String addSeparator(String fName) {
        int pos = fName.lastIndexOf(File.separator);
        if (pos != fName.length() - 1) {
            pos = fName.lastIndexOf("/");
        }
        if (pos != fName.length() - 1) {
            return String.valueOf(fName) + File.separator;
        }
        return fName;
    }

    public static String exchangeSeparators(String fName) {
        int pos;
        StringBuffer sb = new StringBuffer(fName);
        while ((pos = sb.indexOf("\\")) != -1) {
            sb.setCharAt(pos, '/');
        }
        return sb.toString();
    }

    public static String getFileName(String path) {
        int p1 = path.lastIndexOf("/");
        int p2 = path.lastIndexOf("\\");
        if (p2 > p1) {
            p1 = p2;
        }
        p1 = p1 < 0 ? 0 : ++p1;
        return path.substring(p1);
    }

    public static String getPathName(String path) {
        int p1 = path.lastIndexOf("/");
        int p2 = path.lastIndexOf("\\");
        if (p2 > p1) {
            p1 = p2;
        }
        if (p1 < 0) {
            p1 = 0;
        }
        return path.substring(0, p1);
    }

    public static String getExtension(String path) {
        int p1 = path.lastIndexOf("/");
        int p2 = path.lastIndexOf("\\");
        int p = path.lastIndexOf(".");
        if (p == -1 || p < p1 || p < p2) {
            return null;
        }
        return path.substring(p + 1);
    }

    public static String stripExtension(String path) {
        int p1 = path.lastIndexOf("/");
        int p2 = path.lastIndexOf("\\");
        int p = path.lastIndexOf(".");
        if (p == -1 || p < p1 || p < p2) {
            return path;
        }
        return path.substring(0, p);
    }

    public static byte[] getFileID(String fname, int num) {
        byte[] buf = new byte[num];
        File f = new File(fname);
        if (f.length() < (long)num) {
            return null;
        }
        try {
            FileInputStream fi = new FileInputStream(fname);
            fi.read(buf);
            fi.close();
        }
        catch (Exception ex) {
            return null;
        }
        return buf;
    }

    public static String trim(String s) {
        int spos = 0;
        while (spos < s.length()) {
            if (s.charAt(spos) != ' ') break;
            ++spos;
        }
        int epos = s.length() - 1;
        while (epos > spos) {
            if (s.charAt(epos) != ' ') break;
            --epos;
        }
        return s.substring(spos, epos + 1);
    }

    public static int getInt(String s) {
        try {
            return Integer.parseInt(ToolBox.trim(s));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static double getDouble(String s) {
        try {
            return Double.parseDouble(ToolBox.trim(s));
        }
        catch (NumberFormatException ex) {
            return -1.0;
        }
    }
}

