/*
 * Decompiled with CFR 0.152.
 */
package bdvm.vm;

import bdvm.vm.common;
import bdvm.vm.conv_tab_segments;

public class conv_tab_subtables {
    public int subtable_id;
    public int segment_count;
    private int[] segmentLength;
    public conv_tab_segments[] segment;

    public conv_tab_subtables(byte[] conversionTable, int subtableOffset) {
        byte[] BA_segment_count = new byte[4];
        int address = subtableOffset;
        this.subtable_id = common.byteArrayToInt(conversionTable, address);
        System.err.format("%d,", this.subtable_id);
        System.arraycopy(conversionTable, address += 4, BA_segment_count, 2, 2);
        this.segment_count = common.byteArrayToInt(BA_segment_count, 0);
        address += 2;
        this.segment = new conv_tab_segments[this.segment_count];
        this.segmentLength = new int[this.segment_count];
        for (int i = 0; i < this.segment_count; ++i) {
            int segmentOffset = common.byteArrayToInt(conversionTable, address);
            address += 4;
            this.segment[i] = new conv_tab_segments(conversionTable, segmentOffset);
            this.segmentLength[i] = this.segment[i].length();
        }
    }

    public int length() {
        int length = 6 + 4 * this.segment_count;
        for (int i = 0; i < this.segment_count; ++i) {
            length += this.segmentLength[i];
        }
        return length;
    }

    public boolean decryptSegment(int segmentNumber, byte[] segmentKey) {
        return this.segment[segmentNumber].decrypt(segmentKey);
    }

    public void checkSegment(int segmentNumber, byte[] segmentMask) {
        this.segment[segmentNumber].check(segmentMask);
        this.segmentLength[segmentNumber] = this.segment[segmentNumber].length();
    }

    public int getFirstEncryptedNonemptySegmentNumber() {
        for (int i = 0; i < this.segment_count; ++i) {
            if (!this.segment[i].needsDecryption()) continue;
            return i;
        }
        return -1;
    }

    public byte[] toByteArray(int subtableOffset) {
        int[] segmentLength = new int[this.segment_count];
        int subtableLength = this.length();
        byte[] BA_subtable = new byte[subtableLength];
        int writeAddressOffset = 6;
        int writeAddressSegment = 6 + 4 * this.segment_count;
        common.int32ToByteArray(this.subtable_id, BA_subtable, 0);
        BA_subtable[5] = (byte)this.segment_count;
        BA_subtable[4] = (byte)(this.segment_count >>> 8);
        for (int i = 0; i < this.segment_count; ++i) {
            common.int32ToByteArray(subtableOffset + writeAddressSegment, BA_subtable, writeAddressOffset);
            writeAddressOffset += 4;
            byte[] BA_segment = this.segment[i].toByteArray();
            System.arraycopy(BA_segment, 0, BA_subtable, writeAddressSegment, BA_segment.length);
            writeAddressSegment += BA_segment.length;
        }
        return BA_subtable;
    }
}

