/*
 * Decompiled with CFR 0.152.
 */
package bdvm.vm;

import bdvm.vm.BDVM;
import bdvm.vm.conv_tab_main;
import java.util.Arrays;

public class decoder {
    private final BDVM vm;
    private conv_tab_main convTab = new conv_tab_main();
    private int[] currentEvent = new int[4];
    private int eventCounter = 0;
    private int[] currentSegmentID = new int[2];
    private int fileNumber = 1;

    public decoder(BDVM vm) {
        this.vm = vm;
    }

    public void reset() {
        this.convTab = new conv_tab_main();
        Arrays.fill(this.currentEvent, 0);
        this.eventCounter = 0;
        Arrays.fill(this.currentSegmentID, 0);
        this.fileNumber = 1;
    }

    public conv_tab_main getConvTab() {
        return this.convTab;
    }

    public void getConversionTable(int len, int pTable) {
        if (len > 0) {
            byte[] conversionTable = this.vm.ReadMemory8(pTable, len);
            this.convTab.setConversionTable(conversionTable);
        }
    }

    public void applySegmentKey(int tableID, int segmentNum, byte[] segmentKey) {
        this.convTab.decryptSegment(tableID, segmentNum, segmentKey);
    }

    public void writeConversionTable() {
        this.convTab.dumpConversionTable();
    }

    public int getRequestCounter() {
        return this.eventCounter;
    }

    public int getCurrentEventID() {
        return this.currentEvent[0];
    }

    public int getCurrentTableID() {
        return this.currentEvent[2];
    }

    public int getCurrentSegmentNumber() {
        return this.currentEvent[3];
    }

    public void resetVMToHandleEvent() {
        this.vm.R[28] = this.vm.pc;
        this.vm.pc = 4096;
        this.vm.watchDogCounter = Integer.MAX_VALUE;
    }

    public void generateEvent() {
        this.resetVMToHandleEvent();
        switch (this.eventCounter) {
            case 0: {
                this.currentEvent[0] = 272;
                this.currentEvent[1] = 0;
                this.currentEvent[2] = 65535;
                this.vm.WriteMemory32(this.currentEvent, 0, 3);
                break;
            }
            case 1: {
                this.currentEvent[0] = 528;
                this.currentEvent[1] = 0;
                this.currentEvent[2] = 1;
                this.vm.WriteMemory32(this.currentEvent, 0, 3);
                break;
            }
            case 2: {
                this.currentEvent[0] = 272;
                this.currentEvent[1] = 0;
                this.currentEvent[2] = this.fileNumber;
                this.vm.WriteMemory32(this.currentEvent, 0, 3);
                break;
            }
            default: {
                if (this.fileNumber < 25) {
                    this.currentEvent[0] = 272;
                    this.currentEvent[1] = 0;
                    this.currentEvent[2] = ++this.fileNumber;
                    this.vm.WriteMemory32(this.currentEvent, 0, 3);
                    break;
                }
                if (this.convTab.getNextSegmentID(this.currentSegmentID)) {
                    this.currentEvent[0] = 544;
                    this.currentEvent[1] = 0;
                    this.currentEvent[2] = this.currentSegmentID[0];
                    this.currentEvent[3] = this.currentSegmentID[1];
                    this.vm.WriteMemory32(this.currentEvent, 0, 4);
                    break;
                }
                this.currentEvent[0] = 16;
                this.currentEvent[1] = 0;
                this.vm.WriteMemory32(this.currentEvent, 0, 2);
            }
        }
        switch (this.currentEvent[0]) {
            case 16: {
                System.err.format("[Event #%08X] EVENT_Shutdown( %08X )\n", this.eventCounter, this.currentEvent[1]);
                break;
            }
            case 272: {
                System.err.format("[Event #%08X] EVENT_PlaybackFile( %08X, %08X )\n", this.eventCounter, this.currentEvent[1], this.currentEvent[2]);
                break;
            }
            case 528: {
                System.err.format("[Event #%08X] EVENT_0210( %08X, %08X )\n", this.eventCounter, this.currentEvent[1], this.currentEvent[2]);
                break;
            }
            case 544: {
                System.err.format("[Event #%08X] EVENT_PlaybackSegment( %08X, %08X, %08X )\n", this.eventCounter, this.currentEvent[1], this.currentEvent[2], this.currentEvent[3]);
                break;
            }
            default: {
                System.err.format("[Event #%08X] %04X ( %08X, %08X, %08X )\n", this.eventCounter, this.currentEvent[0], this.currentEvent[1], this.currentEvent[2], this.currentEvent[3]);
            }
        }
        ++this.eventCounter;
    }

    public void ContentCodeFinished() {
        int currentEventID = this.getCurrentEventID();
        if (currentEventID == 16) {
            this.convTab.dumpConversionTable();
            this.vm.setSuspend(true);
        }
        if (currentEventID == 544) {
            int tableID = this.currentSegmentID[0];
            int segmentNum = this.currentSegmentID[1];
            byte[] segmentKey = this.vm.ReadMemory8(16, 16);
            byte[] segmentMask = this.vm.ReadMemory8(32, 8);
            this.convTab.decryptSegment(tableID, segmentNum, segmentKey);
            this.convTab.checkSegment(tableID, segmentNum, segmentMask);
        }
    }
}

