/*
 * Decompiled with CFR 0.152.
 */
package bdvm.vm;

import bdvm.vm.common;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class hash_db {
    public hash_db() {
        File hash_db_file = new File("hash_db.bin");
        try {
            hash_db_file.createNewFile();
        }
        catch (Exception ex) {
            System.err.format("[W] Creation of hash database file failed!\n", new Object[0]);
        }
    }

    private byte[] genKey(byte[] FileName, long FileOffset, int BytesToHash) {
        byte[] buffer = new byte[12 + FileName.length];
        byte[] BA_Offset = new byte[8];
        byte[] BA_BytesToHash = new byte[4];
        byte[] hash = new byte[20];
        common.int64ToByteArray(FileOffset, BA_Offset, 0);
        common.int32ToByteArray(BytesToHash, BA_BytesToHash, 0);
        System.arraycopy(BA_Offset, 0, buffer, 0, 8);
        System.arraycopy(BA_BytesToHash, 0, buffer, 8, 4);
        System.arraycopy(FileName, 0, buffer, 12, FileName.length);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(buffer);
            hash = md.digest();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return hash;
    }

    public byte[] Load(byte[] FileName, long FileOffset, int LengthRequested) {
        byte[] buffer = new byte[20];
        byte[] BA_BytesHashed = new byte[4];
        byte[] BA_NextPointer = new byte[4];
        byte[] key = this.genKey(FileName, FileOffset, LengthRequested);
        try {
            File hash_db2 = new File("hash_db.bin");
            FileInputStream hash_db_stream = new FileInputStream(hash_db2);
            while (true) {
                int bytesRead;
                if ((bytesRead = hash_db_stream.read(buffer)) < buffer.length) {
                    hash_db_stream.close();
                    return null;
                }
                if (Arrays.equals(key, buffer)) {
                    hash_db_stream.skip(4L);
                    hash_db_stream.read(BA_BytesHashed);
                    int bytesHashed = common.byteArrayToInt(BA_BytesHashed, 0);
                    byte[] hashArray = new byte[bytesHashed / 512 * 20];
                    hash_db_stream.read(hashArray);
                    hash_db_stream.close();
                    return hashArray;
                }
                hash_db_stream.read(BA_NextPointer);
                int NextPointer = common.byteArrayToInt(BA_NextPointer, 0);
                hash_db_stream.skip(NextPointer);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void Store(byte[] FileName, long FileOffset, int LengthRequested, int LengthProcessed, byte[] HashArray) {
        byte[] BA_BytesHashed = new byte[4];
        byte[] BA_NextPointer = new byte[4];
        byte[] hashEntry = new byte[20];
        if (this.Load(FileName, FileOffset, LengthRequested) == null) {
            byte[] buffer = new byte[28 + HashArray.length];
            byte[] key = this.genKey(FileName, FileOffset, LengthRequested);
            common.int32ToByteArray(LengthProcessed, BA_BytesHashed, 0);
            common.int32ToByteArray(4 + HashArray.length, BA_NextPointer, 0);
            System.arraycopy(key, 0, buffer, 0, 20);
            System.arraycopy(BA_NextPointer, 0, buffer, 20, 4);
            System.arraycopy(BA_BytesHashed, 0, buffer, 24, 4);
            System.arraycopy(HashArray, 0, buffer, 28, HashArray.length);
            try {
                FileOutputStream hash_db2 = new FileOutputStream("hash_db.bin", true);
                hash_db2.write(buffer);
                hash_db2.flush();
                hash_db2.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void clear() {
        try {
            FileOutputStream hash_db2 = new FileOutputStream("hash_db.bin", false);
            hash_db2.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

