/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class SubjectKeyIdentifier
extends ASN1Encodable {
    private byte[] keyidentifier;

    public static SubjectKeyIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SubjectKeyIdentifier.getInstance(ASN1OctetString.getInstance(aSN1TaggedObject, bl));
    }

    public static SubjectKeyIdentifier getInstance(Object object) {
        if (object instanceof SubjectKeyIdentifier) {
            return (SubjectKeyIdentifier)object;
        }
        if (object instanceof SubjectPublicKeyInfo) {
            return new SubjectKeyIdentifier((SubjectPublicKeyInfo)object);
        }
        if (object instanceof ASN1OctetString) {
            return new SubjectKeyIdentifier((ASN1OctetString)object);
        }
        if (object instanceof X509Extension) {
            return SubjectKeyIdentifier.getInstance(X509Extension.convertValueToObject((X509Extension)object));
        }
        throw new IllegalArgumentException("Invalid SubjectKeyIdentifier: " + object.getClass().getName());
    }

    public SubjectKeyIdentifier(byte[] byArray) {
        this.keyidentifier = byArray;
    }

    public SubjectKeyIdentifier(ASN1OctetString aSN1OctetString) {
        this.keyidentifier = aSN1OctetString.getOctets();
    }

    public SubjectKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        byte[] byArray = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray2 = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        sHA1Digest.update(byArray2, 0, byArray2.length);
        sHA1Digest.doFinal(byArray, 0);
        this.keyidentifier = byArray;
    }

    public byte[] getKeyIdentifier() {
        return this.keyidentifier;
    }

    @Override
    public DERObject toASN1Object() {
        return new DEROctetString(this.keyidentifier);
    }
}

