/* SPDX-License-Identifier: MIT */
/**
	@file		ancillarydata_framestatusinfo5251.h
	@brief		Declares the AJAAncillaryData_FrameStatusInfo5251 class.
	@copyright	(C) 2012-2021 AJA Video Systems, Inc.
**/

#ifndef AJA_ANCILLARYDATA_FRAMESTATUSINFO5251_H
#define AJA_ANCILLARYDATA_FRAMESTATUSINFO5251_H

#include "ancillarydatafactory.h"
#include "ancillarydata.h"


// Ancillary Packet generated by the Canon C500
const uint8_t	AJAAncillaryData_FrameStatusInfo5251_DID = 0x52;
const uint8_t	AJAAncillaryData_FrameStatusInfo5251_SID = 0x51;


/**
	@brief	This class handles "5251" Frame Status Information packets.
**/
class AJA_EXPORT AJAAncillaryData_FrameStatusInfo5251 : public AJAAncillaryData
{
public:
	AJAAncillaryData_FrameStatusInfo5251 ();	///< @brief	My default constructor.

	/**
		@brief	My copy constructor.
		@param[in]	inClone	The AJAAncillaryData object to be cloned.
	**/
	AJAAncillaryData_FrameStatusInfo5251 (const AJAAncillaryData_FrameStatusInfo5251 & inClone);

	/**
		@brief	My copy constructor.
		@param[in]	pInClone	A valid pointer to the AJAAncillaryData object to be cloned.
	**/
	AJAAncillaryData_FrameStatusInfo5251 (const AJAAncillaryData_FrameStatusInfo5251 * pInClone);

	/**
		@brief	Constructs me from a generic AJAAncillaryData object.
		@param[in]	pInData	A valid pointer to the AJAAncillaryData object.
	**/
	AJAAncillaryData_FrameStatusInfo5251 (const AJAAncillaryData * pInData);

	virtual									~AJAAncillaryData_FrameStatusInfo5251 ();	///< @brief		My destructor.

	virtual void							Clear (void);								///< @brief	Frees my allocated memory, if any, and resets my members to their default values.

	/**
		@brief	Assignment operator -- replaces my contents with the right-hand-side value.
		@param[in]	inRHS	The value to be assigned to me.
		@return		A reference to myself.
	**/
	virtual AJAAncillaryData_FrameStatusInfo5251 &			operator = (const AJAAncillaryData_FrameStatusInfo5251 & inRHS);


	virtual inline AJAAncillaryData_FrameStatusInfo5251 *	Clone (void) const	{return new AJAAncillaryData_FrameStatusInfo5251 (this);}	///< @return	A clone of myself.

	/**
		@brief		Parses out (interprets) the "local" ancillary data from my payload data.
		@return		AJA_STATUS_SUCCESS if successful.
	**/
	virtual AJAStatus						ParsePayloadData (void);

	/**
		@brief		Streams a human-readable representation of me to the given output stream.
		@param		inOutStream		Specifies the output stream.
		@param[in]	inDetailed		Specify 'true' for a detailed representation;  otherwise use 'false' for a brief one.
		@return		The given output stream.
	**/
	virtual std::ostream &					Print (std::ostream & inOutStream, const bool inDetailed = false) const;

	virtual inline bool						IsRecording (void) const	{return m_IsRecording;}		///< @return	True if the remote camera is recording.

	virtual inline bool						IsValidFrame (void) const	{return m_IsValidFrame;}	///< @return	True if the remote camera's outbound frame is valid for capture.

	/**
		@param[in]	pInAncData	A valid pointer to a base AJAAncillaryData object that contains the Anc data to inspect.
		@return		AJAAncillaryDataType if I recognize this Anc data (or AJAAncillaryDataType_Unknown if unrecognized).
	**/
	static AJAAncillaryDataType				RecognizeThisAncillaryData (const AJAAncillaryData * pInAncData);


protected:
	void		Init (void);	// NOT virtual - called by constructors

private:
	bool	m_IsRecording;
	bool	m_IsValidFrame;

};	//	AJAAncillaryData_FrameStatusInfo5251

#endif	// AJA_ANCILLARYDATA_FRAMESTATUSINFO5251_H
