 付録について
==============


## allconv.sed

GNU sedを利用して、cuda関連機能を使用するモデルデータ(t7形式)を、cuda関連機能を使用しないように型・モジュールの置き換えを行うためのスクリプトです。

具体的に何をしているかは、sedのマニュアルを見つつ中身を見てみて下さい。

モデル変換は次のようにして行います。
```
sed -f allconv.sed noise1_model.t7 > noise1_model_nocuda.t7
```


## waifu2x-nocuda

オリジナル版waifu2xのコミットffcb460を元に、cuda関連機能を使用しないように改造したものです。
これを使用するためには、モデルファイルも上のsedスクリプトを使用してno-cuda化しておく必要が有ります。

自身のwaifu2x動作テストは、これを利用して行いました(MacBook Late 2011 (OS:Ubuntu)で実行可能であることを確認済み)。

ちょっと古いコミット時点のものを使用しているため、「数珠めいた模様が出る」現象が残っています。
オリジナルの最新のコミットでno-cuda化したい場合は、一旦オリジナルのコミットffcb460をチェックアウトした上で、
diffなどを使用してどこが変更されているかを観察し、その後再改造かマージを試みて下さい。

(cudaは使用しませんが、torch7とnn等のtorchモジュールは必要です)

(ちなみに、今現在拙作のwaifu2x-converterより、このオリジナルのno-cudaバージョンの方が、総合的に性能が良いです)


## waifu2x-nocuda/export_model_nocuda.lua

Hector Martinさん作のt7形式モデルをjson形式モデルに変換するtorchスクリプト`export_model.lua`を、上と同様の手段で
no-cuda化したものです。
変換元のモデルも、上のsedスクリプトを使用してno-cuda化しておく必要が有ります。


## waifu2x-commented.py

Hector Martinさん作のwaifu2x.pyに、処理フローを拙作の開発中にわかりやすくするためにやたらとコメントを入れたものです。
jsonモデルの構造についてのメモも記してあります。

拙作のコンバータは、基本的にwaifu2x.pyの処理フローを継承しています(マルチスレッドで仕事を配ったりなどの機能追加はしましたが)。

本リポジトリのコードはお世辞にも処理フローが読みやすいとは言えないので、こちらの方がわかりやすいと思います。

(コメントだけを入れているつもりですが、記憶から消えてしまったテストコードなどが残っているかも知れません。予めご了承下さい。)


## hints-jp.md

ヒント集という名のただのメモです。
メモリ消費量計算式などの雑多な情報をまとめてあります。
将来実装してみたい機能の実装に向けての備忘録なども。


** オリジナルのwaifu2x, waifu2x.py, export_model.luaは全てMITライセンスの下で公開されており、本appendixに含まれる全てのファイルもMITライセンスの下で公開するものとします。 **
