/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.model;

import java.util.ArrayList;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.TableType;

public class FilterConfig {
    public static final String JDBC_TYPE_NO_LIMIT = "NO_LIMIT";
    public static final String JDBC_TYPE_TABLE = "TABLE";
    public static final String JDBC_TYPE_VIEW = "VIEW";
    public static final String JDBC_TYPE_SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String JDBC_TYPE_GLOBAL_TEMPORARY = "GLOBAL TEMPORARY";
    public static final String JDBC_TYPE_LOCAL_TEMPORARY = "LOCAL TEMPORARY";
    public static final String JDBC_TYPE_ALIAS = "ALIAS";
    public static final String JDBC_TYPE_SYNONYM = "SYNONYM";
    private TableType type;
    private boolean isShowSystemTable;
    private boolean isShowAlias;
    private String schemaName;
    private String namePattern;
    private int maxSchemaCount;
    private int maxTableCountPerSchema;

    public FilterConfig(String schemaName, Type type, String namePattern, boolean isShowSystemTable, boolean isShowAlias, int maxSchemaCount, int maxTableCountPerSchema) {
        assert (type != null && maxSchemaCount > 0 && maxTableCountPerSchema > 0);
        this.schemaName = schemaName;
        this.type = TableType.valueOf(type);
        this.isShowSystemTable = isShowSystemTable;
        this.isShowAlias = isShowAlias;
        this.namePattern = FilterConfig.generatePattern(namePattern);
        this.maxSchemaCount = maxSchemaCount;
        this.maxTableCountPerSchema = maxTableCountPerSchema;
    }

    public FilterConfig(String schemaName, TableType type, String namePattern, boolean isShowSystemTable, boolean isShowAlias, int maxSchemaCount, int maxTableCountPerSchema) {
        assert (type != null && maxSchemaCount > 0 && maxTableCountPerSchema > 0);
        this.schemaName = schemaName;
        this.type = type;
        this.isShowSystemTable = isShowSystemTable;
        this.isShowAlias = isShowAlias;
        this.namePattern = FilterConfig.generatePattern(namePattern);
        this.maxSchemaCount = maxSchemaCount;
        this.maxTableCountPerSchema = maxTableCountPerSchema;
    }

    public Type getType() {
        return this.type.getTypeID();
    }

    public TableType getTableType() {
        return this.type;
    }

    public boolean isShowSystemTable() {
        return this.isShowSystemTable;
    }

    public boolean isShowAlias() {
        return this.isShowAlias;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public int getMaxSchemaCount() {
        return this.maxSchemaCount;
    }

    public int getMaxTableCountPerSchema() {
        return this.maxTableCountPerSchema;
    }

    public String[] getTableTypesForJDBC() {
        ArrayList<String> types = new ArrayList<String>();
        if (this.type != TableType.PROCEDURE) {
            if (this.type == TableType.TABLE) {
                types.add(JDBC_TYPE_TABLE);
                this.populateSystemTableOption(types);
                this.populateAliasOption(types);
            } else if (this.type == TableType.VIEW) {
                types.add(JDBC_TYPE_VIEW);
                this.populateAliasOption(types);
            } else if (this.type == TableType.ALL) {
                types.add(JDBC_TYPE_TABLE);
                types.add(JDBC_TYPE_VIEW);
                this.populateSystemTableOption(types);
                this.populateAliasOption(types);
            } else {
                types.add(this.type.getTypeName());
            }
        }
        return types.isEmpty() ? null : types.toArray(new String[0]);
    }

    private void populateSystemTableOption(ArrayList<String> types) {
        if (this.isShowSystemTable()) {
            types.add(JDBC_TYPE_SYSTEM_TABLE);
        }
    }

    private void populateAliasOption(ArrayList<String> types) {
        if (this.isShowAlias()) {
            types.add(JDBC_TYPE_ALIAS);
            types.add(JDBC_TYPE_SYNONYM);
        }
    }

    private static String generatePattern(String input) {
        if (input != null) {
            if (((String)input).lastIndexOf(37) == -1) {
                input = (String)input + "%";
            }
        } else {
            input = "%";
        }
        return input;
    }

    public static String getTypeDisplayText(Type type) {
        assert (type != null);
        switch (type) {
            case PROCEDURE: {
                return JdbcPlugin.getResourceString("tablepage.text.procedure");
            }
            case TABLE: {
                return JdbcPlugin.getResourceString("tablepage.text.tabletype");
            }
            case VIEW: {
                return JdbcPlugin.getResourceString("tablepage.text.viewtype");
            }
            case ALL: {
                return JdbcPlugin.getResourceString("tablepage.text.All");
            }
        }
        return type.name();
    }

    public static enum Type {
        ALL,
        TABLE,
        VIEW,
        PROCEDURE;

    }
}

