/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.store.backing.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.ha.cache.command.Command;
import org.glassfish.shoal.ha.cache.util.CommandResponse;
import org.glassfish.shoal.ha.cache.util.ResponseMediator;

public class RemoveExpiredResultCommand<K, V>
extends Command<String, V> {
    private static final long serialVersionUID = -6402834139071754486L;
    protected static final Logger _logger = Logger.getLogger("org.glassfish.shoal.ha.cache.command.remove");
    private String target;
    private long tokenId;
    private int result = 0;

    public RemoveExpiredResultCommand(String target, long tokenId, int result) {
        super((byte)44);
        this.target = target;
        this.tokenId = tokenId;
        this.result = result;
        super.setKey("RemExpResp:" + tokenId);
    }

    @Override
    public boolean beforeTransmit() {
        this.setTargetName(this.target);
        return this.target != null;
    }

    private void writeObject(ObjectOutputStream ros) throws IOException {
        ros.writeLong(this.tokenId);
        ros.writeInt(this.result);
    }

    private void readObject(ObjectInputStream ris) throws IOException, ClassNotFoundException {
        this.tokenId = ris.readLong();
        this.result = ris.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) {
        ResponseMediator respMed = this.getDataStoreContext().getResponseMediator();
        CommandResponse resp = respMed.getCommandResponse(this.tokenId);
        if (resp != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.dsc.getInstanceName() + "For tokenId = " + this.tokenId + " received remove_expired_response value=" + this.result);
            }
            int pendingUpdates = 0;
            CommandResponse commandResponse = resp;
            synchronized (commandResponse) {
                Integer existingValue = (Integer)resp.getTransientResult();
                Integer newResult = new Integer(existingValue + this.result);
                resp.setTransientResult(newResult);
                pendingUpdates = resp.decrementAndGetExpectedUpdateCount();
            }
            if (pendingUpdates == 0) {
                resp.setResult(resp.getTransientResult());
            }
        } else {
            _logger.log(Level.FINE, "RemoveExpiredResult: TOKEN already removed for tokenId = " + this.tokenId);
        }
    }

    @Override
    protected boolean isArtificialKey() {
        return true;
    }

    @Override
    public String toString() {
        return this.getName() + "(result=" + this.result + ")";
    }
}

