/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.presentation.rmi;

import com.sun.corba.ee.impl.presentation.rmi.Exceptions;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import java.lang.reflect.Field;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.StateFactory;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class JNDIStateFactoryImpl
implements StateFactory {
    private ConcurrentMap<Class<?>, Field> orbFields = new ConcurrentHashMap();

    @Override
    public java.lang.Object getStateToBind(java.lang.Object orig, Name name, Context ctx, Hashtable<?, ?> env) throws NamingException {
        Remote stub;
        block8: {
            if (orig instanceof Object) {
                return orig;
            }
            if (!(orig instanceof Remote)) {
                return null;
            }
            com.sun.corba.ee.spi.orb.ORB orb = this.getORB(ctx);
            if (orb == null) {
                return null;
            }
            try {
                stub = PortableRemoteObject.toStub((Remote)((Remote)orig));
            }
            catch (Exception exc) {
                Exceptions.self.noStub(exc);
                return null;
            }
            if (StubAdapter.isStub(stub)) {
                try {
                    StubAdapter.connect(stub, (ORB)orb);
                }
                catch (Exception exc) {
                    Exceptions.self.couldNotConnect(exc);
                    if (exc instanceof RemoteException) break block8;
                    return null;
                }
            }
        }
        return stub;
    }

    private com.sun.corba.ee.spi.orb.ORB getORB(Context ctx) {
        try {
            return (com.sun.corba.ee.spi.orb.ORB)this.getOrbField(ctx).get(ctx);
        }
        catch (Exception exc) {
            Exceptions.self.couldNotGetORB(exc, ctx);
            return null;
        }
    }

    private Field getOrbField(Context ctx) {
        Field orbField = (Field)this.orbFields.get(ctx.getClass());
        if (orbField != null) {
            return orbField;
        }
        orbField = AccessController.doPrivileged(() -> this.getField(ctx.getClass(), "_orb"));
        this.orbFields.put(ctx.getClass(), orbField);
        return orbField;
    }

    private Field getField(Class<?> aClass, String fieldName) {
        try {
            Field field = aClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (aClass.getSuperclass() == null) {
                return null;
            }
            return this.getField(aClass.getSuperclass(), fieldName);
        }
    }
}

