/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.tree.BinaryShiftExpression;
import org.glassfish.rmic.tools.tree.CommaExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.IntExpression;
import org.glassfish.rmic.tools.tree.LongExpression;

public class ShiftLeftExpression
extends BinaryShiftExpression {
    public ShiftLeftExpression(long where, Expression left, Expression right) {
        super(26, where, left, right);
    }

    @Override
    Expression eval(int a, int b) {
        return new IntExpression(this.where, a << b);
    }

    @Override
    Expression eval(long a, long b) {
        return new LongExpression(this.where, a << (int)b);
    }

    @Override
    Expression simplify() {
        if (this.right.equals(0)) {
            return this.left;
        }
        if (this.left.equals(0)) {
            return new CommaExpression(this.where, this.right, this.left).simplify();
        }
        return this;
    }

    @Override
    void codeOperation(Environment env, Context ctx, Assembler asm) {
        asm.add(this.where, 120 + this.type.getTypeCodeOffset());
    }
}

