/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-jacc-provider")
@PerLookup
@I18n(value="create.jacc.provider")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateJACCProvider
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJACCProvider.class);
    @Param(name="policyconfigfactoryclass", alias="policyConfigurationFactoryProvider")
    private String polConfFactoryClass;
    @Param(name="policyproviderclass", alias="policyProvider")
    private String polProviderClass;
    @Param(name="jaccprovidername", primary=true)
    private String jaccProviderName;
    @Param(optional=true, name="property", separator=58)
    private Properties properties;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    @AccessRequired.NewChild(type=JaccProvider.class)
    private SecurityService securityService;

    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.domain, this.target, context.getActionReport());
        if (this.config == null) {
            return false;
        }
        this.securityService = this.config.getSecurityService();
        JaccProvider jaccProvider = CLIUtil.findJaccProvider(this.securityService, this.jaccProviderName);
        if (jaccProvider != null) {
            ActionReport report = context.getActionReport();
            report.setMessage(localStrings.getLocalString("create.jacc.provider.duplicatefound", "JaccProvider named {0} exists. Cannot add duplicate JaccProvider.", new Object[]{this.jaccProviderName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    JaccProvider newJacc = (JaccProvider)param.createChild(JaccProvider.class);
                    newJacc.setName(CreateJACCProvider.this.jaccProviderName);
                    newJacc.setPolicyConfigurationFactoryProvider(CreateJACCProvider.this.polConfFactoryClass);
                    newJacc.setPolicyProvider(CreateJACCProvider.this.polProviderClass);
                    param.getJaccProvider().add(newJacc);
                    return newJacc;
                }
            }, (ConfigBeanProxy)this.securityService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.auth.realm.fail", "Creation of Authrealm {0} failed", new Object[]{this.jaccProviderName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

