/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.shared.common.error.StandardException;

public class ConglomerateDescriptorList
extends ArrayList<ConglomerateDescriptor> {
    public ConglomerateDescriptor getConglomerateDescriptor(long l) {
        ConglomerateDescriptor conglomerateDescriptor = null;
        for (ConglomerateDescriptor conglomerateDescriptor2 : this) {
            if (l != conglomerateDescriptor2.getConglomerateNumber()) continue;
            conglomerateDescriptor = conglomerateDescriptor2;
            break;
        }
        return conglomerateDescriptor;
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(long l) {
        int n = this.size();
        int n2 = 0;
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[n];
        for (ConglomerateDescriptor conglomerateDescriptor : this) {
            if (l != conglomerateDescriptor.getConglomerateNumber()) continue;
            conglomerateDescriptorArray[n2++] = conglomerateDescriptor;
        }
        if (n2 == n) {
            return conglomerateDescriptorArray;
        }
        return Arrays.copyOf(conglomerateDescriptorArray, n2);
    }

    public ConglomerateDescriptor getConglomerateDescriptor(String string) {
        ConglomerateDescriptor conglomerateDescriptor = null;
        for (ConglomerateDescriptor conglomerateDescriptor2 : this) {
            if (!string.equals(conglomerateDescriptor2.getConglomerateName())) continue;
            conglomerateDescriptor = conglomerateDescriptor2;
            break;
        }
        return conglomerateDescriptor;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(UUID uUID) throws StandardException {
        ConglomerateDescriptor conglomerateDescriptor = null;
        for (ConglomerateDescriptor conglomerateDescriptor2 : this) {
            if (!uUID.equals(conglomerateDescriptor2.getUUID())) continue;
            conglomerateDescriptor = conglomerateDescriptor2;
            break;
        }
        return conglomerateDescriptor;
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(UUID uUID) {
        int n = this.size();
        int n2 = 0;
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[n];
        for (ConglomerateDescriptor conglomerateDescriptor : this) {
            if (!uUID.equals(conglomerateDescriptor.getUUID())) continue;
            conglomerateDescriptorArray[n2++] = conglomerateDescriptor;
        }
        if (n2 == n) {
            return conglomerateDescriptorArray;
        }
        return Arrays.copyOf(conglomerateDescriptorArray, n2);
    }

    public void dropConglomerateDescriptor(UUID uUID, ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ConglomerateDescriptor conglomerateDescriptor2 = (ConglomerateDescriptor)iterator.next();
            if (conglomerateDescriptor2.getConglomerateNumber() != conglomerateDescriptor.getConglomerateNumber() || !conglomerateDescriptor2.getConglomerateName().equals(conglomerateDescriptor.getConglomerateName()) || !conglomerateDescriptor2.getSchemaID().equals(conglomerateDescriptor.getSchemaID())) continue;
            iterator.remove();
            break;
        }
    }

    public void dropConglomerateDescriptorByUUID(UUID uUID) throws StandardException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)iterator.next();
            if (!uUID.equals(conglomerateDescriptor.getUUID())) continue;
            iterator.remove();
            break;
        }
    }
}

