/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigException;
import io.helidon.config.spi.ConfigNode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

final class ConfigUtils {
    private static final System.Logger LOGGER = System.getLogger(ConfigUtils.class.getName());

    private ConfigUtils() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    static ConfigNode.ObjectNode mapToObjectNode(Map<?, ?> map, boolean strict) {
        ConfigNode.ObjectNode.Builder builder = ConfigNode.ObjectNode.builder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            try {
                builder.addValue(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            catch (ConfigException ex) {
                if (strict) {
                    throw ex;
                }
                LOGGER.log(System.Logger.Level.TRACE, "Tree-structure failure on key '" + String.valueOf(entry.getKey()) + "' = '" + String.valueOf(entry.getValue()) + "'.", (Throwable)ex);
            }
        }
        return builder.build();
    }

    static Map<String, String> propertiesToMap(Properties properties) {
        return properties.stringPropertyNames().stream().collect(Collectors.toMap(k -> k, properties::getProperty));
    }

    static void shutdownExecutor(ScheduledExecutorService executor) {
        executor.shutdown();
        try {
            executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
        }
    }

    static Charset getContentCharset(String contentEncoding) throws ConfigException {
        try {
            return Optional.ofNullable(contentEncoding).map(Charset::forName).orElse(StandardCharsets.UTF_8);
        }
        catch (UnsupportedCharsetException ex) {
            throw new ConfigException("Unsupported response content-encoding '" + contentEncoding + "'.", ex);
        }
    }
}

