/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.sun.enterprise.v3.common.ActionReporter;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.utils.JsonUtil;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;

@Provider
@Produces(value={"application/json", "application/x-javascript"})
public class ActionReportJsonProvider
extends BaseProvider<ActionReporter> {
    public ActionReportJsonProvider() {
        super(ActionReporter.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    protected boolean isGivenTypeWritable(Class<?> type, Type genericType) {
        return this.desiredType.isAssignableFrom(type);
    }

    @Override
    public String getContent(ActionReporter ar) {
        String JSONP = this.getCallBackJSONP();
        try {
            JSONObject result = this.processReport(ar);
            int indent = this.getFormattingIndentLevel();
            if (indent > -1) {
                if (JSONP == null) {
                    return result.toString(indent);
                }
                return JSONP + "(" + result.toString(indent) + ")";
            }
            if (JSONP == null) {
                return result.toString();
            }
            return JSONP + "(" + result.toString() + ")";
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected JSONObject processReport(ActionReporter ar) throws JSONException {
        List subReports;
        List children;
        Properties extraProperties;
        JSONObject result = new JSONObject();
        result.put("message", (Object)(ar instanceof RestActionReporter ? ((RestActionReporter)ar).getCombinedMessage() : this.decodeEol(ar.getMessage())));
        result.put("command", (Object)ar.getActionDescription());
        result.put("exit_code", (Object)ar.getActionExitCode());
        Properties properties = ar.getTopMessagePart().getProps();
        if (properties != null && !properties.isEmpty()) {
            result.put("properties", (Map)properties);
        }
        if ((extraProperties = ar.getExtraProperties()) != null && !extraProperties.isEmpty()) {
            result.put("extraProperties", (Object)this.getExtraProperties(result, extraProperties));
        }
        if ((children = ar.getTopMessagePart().getChildren()) != null && !children.isEmpty()) {
            result.put("children", (Object)this.processChildren(children));
        }
        if ((subReports = ar.getSubActionsReport()) != null && !subReports.isEmpty()) {
            result.put("subReports", (Object)this.processSubReports(subReports));
        }
        return result;
    }

    protected JSONArray processChildren(List<ActionReport.MessagePart> parts) throws JSONException {
        JSONArray array = new JSONArray();
        for (ActionReport.MessagePart part : parts) {
            JSONObject object = new JSONObject();
            object.put("message", (Object)this.decodeEol(part.getMessage()));
            object.put("properties", (Map)part.getProps());
            List children = part.getChildren();
            if (children.size() > 0) {
                object.put("children", (Object)this.processChildren(part.getChildren()));
            }
            array.put((Object)object);
        }
        return array;
    }

    protected JSONArray processSubReports(List<ActionReporter> subReports) throws JSONException {
        JSONArray array = new JSONArray();
        for (ActionReporter subReport : subReports) {
            array.put((Object)this.processReport(subReport));
        }
        return array;
    }

    protected JSONObject getExtraProperties(JSONObject object, Properties props) throws JSONException {
        JSONObject extraProperties = new JSONObject();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            Object value = JsonUtil.getJsonObject(entry.getValue());
            extraProperties.put(key, value);
        }
        return extraProperties;
    }

    protected <T> T getFieldValue(final ActionReporter ar, final String name, T type) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                Object value = null;
                try {
                    Class<?> clazz = ar.getClass().getSuperclass();
                    Field field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    value = field.get(ar);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                return value;
            }
        });
    }

    protected String decodeEol(String str) {
        if (str == null) {
            return str;
        }
        return str.replace("%%%EOL%%%", "\n");
    }
}

