/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.config.validators;

import com.sun.enterprise.config.serverbeans.ResourcePool;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.validators.ConnectionPoolConstraint;
import org.glassfish.connectors.config.validators.ConnectionPoolErrorMessages;

public class ConnectionPoolValidator
implements ConstraintValidator<ConnectionPoolConstraint, ResourcePool> {
    protected ConnectionPoolErrorMessages poolFaults;

    public void initialize(ConnectionPoolConstraint constraint) {
        this.poolFaults = constraint.value();
    }

    public boolean isValid(ResourcePool pool, ConstraintValidatorContext constraintValidatorContext) {
        if (this.poolFaults == ConnectionPoolErrorMessages.MAX_STEADY_INVALID && pool instanceof ConnectorConnectionPool) {
            ConnectorConnectionPool connPool = (ConnectorConnectionPool)pool;
            String maxPoolSize = connPool.getMaxPoolSize();
            String steadyPoolSize = connPool.getSteadyPoolSize();
            if (steadyPoolSize == null) {
                steadyPoolSize = "8";
            }
            if (maxPoolSize == null) {
                maxPoolSize = "32";
            }
            if (Integer.parseInt(maxPoolSize) < Integer.parseInt(steadyPoolSize)) {
                return false;
            }
        }
        return true;
    }
}

