/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;

public class ConfigChangeEventHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public ConfigChangeEventHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(BrokerAddress sender, GPacket pkt) {
        if (DEBUG) {
            this.logger.log(4, "ConfigChangeEventHandler");
        }
        if (pkt.getType() == 17) {
            this.handleConfigChangeEvent(sender, pkt);
        } else if (pkt.getType() == 18) {
            this.handleConfigChangeEventReply(sender, pkt);
        } else {
            this.logger.log(16, "ConfigChangeEventHandler Internal error : Cannot handle this packet :" + pkt.toLongString());
        }
    }

    public void handleConfigChangeEvent(BrokerAddress sender, GPacket pkt) {
        Long xidProp = (Long)pkt.getProp("X");
        this.p.receiveConfigChangeEvent(sender, xidProp, pkt.getPayload().array());
    }

    public void handleConfigChangeEventReply(BrokerAddress sender, GPacket pkt) {
        Long xid = (Long)pkt.getProp("X");
        int status = (Integer)pkt.getProp("S");
        String reason = (String)pkt.getProp("reason");
        this.p.receiveConfigChangeEventReply(sender, xid, status, reason);
    }
}

