/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.io.txnlog.CheckPointListener;
import com.sun.messaging.jmq.io.txnlog.TransactionLogRecord;
import com.sun.messaging.jmq.io.txnlog.TransactionLogWriter;
import com.sun.messaging.jmq.io.txnlog.file.FileTransactionLogWriter;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.CheckpointManager;
import com.sun.messaging.jmq.jmsserver.persist.file.ClusterTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.LoggedMessageHelper;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgRemovalEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.NonTransactedMsgAckEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.NonTransactedMsgEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.PreparedTxnStore;
import com.sun.messaging.jmq.jmsserver.persist.file.RemoteTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogReplayer;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.WaitTimeoutException;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class TransactionLogManager
implements CheckPointListener {
    private static boolean DEBUG = false;
    static final String TXNLOG_PROP_PREFIX = "imq.persist.file.txnLog";
    static final String TXNLOG_FILE_SIZE_PROP = "imq.persist.file.txnLog.file.size";
    static final long DEFAULT_TXNLOG_FILE_SIZE_KB = 10240L;
    static final String MSG_LOG_FILENAME = "txnlog";
    static final String INCOMPLETE_TXN_STORE = "incompleteTxnStore";
    public static final BrokerResources br = Globals.getBrokerResources();
    FileStore store;
    File rootDir;
    boolean closed = false;
    private static boolean defaultLogNonTransactedMsgSend = Destination.PERSIST_SYNC;
    public static final String LOG_NON_TRANSACTED_MSG_SEND_PROP = "imq.persist.file.txnLog.logNonTransactedMsgSend";
    public static final boolean logNonTransactedMsgSend = Globals.getConfig().getBooleanProperty("imq.persist.file.txnLog.logNonTransactedMsgSend", defaultLogNonTransactedMsgSend);
    private static boolean defaultLogNonTransactedMsgAck = Destination.PERSIST_SYNC;
    public static final String LOG_NON_TRANSACTED_MSG_ACK_PROP = "imq.persist.file.txnLog.logNonTransactedMsgAck";
    public static final boolean logNonTransactedMsgAck = Globals.getConfig().getBooleanProperty("imq.persist.file.txnLog.logNonTransactedMsgAck", defaultLogNonTransactedMsgAck);
    public static final String TXN_LOG_GROUP_COMMITS_PROP = "imq.persist.file.txnLog.groupCommits";
    public static final boolean isTxnLogGroupCommits = Globals.getConfig().getBooleanProperty("imq.persist.file.txnLog.groupCommits", false);
    public static final String WAIT_LOCAL_PLAYTO_STORE_WITH_EXLOCK_PROP = "imq.persist.file.txnLog.waitLocalPlayToStoreCompletionWithExLock";
    public static final boolean waitLocalPlayToStoreWithExLock = Globals.getConfig().getBooleanProperty("imq.persist.file.txnLog.waitLocalPlayToStoreCompletionWithExLock", false);
    public static final String WAIT_REMOTE_PLAYTO_STORE_WITH_EXLOCK_PROP = "imq.persist.file.txnLog.waitRemotePlayToStoreCompletionWithExLock";
    public static final boolean waitRemotePlayToStoreWithExLock = Globals.getConfig().getBooleanProperty("imq.persist.file.txnLog.waitRemotePlayToStoreCompletionWithExLock", false);
    private static boolean replayInProgress = false;
    private TransactionLogWriter msgLogWriter = null;
    TransactionLogReplayer transactionLogReplayer;
    LocalTransactionManager localTransactionManager;
    ClusterTransactionManager clusterTransactionManager;
    RemoteTransactionManager remoteTransactionManager;
    LoggedMessageHelper loggedMessageHelper;
    CheckpointManager checkpointManager;
    PreparedTxnStore preparedTxnStore;
    public static final Logger logger = Globals.getLogger();
    private boolean playToStoreCompletionNotified = false;
    private Object playToStoreCompletionWaiter = new Object();

    public TransactionLogManager(Store store, MsgStore msgStore, File rootDir, boolean resetStore) throws BrokerException {
        this.rootDir = rootDir;
        this.store = (FileStore)store;
        File preparedTxnStoreDir = new File(rootDir, INCOMPLETE_TXN_STORE);
        if (resetStore) {
            this.clearPreparedTxnStore(preparedTxnStoreDir);
            this.resetTransactionLogOnStartUp();
        }
        this.preparedTxnStore = new PreparedTxnStore(msgStore, preparedTxnStoreDir, false);
        this.transactionLogReplayer = new TransactionLogReplayer(msgStore);
        this.localTransactionManager = new LocalTransactionManager(this);
        this.clusterTransactionManager = new ClusterTransactionManager(this);
        this.remoteTransactionManager = new RemoteTransactionManager(this);
        this.checkpointManager = new CheckpointManager(this);
        this.loggedMessageHelper = new LoggedMessageHelper(this);
    }

    public boolean getDEBUG() {
        return Store.getDEBUG() || DEBUG;
    }

    public void startup() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " startup");
        }
        this.processStoredTxnsOnStartup();
        this.initTransactionLogOnStartUp();
        this.replayTransactionLogOnStartup();
        this.localTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
        this.clusterTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
        this.remoteTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
        this.preparedTxnStore.sync();
        this.store.syncDestination(null);
        try {
            this.msgLogWriter.reset();
        }
        catch (IOException e) {
            throw new BrokerException("failed to reset transaction log", e);
        }
        this.removeCommittedTransactionsOnStartup();
    }

    public void close() {
        this.closed = true;
        try {
            if (this.msgLogWriter != null) {
                this.msgLogWriter.close(false);
            }
            if (this.preparedTxnStore != null) {
                this.preparedTxnStore.close(true);
            }
        }
        catch (IOException e) {
            logger.logStack(32, "caught exception closing", e);
        }
    }

    public static void deleteAllFileState(File rootDir) throws BrokerException {
        logger.log(4, "deleteAllFileState " + String.valueOf(rootDir));
        File txnLogFile = new File(rootDir, MSG_LOG_FILENAME);
        boolean deleted = false;
        if (txnLogFile.exists() && !(deleted = txnLogFile.delete())) {
            throw new BrokerException("Could not delete txnLog file " + String.valueOf(txnLogFile));
        }
        File incompleteTxnStore = new File(rootDir, INCOMPLETE_TXN_STORE);
        try {
            if (incompleteTxnStore.exists()) {
                FileUtil.removeFiles(incompleteTxnStore, true);
            }
        }
        catch (IOException e) {
            String msg = "Can not delete incomplete txn store " + String.valueOf(incompleteTxnStore);
            logger.log(32, msg, e);
            throw new BrokerException(msg, e);
        }
    }

    public static boolean txnLogExists(File rootDir) {
        File txnLogFile = new File(rootDir, MSG_LOG_FILENAME);
        return txnLogFile.exists();
    }

    public static boolean incompleteTxnStoreExists(File rootDir) {
        File file = new File(rootDir, INCOMPLETE_TXN_STORE);
        return file.exists();
    }

    public static void assertAllFilesExist(File rootDir) throws BrokerException {
        if (!TransactionLogManager.txnLogExists(rootDir)) {
            throw new BrokerException("assertion failure: txnlog file does not exist");
        }
        if (!TransactionLogManager.incompleteTxnStoreExists(rootDir)) {
            throw new BrokerException("assertion failure: incompleteTxnStore file does not exist");
        }
    }

    HashMap getAllTransactionStates() throws IOException {
        HashMap localTxnMap = this.localTransactionManager.getAllTransactionsMap();
        HashMap clusterTxnMap = this.clusterTransactionManager.getAllTransactionsMap();
        HashMap txnMap = new HashMap(localTxnMap.size() + clusterTxnMap.size());
        txnMap.putAll(localTxnMap);
        txnMap.putAll(clusterTxnMap);
        return txnMap;
    }

    void rollbackAllTransactions() {
        this.localTransactionManager.rollbackAllTransactions();
        this.clusterTransactionManager.rollbackAllTransactions();
        this.remoteTransactionManager.rollbackAllTransactions();
    }

    void processStoredTxnsOnStartup() throws BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " processStoredTxnsOnStartup";
            logger.log(4, msg);
        }
        this.preparedTxnStore.loadTransactions();
        Enumeration<BaseTransaction> transactions = this.preparedTxnStore.txnEnumeration();
        while (transactions.hasMoreElements()) {
            BaseTransaction baseTxn = transactions.nextElement();
            int type = baseTxn.getType();
            BaseTransactionManager baseTxnMan = this.getTransactionManager(type);
            baseTxnMan.processStoredTxnOnStartup(baseTxn);
        }
    }

    void removeCommittedTransactionsOnStartup() throws BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " removeCommitedTransactionsInPreparedTxnStore";
            logger.log(4, msg);
        }
        Enumeration<BaseTransaction> transactions = this.preparedTxnStore.txnEnumeration();
        ArrayList<BaseTransaction> committed = new ArrayList<BaseTransaction>();
        while (transactions.hasMoreElements()) {
            String msg;
            BaseTransaction baseTxn = transactions.nextElement();
            if (baseTxn.getState() != 6) continue;
            if (baseTxn.getType() == 3 && !baseTxn.getTransactionDetails().isComplete()) {
                if (!Store.getDEBUG()) continue;
                msg = this.getPrefix() + " not removing incomplete cluster transaction " + String.valueOf(baseTxn.getTransactionDetails());
                logger.log(4, msg);
                continue;
            }
            if (Store.getDEBUG()) {
                msg = this.getPrefix() + " removing transaction " + String.valueOf(baseTxn.getTransactionDetails());
                logger.log(4, msg);
            }
            committed.add(baseTxn);
        }
        for (BaseTransaction baseTxn : committed) {
            TransactionUID tid = baseTxn.getTid();
            this.preparedTxnStore.removeTransaction(tid, true);
            if (!Store.getDEBUG()) continue;
            String msg = this.getPrefix() + " removed committed transaction from preparedTxnStore. Tid=" + String.valueOf(tid);
            logger.log(4, msg);
        }
    }

    private void resetTransactionLogOnStartUp() {
        String filename = MSG_LOG_FILENAME;
        File file = new File(this.rootDir, filename);
        logger.log(8, "resetting txn Log file " + String.valueOf(file));
        if (!file.exists()) {
            logger.log(8, "nothing to reset. txn Log file " + String.valueOf(file) + " does not exist");
            return;
        }
        boolean deleted = file.delete();
        if (!deleted) {
            String msg = this.getPrefix() + " could not delete " + String.valueOf(file);
            logger.log(4, msg);
        }
    }

    private void clearPreparedTxnStore(File preparedTxnStoreDir) throws BrokerException {
        try {
            FileUtil.removeFiles(preparedTxnStoreDir, false);
        }
        catch (IOException e) {
            logger.log(32, "B4149", (Object)preparedTxnStoreDir, (Throwable)e);
            throw new BrokerException(br.getString("B4149", preparedTxnStoreDir), e);
        }
    }

    public static boolean transactionLogExists(File rootDir) {
        boolean result = false;
        String filename = MSG_LOG_FILENAME;
        File txnLogFile = new File(rootDir, filename);
        result = txnLogFile.exists();
        return result;
    }

    private void initTransactionLogOnStartUp() throws BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " initTransactionLogOnStartUp";
            logger.log(4, msg);
        }
        logger.log(8, "new transaction log enabled");
        logger.log(8, "sync writes to disk = " + Destination.PERSIST_SYNC);
        logger.log(8, "logNonTransactedMsgSend = " + logNonTransactedMsgSend);
        logger.log(8, "logNonTransactedMsgAck = " + logNonTransactedMsgAck);
        String filename = null;
        try {
            BrokerConfig config = Globals.getConfig();
            SizeString filesize = config.getSizeProperty(TXNLOG_FILE_SIZE_PROP, 10240L);
            filename = MSG_LOG_FILENAME;
            String mode = "rwd";
            boolean synch = true;
            if (!Destination.PERSIST_SYNC) {
                mode = "rw";
                synch = false;
            }
            logger.log(8, br.getKString("B1392", mode, filesize.getBytes()));
            FileTransactionLogWriter ftlw = new FileTransactionLogWriter(this.rootDir, filename, filesize.getBytes(), mode, synch, isTxnLogGroupCommits, 1L);
            long existingFormatVersion = ftlw.getExistingAppCookie();
            if (existingFormatVersion != 1L) {
                throw new BrokerException("Unexpected transaction log format. Format on file = " + existingFormatVersion + " Current software version = 1");
            }
            this.msgLogWriter = ftlw;
            this.msgLogWriter.setCheckPointListener(this);
            if (Store.getDEBUG()) {
                logger.log(4, "created txn log");
            }
        }
        catch (IOException ex) {
            logger.logStack(32, "B3225", filename, (Throwable)ex);
            throw new BrokerException(br.getString("B3225", filename), ex);
        }
    }

    public void replayTransactionLogOnStartup() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " replayTransactionLogOnStartup");
        }
        try {
            TransactionLogManager.setReplayInProgress(true);
            if (this.msgLogWriter.playBackRequired()) {
                if (Store.getDEBUG()) {
                    String msg = this.getPrefix() + " replayTransactionLogOnStartup: playBackRequired";
                    logger.log(4, msg);
                }
                logger.log(64, "B1270");
                Globals.getDestinationList();
                DestinationList.loadDestinations(this.store);
                Globals.getCoreLifecycle().initSubscriptions();
                HashSet dstLoadedSet = new HashSet();
                Iterator itr = this.msgLogWriter.iterator();
                while (itr.hasNext()) {
                    TransactionLogRecord rec = (TransactionLogRecord)itr.next();
                    byte[] data = rec.getBody();
                    TransactionEvent txnEvent = this.readTransactionEvent(data);
                    int type = txnEvent.getType();
                    if (Store.getDEBUG()) {
                        String msg = this.getPrefix() + " replayTransactionLogOnStartup() recordSeq= " + rec.getSequence() + " txnEvent= " + String.valueOf(txnEvent);
                        logger.log(4, msg);
                    }
                    if (type == 4) {
                        this.transactionLogReplayer.replayNonTxnMsg((NonTransactedMsgEvent)txnEvent, dstLoadedSet);
                        continue;
                    }
                    if (type == 5) {
                        this.transactionLogReplayer.replayNonTxnMsgAck((NonTransactedMsgAckEvent)txnEvent, dstLoadedSet);
                        continue;
                    }
                    if (type == 6) {
                        this.transactionLogReplayer.replayMessageRemoval((MsgRemovalEvent)txnEvent, dstLoadedSet);
                        continue;
                    }
                    BaseTransactionManager tm = this.getTransactionManager(type);
                    tm.replayTransactionEvent(txnEvent, dstLoadedSet);
                }
            } else if (Store.getDEBUG()) {
                logger.log(4, "no playBackRequired");
            }
        }
        catch (IOException e) {
            logger.log(32, "exception in playback", e);
            throw new BrokerException("exception in playback", e);
        }
        finally {
            TransactionLogManager.setReplayInProgress(false);
        }
    }

    TransactionEvent readTransactionEvent(byte[] data) throws IOException, BrokerException {
        TransactionEvent event = TransactionEvent.createFromBytes(data);
        return event;
    }

    public void loggedCommitWrittenToMessageStore(TransactionUID tid, int type) {
        BaseTransactionManager txnMan = this.getTransactionManager(type);
        txnMan.playingToMessageStoreComplete(tid);
    }

    BaseTransactionManager getTransactionManager(int type) {
        BaseTransactionManager r = null;
        switch (type) {
            case 1: {
                r = this.localTransactionManager;
                break;
            }
            case 3: {
                r = this.clusterTransactionManager;
                break;
            }
            case 2: {
                r = this.remoteTransactionManager;
                break;
            }
            case 0: {
                throw new UnsupportedOperationException("UNDEFINED_TRANSACTION_TYPE");
            }
            default: {
                throw new UnsupportedOperationException("unknown type:" + type);
            }
        }
        return r;
    }

    public void logMsgRemoval(DestinationUID dstID, SysMessageID mid) throws BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " logMsgRemoval() dstID=" + String.valueOf(dstID) + " mid=" + String.valueOf(mid);
            logger.log(4, msg);
        }
        try {
            this.store.txnLogSharedLock.lock();
            MsgRemovalEvent txnEvent = new MsgRemovalEvent(dstID, mid);
            byte[] data = txnEvent.writeToBytes();
            TransactionLogRecord record = this.msgLogWriter.newTransactionLogRecord();
            record.setBody(data);
            this.msgLogWriter.write(record);
        }
        catch (IOException ioe) {
            throw new BrokerException("error logging transaction", ioe);
        }
        finally {
            this.store.txnLogSharedLock.unlock();
        }
    }

    public void logNonTxnMessage(TransactionWorkMessage twm) throws BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " logNonTxnMessage() " + String.valueOf(twm);
            logger.log(4, msg);
        }
        try {
            this.store.txnLogSharedLock.lock();
            NonTransactedMsgEvent txnEvent = new NonTransactedMsgEvent(twm);
            this.writeTransactionEvent(txnEvent);
            this.loggedMessageHelper.messageLogged(twm);
        }
        finally {
            this.store.txnLogSharedLock.unlock();
        }
    }

    public void logNonTxnMessageAck(TransactionWorkMessageAck twma) throws BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " logNonTxnMessageAck() " + String.valueOf(twma);
            logger.log(4, msg);
        }
        try {
            this.store.txnLogSharedLock.lock();
            NonTransactedMsgAckEvent txnEvent = new NonTransactedMsgAckEvent(twma);
            this.writeTransactionEvent(txnEvent);
        }
        finally {
            this.store.txnLogSharedLock.unlock();
        }
    }

    public void logTxn(BaseTransaction baseTxn) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " logTxn() " + String.valueOf(baseTxn));
        }
        try {
            this.store.txnLogSharedLock.lock();
            int type = baseTxn.getType();
            BaseTransactionManager txnManager = this.getTransactionManager(type);
            txnManager.processTxn(baseTxn);
            TransactionEvent txnEvent = txnManager.generateEvent(baseTxn, false);
            this.writeTransactionEvent(txnEvent);
        }
        catch (IOException ioe) {
            throw new BrokerException("error logging transaction", ioe);
        }
        finally {
            this.store.txnLogSharedLock.unlock();
        }
    }

    public void logTxnCompletion(TransactionUID tid, int completionState, int type) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " logTxnCompletion() " + String.valueOf(tid));
        }
        try {
            this.store.txnLogSharedLock.lock();
            BaseTransactionManager txnMan = this.getTransactionManager(type);
            BaseTransaction existing = txnMan.processTxnCompletion(tid, completionState);
            TransactionEvent txnEvent = txnMan.generateEvent(existing, true);
            this.writeTransactionEvent(txnEvent);
        }
        catch (IOException ioe) {
            throw new BrokerException("error logging transaction", ioe);
        }
        finally {
            this.store.txnLogSharedLock.unlock();
        }
    }

    public void writeTransactionEvent(TransactionEvent txnEvent) throws BrokerException {
        try {
            byte[] data = txnEvent.writeToBytes();
            TransactionLogRecord record = this.msgLogWriter.newTransactionLogRecord();
            record.setBody(data);
            this.msgLogWriter.write(record);
        }
        catch (IOException ioe) {
            throw new BrokerException("error logging transaction", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPlayToStoreCompletion() {
        Object object = this.playToStoreCompletionWaiter;
        synchronized (object) {
            this.playToStoreCompletionNotified = true;
            this.playToStoreCompletionWaiter.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckpoint() {
        if (this.closed) {
            return;
        }
        if (Store.getDEBUG()) {
            logger.log(8, br.getKString("B1422"));
        }
        FileStore store = null;
        try {
            store = (FileStore)Globals.getStore();
        }
        catch (Throwable e) {
            logger.logStack(32, "failed to getStore", e);
        }
        boolean locked = false;
        try {
            int count = 0;
            while (true) {
                if (this.closed) {
                    return;
                }
                store.txnLogExclusiveLock.lock();
                locked = true;
                try {
                    Object msg = this.playToStoreCompletionWaiter;
                    synchronized (msg) {
                        this.playToStoreCompletionNotified = false;
                    }
                    this.localTransactionManager.waitForPlayingToMessageStoreCompletion(!waitLocalPlayToStoreWithExLock);
                    this.clusterTransactionManager.waitForPlayingToMessageStoreCompletion(!waitLocalPlayToStoreWithExLock);
                    this.remoteTransactionManager.waitForPlayingToMessageStoreCompletion(!waitRemotePlayToStoreWithExLock);
                    this.loggedMessageHelper.waitForPendingRemoveCompletion(!waitRemotePlayToStoreWithExLock);
                    break;
                }
                catch (WaitTimeoutException e) {
                    store.txnLogExclusiveLock.unlock();
                    locked = false;
                    ++count;
                    if (this.closed) {
                        throw e;
                    }
                    Object object = this.playToStoreCompletionWaiter;
                    synchronized (object) {
                        int cnt = 0;
                        while (!this.playToStoreCompletionNotified && !this.closed) {
                            try {
                                this.playToStoreCompletionWaiter.wait(1000L);
                                ++cnt;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (cnt % 15 != 0) continue;
                            Object[] args = new String[]{e.getMessage() + "(" + cnt + ", " + count + ")"};
                            logger.log(16, br.getKTString("B2259", args));
                        }
                    }
                }
            }
            store.syncStoreOnCheckpoint();
            this.localTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
            this.clusterTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
            this.remoteTransactionManager.writePreparedTransactionsToPreparedTxnStoreOnCheckpoint();
            this.preparedTxnStore.sync();
            this.msgLogWriter.checkpoint();
            this.localTransactionManager.removeCompleteTransactionsAfterCheckpoint();
            this.clusterTransactionManager.removeCompleteTransactionsAfterCheckpoint();
            this.remoteTransactionManager.removeCompleteTransactionsAfterCheckpoint();
            this.loggedMessageHelper.onCheckpoint();
            if (Store.getDEBUG()) {
                logger.log(8, br.getKString("B1423"));
            }
        }
        catch (Throwable e) {
            String msg = this.getPrefix() + "Failed to synchronize persistence store for transaction log checkpoint";
            logger.logStack(32, "B3100", msg, e);
        }
        finally {
            try {
                if (locked) {
                    store.txnLogExclusiveLock.unlock();
                }
            }
            finally {
                Object object = this.playToStoreCompletionWaiter;
                synchronized (object) {
                    this.playToStoreCompletionNotified = true;
                    this.playToStoreCompletionWaiter.notifyAll();
                }
            }
            if (this.getDEBUG()) {
                String msg = this.getPrefix() + " doCheckpoint complete";
                logger.log(8, msg);
            }
        }
    }

    @Override
    public final void checkpoint() {
        if (Store.getDEBUG()) {
            logger.log(4, this.getPrefix() + " request a checkpoint");
        }
        this.checkpointManager.enqueueCheckpoint();
    }

    String getPrefix() {
        return "TransactionLogManager: " + Thread.currentThread().getName();
    }

    public LocalTransactionManager getLocalTransactionManager() {
        return this.localTransactionManager;
    }

    public ClusterTransactionManager getClusterTransactionManager() {
        return this.clusterTransactionManager;
    }

    public RemoteTransactionManager getRemoteTransactionManager() {
        return this.remoteTransactionManager;
    }

    public LoggedMessageHelper getLoggedMessageHelper() {
        return this.loggedMessageHelper;
    }

    public static boolean isReplayInProgress() {
        return replayInProgress;
    }

    public static void setReplayInProgress(boolean val) {
        replayInProgress = val;
    }
}

