/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.net.InetSocketAddress;
import java.util.Objects;

public class HostAndPort {
    private final String host;
    private final int port;
    private final boolean secure;

    public HostAndPort(String host, int port, boolean secure) {
        this.host = Objects.requireNonNull(host, "Host name is mandatory.");
        this.port = port;
        this.secure = secure;
        if (port == 0) {
            throw new IllegalArgumentException("Zero port is not allowed.");
        }
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.secure);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostAndPort other = (HostAndPort)obj;
        return Objects.equals(this.host, other.host) && this.port == other.port && this.secure == other.secure;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

