/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.jmsserver.comm.CommGlobals;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.FileLock;
import java.util.StringTokenizer;

public class LockFile {
    private static LockFile currentLockFile = null;
    private static final System.Logger logger = System.getLogger(LockFile.class.getName());
    private String hostname = null;
    private String instance = null;
    private String filePath = null;
    private int port = 0;
    private boolean isMyLock = false;

    private LockFile() {
    }

    private LockFile(String instance, String hostname, int port) {
        this.hostname = hostname;
        this.instance = instance;
        this.port = port;
    }

    public static synchronized void clearLock() {
        currentLockFile = null;
    }

    public static synchronized LockFile getLock(String varhome, String instance, String hostname, int port, boolean useFileLock) throws IOException {
        LockFile lf = null;
        File file = new File(LockFile.getLockFilePath(varhome, instance));
        if (file.createNewFile()) {
            lf = new LockFile(instance, hostname, port);
            lf.filePath = file.getCanonicalPath();
            lf.writeLockFile(file, useFileLock, true);
            lf.isMyLock = true;
            file.deleteOnExit();
            currentLockFile = lf;
            return lf;
        }
        lf = LockFile.loadLockFile(file, useFileLock);
        if (lf == null) {
            lf = new LockFile(instance, hostname, port);
            lf.filePath = file.getCanonicalPath();
            lf.writeLockFile(file, useFileLock, true);
            lf.isMyLock = true;
            file.deleteOnExit();
            currentLockFile = lf;
            return lf;
        }
        lf.filePath = file.getCanonicalPath();
        if (port == lf.getPort() && LockFile.equivalentHostNames(hostname, lf.getHost(), false) && instance.equals(lf.getInstance())) {
            file.deleteOnExit();
            lf.isMyLock = true;
            currentLockFile = lf;
            return lf;
        }
        if (port == lf.getPort() && LockFile.isSameIP(hostname, lf.getHost()) && instance.equals(lf.getInstance())) {
            lf.updateHostname(hostname, useFileLock);
            file.deleteOnExit();
            lf.isMyLock = true;
            currentLockFile = lf;
            return lf;
        }
        try (Socket unused = new Socket(InetAddress.getByName(lf.hostname), lf.port);){
            lf.isMyLock = false;
        }
        catch (IOException e) {
            if (!file.delete()) {
                throw new IOException(CommGlobals.getBrokerResources().getString("B4106"));
            }
            return LockFile.getLock(varhome, instance, hostname, port, useFileLock);
        }
        currentLockFile = lf;
        return lf;
    }

    public static boolean isSameIP(String host1, String host2) {
        boolean sflag = false;
        try {
            String addr1 = InetAddress.getByName(host1).getHostAddress();
            String addr2 = InetAddress.getByName(host2).getHostAddress();
            if (addr1.equals(addr2)) {
                sflag = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, e.getMessage(), (Throwable)e);
        }
        return sflag;
    }

    public static String getLockFilePath(String varhome, String instance) {
        return varhome + File.separator + "instances" + File.separator + instance + File.separator + "lock";
    }

    public boolean isMyLock() {
        return this.isMyLock;
    }

    public String getHost() {
        return this.hostname;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.instance + " " + this.hostname + ":" + this.port + " (" + this.isMyLock + ")";
    }

    public void updatePort(int port, boolean useFileLock) throws IOException {
        File file = new File(this.filePath);
        int oldPort = this.port;
        this.port = port;
        try {
            this.writeLockFile(file, useFileLock);
        }
        catch (IOException e) {
            this.port = oldPort;
            throw e;
        }
    }

    public void updateHostname(String hostname, boolean useFileLock) throws IOException {
        File file = new File(this.filePath);
        String oldHostname = this.hostname;
        this.hostname = hostname;
        try {
            this.writeLockFile(file, useFileLock);
        }
        catch (IOException e) {
            this.hostname = oldHostname;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized LockFile loadLockFile(File file, boolean useFileLock) throws IOException {
        byte[] data = new byte[128];
        LockFile lf = new LockFile();
        FileInputStream fis = new FileInputStream(file);
        FileLock filelock = null;
        try {
            if (useFileLock) {
                if (file.length() == 0L) {
                    LockFile lockFile = null;
                    return lockFile;
                }
                filelock = fis.getChannel().tryLock(0L, Long.MAX_VALUE, true);
                if (filelock == null) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    filelock = fis.getChannel().tryLock(0L, Long.MAX_VALUE, true);
                    if (filelock == null) {
                        throw new IOException(CommGlobals.getBrokerResources().getKString("B4456", file.toString()));
                    }
                }
            }
            fis.read(data);
            String s = new String(data, "UTF8");
            int i1 = s.indexOf(58);
            if (i1 == -1) {
                throw new IOException(CommGlobals.getBrokerResources().getKString("B4314", file.toString(), "[" + s + "]"));
            }
            StringTokenizer st = new StringTokenizer(s.substring(0, i1), " \t\n\r\f");
            lf.instance = st.nextToken();
            int i2 = s.lastIndexOf(58);
            if (i2 == -1 || i1 == i2) {
                throw new IOException(CommGlobals.getBrokerResources().getKString("B4314", file.toString(), "[" + s + "]"));
            }
            st = new StringTokenizer(s.substring(i2 + 1), " \t\n\r\f");
            lf.port = Integer.parseInt(st.nextToken());
            st = new StringTokenizer(s.substring(i1 + 1, i2), " \t\n\r\f");
            lf.hostname = st.nextToken();
        }
        finally {
            if (filelock != null) {
                filelock.release();
            }
            fis.close();
        }
        return lf;
    }

    public void writeLockFile(File file, boolean useFileLock) throws IOException {
        this.writeLockFile(file, useFileLock, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeLockFile(File file, boolean useFileLock, boolean checkEmpty) throws IOException {
        String data = this.instance + ":" + this.hostname + ":" + this.port + "\n";
        FileOutputStream os = new FileOutputStream(file);
        FileLock filelock = null;
        try {
            if (useFileLock) {
                filelock = os.getChannel().tryLock();
                if (filelock == null) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    filelock = os.getChannel().tryLock();
                    if (filelock == null) {
                        throw new IOException(CommGlobals.getBrokerResources().getKString("B4455", file.toString(), this.toString()));
                    }
                }
                if (checkEmpty && file.length() != 0L) {
                    throw new IOException(CommGlobals.getBrokerResources().getKString("B4454", file, this.toString()));
                }
            }
            os.write(data.getBytes("UTF8"));
            os.getChannel().force(false);
        }
        finally {
            if (filelock != null) {
                filelock.release();
            }
            os.close();
        }
    }

    public static LockFile getCurrentLockFile() {
        return currentLockFile;
    }

    public static boolean equivalentHostNames(String h1, String h2, boolean exact) {
        if (exact) {
            return h1.equals(h2);
        }
        StringTokenizer st1 = new StringTokenizer(h1, ".");
        StringTokenizer st2 = new StringTokenizer(h2, ".");
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            if (st1.nextToken().equals(st2.nextToken())) continue;
            return false;
        }
        return true;
    }
}

