/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.copyobject.impl;

import org.glassfish.pfl.basic.logex.Chain;
import org.glassfish.pfl.basic.logex.ExceptionWrapper;
import org.glassfish.pfl.basic.logex.Log;
import org.glassfish.pfl.basic.logex.LogLevel;
import org.glassfish.pfl.basic.logex.Message;
import org.glassfish.pfl.basic.logex.WrapperGenerator;
import org.glassfish.pfl.dynamic.copyobject.spi.ReflectiveCopyException;

@ExceptionWrapper(idPrefix="OBJCOPY")
public interface Exceptions {
    public static final Exceptions self = (Exceptions)WrapperGenerator.makeWrapper(Exceptions.class);
    public static final int EXCEPTIONS_PER_CLASS = 100;
    public static final int FB_START = 1;
    public static final int CCB_START = 101;
    public static final int DC_START = 201;
    public static final int CCFPI_START = 301;
    public static final int CCOI_START = 401;

    @Message(value="Object copy failed on copy of {0} which has type {1}")
    @Log(id=1, level=LogLevel.FINE)
    public void failureInFallback(@Chain ReflectiveCopyException var1, Object var2, Class<?> var3);

    @Message(value="Stack overflow while copying {0}")
    @Log(id=101, level=LogLevel.WARNING)
    public ReflectiveCopyException stackOverflow(Object var1, @Chain StackOverflowError var2);

    @Message(value="Could not copy {0}")
    @Log(id=201, level=LogLevel.WARNING)
    public ReflectiveCopyException couldNotCopy(Object var1, ReflectiveCopyException var2);

    @Log(id=301, level=LogLevel.WARNING)
    @Message(value="Cannot copy interface (attempt was for {0})")
    public ReflectiveCopyException cannotCopyInterface(Class<?> var1);

    @Log(id=302, level=LogLevel.WARNING)
    @Message(value="Could not find ClassCopier for {0}")
    public IllegalStateException couldNotFindClassCopier(Class<?> var1);

    @Log(id=303, level=LogLevel.WARNING)
    @Message(value="Could not copy class {0}")
    public ReflectiveCopyException cannotCopyClass(Class<?> var1);

    @Message(value="Exception in readResolve() for {0}")
    @Log(id=401, level=LogLevel.WARNING)
    public RuntimeException exceptionInReadResolve(Object var1, @Chain Throwable var2);

    @Message(value="Cannot create ClassFieldCopier for superclass {0} : This class already has a ClassCopier")
    @Log(id=401, level=LogLevel.WARNING)
    public ReflectiveCopyException noClassCopierForSuperclass(Class<?> var1);
}

