/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import org.glassfish.grizzly.servlet.FilterMap;
import org.glassfish.grizzly.servlet.Registration;
import org.glassfish.grizzly.servlet.WebappContext;

public class FilterRegistration
extends Registration
implements FilterRegistration.Dynamic {
    protected Class<? extends Filter> filterClass;
    protected Filter filter;
    protected boolean isAsyncSupported;

    protected FilterRegistration(WebappContext ctx, String name, String filterClassName) {
        super(ctx, name, filterClassName);
        this.initParameters = new HashMap(4, 1.0f);
    }

    protected FilterRegistration(WebappContext ctx, String name, Class<? extends Filter> filter) {
        this(ctx, name, filter.getName());
        this.filterClass = filter;
    }

    protected FilterRegistration(WebappContext ctx, String name, Filter filter) {
        this(ctx, name, filter.getClass());
        this.filter = filter;
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, String ... servletNames) {
        this.addMappingForServletNames(dispatcherTypes, true, servletNames);
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        if (servletNames == null || servletNames.length == 0) {
            throw new IllegalArgumentException("'servletNames' is null or zero-length");
        }
        for (String servletName : servletNames) {
            FilterMap fmap = new FilterMap();
            fmap.setFilterName(this.getName());
            fmap.setServletName(servletName);
            fmap.setDispatcherTypes(dispatcherTypes);
            this.ctx.addFilterMap(fmap, isMatchAfter);
        }
    }

    public Collection<String> getServletNameMappings() {
        return this.ctx.getServletNameFilterMappings(this.getName());
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, String ... urlPatterns) {
        this.addMappingForUrlPatterns(dispatcherTypes, true, urlPatterns);
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        if (urlPatterns == null || urlPatterns.length == 0) {
            throw new IllegalArgumentException("'urlPatterns' is null or zero-length");
        }
        for (String urlPattern : urlPatterns) {
            FilterMap fmap = new FilterMap();
            fmap.setFilterName(this.getName());
            fmap.setURLPattern(urlPattern);
            fmap.setDispatcherTypes(dispatcherTypes);
            this.ctx.addFilterMap(fmap, isMatchAfter);
        }
    }

    public Collection<String> getUrlPatternMappings() {
        return this.ctx.getUrlPatternFilterMappings(this.getName());
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        this.isAsyncSupported = isAsyncSupported;
    }
}

