/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.io.File;
import java.util.Locale;

public class OS {
    private OS() {
    }

    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static boolean isUNIX() {
        return File.separatorChar == '/';
    }

    public static boolean isUnix() {
        return OS.isUNIX();
    }

    public static boolean isLinux() {
        return OS.isName("linux");
    }

    public static boolean isDarwin() {
        return OS.isName("Mac OS X");
    }

    public static boolean isWindowsForSure() {
        return OS.isName("windows") && OS.isWindows();
    }

    public static boolean isAix() {
        return OS.isName("AIX");
    }

    private static boolean isArch(String name) {
        String archname = System.getProperty("os.arch");
        if (archname == null || archname.isEmpty()) {
            return false;
        }
        return (archname = archname.toLowerCase(Locale.getDefault())).indexOf(name = name.toLowerCase(Locale.getDefault())) >= 0;
    }

    private static boolean isName(String name) {
        String osname = System.getProperty("os.name");
        if (osname == null || osname.isEmpty()) {
            return false;
        }
        return (osname = osname.toLowerCase(Locale.getDefault())).contains(name = name.toLowerCase(Locale.getDefault()));
    }
}

