/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.server.logging.ServerLogFileManager;
import jakarta.inject.Singleton;
import java.io.File;
import org.glassfish.main.jul.JULHelperFactory;
import org.glassfish.main.jul.handler.GlassFishLogHandler;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@ContractsProvided(value={ServerLogFileManager.class})
public class ServerLogFileService
implements ServerLogFileManager {
    private final JULHelperFactory.JULHelper julHelper = JULHelperFactory.getHelper();

    @Override
    public File getCurrentLogFile() {
        GlassFishLogHandler logHandler = this.julHelper.findGlassFishLogHandler();
        if (logHandler == null) {
            this.julHelper.getSystemLogger(this.getClass()).log(System.Logger.Level.WARNING, "The GlassFishLogHandler was not found, returning null");
            return null;
        }
        return logHandler.getConfiguration().getLogFile();
    }

    @Override
    public void roll() {
        GlassFishLogHandler logHandler = this.julHelper.findGlassFishLogHandler();
        if (logHandler == null) {
            throw new IllegalStateException("The GlassFishLogHandler was not found, rolling the output file failed.");
        }
        logHandler.roll();
    }
}

