/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.contexts.BusyConversationException;
import org.jboss.weld.contexts.NonexistentConversationException;
import org.jboss.weld.logging.ConversationLogger;
import org.jboss.weld.logging.WeldLogger;

public class ConversationLogger_$logger
extends DelegatingBasicLogger
implements ConversationLogger,
WeldLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConversationLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ConversationLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void cleaningUpConversation(Object param1) {
        this.log.logv(FQCN, Logger.Level.TRACE, null, this.cleaningUpConversation$str(), param1);
    }

    protected String cleaningUpConversation$str() {
        return "WELD-000304: Cleaning up conversation {0}";
    }

    @Override
    public final void conversationLocked(Object param1) {
        this.log.logv(FQCN, Logger.Level.TRACE, null, this.conversationLocked$str(), param1);
    }

    protected String conversationLocked$str() {
        return "WELD-000313: Lock acquired on conversation {0}";
    }

    @Override
    public final void conversationUnlocked(Object param1) {
        this.log.logv(FQCN, Logger.Level.TRACE, null, this.conversationUnlocked$str(), param1);
    }

    protected String conversationUnlocked$str() {
        return "WELD-000314: Lock released on conversation {0}";
    }

    @Override
    public final void conversationUnavailable(Object param1, Object param2) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.conversationUnavailable$str(), param1, param2);
    }

    protected String conversationUnavailable$str() {
        return "WELD-000315: Failed to acquire conversation lock in {0} ms for {1}";
    }

    @Override
    public final void illegalConversationUnlockAttempt(Object param1, Object param2) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.illegalConversationUnlockAttempt$str(), param1, param2);
    }

    protected String illegalConversationUnlockAttempt$str() {
        return "WELD-000316: Attempt to release lock on conversation {0} failed because {1}";
    }

    @Override
    public final void promotedTransientConversation(Object param1) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.promotedTransientConversation$str(), param1);
    }

    protected String promotedTransientConversation$str() {
        return "WELD-000317: Promoted conversation {0} to long-running";
    }

    @Override
    public final void demotedLongRunningConversation(Object param1) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.demotedLongRunningConversation$str(), param1);
    }

    protected String demotedLongRunningConversation$str() {
        return "WELD-000318: Returned long-running conversation {0} to transient";
    }

    @Override
    public final void cleaningUpTransientConversation() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.cleaningUpTransientConversation$str(), new Object[0]);
    }

    protected String cleaningUpTransientConversation$str() {
        return "WELD-000320: Cleaning up transient conversation";
    }

    protected String noConversationFoundToRestore$str() {
        return "WELD-000321: No conversation found to restore for id {0}";
    }

    @Override
    public final NonexistentConversationException noConversationFoundToRestore(Object param1) {
        NonexistentConversationException result = new NonexistentConversationException(this._formatMessage(this.noConversationFoundToRestore$str(), param1));
        ConversationLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String conversationLockTimedout$str() {
        return "WELD-000322: Conversation lock timed out: {0}";
    }

    @Override
    public final BusyConversationException conversationLockTimedout(Object param1) {
        BusyConversationException result = new BusyConversationException(this._formatMessage(this.conversationLockTimedout$str(), param1));
        ConversationLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    @Override
    public final void foundConversationFromRequest(Object param1) {
        this.log.logv(FQCN, Logger.Level.TRACE, null, this.foundConversationFromRequest$str(), param1);
    }

    protected String foundConversationFromRequest$str() {
        return "WELD-000326: Found conversation id {0} in request parameter";
    }

    @Override
    public final void resumingConversation(Object param1) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.resumingConversation$str(), param1);
    }

    protected String resumingConversation$str() {
        return "WELD-000327: Resuming conversation with id {0}";
    }

    protected String beginCalledOnLongRunningConversation$str() {
        return "WELD-000328: Attempt to call begin() on a long-running conversation";
    }

    @Override
    public final IllegalStateException beginCalledOnLongRunningConversation() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.beginCalledOnLongRunningConversation$str(), new Object[0]));
        ConversationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String endCalledOnTransientConversation$str() {
        return "WELD-000329: Attempt to call end() on a transient conversation";
    }

    @Override
    public final IllegalStateException endCalledOnTransientConversation() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.endCalledOnTransientConversation$str(), new Object[0]));
        ConversationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conversationIdAlreadyInUse$str() {
        return "WELD-000332: Conversation ID {0} is already in use";
    }

    @Override
    public final IllegalArgumentException conversationIdAlreadyInUse(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.conversationIdAlreadyInUse$str(), param1));
        ConversationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustCallAssociateBeforeActivate$str() {
        return "WELD-000333: Must call associate() before calling activate()";
    }

    @Override
    public final IllegalStateException mustCallAssociateBeforeActivate() {
        IllegalStateException result = new IllegalStateException(this.mustCallAssociateBeforeActivate$str());
        ConversationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustCallAssociateBeforeDeactivate$str() {
        return "WELD-000334: Must call associate() before calling deactivate()";
    }

    @Override
    public final IllegalStateException mustCallAssociateBeforeDeactivate() {
        IllegalStateException result = new IllegalStateException(this.mustCallAssociateBeforeDeactivate$str());
        ConversationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void contextAlreadyActive(Object request) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.contextAlreadyActive$str(), request);
    }

    protected String contextAlreadyActive$str() {
        return "WELD-000335: Conversation context is already active, most likely it was not cleaned up properly during previous request processing: {0}";
    }

    protected String contextNotActive$str() {
        return "WELD-000336: Conversation context is not active";
    }

    @Override
    public final IllegalStateException contextNotActive() {
        IllegalStateException result = new IllegalStateException(this.contextNotActive$str());
        ConversationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conversationNamingSchemeNotFound$str() {
        return "WELD-000337: Unable to find ConversationNamingScheme in the request, this conversation wasn't transient at the start of the request";
    }

    @Override
    public final IllegalStateException conversationNamingSchemeNotFound() {
        IllegalStateException result = new IllegalStateException(this.conversationNamingSchemeNotFound$str());
        ConversationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conversationIdGeneratorNotFound$str() {
        return "WELD-000338: Unable to locate ConversationIdGenerator";
    }

    @Override
    public final IllegalStateException conversationIdGeneratorNotFound() {
        IllegalStateException result = new IllegalStateException(this.conversationIdGeneratorNotFound$str());
        ConversationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustCallAssociateBeforeGeneratingId$str() {
        return "WELD-000339: A request must be associated with the context in order to generate a conversation id";
    }

    @Override
    public final IllegalStateException mustCallAssociateBeforeGeneratingId() {
        IllegalStateException result = new IllegalStateException(this.mustCallAssociateBeforeGeneratingId$str());
        ConversationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustCallAssociateBeforeLoadingKnownConversations$str() {
        return "WELD-000340: A request must be associated with the context in order to load the known conversations";
    }

    @Override
    public final IllegalStateException mustCallAssociateBeforeLoadingKnownConversations() {
        IllegalStateException result = new IllegalStateException(this.mustCallAssociateBeforeLoadingKnownConversations$str());
        ConversationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadConversations$str() {
        return "WELD-000341: Unable to load the conversations from the associated request - {0}: {1}, request: {2}";
    }

    @Override
    public final IllegalStateException unableToLoadConversations(String attributeName, Object attributeValue, Object request) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.unableToLoadConversations$str(), attributeName, attributeValue, request));
        ConversationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void endLockedConversation(String cid) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.endLockedConversation$str(), (Object)cid);
    }

    protected String endLockedConversation$str() {
        return "WELD-000342: Going to end a locked conversation with id {0}";
    }

    protected String unableToLoadCurrentConversation$str() {
        return "WELD-000343: Unable to load the current conversation from the associated request - {0}: {1}, request: {2}";
    }

    @Override
    public final IllegalStateException unableToLoadCurrentConversation(String attributeName, Object attributeValue, Object request) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.unableToLoadCurrentConversation$str(), attributeName, attributeValue, request));
        ConversationLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void catchingDebug(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.DEBUG, throwable, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }
}

