/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HalfOuterJoinNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.shared.common.error.StandardException;

class JoinNode
extends TableOperatorNode {
    static final int INNERJOIN = 1;
    static final int CROSSJOIN = 2;
    static final int LEFTOUTERJOIN = 3;
    static final int RIGHTOUTERJOIN = 4;
    static final int FULLOUTERJOIN = 5;
    static final int UNIONJOIN = 6;
    private boolean naturalJoin;
    private boolean optimized;
    private PredicateList leftPredicateList;
    private PredicateList rightPredicateList;
    protected boolean flattenableJoin = true;
    List<AggregateNode> aggregates;
    SubqueryList subqueryList;
    ValueNode joinClause;
    boolean joinClauseNormalized;
    PredicateList joinPredicates;
    ResultColumnList usingClause;
    Properties joinOrderStrategyProperties;

    JoinNode(ResultSetNode resultSetNode, ResultSetNode resultSetNode2, ValueNode valueNode, ResultColumnList resultColumnList, ResultColumnList resultColumnList2, Properties properties, Properties properties2, ContextManager contextManager) throws StandardException {
        super(resultSetNode, resultSetNode2, properties, contextManager);
        this.setResultColumns(resultColumnList2);
        this.joinClause = valueNode;
        this.joinClauseNormalized = false;
        this.usingClause = resultColumnList;
        this.joinOrderStrategyProperties = properties2;
        if (this.getResultColumns() != null && this.leftResultSet.getReferencedTableMap() != null) {
            this.setReferencedTableMap((JBitSet)this.leftResultSet.getReferencedTableMap().clone());
            this.getReferencedTableMap().or(this.rightResultSet.getReferencedTableMap());
        }
        this.joinPredicates = new PredicateList(contextManager);
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceOptimizingJoinNode();
        }
        this.updateBestPlanMap((short)1, this);
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, this.getLeftPredicateList(), costEstimate);
        for (int i = this.joinPredicates.size() - 1; i >= 0; --i) {
            Predicate predicate = (Predicate)this.joinPredicates.elementAt(i);
            if (!((Predicate)this.joinPredicates.elementAt(i)).getPushable()) continue;
            this.joinPredicates.removeElementAt(i);
            this.getRightPredicateList().addElement(predicate);
        }
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, this.getRightPredicateList(), this.leftResultSet.getCostEstimate());
        this.setCostEstimate(this.getCostEstimate(optimizer));
        this.getCostEstimate().setCost(this.leftResultSet.getCostEstimate().getEstimatedCost() + this.rightResultSet.getCostEstimate().getEstimatedCost(), this.rightResultSet.getCostEstimate().rowCount(), this.rightResultSet.getCostEstimate().rowCount());
        this.adjustNumberOfRowsReturned(this.getCostEstimate());
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, optimizablePredicateList, null, costEstimate, optimizer, this.getCostEstimate());
        optimizer.considerCost(this, optimizablePredicateList, this.getCostEstimate(), costEstimate);
        if (!this.optimized && this.subqueryList != null) {
            this.subqueryList.optimize(optimizer.getDataDictionary(), this.getCostEstimate().rowCount());
            this.subqueryList.modifyAccessPaths();
        }
        this.optimized = true;
        return this.getCostEstimate();
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        this.joinPredicates.addPredicate((Predicate)optimizablePredicate);
        RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
        ((Predicate)optimizablePredicate).getAndNode().accept(remapCRsVisitor);
        return true;
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        super.modifyAccessPath(jBitSet);
        return this;
    }

    protected void adjustNumberOfRowsReturned(CostEstimate costEstimate) {
    }

    @Override
    ResultColumnList getAllResultColumns(TableName tableName) throws StandardException {
        if (this.usingClause == null) {
            return this.getAllResultColumnsNoUsing(tableName);
        }
        ResultSetNode resultSetNode = this.getLogicalLeftResultSet();
        ResultColumnList resultColumnList = resultSetNode.getAllResultColumns(null).getJoinColumns(this.usingClause);
        ResultColumnList resultColumnList2 = this.leftResultSet.getAllResultColumns(tableName);
        ResultColumnList resultColumnList3 = this.rightResultSet.getAllResultColumns(tableName);
        if (resultColumnList2 != null) {
            resultColumnList2.removeJoinColumns(this.usingClause);
        }
        if (resultColumnList3 != null) {
            resultColumnList3.removeJoinColumns(this.usingClause);
        }
        if (resultColumnList2 == null) {
            if (resultColumnList3 == null) {
                return null;
            }
            resultColumnList3.resetVirtualColumnIds();
            return resultColumnList3;
        }
        if (resultColumnList3 == null) {
            resultColumnList2.resetVirtualColumnIds();
            return resultColumnList2;
        }
        resultColumnList.destructiveAppend(resultColumnList2);
        resultColumnList.destructiveAppend(resultColumnList3);
        resultColumnList.resetVirtualColumnIds();
        return resultColumnList;
    }

    private ResultColumnList getAllResultColumnsNoUsing(TableName tableName) throws StandardException {
        ResultColumnList resultColumnList = this.leftResultSet.getAllResultColumns(tableName);
        ResultColumnList resultColumnList2 = this.rightResultSet.getAllResultColumns(tableName);
        if (resultColumnList == null) {
            return resultColumnList2;
        }
        if (resultColumnList2 == null) {
            return resultColumnList;
        }
        ResultColumnList resultColumnList3 = new ResultColumnList(this.getContextManager());
        resultColumnList3.nondestructiveAppend(resultColumnList);
        resultColumnList3.nondestructiveAppend(resultColumnList2);
        return resultColumnList3;
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        ResultSetNode resultSetNode = this.getLogicalLeftResultSet();
        ResultSetNode resultSetNode2 = this.getLogicalRightResultSet();
        ResultColumn resultColumn = null;
        ResultColumn resultColumn2 = null;
        ResultColumn resultColumn3 = null;
        ResultColumn resultColumn4 = resultSetNode.getMatchingColumn(columnReference);
        if (resultColumn4 != null) {
            resultColumn = resultColumn4;
            if (this.usingClause != null) {
                resultColumn3 = this.usingClause.getResultColumn(resultColumn4.getName());
            }
        }
        if (resultColumn3 == null) {
            resultColumn2 = resultSetNode2.getMatchingColumn(columnReference);
        } else if (this instanceof HalfOuterJoinNode && ((HalfOuterJoinNode)this).isRightOuterJoin()) {
            resultColumn4.setRightOuterJoinUsingClause(true);
        }
        if (resultColumn2 != null) {
            if (resultColumn4 != null) {
                throw StandardException.newException("42X03", columnReference.getSQLColumnName());
            }
            if (this instanceof HalfOuterJoinNode) {
                resultColumn2.setNullability(true);
            }
            resultColumn = resultColumn2;
        }
        if (this.getResultColumns() != null) {
            for (ResultColumn resultColumn5 : this.getResultColumns()) {
                VirtualColumnNode virtualColumnNode = (VirtualColumnNode)resultColumn5.getExpression();
                if (resultColumn != virtualColumnNode.getSourceColumn()) continue;
                resultColumn = resultColumn5;
                break;
            }
        }
        return resultColumn;
    }

    @Override
    public void bindExpressions(FromList fromList) throws StandardException {
        super.bindExpressions(fromList);
        if (this.naturalJoin) {
            this.usingClause = this.getCommonColumnsForNaturalJoin();
        }
    }

    @Override
    void bindResultColumns(FromList fromList) throws StandardException {
        super.bindResultColumns(fromList);
        this.buildRCL();
        this.deferredBindExpressions(fromList);
    }

    @Override
    void bindResultColumns(TableDescriptor tableDescriptor, FromVTI fromVTI, ResultColumnList resultColumnList, DMLStatementNode dMLStatementNode, FromList fromList) throws StandardException {
        super.bindResultColumns(tableDescriptor, fromVTI, resultColumnList, dMLStatementNode, fromList);
        this.buildRCL();
        this.deferredBindExpressions(fromList);
    }

    private void buildRCL() throws StandardException {
        if (this.getResultColumns() != null) {
            return;
        }
        this.setResultColumns(this.leftResultSet.getResultColumns());
        ResultColumnList resultColumnList = this.getResultColumns().copyListAndObjects();
        this.leftResultSet.setResultColumns(resultColumnList);
        this.getResultColumns().genVirtualColumnNodes(this.leftResultSet, resultColumnList, false);
        if (this instanceof HalfOuterJoinNode && ((HalfOuterJoinNode)this).isRightOuterJoin()) {
            this.getResultColumns().setNullability(true);
        }
        ResultColumnList resultColumnList2 = this.rightResultSet.getResultColumns();
        ResultColumnList resultColumnList3 = resultColumnList2.copyListAndObjects();
        this.rightResultSet.setResultColumns(resultColumnList3);
        resultColumnList2.genVirtualColumnNodes(this.rightResultSet, resultColumnList3, false);
        resultColumnList2.adjustVirtualColumnIds(this.getResultColumns().size());
        if (this instanceof HalfOuterJoinNode && !((HalfOuterJoinNode)this).isRightOuterJoin()) {
            resultColumnList2.setNullability(true);
        }
        this.getResultColumns().nondestructiveAppend(resultColumnList2);
    }

    private void deferredBindExpressions(FromList fromList) throws StandardException {
        Object object;
        ContextManager contextManager = this.getContextManager();
        CompilerContext compilerContext = this.getCompilerContext();
        this.subqueryList = new SubqueryList(contextManager);
        this.aggregates = new ArrayList<AggregateNode>();
        if (this.joinClause != null) {
            this.joinClause = this.bindExpression(this.joinClause, true, true, "ON");
        } else if (this.usingClause != null) {
            this.joinClause = new BooleanConstantNode(true, contextManager);
            object = this.usingClause.iterator();
            while (object.hasNext()) {
                ResultColumn resultColumn = (ResultColumn)object.next();
                fromList.insertElementAt(this.leftResultSet, 0);
                ValueNode valueNode = new ColumnReference(resultColumn.getName(), ((FromTable)this.leftResultSet).getTableName(), contextManager);
                valueNode = valueNode.bindExpression(fromList, this.subqueryList, (List)this.aggregates);
                fromList.removeElementAt(0);
                fromList.insertElementAt(this.rightResultSet, 0);
                ValueNode valueNode2 = new ColumnReference(resultColumn.getName(), ((FromTable)this.rightResultSet).getTableName(), contextManager);
                valueNode2 = valueNode2.bindExpression(fromList, this.subqueryList, (List)this.aggregates);
                fromList.removeElementAt(0);
                BinaryRelationalOperatorNode binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(0, valueNode, valueNode2, false, contextManager);
                binaryRelationalOperatorNode.bindComparisonOperator();
                AndNode andNode = new AndNode(binaryRelationalOperatorNode, this.joinClause, contextManager);
                andNode.postBindFixup();
                this.joinClause = andNode;
            }
        }
        if (this.joinClause != null) {
            if (this.joinClause.requiresTypeFromContext()) {
                this.joinClause.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, true));
            }
            if (((TypeId)(object = this.joinClause.getTypeId())).userType()) {
                this.joinClause = this.joinClause.genSQLJavaSQLTree();
            }
            if (!this.joinClause.getTypeServices().getTypeId().equals(TypeId.BOOLEAN_ID)) {
                throw StandardException.newException("42Y12", this.joinClause.getTypeServices().getTypeId().getSQLTypeName());
            }
        }
    }

    public ValueNode bindExpression(ValueNode valueNode, boolean bl, boolean bl2, String string) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        CompilerContext compilerContext = this.getCompilerContext();
        FromList fromList = this.makeFromList(bl, bl2);
        int n = this.orReliability(16384);
        valueNode = valueNode.bindExpression(fromList, this.subqueryList, this.aggregates);
        compilerContext.setReliability(n);
        SelectNode.checkNoWindowFunctions(valueNode, string);
        if (!this.aggregates.isEmpty()) {
            throw StandardException.newException("42Z07", new Object[0]);
        }
        return valueNode;
    }

    public FromList makeFromList(boolean bl, boolean bl2) throws StandardException {
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        if (bl) {
            fromList.addElement((FromTable)this.leftResultSet);
        }
        if (bl2) {
            fromList.addElement((FromTable)this.rightResultSet);
        }
        return fromList;
    }

    private ResultColumnList getCommonColumnsForNaturalJoin() throws StandardException {
        ResultColumnList resultColumnList = this.getLeftResultSet().getAllResultColumns(null);
        ResultColumnList resultColumnList2 = this.getRightResultSet().getAllResultColumns(null);
        List<String> list = JoinNode.extractColumnNames(resultColumnList);
        list.retainAll(JoinNode.extractColumnNames(resultColumnList2));
        ResultColumnList resultColumnList3 = new ResultColumnList(this.getContextManager());
        for (String string : list) {
            ResultColumn resultColumn = new ResultColumn(string, null, this.getContextManager());
            resultColumnList3.addResultColumn(resultColumn);
        }
        return resultColumnList3;
    }

    private static List<String> extractColumnNames(ResultColumnList resultColumnList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ResultColumn resultColumn : resultColumnList) {
            arrayList.add(resultColumn.getName());
        }
        return arrayList;
    }

    @Override
    ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        ResultSetNode resultSetNode = super.preprocess(n, groupByList, fromList);
        if (this.joinClause != null) {
            this.normExpressions();
            if (this.subqueryList != null) {
                this.joinClause = this.joinClause.preprocess(n, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()), new SubqueryList(this.getContextManager()), new PredicateList(this.getContextManager()));
            }
            this.joinPredicates.pullExpressions(n, this.joinClause);
            this.joinPredicates.categorize();
            this.joinClause = null;
        }
        return resultSetNode;
    }

    @Override
    void projectResultColumns() throws StandardException {
        this.leftResultSet.projectResultColumns();
        this.rightResultSet.projectResultColumns();
        this.getResultColumns().pullVirtualIsReferenced();
        super.projectResultColumns();
    }

    void normExpressions() throws StandardException {
        if (this.joinClauseNormalized) {
            return;
        }
        this.joinClause = this.joinClause.eliminateNots(false);
        this.joinClause = this.joinClause.putAndsOnTop();
        this.joinClause = this.joinClause.changeToCNF(false);
        this.joinClauseNormalized = true;
    }

    @Override
    void pushExpressions(PredicateList predicateList) throws StandardException {
        FromTable fromTable = (FromTable)this.leftResultSet;
        FromTable fromTable2 = (FromTable)this.rightResultSet;
        this.pushExpressionsToLeft(predicateList);
        fromTable.pushExpressions(this.getLeftPredicateList());
        this.pushExpressionsToRight(predicateList);
        fromTable2.pushExpressions(this.getRightPredicateList());
        this.grabJoinPredicates(predicateList);
    }

    protected void pushExpressionsToLeft(PredicateList predicateList) throws StandardException {
        FromTable fromTable = (FromTable)this.leftResultSet;
        JBitSet jBitSet = fromTable.getReferencedTableMap();
        for (int i = predicateList.size() - 1; i >= 0; --i) {
            JBitSet jBitSet2;
            Predicate predicate = (Predicate)predicateList.elementAt(i);
            if (!predicate.getPushable() || !jBitSet.contains(jBitSet2 = predicate.getReferencedSet())) continue;
            this.getLeftPredicateList().addPredicate(predicate);
            RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(remapCRsVisitor);
            predicate.getAndNode().accept(remapCRsVisitor);
            predicateList.removeElementAt(i);
        }
    }

    private void pushExpressionsToRight(PredicateList predicateList) throws StandardException {
        FromTable fromTable = (FromTable)this.rightResultSet;
        JBitSet jBitSet = fromTable.getReferencedTableMap();
        for (int i = predicateList.size() - 1; i >= 0; --i) {
            JBitSet jBitSet2;
            Predicate predicate = (Predicate)predicateList.elementAt(i);
            if (!predicate.getPushable() || !jBitSet.contains(jBitSet2 = predicate.getReferencedSet())) continue;
            this.getRightPredicateList().addPredicate(predicate);
            RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(remapCRsVisitor);
            predicate.getAndNode().accept(remapCRsVisitor);
            predicateList.removeElementAt(i);
        }
    }

    private void grabJoinPredicates(PredicateList predicateList) throws StandardException {
        FromTable fromTable = (FromTable)this.leftResultSet;
        FromTable fromTable2 = (FromTable)this.rightResultSet;
        JBitSet jBitSet = fromTable.getReferencedTableMap();
        JBitSet jBitSet2 = fromTable2.getReferencedTableMap();
        for (int i = predicateList.size() - 1; i >= 0; --i) {
            Predicate predicate = (Predicate)predicateList.elementAt(i);
            if (!predicate.getPushable()) continue;
            JBitSet jBitSet3 = predicate.getReferencedSet();
            JBitSet jBitSet4 = (JBitSet)jBitSet2.clone();
            jBitSet4.or(jBitSet);
            if (!jBitSet4.contains(jBitSet3)) continue;
            this.joinPredicates.addPredicate(predicate);
            RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(remapCRsVisitor);
            predicate.getAndNode().accept(remapCRsVisitor);
            predicateList.removeElementAt(i);
        }
    }

    @Override
    FromList flatten(ResultColumnList resultColumnList, PredicateList predicateList, SubqueryList subqueryList, GroupByList groupByList, ValueNode valueNode) throws StandardException {
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        fromList.addElement((FromTable)this.leftResultSet);
        fromList.addElement((FromTable)this.rightResultSet);
        this.getResultColumns().setRedundant();
        resultColumnList.remapColumnReferencesToExpressions();
        predicateList.remapColumnReferencesToExpressions();
        if (groupByList != null) {
            groupByList.remapColumnReferencesToExpressions();
        }
        if (valueNode != null) {
            valueNode.remapColumnReferencesToExpressions();
        }
        if (this.joinPredicates.size() > 0) {
            predicateList.destructiveAppend(this.joinPredicates);
        }
        if (this.subqueryList != null && this.subqueryList.size() > 0) {
            subqueryList.destructiveAppend(this.subqueryList);
        }
        return fromList;
    }

    @Override
    boolean LOJ_reorderable(int n) throws StandardException {
        return false;
    }

    @Override
    FromTable transformOuterJoins(ValueNode valueNode, int n) throws StandardException {
        if (valueNode == null) {
            ((FromTable)this.leftResultSet).transformOuterJoins(null, n);
            ((FromTable)this.rightResultSet).transformOuterJoins(null, n);
            return this;
        }
        this.leftResultSet = ((FromTable)this.leftResultSet).transformOuterJoins(valueNode, n);
        this.rightResultSet = ((FromTable)this.rightResultSet).transformOuterJoins(valueNode, n);
        return this;
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCore(activationClassBuilder, methodBuilder, 1, null, null);
    }

    void generateCore(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, int n) throws StandardException {
        this.generateCore(activationClassBuilder, methodBuilder, n, this.joinClause, this.subqueryList);
    }

    void generateCore(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, int n, ValueNode valueNode, SubqueryList subqueryList) throws StandardException {
        if (this.joinPredicates != null) {
            valueNode = this.joinPredicates.restorePredicates();
            this.joinPredicates = null;
        }
        this.assignResultSetNumber();
        if (subqueryList != null && subqueryList.size() > 0) {
            subqueryList.setPointOfAttachment(this.getResultSetNumber());
        }
        String string = n == 3 ? ((Optimizable)((Object)this.rightResultSet)).getTrulyTheBestAccessPath().getJoinStrategy().halfOuterJoinResultSetMethodName() : ((Optimizable)((Object)this.rightResultSet)).getTrulyTheBestAccessPath().getJoinStrategy().joinResultSetMethodName();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        int n2 = this.getJoinArguments(activationClassBuilder, methodBuilder, valueNode);
        methodBuilder.callMethod((short)185, null, string, "org.apache.derby.iapi.sql.execute.NoPutResultSet", n2);
    }

    private int getJoinArguments(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, ValueNode valueNode) throws StandardException {
        int n = this.getNumJoinArguments();
        this.leftResultSet.generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.leftResultSet.getResultColumns().size());
        this.rightResultSet.generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.rightResultSet.getResultColumns().size());
        this.setCostEstimate(this.getFinalCostEstimate());
        if (valueNode == null) {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder methodBuilder2 = activationClassBuilder.newUserExprFun();
            valueNode.generate(activationClassBuilder, methodBuilder2);
            methodBuilder2.methodReturn();
            methodBuilder2.complete();
            activationClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        }
        methodBuilder.push(this.getResultSetNumber());
        this.addOuterJoinArguments(activationClassBuilder, methodBuilder);
        this.oneRowRightSide(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        if (this.joinOrderStrategyProperties != null) {
            methodBuilder.push(PropertyUtil.sortProperties(this.joinOrderStrategyProperties));
        } else {
            methodBuilder.pushNull("java.lang.String");
        }
        return n;
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.getCandidateFinalCostEstimate() != null) {
            return this.getCandidateFinalCostEstimate();
        }
        CostEstimate costEstimate = this.leftResultSet.getFinalCostEstimate();
        CostEstimate costEstimate2 = this.rightResultSet.getFinalCostEstimate();
        this.setCandidateFinalCostEstimate(this.getNewCostEstimate());
        this.getCandidateFinalCostEstimate().setCost(costEstimate.getEstimatedCost() + costEstimate2.getEstimatedCost(), costEstimate2.rowCount(), costEstimate2.rowCount());
        return this.getCandidateFinalCostEstimate();
    }

    void oneRowRightSide(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        methodBuilder.push(this.rightResultSet.isOneRowResultSet());
        methodBuilder.push(this.rightResultSet.isNotExists());
    }

    protected int getNumJoinArguments() {
        return 11;
    }

    int addOuterJoinArguments(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        return 0;
    }

    static String joinTypeToString(int n) {
        switch (n) {
            case 1: {
                return "INNER JOIN";
            }
            case 2: {
                return "CROSS JOIN";
            }
            case 3: {
                return "LEFT OUTER JOIN";
            }
            case 4: {
                return "RIGHT OUTER JOIN";
            }
            case 5: {
                return "FULL OUTER JOIN";
            }
            case 6: {
                return "UNION JOIN";
            }
        }
        return null;
    }

    protected PredicateList getLeftPredicateList() throws StandardException {
        if (this.leftPredicateList == null) {
            this.leftPredicateList = new PredicateList(this.getContextManager());
        }
        return this.leftPredicateList;
    }

    protected PredicateList getRightPredicateList() throws StandardException {
        if (this.rightPredicateList == null) {
            this.rightPredicateList = new PredicateList(this.getContextManager());
        }
        return this.rightPredicateList;
    }

    @Override
    int updateTargetLockMode() {
        return 6;
    }

    @Override
    void notFlattenableJoin() {
        this.flattenableJoin = false;
        this.leftResultSet.notFlattenableJoin();
        this.rightResultSet.notFlattenableJoin();
    }

    @Override
    boolean isFlattenableJoinNode() {
        return this.flattenableJoin;
    }

    @Override
    boolean isOrderedOn(ColumnReference[] columnReferenceArray, boolean bl, List<FromBaseTable> list) throws StandardException {
        return this.leftResultSet.isOrderedOn(columnReferenceArray, bl, list);
    }

    @Override
    void printSubNodes(int n) {
    }

    void setSubqueryList(SubqueryList subqueryList) {
        this.subqueryList = subqueryList;
    }

    void setAggregates(List<AggregateNode> list) {
        this.aggregates = list;
    }

    void setNaturalJoin() {
        this.naturalJoin = true;
    }

    ResultSetNode getLogicalLeftResultSet() {
        return this.leftResultSet;
    }

    ResultSetNode getLogicalRightResultSet() {
        return this.rightResultSet;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.getResultColumns() != null) {
            this.setResultColumns((ResultColumnList)this.getResultColumns().accept(visitor));
        }
        if (this.joinClause != null) {
            this.joinClause = (ValueNode)this.joinClause.accept(visitor);
        }
        if (this.usingClause != null) {
            this.usingClause = (ResultColumnList)this.usingClause.accept(visitor);
        }
        if (this.joinPredicates != null) {
            this.joinPredicates = (PredicateList)this.joinPredicates.accept(visitor);
        }
    }

    @Override
    JBitSet LOJgetReferencedTables(int n) throws StandardException {
        JBitSet jBitSet = this.leftResultSet.LOJgetReferencedTables(n);
        if (jBitSet == null) {
            return null;
        }
        jBitSet.or(this.rightResultSet.LOJgetReferencedTables(n));
        return jBitSet;
    }
}

