/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Graphics2D;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.AxisPair;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Legend_Marker;
import org.knowm.xchart.internal.chartpart.Plot_XY;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyle;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyleCycler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.theme.Theme;

public class XYChart
extends Chart<XYStyler, XYSeries> {
    public XYChart(int width, int height) {
        super(width, height, new XYStyler());
        this.axisPair = new AxisPair<XYStyler, XYSeries>(this);
        this.plot = new Plot_XY<XYStyler, XYSeries>(this);
        this.legend = new Legend_Marker<XYStyler, XYSeries>(this);
    }

    public XYChart(int width, int height, Theme theme) {
        this(width, height);
        ((XYStyler)this.styler).setTheme(theme);
    }

    public XYChart(int width, int height, Styler.ChartTheme chartTheme) {
        this(width, height, chartTheme.newInstance(chartTheme));
    }

    public XYChart(XYChartBuilder chartBuilder) {
        this(chartBuilder.width, chartBuilder.height, chartBuilder.chartTheme);
        this.setTitle(chartBuilder.title);
        this.setXAxisTitle(chartBuilder.xAxisTitle);
        this.setYAxisTitle(chartBuilder.yAxisTitle);
    }

    public XYSeries addSeries(String seriesName, double[] yData) {
        return this.addSeries(seriesName, null, yData);
    }

    public XYSeries addSeries(String seriesName, double[] xData, double[] yData) {
        return this.addSeries(seriesName, xData, yData, null, Series.DataType.Number);
    }

    public XYSeries addSeries(String seriesName, float[] yData) {
        return this.addSeries(seriesName, (float[])null, yData, (float[])null);
    }

    public XYSeries addSeries(String seriesName, float[] xData, float[] yData) {
        return this.addSeries(seriesName, xData, yData, (float[])null);
    }

    public XYSeries addSeries(String seriesName, float[] xData, float[] yData, float[] errorBars) {
        return this.addSeries(seriesName, Utils.getDoubleArrayFromFloatArray(xData), Utils.getDoubleArrayFromFloatArray(yData), Utils.getDoubleArrayFromFloatArray(errorBars), Series.DataType.Number);
    }

    public XYSeries addSeries(String seriesName, int[] yData) {
        return this.addSeries(seriesName, (int[])null, yData, (int[])null);
    }

    public XYSeries addSeries(String seriesName, int[] xData, int[] yData) {
        return this.addSeries(seriesName, xData, yData, (int[])null);
    }

    public XYSeries addSeries(String seriesName, int[] xData, int[] yData, int[] errorBars) {
        return this.addSeries(seriesName, Utils.getDoubleArrayFromIntArray(xData), Utils.getDoubleArrayFromIntArray(yData), Utils.getDoubleArrayFromIntArray(errorBars), Series.DataType.Number);
    }

    public XYSeries addSeries(String seriesName, List<?> xData, List<? extends Number> yData) {
        return this.addSeries(seriesName, xData, yData, null);
    }

    public XYSeries addSeries(String seriesName, List<? extends Number> yData) {
        return this.addSeries(seriesName, null, yData, null);
    }

    public XYSeries addSeries(String seriesName, List<?> xData, List<? extends Number> yData, List<? extends Number> errorBars) {
        Series.DataType dataType = this.getDataType(xData);
        switch (dataType) {
            case Date: {
                return this.addSeries(seriesName, Utils.getDoubleArrayFromDateList(xData), Utils.getDoubleArrayFromNumberList(yData), Utils.getDoubleArrayFromNumberList(errorBars), Series.DataType.Date);
            }
        }
        return this.addSeries(seriesName, Utils.getDoubleArrayFromNumberList(xData), Utils.getDoubleArrayFromNumberList(yData), Utils.getDoubleArrayFromNumberList(errorBars), Series.DataType.Number);
    }

    private Series.DataType getDataType(List<?> data) {
        Series.DataType axisType;
        if (data == null || data.isEmpty()) {
            return Series.DataType.Number;
        }
        Iterator<?> itr = data.iterator();
        Object dataPoint = itr.next();
        if (dataPoint instanceof Number) {
            axisType = Series.DataType.Number;
        } else if (dataPoint instanceof Date) {
            axisType = Series.DataType.Date;
        } else {
            throw new IllegalArgumentException("Series data must be either Number or Date type!!!");
        }
        return axisType;
    }

    public XYSeries addSeries(String seriesName, double[] xData, double[] yData, double[] errorBars) {
        return this.addSeries(seriesName, xData, yData, errorBars, Series.DataType.Number);
    }

    private XYSeries addSeries(String seriesName, double[] xData, double[] yData, double[] errorBars, Series.DataType dataType) {
        XYSeries series;
        this.sanityCheck(seriesName, xData, yData, errorBars);
        if (xData != null) {
            if (xData.length != yData.length) {
                throw new IllegalArgumentException("X and Y-Axis sizes are not the same!!!");
            }
            series = new XYSeries(seriesName, xData, yData, errorBars, dataType);
        } else {
            series = new XYSeries(seriesName, Utils.getGeneratedDataAsArray(yData.length), yData, errorBars, dataType);
        }
        this.seriesMap.put(seriesName, series);
        return series;
    }

    public XYSeries updateXYSeries(String seriesName, List<?> newXData, List<? extends Number> newYData, List<? extends Number> newErrorBarData) {
        Series.DataType dataType = this.getDataType(newXData);
        switch (dataType) {
            case Date: {
                return this.updateXYSeries(seriesName, Utils.getDoubleArrayFromDateList(newXData), Utils.getDoubleArrayFromNumberList(newYData), Utils.getDoubleArrayFromNumberList(newErrorBarData));
            }
        }
        return this.updateXYSeries(seriesName, Utils.getDoubleArrayFromNumberList(newXData), Utils.getDoubleArrayFromNumberList(newYData), Utils.getDoubleArrayFromNumberList(newErrorBarData));
    }

    public XYSeries updateXYSeries(String seriesName, double[] newXData, double[] newYData, double[] newErrorBarData) {
        Map seriesMap = this.getSeriesMap();
        XYSeries series = (XYSeries)seriesMap.get(seriesName);
        if (series == null) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< not found!!!");
        }
        if (newXData == null) {
            double[] generatedXData = Utils.getGeneratedDataAsArray(newYData.length);
            series.replaceData(generatedXData, newYData, newErrorBarData);
        } else {
            series.replaceData(newXData, newYData, newErrorBarData);
        }
        return series;
    }

    private void sanityCheck(String seriesName, double[] xData, double[] yData, double[] errorBars) {
        if (this.seriesMap.containsKey(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series!!!");
        }
        if (yData == null) {
            throw new IllegalArgumentException("Y-Axis data cannot be null!!! >" + seriesName);
        }
        if (yData.length == 0) {
            throw new IllegalArgumentException("Y-Axis data cannot be empty!!! >" + seriesName);
        }
        if (xData != null && xData.length == 0) {
            throw new IllegalArgumentException("X-Axis data cannot be empty!!! >" + seriesName);
        }
        if (errorBars != null && errorBars.length != yData.length) {
            throw new IllegalArgumentException("Error bars and Y-Axis sizes are not the same!!! >" + seriesName);
        }
    }

    @Override
    public void paint(Graphics2D g, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        for (XYSeries xySeries : this.getSeriesMap().values()) {
            XYSeries.XYSeriesRenderStyle chartXYSeriesRenderStyle = xySeries.getXYSeriesRenderStyle();
            if (chartXYSeriesRenderStyle != null) continue;
            xySeries.setXYSeriesRenderStyle(((XYStyler)this.getStyler()).getDefaultSeriesRenderStyle());
        }
        this.setSeriesStyles();
        this.paintBackground(g);
        this.axisPair.paint(g);
        this.plot.paint(g);
        this.chartTitle.paint(g);
        this.legend.paint(g);
        this.annotations.forEach(x -> x.paint(g));
    }

    private void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((XYStyler)this.getStyler()).getSeriesColors(), ((XYStyler)this.getStyler()).getSeriesMarkers(), ((XYStyler)this.getStyler()).getSeriesLines());
        for (XYSeries series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            if (series.getLineStyle() == null) {
                series.setLineStyle(seriesColorMarkerLineStyle.getStroke());
            }
            if (series.getLineColor() == null) {
                series.setLineColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getFillColor() == null) {
                series.setFillColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getMarker() == null) {
                series.setMarker(seriesColorMarkerLineStyle.getMarker());
            }
            if (series.getMarkerColor() != null) continue;
            series.setMarkerColor(seriesColorMarkerLineStyle.getColor());
        }
    }
}

