/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.automata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.IncomingEdgeIterator;
import org.eclipse.escet.cif.eventbased.automata.OutgoingEdgeIterator;
import org.eclipse.escet.cif.eventbased.automata.origin.Origin;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class Location {
    public Edge incomingEdges = null;
    public Edge outgoingEdges = null;
    public Location prevLoc = null;
    public Location nextLoc = null;
    public boolean marked = false;
    public final Origin origin;

    public Location(Automaton aut, Origin origin) {
        this.origin = origin;
        aut.registerLocation(this);
    }

    public void removeInternal() {
        this.removeAllIncomingEdges();
        this.removeAllOutgoingEdges();
        Assert.check((this.incomingEdges == null ? 1 : 0) != 0);
        Assert.check((this.outgoingEdges == null ? 1 : 0) != 0);
        if (this.prevLoc != null) {
            this.prevLoc.nextLoc = this.nextLoc;
        }
        if (this.nextLoc != null) {
            this.nextLoc.prevLoc = this.prevLoc;
        }
    }

    public void addOutgoingEdge(Edge edge) {
        Assert.check((edge.nextOutgoing == null ? 1 : 0) != 0);
        edge.nextOutgoing = this.outgoingEdges;
        this.outgoingEdges = edge;
    }

    public void addIncomingEdge(Edge edge) {
        Assert.check((edge.nextIncoming == null ? 1 : 0) != 0);
        edge.nextIncoming = this.incomingEdges;
        this.incomingEdges = edge;
    }

    public void removeAllOutgoingEdges() {
        Map splitEdges = Maps.map();
        Edge e = this.outgoingEdges;
        while (e != null) {
            Set se = (Set)splitEdges.get(e.dstLoc);
            if (se == null) {
                se = Sets.set();
                splitEdges.put(e.dstLoc, se);
            }
            se.add(e);
            e = e.nextOutgoing;
        }
        for (Map.Entry locEdges : splitEdges.entrySet()) {
            ((Location)locEdges.getKey()).removeIncomingEdges((Set)locEdges.getValue());
        }
        this.outgoingEdges = null;
    }

    private void removeIncomingEdges(Set<Edge> edges) {
        Edge curEdge = this.incomingEdges;
        Edge newEdge = null;
        while (curEdge != null && !edges.isEmpty()) {
            if (!edges.remove(curEdge)) {
                if (newEdge == null) {
                    this.incomingEdges = curEdge;
                } else {
                    newEdge.nextIncoming = curEdge;
                }
                newEdge = curEdge;
            }
            curEdge = curEdge.nextIncoming;
        }
        if (newEdge == null) {
            this.incomingEdges = curEdge;
        } else {
            newEdge.nextIncoming = curEdge;
        }
    }

    public void removeAllIncomingEdges() {
        Map splitEdges = Maps.map();
        Edge e = this.incomingEdges;
        while (e != null) {
            Set se = (Set)splitEdges.get(e.srcLoc);
            if (se == null) {
                se = Sets.set();
                splitEdges.put(e.srcLoc, se);
            }
            se.add(e);
            e = e.nextIncoming;
        }
        for (Map.Entry locEdges : splitEdges.entrySet()) {
            ((Location)locEdges.getKey()).removeOutgoingEdges((Set)locEdges.getValue());
        }
        this.incomingEdges = null;
    }

    private void removeOutgoingEdges(Set<Edge> edges) {
        Edge curEdge = this.outgoingEdges;
        Edge newEdge = null;
        while (curEdge != null && !edges.isEmpty()) {
            if (!edges.remove(curEdge)) {
                if (newEdge == null) {
                    this.outgoingEdges = curEdge;
                } else {
                    newEdge.nextOutgoing = curEdge;
                }
                newEdge = curEdge;
            }
            curEdge = curEdge.nextOutgoing;
        }
        if (newEdge == null) {
            this.outgoingEdges = curEdge;
        } else {
            newEdge.nextOutgoing = curEdge;
        }
    }

    public void removeIncomingEdge(Edge edge) {
        Edge prev = null;
        Edge e = this.incomingEdges;
        while (e != edge) {
            prev = e;
            e = e.nextIncoming;
        }
        if (prev == null) {
            this.incomingEdges = e.nextIncoming;
        } else {
            prev.nextIncoming = e.nextIncoming;
        }
        e.nextIncoming = null;
    }

    public void removeOutgoingEdge(Edge edge) {
        Edge prev = null;
        Edge e = this.outgoingEdges;
        while (e != edge) {
            prev = e;
            e = e.nextOutgoing;
        }
        if (prev == null) {
            this.outgoingEdges = e.nextOutgoing;
        } else {
            prev.nextOutgoing = e.nextOutgoing;
        }
        e.nextOutgoing = null;
    }

    public OutgoingEdgeIterator getOutgoing() {
        return this.getOutgoing(null);
    }

    public IncomingEdgeIterator getIncoming() {
        return this.getIncoming(null);
    }

    public OutgoingEdgeIterator getOutgoing(Event evt) {
        return new OutgoingEdgeIterator(this, evt);
    }

    public IncomingEdgeIterator getIncoming(Event evt) {
        return new IncomingEdgeIterator(this, evt);
    }

    public List<Annotation> createStateAnnos() {
        return this.origin == null ? Collections.emptyList() : this.origin.createStateAnnos();
    }

    public String toString() {
        return this.origin.toString();
    }
}

