/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

public class PermuteUtils {
    private static final int[] FACTORIALS = new int[]{1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 479001600};

    private PermuteUtils() {
    }

    public static int[][] permute(int[] a) {
        int permCnt = PermuteUtils.factorial(a.length);
        int[][] perms = new int[permCnt][a.length];
        PermuteUtils.permute(a, perms);
        return perms;
    }

    public static void permute(int[] a, int[][] p) {
        int n = a.length;
        int[] c = new int[n];
        int pi = 0;
        System.arraycopy(a, 0, p[pi++], 0, n);
        int i = 1;
        while (i < n) {
            if (c[i] < i) {
                int k = i % 2 * c[i];
                int tmp = a[k];
                a[k] = a[i];
                a[i] = tmp;
                System.arraycopy(a, 0, p[pi++], 0, n);
                int n2 = i;
                c[n2] = c[n2] + 1;
                i = 1;
                continue;
            }
            c[i++] = 0;
        }
    }

    public static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n > 12) {
            throw new IllegalArgumentException("n > 12");
        }
        return FACTORIALS[n];
    }
}

