/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime;

import java.util.List;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.SelectChoice;
import org.eclipse.escet.chi.runtime.SimulationData;
import org.eclipse.escet.chi.runtime.SimulationResult;
import org.eclipse.escet.chi.runtime.SimulationState;
import org.eclipse.escet.chi.runtime.data.BaseProcess;
import org.eclipse.escet.chi.runtime.data.Timer;
import org.eclipse.escet.chi.runtime.data.io.ChiFileHandle;
import org.eclipse.escet.chi.runtime.data.io.ChiReadDataFile;
import org.eclipse.escet.chi.runtime.data.random.GaussianGenerator;
import org.eclipse.escet.chi.runtime.data.random.MersenneTwister;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.java.Assert;

public class ChiCoordinator {
    private final Application<?> app;
    private SimulationData currentSim;
    private ChiFileHandle stdout;
    private ChiFileHandle stdin;
    private RandomGenerator randGen;
    private GaussianGenerator gausGen;
    private long seed;
    private final boolean seedProvided;

    public ChiCoordinator(Application<?> app, long seed, boolean seedProvided) {
        this.app = app;
        this.stdout = ChiFileHandle.createFile(null, "w", "text");
        this.stdin = null;
        this.currentSim = null;
        this.randGen = null;
        this.gausGen = null;
        this.seed = seed;
        this.seedProvided = seedProvided;
    }

    public Timer addTimer(Timer t) {
        return this.currentSim.addTimer(t);
    }

    public ChiFileHandle openFile(String path, String operation, String type) {
        Assert.check((path != null ? 1 : 0) != 0);
        return this.currentSim.openFile(path, operation, type);
    }

    public ChiFileHandle getStdin() {
        if (this.stdin == null) {
            this.stdin = ChiFileHandle.createFile(null, "r", "text");
        }
        return this.stdin;
    }

    public ChiFileHandle getStdout() {
        return this.stdout;
    }

    public void closeFiles() {
        this.currentSim.closeFiles();
    }

    public void closeFile(ChiFileHandle handle) {
        this.currentSim.closeFile(handle);
    }

    public int getNewlines(ChiFileHandle handle) {
        if (handle instanceof ChiReadDataFile) {
            ChiReadDataFile rdf = (ChiReadDataFile)handle;
            return rdf.getNewlinesInfo();
        }
        String msg = "Whitespace checking can only be done on input files.";
        throw new ChiSimulatorException(msg);
    }

    public boolean checkEol(ChiFileHandle handle) {
        if (handle instanceof ChiReadDataFile) {
            ChiReadDataFile rdf = (ChiReadDataFile)handle;
            return rdf.getNewlinesInfo() != 0;
        }
        String msg = "End of line (EOL) checking can only be done on input files.";
        throw new ChiSimulatorException(msg);
    }

    public boolean checkEof(ChiFileHandle handle) {
        if (handle instanceof ChiReadDataFile) {
            ChiReadDataFile rdf = (ChiReadDataFile)handle;
            return rdf.getNewlinesInfo() < 0;
        }
        String msg = "End of file (EOF) checking can only be done on input files.";
        throw new ChiSimulatorException(msg);
    }

    public RandomGenerator getFreshGenerator() {
        if (this.randGen == null) {
            if (!this.seedProvided) {
                this.seed = System.currentTimeMillis() + (long)System.identityHashCode(this);
                if (this.seed == 0L) {
                    this.seed = 1L;
                }
            }
            this.randGen = new MersenneTwister(this.seed);
            AppEnv.setProperty((String)"org.eclipse.escet.chi.runtime.seed", (String)Long.toString(this.seed));
        }
        return this.randGen;
    }

    public GaussianGenerator getGaussianGenerator() {
        if (this.gausGen == null) {
            this.gausGen = new GaussianGenerator(this);
        }
        return this.gausGen;
    }

    public void setSelect(BaseProcess proc, List<SelectChoice> choices) {
        this.currentSim.setSelect(proc, choices);
    }

    public void setTerminateAll(Object exitValue) {
        this.currentSim.setTerminateAll(exitValue, SimulationResult.ExitReason.EXITED);
    }

    public void testTerminating() {
        this.currentSim.testTerminating();
    }

    public void addProcess(BaseProcess newProcess) {
        this.currentSim.addProcess(newProcess);
    }

    public double getCurrentTime() {
        return this.currentSim.getCurrentTime();
    }

    public SimulationResult run(BaseProcess rootProcess) {
        Assert.check((this.currentSim == null || this.currentSim.simState == SimulationState.RUNNING ? 1 : 0) != 0);
        this.currentSim = new SimulationData(this.app, this, this.currentSim);
        this.addProcess(rootProcess);
        Assert.check((this.currentSim.simState == SimulationState.STARTING ? 1 : 0) != 0);
        this.stdout.flush();
        try {
            this.currentSim.run();
        }
        finally {
            this.stdout.flush();
        }
        SimulationResult simResult = new SimulationResult(rootProcess.kind, this.randGen != null, this.seed, this.currentSim.exitReason, this.currentSim.getCurrentTime(), this.currentSim.exitValue);
        this.currentSim = this.currentSim.parentSim;
        return simResult;
    }

    public Object finishSimulation() {
        Assert.check((this.currentSim.simState == SimulationState.FINISHED ? 1 : 0) != 0);
        Object exitValue = this.currentSim.exitValue;
        this.currentSim = this.currentSim.parentSim;
        return exitValue;
    }

    public Object runSubSimulation(BaseProcess model) {
        SimulationResult simResult = this.run(model);
        this.testTerminating();
        if (simResult.exitValue != null) {
            return simResult.exitValue;
        }
        switch (simResult.exitReason) {
            case DEADLOCKED: {
                String msg = "Model terminated due to deadlock (causing infinite delay).";
                throw new ChiSimulatorException(msg);
            }
            case FINISHED: {
                String msg = "All processes ended without using 'exit'.";
                throw new ChiSimulatorException(msg);
            }
        }
        Assert.fail((Object)"Unexpected fail reason.");
        return null;
    }
}

