/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_uk extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_hy = "вірменська";
        final String metaValue_bax = "бамум";
        final String metaValue_bn = "бенгальська";
        final String metaValue_ccp = "чакма";
        final String metaValue_chr = "черокі";
        final String metaValue_ka = "грузинська";
        final String metaValue_el = "грецька";
        final String metaValue_gu = "гуджараті";
        final String metaValue_zh = "китайська";
        final String metaValue_he = "іврит";
        final String metaValue_ja = "японська";
        final String metaValue_km = "кхмерська";
        final String metaValue_kn = "каннада";
        final String metaValue_ko = "корейська";
        final String metaValue_lo = "лаоська";
        final String metaValue_mn = "монгольська";
        final String metaValue_nqo = "нко";
        final String metaValue_si = "сингальська";
        final String metaValue_su = "сунданська";
        final String metaValue_syr = "сирійська";
        final String metaValue_ta = "тамільська";
        final String metaValue_te = "телугу";
        final String metaValue_th = "тайська";
        final String metaValue_bo = "тибетська";
        final String metaValue_vai = "ваї";
        final String metaValue_key_nu = "цифри";
        final Object[][] data = new Object[][] {
            { "001", "Світ" },
            { "002", "Африка" },
            { "003", "Північна Америка" },
            { "005", "Південна Америка" },
            { "009", "Океанія" },
            { "011", "Західна Африка" },
            { "013", "Центральна Америка" },
            { "014", "Східна Африка" },
            { "015", "Північна Африка" },
            { "017", "Центральна Африка" },
            { "018", "Південноафриканський регіон" },
            { "019", "Американський регіон" },
            { "021", "Північноамериканський регіон" },
            { "029", "Карибський басейн" },
            { "030", "Східна Азія" },
            { "034", "Південна Азія" },
            { "035", "Південно-Східна Азія" },
            { "039", "Південна Європа" },
            { "053", "Австралазія" },
            { "054", "Меланезія" },
            { "057", "Мікронезійський регіон" },
            { "061", "Полінезія" },
            { "142", "Азія" },
            { "143", "Центральна Азія" },
            { "145", "Західна Азія" },
            { "150", "Європа" },
            { "151", "Східна Європа" },
            { "154", "Північна Європа" },
            { "155", "Західна Європа" },
            { "202", "Африка на південь від Сахари" },
            { "419", "Латинська Америка" },
            { "AC", "Острів Вознесіння" },
            { "AD", "Андорра" },
            { "AE", "Обʼєднані Арабські Емірати" },
            { "AF", "Афганістан" },
            { "AG", "Антигуа і Барбуда" },
            { "AI", "Ангілья" },
            { "AL", "Албанія" },
            { "AM", "Вірменія" },
            { "AO", "Ангола" },
            { "AQ", "Антарктика" },
            { "AR", "Аргентина" },
            { "AS", "Американське Самоа" },
            { "AT", "Австрія" },
            { "AU", "Австралія" },
            { "AW", "Аруба" },
            { "AX", "Аландські Острови" },
            { "AZ", "Азербайджан" },
            { "BA", "Боснія і Герцеговина" },
            { "BB", "Барбадос" },
            { "BD", "Бангладеш" },
            { "BE", "Бельгія" },
            { "BF", "Буркіна-Фасо" },
            { "BG", "Болгарія" },
            { "BH", "Бахрейн" },
            { "BI", "Бурунді" },
            { "BJ", "Бенін" },
            { "BL", "Сен-Бартелемі" },
            { "BM", "Бермудські Острови" },
            { "BN", "Бруней" },
            { "BO", "Болівія" },
            { "BQ", "Карибські Нідерланди" },
            { "BR", "Бразилія" },
            { "BS", "Багамські Острови" },
            { "BT", "Бутан" },
            { "BV", "Острів Буве" },
            { "BW", "Ботсвана" },
            { "BY", "Білорусь" },
            { "BZ", "Беліз" },
            { "CA", "Канада" },
            { "CC", "Кокосові (Кілінг) Острови" },
            { "CD", "Конго – Кіншаса" },
            { "CF", "Центральноафриканська Республіка" },
            { "CG", "Конго – Браззавіль" },
            { "CH", "Швейцарія" },
            { "CI", "Кот-дʼІвуар" },
            { "CK", "Острови Кука" },
            { "CL", "Чилі" },
            { "CM", "Камерун" },
            { "CN", "Китай" },
            { "CO", "Колумбія" },
            { "CP", "Острів Кліппертон" },
            { "CR", "Коста-Рика" },
            { "CU", "Куба" },
            { "CV", "Кабо-Верде" },
            { "CW", "Кюрасао" },
            { "CX", "Острів Різдва" },
            { "CY", "Кіпр" },
            { "CZ", "Чехія" },
            { "DE", "Німеччина" },
            { "DG", "Дієго-Гарсія" },
            { "DJ", "Джибуті" },
            { "DK", "Данія" },
            { "DM", "Домініка" },
            { "DO", "Домініканська Республіка" },
            { "DZ", "Алжир" },
            { "EA", "Сеута і Мелілья" },
            { "EC", "Еквадор" },
            { "EE", "Естонія" },
            { "EG", "Єгипет" },
            { "EH", "Західна Сахара" },
            { "ER", "Еритрея" },
            { "ES", "Іспанія" },
            { "ET", "Ефіопія" },
            { "EU", "Європейський Союз" },
            { "EZ", "Єврозона" },
            { "FI", "Фінляндія" },
            { "FJ", "Фіджі" },
            { "FK", "Фолклендські Острови" },
            { "FM", "Мікронезія" },
            { "FO", "Фарерські Острови" },
            { "FR", "Франція" },
            { "GA", "Габон" },
            { "GB", "Велика Британія" },
            { "GD", "Гренада" },
            { "GE", "Грузія" },
            { "GF", "Французька Гвіана" },
            { "GG", "Гернсі" },
            { "GH", "Гана" },
            { "GI", "Гібралтар" },
            { "GL", "Гренландія" },
            { "GM", "Гамбія" },
            { "GN", "Гвінея" },
            { "GP", "Гваделупа" },
            { "GQ", "Екваторіальна Гвінея" },
            { "GR", "Греція" },
            { "GS", "Південна Джорджія та Південні Сандвічеві Острови" },
            { "GT", "Гватемала" },
            { "GU", "Гуам" },
            { "GW", "Гвінея-Бісау" },
            { "GY", "Гаяна" },
            { "HK", "Гонконг, ОАР Китаю" },
            { "HM", "Острови Герд і Макдоналд" },
            { "HN", "Гондурас" },
            { "HR", "Хорватія" },
            { "HT", "Гаїті" },
            { "HU", "Угорщина" },
            { "IC", "Канарські Острови" },
            { "ID", "Індонезія" },
            { "IE", "Ірландія" },
            { "IL", "Ізраїль" },
            { "IM", "Острів Мен" },
            { "IN", "Індія" },
            { "IO", "Британська територія в Індійському океані" },
            { "IQ", "Ірак" },
            { "IR", "Іран" },
            { "IS", "Ісландія" },
            { "IT", "Італія" },
            { "JE", "Джерсі" },
            { "JM", "Ямайка" },
            { "JO", "Йорданія" },
            { "JP", "Японія" },
            { "KE", "Кенія" },
            { "KG", "Киргизстан" },
            { "KH", "Камбоджа" },
            { "KI", "Кірибаті" },
            { "KM", "Комори" },
            { "KN", "Сент-Кітс і Невіс" },
            { "KP", "Північна Корея" },
            { "KR", "Південна Корея" },
            { "KW", "Кувейт" },
            { "KY", "Кайманові Острови" },
            { "KZ", "Казахстан" },
            { "LA", "Лаос" },
            { "LB", "Ліван" },
            { "LC", "Сент-Люсія" },
            { "LI", "Ліхтенштейн" },
            { "LK", "Шрі-Ланка" },
            { "LR", "Ліберія" },
            { "LS", "Лесото" },
            { "LT", "Литва" },
            { "LU", "Люксембург" },
            { "LV", "Латвія" },
            { "LY", "Лівія" },
            { "MA", "Марокко" },
            { "MC", "Монако" },
            { "MD", "Молдова" },
            { "ME", "Чорногорія" },
            { "MF", "Сен-Мартен" },
            { "MG", "Мадагаскар" },
            { "MH", "Маршаллові Острови" },
            { "MK", "Північна Македонія" },
            { "ML", "Малі" },
            { "MM", "Мʼянма (Бірма)" },
            { "MN", "Монголія" },
            { "MO", "Макао, ОАР Китаю" },
            { "MP", "Північні Маріанські Острови" },
            { "MQ", "Мартиніка" },
            { "MR", "Мавританія" },
            { "MS", "Монтсеррат" },
            { "MT", "Мальта" },
            { "MU", "Маврикій" },
            { "MV", "Мальдіви" },
            { "MW", "Малаві" },
            { "MX", "Мексика" },
            { "MY", "Малайзія" },
            { "MZ", "Мозамбік" },
            { "NA", "Намібія" },
            { "NC", "Нова Каледонія" },
            { "NE", "Нігер" },
            { "NF", "Острів Норфолк" },
            { "NG", "Нігерія" },
            { "NI", "Нікарагуа" },
            { "NL", "Нідерланди" },
            { "NO", "Норвегія" },
            { "NP", "Непал" },
            { "NR", "Науру" },
            { "NU", "Ніуе" },
            { "NZ", "Нова Зеландія" },
            { "OM", "Оман" },
            { "PA", "Панама" },
            { "PE", "Перу" },
            { "PF", "Французька Полінезія" },
            { "PG", "Папуа-Нова Гвінея" },
            { "PH", "Філіппіни" },
            { "PK", "Пакистан" },
            { "PL", "Польща" },
            { "PM", "Сен-Пʼєр і Мікелон" },
            { "PN", "Острови Піткерн" },
            { "PR", "Пуерто-Рико" },
            { "PS", "Палестинські території" },
            { "PT", "Португалія" },
            { "PW", "Палау" },
            { "PY", "Парагвай" },
            { "QA", "Катар" },
            { "QO", "Віддалена Океанія" },
            { "RE", "Реюньйон" },
            { "RO", "Румунія" },
            { "RS", "Сербія" },
            { "RU", "Росія" },
            { "RW", "Руанда" },
            { "SA", "Саудівська Аравія" },
            { "SB", "Соломонові Острови" },
            { "SC", "Сейшельські Острови" },
            { "SD", "Судан" },
            { "SE", "Швеція" },
            { "SG", "Сінгапур" },
            { "SH", "Острів Святої Єлени" },
            { "SI", "Словенія" },
            { "SJ", "Шпіцберген та Ян-Маєн" },
            { "SK", "Словаччина" },
            { "SL", "Сьєрра-Леоне" },
            { "SM", "Сан-Марино" },
            { "SN", "Сенегал" },
            { "SO", "Сомалі" },
            { "SR", "Суринам" },
            { "SS", "Південний Судан" },
            { "ST", "Сан-Томе і Принсіпі" },
            { "SV", "Сальвадор" },
            { "SX", "Сінт-Мартен" },
            { "SY", "Сирія" },
            { "SZ", "Есватіні" },
            { "TA", "Трістан-да-Кунья" },
            { "TC", "Острови Теркс і Кайкос" },
            { "TD", "Чад" },
            { "TF", "Французькі Південні Території" },
            { "TG", "Того" },
            { "TH", "Таїланд" },
            { "TJ", "Таджикистан" },
            { "TK", "Токелау" },
            { "TL", "Тимор-Лешті" },
            { "TM", "Туркменістан" },
            { "TN", "Туніс" },
            { "TO", "Тонга" },
            { "TR", "Туреччина" },
            { "TT", "Тринідад і Тобаго" },
            { "TV", "Тувалу" },
            { "TW", "Тайвань" },
            { "TZ", "Танзанія" },
            { "UA", "Україна" },
            { "UG", "Уганда" },
            { "UM", "Віддалені острови США" },
            { "UN", "Організація Об’єднаних Націй" },
            { "US", "Сполучені Штати" },
            { "UY", "Уругвай" },
            { "UZ", "Узбекистан" },
            { "VA", "Ватикан" },
            { "VC", "Сент-Вінсент і Гренадіни" },
            { "VE", "Венесуела" },
            { "VG", "Британські Віргінські острови" },
            { "VI", "Віргінські Острови (США)" },
            { "VN", "Вʼєтнам" },
            { "VU", "Вануату" },
            { "WF", "Уолліс і Футуна" },
            { "WS", "Самоа" },
            { "XA", "Псевдоакценти" },
            { "XB", "Псевдобіді" },
            { "XK", "Косово" },
            { "YE", "Ємен" },
            { "YT", "Майотта" },
            { "ZA", "Південно-Африканська Республіка" },
            { "ZM", "Замбія" },
            { "ZW", "Зімбабве" },
            { "ZZ", "Невідомий регіон" },
            { "aa", "афарська" },
            { "ab", "абхазька" },
            { "ae", "авестійська" },
            { "af", "африкаанс" },
            { "ak", "акан" },
            { "am", "амхарська" },
            { "an", "арагонська" },
            { "ar", "арабська" },
            { "as", "асамська" },
            { "av", "аварська" },
            { "ay", "аймара" },
            { "az", "азербайджанська" },
            { "ba", "башкирська" },
            { "be", "білоруська" },
            { "bg", "болгарська" },
            { "bi", "біслама" },
            { "bm", "бамбара" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "бретонська" },
            { "bs", "боснійська" },
            { "ca", "каталонська" },
            { "ce", "чеченська" },
            { "ch", "чаморро" },
            { "co", "корсиканська" },
            { "cr", "крі" },
            { "cs", "чеська" },
            { "cu", "церковнословʼянська" },
            { "cv", "чуваська" },
            { "cy", "валлійська" },
            { "da", "данська" },
            { "de", "німецька" },
            { "dv", "дивехі" },
            { "dz", "дзонг-ке" },
            { "ee", "еве" },
            { "el", metaValue_el },
            { "en", "англійська" },
            { "eo", "есперанто" },
            { "es", "іспанська" },
            { "et", "естонська" },
            { "eu", "баскська" },
            { "fa", "перська" },
            { "ff", "фула" },
            { "fi", "фінська" },
            { "fj", "фіджі" },
            { "fo", "фарерська" },
            { "fr", "французька" },
            { "fy", "західнофризька" },
            { "ga", "ірландська" },
            { "gd", "шотландська гельська" },
            { "gl", "галісійська" },
            { "gn", "гуарані" },
            { "gu", metaValue_gu },
            { "gv", "менкська" },
            { "ha", "хауса" },
            { "he", metaValue_he },
            { "hi", "гінді" },
            { "ho", "хірі-моту" },
            { "hr", "хорватська" },
            { "ht", "гаїтянська креольська" },
            { "hu", "угорська" },
            { "hy", metaValue_hy },
            { "hz", "гереро" },
            { "ia", "інтерлінгва" },
            { "id", "індонезійська" },
            { "ie", "інтерлінгве" },
            { "ig", "ігбо" },
            { "ii", "сичуаньська ї" },
            { "ik", "інупіак" },
            { "io", "ідо" },
            { "is", "ісландська" },
            { "it", "італійська" },
            { "iu", "інуктитут" },
            { "ja", metaValue_ja },
            { "jv", "яванська" },
            { "ka", metaValue_ka },
            { "kg", "конґолезька" },
            { "ki", "кікуйю" },
            { "kj", "кунама" },
            { "kk", "казахська" },
            { "kl", "калааллісут" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "канурі" },
            { "ks", "кашмірська" },
            { "ku", "курдська" },
            { "kv", "комі" },
            { "kw", "корнська" },
            { "ky", "киргизька" },
            { "la", "латинська" },
            { "lb", "люксембурзька" },
            { "lg", "ганда" },
            { "li", "лімбургійська" },
            { "ln", "лінгала" },
            { "lo", metaValue_lo },
            { "lt", "литовська" },
            { "lu", "луба-катанга" },
            { "lv", "латиська" },
            { "mg", "малагасійська" },
            { "mh", "маршалльська" },
            { "mi", "маорі" },
            { "mk", "македонська" },
            { "ml", "малаялам" },
            { "mn", metaValue_mn },
            { "mr", "маратхі" },
            { "ms", "малайська" },
            { "mt", "мальтійська" },
            { "my", "бірманська" },
            { "na", "науру" },
            { "nb", "норвезька (букмол)" },
            { "nd", "північна ндебеле" },
            { "ne", "непальська" },
            { "ng", "ндонга" },
            { "nl", "нідерландська" },
            { "nn", "норвезька (нюношк)" },
            { "no", "норвезька" },
            { "nr", "ндебелє південна" },
            { "nv", "навахо" },
            { "ny", "ньянджа" },
            { "oc", "окситанська" },
            { "oj", "оджібва" },
            { "om", "оромо" },
            { "or", "одія" },
            { "os", "осетинська" },
            { "pa", "панджабі" },
            { "pi", "палі" },
            { "pl", "польська" },
            { "ps", "пушту" },
            { "pt", "португальська" },
            { "qu", "кечуа" },
            { "rm", "ретороманська" },
            { "rn", "рунді" },
            { "ro", "румунська" },
            { "ru", "російська" },
            { "rw", "кіньяруанда" },
            { "sa", "санскрит" },
            { "sc", "сардинська" },
            { "sd", "синдхі" },
            { "se", "північносаамська" },
            { "sg", "санго" },
            { "sh", "сербсько-хорватська" },
            { "si", metaValue_si },
            { "sk", "словацька" },
            { "sl", "словенська" },
            { "sm", "самоанська" },
            { "sn", "шона" },
            { "so", "сомалі" },
            { "sq", "албанська" },
            { "sr", "сербська" },
            { "ss", "сисваті" },
            { "st", "південна сото" },
            { "su", metaValue_su },
            { "sv", "шведська" },
            { "sw", "суахілі" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "таджицька" },
            { "th", metaValue_th },
            { "ti", "тигринья" },
            { "tk", "туркменська" },
            { "tl", "тагальська" },
            { "tn", "тсвана" },
            { "to", "тонганська" },
            { "tr", "турецька" },
            { "ts", "тсонга" },
            { "tt", "татарська" },
            { "tw", "тві" },
            { "ty", "таїтянська" },
            { "ug", "уйгурська" },
            { "uk", "українська" },
            { "ur", "урду" },
            { "uz", "узбецька" },
            { "ve", "венда" },
            { "vi", "вʼєтнамська" },
            { "vo", "волапюк" },
            { "wa", "валлонська" },
            { "wo", "волоф" },
            { "xh", "кхоса" },
            { "yi", "їдиш" },
            { "yo", "йоруба" },
            { "za", "чжуан" },
            { "zh", metaValue_zh },
            { "zu", "зулуська" },
            { "ace", "ачехська" },
            { "ach", "ачолі" },
            { "ada", "адангме" },
            { "ady", "адигейська" },
            { "afh", "африхілі" },
            { "agq", "агем" },
            { "ain", "айнська" },
            { "akk", "аккадська" },
            { "akz", "алабама" },
            { "ale", "алеутська" },
            { "alt", "південноалтайська" },
            { "ang", "давньоанглійська" },
            { "ann", "оболо" },
            { "anp", "ангіка" },
            { "arc", "арамейська" },
            { "arn", "арауканська" },
            { "aro", "араона" },
            { "arp", "арапахо" },
            { "arq", "алжирська арабська" },
            { "ars", "надждійська арабська" },
            { "arw", "аравакська" },
            { "asa", "асу" },
            { "ase", "американська мова рухів" },
            { "ast", "астурійська" },
            { "atj", "атикамек" },
            { "awa", "авадхі" },
            { "bal", "балучі" },
            { "ban", "балійська" },
            { "bar", "баеріш" },
            { "bas", "баса" },
            { "bax", metaValue_bax },
            { "bbc", "батак тоба" },
            { "bbj", "гомала" },
            { "bej", "беджа" },
            { "bem", "бемба" },
            { "bew", "бетаві" },
            { "bez", "бена" },
            { "bfd", "бафут" },
            { "bfq", "бадага" },
            { "bgc", "харʼянві" },
            { "bgn", "східнобелуджійська" },
            { "bho", "бходжпурі" },
            { "bik", "бікольська" },
            { "bin", "біні" },
            { "bjn", "банджарська" },
            { "bkm", "ком" },
            { "bla", "сіксіка" },
            { "blo", "анії" },
            { "bqi", "бахтіарі" },
            { "bra", "брадж" },
            { "brx", "бодо" },
            { "bss", "акус" },
            { "bua", "бурятська" },
            { "bug", "бугійська" },
            { "bum", "булу" },
            { "byn", "блін" },
            { "byv", "медумба" },
            { "cad", "каддо" },
            { "car", "карібська" },
            { "cay", "кайюга" },
            { "cch", "атсам" },
            { "ccp", metaValue_ccp },
            { "ceb", "себуанська" },
            { "cgg", "кіга" },
            { "chb", "чібча" },
            { "chg", "чагатайська" },
            { "chk", "чуукська" },
            { "chm", "марійська" },
            { "chn", "чинук жаргон" },
            { "cho", "чокто" },
            { "chp", "чипевʼян" },
            { "chr", metaValue_chr },
            { "chy", "чейєнн" },
            { "ckb", "центральнокурдська" },
            { "clc", "чилкотін" },
            { "cop", "коптська" },
            { "crg", "мічиф" },
            { "crh", "кримськотатарська" },
            { "crj", "південно-східна крі" },
            { "crk", "рівнинна крі" },
            { "crl", "північна іст-крі" },
            { "crm", "муз-крі" },
            { "crr", "каролінська алгонкінська" },
            { "crs", "сейшельська креольська" },
            { "csb", "кашубська" },
            { "csw", "свампі-крі" },
            { "dak", "дакота" },
            { "dar", "даргінська" },
            { "dav", "таїта" },
            { "del", "делаварська" },
            { "den", "слейв" },
            { "dgr", "догрибська" },
            { "din", "дінка" },
            { "dje", "джерма" },
            { "doi", "догрі" },
            { "dsb", "нижньолужицька" },
            { "dua", "дуала" },
            { "dum", "середньонідерландська" },
            { "dyo", "дьола-фоні" },
            { "dyu", "діула" },
            { "dzg", "дазага" },
            { "ebu", "ембу" },
            { "efi", "ефік" },
            { "egy", "давньоєгипетська" },
            { "eka", "екаджук" },
            { "elx", "еламська" },
            { "enm", "середньоанглійська" },
            { "ewo", "евондо" },
            { "fan", "фанг" },
            { "fat", "фанті" },
            { "fil", "філіппінська" },
            { "fon", "фон" },
            { "frc", "кажунська французька" },
            { "frm", "середньофранцузька" },
            { "fro", "давньофранцузька" },
            { "frp", "арпітанська" },
            { "frr", "фризька північна" },
            { "frs", "фризька східна" },
            { "fur", "фріульська" },
            { "gaa", "га" },
            { "gag", "гагаузька" },
            { "gan", "ґань" },
            { "gay", "гайо" },
            { "gba", "гбайя" },
            { "gez", "гєез" },
            { "gil", "гільбертська" },
            { "gmh", "середньоверхньонімецька" },
            { "goh", "давньоверхньонімецька" },
            { "gon", "гонді" },
            { "gor", "горонтало" },
            { "got", "готська" },
            { "grb", "гребо" },
            { "grc", "давньогрецька" },
            { "gsw", "німецька (Швейцарія)" },
            { "guz", "гусії" },
            { "gwi", "кучін" },
            { "hai", "хайда" },
            { "hak", "хаккаська" },
            { "haw", "гавайська" },
            { "hax", "південна гайда" },
            { "hil", "хілігайнон" },
            { "hit", "хітіті" },
            { "hmn", "хмонг" },
            { "hsb", "верхньолужицька" },
            { "hsn", "сянська китайська" },
            { "hup", "хупа" },
            { "hur", "галкомелем" },
            { "iba", "ібанська" },
            { "ibb", "ібібіо" },
            { "ikt", "західноканадська інуктитут" },
            { "ilo", "ілоканська" },
            { "inh", "інгуська" },
            { "jbo", "ложбан" },
            { "jgo", "нгомба" },
            { "jmc", "мачаме" },
            { "jpr", "юдео-перська" },
            { "jrb", "юдео-арабська" },
            { "kaa", "каракалпацька" },
            { "kab", "кабільська" },
            { "kac", "качін" },
            { "kaj", "йю" },
            { "kam", "камба" },
            { "kaw", "каві" },
            { "kbd", "кабардинська" },
            { "kbl", "канембу" },
            { "kcg", "тіап" },
            { "kde", "маконде" },
            { "kea", "кабувердіану" },
            { "kfo", "коро" },
            { "kgp", "кайнґанґ" },
            { "kha", "кхасі" },
            { "kho", "хотаносакська" },
            { "khq", "койра чиїні" },
            { "kkj", "како" },
            { "kln", "календжин" },
            { "kmb", "кімбунду" },
            { "koi", "комі-перм’яцька" },
            { "kok", "конкані" },
            { "kos", "косрае" },
            { "kpe", "кпеллє" },
            { "krc", "карачаєво-балкарська" },
            { "krl", "карельська" },
            { "kru", "курукх" },
            { "ksb", "шамбала" },
            { "ksf", "бафіа" },
            { "ksh", "кельнська" },
            { "kum", "кумицька" },
            { "kut", "кутенаї" },
            { "kwk", "кваквала" },
            { "kxv", "куві" },
            { "lad", "ладино" },
            { "lag", "лангі" },
            { "lah", "ланда" },
            { "lam", "ламба" },
            { "lez", "лезгінська" },
            { "lij", "лігурійська" },
            { "lil", "лілуетська" },
            { "lkt", "лакота" },
            { "lld", "ладинська" },
            { "lmo", "ломбардська" },
            { "lol", "монго" },
            { "lou", "луїзіанська креольська" },
            { "loz", "лозі" },
            { "lrc", "північнолурська" },
            { "lsm", "самія" },
            { "ltg", "латгальська" },
            { "lua", "луба-лулуа" },
            { "lui", "луїсеньо" },
            { "lun", "лунда" },
            { "luo", "луо" },
            { "lus", "мізо" },
            { "luy", "луйя" },
            { "mad", "мадурська" },
            { "maf", "мафа" },
            { "mag", "магадхі" },
            { "mai", "майтхілі" },
            { "mak", "макасарська" },
            { "man", "мандінго" },
            { "mas", "масаї" },
            { "mde", "маба" },
            { "mdf", "мокша" },
            { "mdr", "мандарська" },
            { "men", "менде" },
            { "mer", "меру" },
            { "mfe", "маврикійська креольська" },
            { "mga", "середньоірландська" },
            { "mgh", "макува-меето" },
            { "mgo", "мета" },
            { "mic", "мікмак" },
            { "min", "мінангкабау" },
            { "mnc", "манчжурська" },
            { "mni", "маніпурі" },
            { "moe", "інну-аймун" },
            { "moh", "магавк" },
            { "mos", "моссі" },
            { "mua", "мунданг" },
            { "mul", "кілька мов" },
            { "mus", "крік" },
            { "mwl", "мірандська" },
            { "mwr", "марварі" },
            { "mye", "миін" },
            { "myv", "ерзя" },
            { "mzn", "мазандеранська" },
            { "nan", "південноміньська" },
            { "nap", "неаполітанська" },
            { "naq", "нама" },
            { "nds", "нижньонімецька" },
            { "new", "неварі" },
            { "nia", "ніаська" },
            { "niu", "ніуе" },
            { "njo", "ао нага" },
            { "nmg", "квазіо" },
            { "nnh", "нгємбун" },
            { "nog", "ногайська" },
            { "non", "давньонорвезька" },
            { "nqo", metaValue_nqo },
            { "nso", "північна сото" },
            { "nus", "нуер" },
            { "nwc", "неварі класична" },
            { "nym", "ньямвезі" },
            { "nyn", "ньянколе" },
            { "nyo", "ньоро" },
            { "nzi", "нзіма" },
            { "ojb", "північно-західна оджибве" },
            { "ojc", "центральна оджибве" },
            { "ojs", "оджи-крі" },
            { "ojw", "західна оджибве" },
            { "oka", "оканаганська" },
            { "osa", "осейдж" },
            { "ota", "османська" },
            { "pag", "пангасінанська" },
            { "pal", "пехлеві" },
            { "pam", "пампанга" },
            { "pap", "папʼяменто" },
            { "pau", "палауанська" },
            { "pcm", "нігерійсько-креольська" },
            { "peo", "давньоперська" },
            { "phn", "фінікійсько-пунічна" },
            { "pis", "піджин" },
            { "pon", "понапе" },
            { "pqm", "малесіт-пасамакводі" },
            { "prg", "прусська" },
            { "pro", "давньопровансальська" },
            { "quc", "кіче" },
            { "raj", "раджастхані" },
            { "rap", "рапануї" },
            { "rar", "раротонга" },
            { "rhg", "рогінджа" },
            { "rof", "ромбо" },
            { "rom", "циганська" },
            { "rup", "арумунська" },
            { "rwk", "рва" },
            { "sad", "сандаве" },
            { "sah", "якутська" },
            { "sam", "самаритянська арамейська" },
            { "saq", "самбуру" },
            { "sas", "сасакська" },
            { "sat", "сантальська" },
            { "sba", "нгамбай" },
            { "sbp", "сангу" },
            { "scn", "сицилійська" },
            { "sco", "шотландська" },
            { "sdh", "південнокурдська" },
            { "see", "сенека" },
            { "seh", "сена" },
            { "sel", "селькупська" },
            { "ses", "койраборо сені" },
            { "sga", "давньоірландська" },
            { "shi", "тачеліт" },
            { "shn", "шанська" },
            { "shu", "чадійська арабська" },
            { "sid", "сідамо" },
            { "slh", "південна лушуцид" },
            { "sma", "південносаамська" },
            { "smj", "саамська луле" },
            { "smn", "саамська інарі" },
            { "sms", "скольт-саамська" },
            { "snk", "сонінке" },
            { "sog", "согдійська" },
            { "srn", "сранан тонго" },
            { "srr", "серер" },
            { "ssy", "сахо" },
            { "str", "саліська стрейт" },
            { "suk", "сукума" },
            { "sus", "сусу" },
            { "sux", "шумерська" },
            { "swb", "коморська" },
            { "syc", "сирійська класична" },
            { "syr", metaValue_syr },
            { "szl", "сілезька" },
            { "tce", "південна тутчон" },
            { "tem", "темне" },
            { "teo", "тесо" },
            { "ter", "терено" },
            { "tet", "тетум" },
            { "tgx", "тагіш" },
            { "tht", "талтан" },
            { "tig", "тигре" },
            { "tiv", "тів" },
            { "tkl", "токелау" },
            { "tlh", "клінгонська" },
            { "tli", "тлінгіт" },
            { "tmh", "тамашек" },
            { "tog", "ньяса тонга" },
            { "tok", "токі-пона" },
            { "tpi", "ток-пісін" },
            { "trv", "тароко" },
            { "tsi", "цимшиан" },
            { "ttm", "північна тутчон" },
            { "tum", "тумбука" },
            { "tvl", "тувалу" },
            { "twq", "тасавак" },
            { "tyv", "тувинська" },
            { "tzm", "центральноатласька тамазігт" },
            { "udm", "удмуртська" },
            { "uga", "угаритська" },
            { "umb", "умбунду" },
            { "und", "невідома мова" },
            { "vai", metaValue_vai },
            { "vec", "венеційська" },
            { "vmw", "макува" },
            { "vot", "водська" },
            { "vun", "вуньо" },
            { "wae", "вальзерська" },
            { "wal", "волайтта" },
            { "war", "варай" },
            { "was", "вашо" },
            { "wbp", "валпірі" },
            { "wuu", "китайська уська" },
            { "xal", "калмицька" },
            { "xnr", "кангрі" },
            { "xog", "сога" },
            { "yao", "яо" },
            { "yap", "яп" },
            { "yav", "янгбен" },
            { "ybb", "ємба" },
            { "yrl", "ньєнґату" },
            { "yue", "кантонська" },
            { "zap", "сапотекська" },
            { "zbl", "блісса мова" },
            { "zen", "зенага" },
            { "zgh", "стандартна марокканська берберська" },
            { "zun", "зуньї" },
            { "zxx", "без мовного вмісту" },
            { "zza", "зазакі" },
            { "Adlm", "адлам" },
            { "Afak", "афака" },
            { "Aghb", "кавказька албанська" },
            { "Ahom", "ахом" },
            { "Arab", "арабиця" },
            { "Aran", "насталік" },
            { "Armi", "армі" },
            { "Armn", metaValue_hy },
            { "Avst", "авестійський" },
            { "Bali", "балійський" },
            { "Bamu", metaValue_bax },
            { "Bass", "басса" },
            { "Batk", "батак" },
            { "Beng", metaValue_bn },
            { "Blis", "символи Блісса" },
            { "Bopo", "бопомофо" },
            { "Brah", "брахмі" },
            { "Brai", "шрифт Брайля" },
            { "Bugi", "бугійський" },
            { "Buhd", "бухід" },
            { "Cakm", metaValue_ccp },
            { "Cans", "уніфіковані символи канадських тубільців" },
            { "Cari", "каріанський" },
            { "Cham", "хамітський" },
            { "Cher", metaValue_chr },
            { "Cirt", "кирт" },
            { "Copt", "коптський" },
            { "Cprt", "кіпрський" },
            { "Cyrl", "кирилиця" },
            { "Cyrs", "давньоцерковнословʼянський" },
            { "Deva", "деванагарі" },
            { "Dsrt", "дезерет" },
            { "Egyd", "єгипетський демотичний" },
            { "Egyh", "єгипетський ієратичний" },
            { "Egyp", "єгипетський ієрогліфічний" },
            { "Ethi", "ефіопська" },
            { "Geok", "кхутсурі" },
            { "Geor", metaValue_ka },
            { "Glag", "глаголичний" },
            { "Goth", "готичний" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "гурмухі" },
            { "Hanb", "хань" },
            { "Hang", "хангиль" },
            { "Hani", metaValue_zh },
            { "Hano", "хануну" },
            { "Hans", "спрощена" },
            { "Hant", "традиційна" },
            { "Hebr", metaValue_he },
            { "Hira", "хірагана" },
            { "Hmng", "пахау хмонг" },
            { "Hrkt", "японські силабарії" },
            { "Hung", "давньоугорський" },
            { "Inds", "харапський" },
            { "Ital", "давньоіталійський" },
            { "Jamo", "чамо" },
            { "Java", "яванський" },
            { "Jpan", metaValue_ja },
            { "Kali", "кая лі" },
            { "Kana", "катакана" },
            { "Khar", "кхароштхі" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "каїті" },
            { "Lana", "ланна" },
            { "Laoo", metaValue_lo },
            { "Latf", "латинський фрактурний" },
            { "Latg", "латинський гельський" },
            { "Latn", "латиниця" },
            { "Lepc", "лепча" },
            { "Limb", "лімбу" },
            { "Lina", "лінійний А" },
            { "Linb", "лінійний В" },
            { "Lisu", "абетка Фрейзера" },
            { "Loma", "лома" },
            { "Lyci", "лікійський" },
            { "Lydi", "лідійський" },
            { "Mand", "мандейський" },
            { "Mani", "маніхейський" },
            { "Maya", "майя ієрогліфічний" },
            { "Mero", "мероїтський" },
            { "Mlym", "малаяламська" },
            { "Mong", metaValue_mn },
            { "Moon", "мун" },
            { "Mtei", "мейтей майєк" },
            { "Mymr", "мʼянмська" },
            { "Newa", "нева" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "огамічний" },
            { "Olck", "ол-чикі" },
            { "Orkh", "орхонський" },
            { "Orya", "орія" },
            { "Osge", "осейджиська" },
            { "Osma", "османський" },
            { "Perm", "давньопермський" },
            { "Phag", "пхагс-па" },
            { "Phli", "пехлеві написів" },
            { "Phlp", "пехлеві релігійний" },
            { "Phlv", "пехлеві літературний" },
            { "Phnx", "фінікійський" },
            { "Plrd", "писемність Полларда" },
            { "Prti", "парфянський" },
            { "Qaag", "зоджі" },
            { "Rjng", "реджанг" },
            { "Rohg", "ханіфі" },
            { "Roro", "ронго-ронго" },
            { "Runr", "рунічний" },
            { "Samr", "самаритянський" },
            { "Sara", "сараті" },
            { "Saur", "саураштра" },
            { "Sgnw", "знаковий" },
            { "Shaw", "шоу" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "сілоті нагрі" },
            { "Syrc", metaValue_syr },
            { "Syre", "давньосирійський естрангело" },
            { "Syrj", "давньосирійський західний" },
            { "Syrn", "давньосирійський східний" },
            { "Tagb", "тагбанва" },
            { "Tale", "тай-лі" },
            { "Talu", "новий тайський луе" },
            { "Taml", metaValue_ta },
            { "Tang", "тангут" },
            { "Tavt", "тай-вʼєт" },
            { "Telu", metaValue_te },
            { "Teng", "тенгвар" },
            { "Tfng", "тифінаг" },
            { "Tglg", "тагальський" },
            { "Thaa", "таана" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "угаритський" },
            { "Vaii", metaValue_vai },
            { "Visp", "видиме мовлення" },
            { "Xpeo", "давньоперський" },
            { "Xsux", "шумеро-аккадський клінопис" },
            { "Yiii", "йї" },
            { "Zinh", "успадкована" },
            { "Zmth", "математична" },
            { "Zsye", "емодзі" },
            { "Zsym", "символьна" },
            { "Zxxx", "безписемна" },
            { "Zyyy", "звичайна" },
            { "Zzzz", "невідома система письма" },
            { "de_CH", "верхньонімецька (Швейцарія)" },
            { "fa_AF", "дарі" },
            { "nl_BE", "фламандська" },
            { "ro_MD", "молдавська" },
            { "sw_CD", "суахілі (Конго)" },
            { "%%1901", "Традиційна німецька орфографія" },
            { "%%1994", "Стандартизована резьянська орфографія" },
            { "%%1996", "Нова німецька орфографія з 1996 р." },
            { "ar_001", "сучасна стандартна арабська" },
            { "key.ca", "календар" },
            { "key.cf", "грошовий формат" },
            { "key.co", "порядок сортування" },
            { "key.cu", "валюта" },
            { "key.hc", "формат часу (12 або 24 години)" },
            { "key.lb", "стиль розриву рядка" },
            { "key.ms", "система вимірювання" },
            { "key.nu", metaValue_key_nu },
            { "key.tz", "часовий пояс" },
            { "key.va", "варіант мовного коду" },
            { "nds_NL", "нижньосаксонська" },
            { "%%BISKE", "Діалект Сан-Джорджіо/Біла" },
            { "%%BOONT", "Бунтлінг" },
            { "%%LIPAW", "Ліповазський діалект резьянської мови" },
            { "%%NEDIS", "Натісонський діалект" },
            { "%%NJIVA", "Діалект Нджіва" },
            { "%%OSOJS", "Осоянський діалект" },
            { "%%POSIX", "Компʼютерний" },
            { "%%ROZAJ", "Резьянський" },
            { "%%SAAHO", "Сахо" },
            { "%%SOLBA", "Діалект Столвіца/Солбіка" },
            { "az_Arab", "південноазербайджанська" },
            { "zh_Hans", "китайська (спрощене письмо)" },
            { "zh_Hant", "китайська (традиційне письмо)" },
            { "%%FONIPA", "Міжнародний фонетичний алфавіт" },
            { "%%FONUPA", "Уральський фонетичний алфавіт" },
            { "%%PINYIN", "Романізація піньїн" },
            { "%%SCOUSE", "Ліверпульський діалект" },
            { "%%TARASK", "Орфографія Тараскевича" },
            { "%%AREVELA", "Східновірменський" },
            { "%%AREVMDA", "Західновірменський" },
            { "%%MONOTON", "Монотонічний" },
            { "%%POLYTON", "Політонічний" },
            { "%%REVISED", "Нова орфографія" },
            { "%%1606NICT", "Пізньосередньофранцузська до 1606" },
            { "%%BAKU1926", "Уніфікований турецький латинський алфавіт" },
            { "%%SCOTLAND", "Шотландська англійська" },
            { "%%VALENCIA", "Валенсійська" },
            { "%%WADEGILE", "Романізація Вейда-Джайлза" },
            { "type.ca.roc", "календар Китайської Республіки" },
            { "type.co.eor", "європейські правила упорядкування" },
            { "type.hc.h11", "12-годинний формат (0–11)" },
            { "type.hc.h12", "12-годинний формат (1–12)" },
            { "type.hc.h23", "24-годинний формат (0–23)" },
            { "type.hc.h24", "24-годинний формат (1–24)" },
            { "type.m0.bgn", "транслітерація РГН США" },
            { "type.nu.arab", "арабсько-індійські цифри" },
            { "type.nu.armn", "вірменські цифри" },
            { "type.nu.beng", "бенґальські цифри" },
            { "type.nu.cakm", "цифри чакма" },
            { "type.nu.deva", "цифри деванагарі" },
            { "type.nu.ethi", "ефіопські цифри" },
            { "type.nu.geor", "грузинські цифри" },
            { "type.nu.grek", "грецькі цифри" },
            { "type.nu.gujr", "цифри гуджараті" },
            { "type.nu.guru", "цифри гурмукхі" },
            { "type.nu.hans", "китайські символи чисел (спрощене письмо)" },
            { "type.nu.hant", "китайські символи чисел (традиційне письмо)" },
            { "type.nu.hebr", "цифри івриту" },
            { "type.nu.java", "яванські цифри" },
            { "type.nu.jpan", "японські цифри" },
            { "type.nu.khmr", "кхмерські цифри" },
            { "type.nu.knda", "цифри каннада" },
            { "type.nu.laoo", "лаоські цифри" },
            { "type.nu.latn", "західні цифри" },
            { "type.nu.mlym", "малаяламські цифри" },
            { "type.nu.mong", "монгольські цифри" },
            { "type.nu.mtei", "цифри маніпурі" },
            { "type.nu.mymr", "мʼянмські цифри" },
            { "type.nu.olck", "цифри ол-чикі" },
            { "type.nu.orya", "цифри орія" },
            { "type.nu.taml", "тамільські традиційні цифри" },
            { "type.nu.telu", "цифри телугу" },
            { "type.nu.thai", "тайські цифри" },
            { "type.nu.tibt", "тибетські цифри" },
            { "type.nu.vaii", "цифри ваї" },
            { "type.ca.dangi", "корейський календар" },
            { "type.co.ducet", "типовий порядок сортування Юнікод" },
            { "type.co.emoji", "порядок сортування за емодзі" },
            { "type.lb.loose", "неточний стиль розриву рядка" },
            { "type.nu.roman", "римські цифри" },
            { "type.ca.coptic", "коптський календар" },
            { "type.ca.hebrew", "єврейський календар" },
            { "type.ca.indian", "індійський світський календар" },
            { "type.co.compat", "попередній порядок сортування, для сумісності" },
            { "type.co.pinyin", "порядок сортування піньїнь" },
            { "type.co.search", "універсальний пошук" },
            { "type.co.stroke", "порядок сортування за рисками" },
            { "type.co.unihan", "порядок сортування за ключами ієрогліфів" },
            { "type.co.zhuyin", "порядок сортування чжуїнь" },
            { "type.d0.fwidth", "повна ширина" },
            { "type.d0.hwidth", "половинна ширина" },
            { "type.lb.normal", "звичайний стиль розриву рядка" },
            { "type.lb.strict", "точний стиль розриву рядка" },
            { "type.m0.ungegn", "транслітерація ГЕГН ООН" },
            { "type.ms.metric", "метрична система" },
            { "type.nu.native", "місцеві цифри" },
            { "type.ca.chinese", "китайський календар" },
            { "type.ca.islamic", "календар Хіджра" },
            { "type.ca.iso8601", "календар ISO-8601" },
            { "type.ca.persian", "перський календар" },
            { "type.cf.account", "обліковий грошовий формат" },
            { "type.co.big5han", "китайський традиційний порядок сортування Big5" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "type.nu.arabext", "арабсько-індійські розширені цифри" },
            { "type.nu.armnlow", "вірменські малі цифри" },
            { "type.nu.finance", "фінансові символи чисел" },
            { "type.nu.greklow", "грецькі малі цифри" },
            { "type.nu.hanidec", "китайські десяткові цифри" },
            { "type.nu.hansfin", "китайські фінансові символи чисел (спрощене письмо)" },
            { "type.nu.hantfin", "китайські фінансові символи чисел (традиційне письмо)" },
            { "type.nu.jpanfin", "японські фінансові цифри" },
            { "type.nu.tamldec", "тамільські цифри" },
            { "type.ca.buddhist", "буддійський календар" },
            { "type.ca.ethiopic", "ефіопський календар" },
            { "type.ca.japanese", "японський календар" },
            { "type.cf.standard", "стандартний грошовий формат" },
            { "type.co.phonetic", "фонетичний порядок сортування" },
            { "type.co.searchjl", "пошук за початковою приголосною хангул" },
            { "type.co.standard", "стандартний порядок сортування" },
            { "type.ms.uksystem", "англійська система мір" },
            { "type.ms.ussystem", "американська система мір" },
            { "type.nu.fullwide", "цифри повної ширини" },
            { "type.nu.romanlow", "римські малі цифри" },
            { "type.ca.gregorian", "григоріанський календар" },
            { "type.co.gb2312han", "китайський спрощений порядок сортування - GB2312" },
            { "type.co.phonebook", "порядок сортування за телефонним довідником" },
            { "type.co.dictionary", "порядок сортування за словником" },
            { "type.co.traditional", "традиційний порядок сортування" },
            { "type.nu.traditional", "традиційні символи чисел" },
            { "type.ca.islamic-rgsa", "ісламський календар Саудівської Аравії" },
            { "type.ca.islamic-tbla", "ісламський астрономічний календар" },
            { "type.ca.islamic-civil", "календар Хіджра, світський" },
            { "type.ca.islamic-umalqura", "календар Хіджра (Умм аль-Кура)" },
            { "type.ca.ethiopic-amete-alem", "ефіопський амете алем календар" },
        };
        return data;
    }
}
