/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_tr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_zbl = "Blis Sembolleri";
        final String metaValue_bug = "Bugis";
        final String metaValue_ccp = "Chakma";
        final String metaValue_CY = "Kıbrıs";
        final String metaValue_ET = "Etiyopya";
        final String metaValue_ko = "Korece";
        final String metaValue_nqo = "N’Ko";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_vai = "Vai";
        final String metaValue_ssy = "Saho";
        final Object[][] data = new Object[][] {
            { "001", "Dünya" },
            { "002", "Afrika" },
            { "003", "Kuzey Amerika" },
            { "005", "Güney Amerika" },
            { "009", "Okyanusya" },
            { "011", "Batı Afrika" },
            { "013", "Orta Amerika" },
            { "014", "Doğu Afrika" },
            { "015", "Kuzey Afrika" },
            { "017", "Orta Afrika" },
            { "018", "Afrika’nın Güneyi" },
            { "019", "Amerika" },
            { "021", "Amerika’nın Kuzeyi" },
            { "029", "Karayipler" },
            { "030", "Doğu Asya" },
            { "034", "Güney Asya" },
            { "035", "Güneydoğu Asya" },
            { "039", "Güney Avrupa" },
            { "053", "Avustralasya" },
            { "054", "Melanezya" },
            { "057", "Mikronezya Bölgesi" },
            { "061", "Polinezya" },
            { "142", "Asya" },
            { "143", "Orta Asya" },
            { "145", "Batı Asya" },
            { "150", "Avrupa" },
            { "151", "Doğu Avrupa" },
            { "154", "Kuzey Avrupa" },
            { "155", "Batı Avrupa" },
            { "202", "Sahra Altı Afrika" },
            { "419", "Latin Amerika" },
            { "AC", "Ascension Adası" },
            { "AD", "Andorra" },
            { "AE", "Birleşik Arap Emirlikleri" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ve Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Arnavutluk" },
            { "AM", "Ermenistan" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Arjantin" },
            { "AS", "Amerikan Samoası" },
            { "AT", "Avusturya" },
            { "AU", "Avustralya" },
            { "AW", "Aruba" },
            { "AX", "Åland Adaları" },
            { "AZ", "Azerbaycan" },
            { "BA", "Bosna-Hersek" },
            { "BB", "Barbados" },
            { "BD", "Bangladeş" },
            { "BE", "Belçika" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaristan" },
            { "BH", "Bahreyn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barthelemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivya" },
            { "BQ", "Karayip Hollandası" },
            { "BR", "Brezilya" },
            { "BS", "Bahamalar" },
            { "BT", "Butan" },
            { "BV", "Bouvet Adası" },
            { "BW", "Botsvana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Cocos (Keeling) Adaları" },
            { "CD", "Kongo - Kinşasa" },
            { "CF", "Orta Afrika Cumhuriyeti" },
            { "CG", "Kongo - Brazavil" },
            { "CH", "İsviçre" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Cook Adaları" },
            { "CL", "Şili" },
            { "CM", "Kamerun" },
            { "CN", "Çin" },
            { "CO", "Kolombiya" },
            { "CP", "Clipperton Adası" },
            { "CR", "Kosta Rika" },
            { "CU", "Küba" },
            { "CV", "Cabo Verde" },
            { "CW", "Curaçao" },
            { "CX", "Christmas Adası" },
            { "CY", metaValue_CY },
            { "CZ", "Çekya" },
            { "DE", "Almanya" },
            { "DG", "Diego Garcia" },
            { "DJ", "Cibuti" },
            { "DK", "Danimarka" },
            { "DM", "Dominika" },
            { "DO", "Dominik Cumhuriyeti" },
            { "DZ", "Cezayir" },
            { "EA", "Ceuta ve Melilla" },
            { "EC", "Ekvador" },
            { "EE", "Estonya" },
            { "EG", "Mısır" },
            { "EH", "Batı Sahra" },
            { "ER", "Eritre" },
            { "ES", "İspanya" },
            { "ET", metaValue_ET },
            { "EU", "Avrupa Birliği" },
            { "EZ", "Euro Bölgesi" },
            { "FI", "Finlandiya" },
            { "FJ", "Fiji" },
            { "FK", "Falkland Adaları" },
            { "FM", "Mikronezya" },
            { "FO", "Faroe Adaları" },
            { "FR", "Fransa" },
            { "GA", "Gabon" },
            { "GB", "Birleşik Krallık" },
            { "GD", "Grenada" },
            { "GE", "Gürcistan" },
            { "GF", "Fransız Guyanası" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Cebelitarık" },
            { "GL", "Grönland" },
            { "GM", "Gambiya" },
            { "GN", "Gine" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvator Ginesi" },
            { "GR", "Yunanistan" },
            { "GS", "Güney Georgia ve Güney Sandwich Adaları" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Gine-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Çin Hong Kong ÖİB" },
            { "HM", "Heard Adası ve McDonald Adaları" },
            { "HN", "Honduras" },
            { "HR", "Hırvatistan" },
            { "HT", "Haiti" },
            { "HU", "Macaristan" },
            { "IC", "Kanarya Adaları" },
            { "ID", "Endonezya" },
            { "IE", "İrlanda" },
            { "IL", "İsrail" },
            { "IM", "Man Adası" },
            { "IN", "Hindistan" },
            { "IO", "Britanya Hint Okyanusu Toprakları" },
            { "IQ", "Irak" },
            { "IR", "İran" },
            { "IS", "İzlanda" },
            { "IT", "İtalya" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Ürdün" },
            { "JP", "Japonya" },
            { "KE", "Kenya" },
            { "KG", "Kırgızistan" },
            { "KH", "Kamboçya" },
            { "KI", "Kiribati" },
            { "KM", "Komorlar" },
            { "KN", "Saint Kitts ve Nevis" },
            { "KP", "Kuzey Kore" },
            { "KR", "Güney Kore" },
            { "KW", "Kuveyt" },
            { "KY", "Cayman Adaları" },
            { "KZ", "Kazakistan" },
            { "LA", "Laos" },
            { "LB", "Lübnan" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberya" },
            { "LS", "Lesotho" },
            { "LT", "Litvanya" },
            { "LU", "Lüksemburg" },
            { "LV", "Letonya" },
            { "LY", "Libya" },
            { "MA", "Fas" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Karadağ" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall Adaları" },
            { "MK", "Kuzey Makedonya" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Moğolistan" },
            { "MO", "Çin Makao ÖİB" },
            { "MP", "Kuzey Mariana Adaları" },
            { "MQ", "Martinik" },
            { "MR", "Moritanya" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldivler" },
            { "MW", "Malavi" },
            { "MX", "Meksika" },
            { "MY", "Malezya" },
            { "MZ", "Mozambik" },
            { "NA", "Namibya" },
            { "NC", "Yeni Kaledonya" },
            { "NE", "Nijer" },
            { "NF", "Norfolk Adası" },
            { "NG", "Nijerya" },
            { "NI", "Nikaragua" },
            { "NL", "Hollanda" },
            { "NO", "Norveç" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Yeni Zelanda" },
            { "OM", "Umman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Fransız Polinezyası" },
            { "PG", "Papua Yeni Gine" },
            { "PH", "Filipinler" },
            { "PK", "Pakistan" },
            { "PL", "Polonya" },
            { "PM", "Saint Pierre ve Miquelon" },
            { "PN", "Pitcairn Adaları" },
            { "PR", "Porto Riko" },
            { "PS", "Filistin Bölgeleri" },
            { "PT", "Portekiz" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "Uzak Okyanusya" },
            { "RE", "Reunion" },
            { "RO", "Romanya" },
            { "RS", "Sırbistan" },
            { "RU", "Rusya" },
            { "RW", "Ruanda" },
            { "SA", "Suudi Arabistan" },
            { "SB", "Solomon Adaları" },
            { "SC", "Seyşeller" },
            { "SD", "Sudan" },
            { "SE", "İsveç" },
            { "SG", "Singapur" },
            { "SH", "Saint Helena" },
            { "SI", "Slovenya" },
            { "SJ", "Svalbard ve Jan Mayen" },
            { "SK", "Slovakya" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali" },
            { "SR", "Surinam" },
            { "SS", "Güney Sudan" },
            { "ST", "Sao Tome ve Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Suriye" },
            { "SZ", "Esvatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks ve Caicos Adaları" },
            { "TD", "Çad" },
            { "TF", "Fransız Güney Toprakları" },
            { "TG", "Togo" },
            { "TH", "Tayland" },
            { "TJ", "Tacikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Türkmenistan" },
            { "TN", "Tunus" },
            { "TO", "Tonga" },
            { "TR", "Türkiye" },
            { "TT", "Trinidad ve Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tayvan" },
            { "TZ", "Tanzanya" },
            { "UA", "Ukrayna" },
            { "UG", "Uganda" },
            { "UM", "ABD Küçük Harici Adaları" },
            { "UN", "Birleşmiş Milletler" },
            { "US", "Amerika Birleşik Devletleri" },
            { "UY", "Uruguay" },
            { "UZ", "Özbekistan" },
            { "VA", "Vatikan" },
            { "VC", "Saint Vincent ve Grenadinler" },
            { "VE", "Venezuela" },
            { "VG", "Britanya Virjin Adaları" },
            { "VI", "ABD Virjin Adaları" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis ve Futuna" },
            { "WS", "Samoa" },
            { "XA", "Psödo Aksanlar" },
            { "XB", "Psödo Bidi" },
            { "XK", "Kosova" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Güney Afrika" },
            { "ZM", "Zambiya" },
            { "ZW", "Zimbabve" },
            { "ZZ", "Bilinmeyen Bölge" },
            { "aa", "Afar" },
            { "ab", "Abhazca" },
            { "ae", "Avestçe" },
            { "af", "Afrikaanca" },
            { "ak", "Akan" },
            { "am", "Amharca" },
            { "an", "Aragonca" },
            { "ar", "Arapça" },
            { "as", "Assamca" },
            { "av", "Avar dili" },
            { "ay", "Aymara" },
            { "az", "Azerbaycan dili" },
            { "ba", "Başkırtça" },
            { "be", "Belarusça" },
            { "bg", "Bulgarca" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bengalce" },
            { "bo", "Tibetçe" },
            { "br", "Bretonca" },
            { "bs", "Boşnakça" },
            { "ca", "Katalanca" },
            { "ce", "Çeçence" },
            { "ch", "Çamorro dili" },
            { "co", "Korsikaca" },
            { "cr", "Krice" },
            { "cs", "Çekçe" },
            { "cu", "Kilise Slavcası" },
            { "cv", "Çuvaşça" },
            { "cy", "Galce" },
            { "da", "Danca" },
            { "de", "Almanca" },
            { "dv", "Divehi dili" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", "Yunanca" },
            { "en", "İngilizce" },
            { "eo", "Esperanto" },
            { "es", "İspanyolca" },
            { "et", "Estonca" },
            { "eu", "Baskça" },
            { "fa", "Farsça" },
            { "ff", "Fula dili" },
            { "fi", "Fince" },
            { "fj", "Fiji dili" },
            { "fo", "Faroe dili" },
            { "fr", "Fransızca" },
            { "fy", "Batı Frizcesi" },
            { "ga", "İrlandaca" },
            { "gd", "İskoç Gaelcesi" },
            { "gl", "Galiçyaca" },
            { "gn", "Guarani dili" },
            { "gu", "Güceratça" },
            { "gv", "Man dili" },
            { "ha", "Hausa dili" },
            { "he", "İbranice" },
            { "hi", "Hintçe" },
            { "ho", "Hiri Motu" },
            { "hr", "Hırvatça" },
            { "ht", "Haiti Kreyolu" },
            { "hu", "Macarca" },
            { "hy", "Ermenice" },
            { "hz", "Herero dili" },
            { "ia", "İnterlingua" },
            { "id", "Endonezce" },
            { "ie", "Interlingue" },
            { "ig", "İbo dili" },
            { "ii", "Sichuan Yi" },
            { "ik", "İnyupikçe" },
            { "io", "Ido" },
            { "is", "İzlandaca" },
            { "it", "İtalyanca" },
            { "iu", "İnuktitut dili" },
            { "ja", "Japonca" },
            { "jv", "Cava dili" },
            { "ka", "Gürcüce" },
            { "kg", "Kongo dili" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakça" },
            { "kl", "Grönland dili" },
            { "km", "Khmer dili" },
            { "kn", "Kannada dili" },
            { "ko", metaValue_ko },
            { "kr", "Kanuri dili" },
            { "ks", "Keşmir dili" },
            { "ku", "Kürtçe" },
            { "kv", "Komi" },
            { "kw", "Kernevekçe" },
            { "ky", "Kırgızca" },
            { "la", "Latince" },
            { "lb", "Lüksemburgca" },
            { "lg", "Ganda" },
            { "li", "Limburgca" },
            { "ln", "Lingala" },
            { "lo", "Lao dili" },
            { "lt", "Litvanca" },
            { "lu", "Luba-Katanga" },
            { "lv", "Letonca" },
            { "mg", "Malgaşça" },
            { "mh", "Marshall Adaları dili" },
            { "mi", "Maori dili" },
            { "mk", "Makedonca" },
            { "ml", "Malayalam dili" },
            { "mn", "Moğolca" },
            { "mr", "Marathi dili" },
            { "ms", "Malayca" },
            { "mt", "Maltaca" },
            { "my", "Birman dili" },
            { "na", "Nauru dili" },
            { "nb", "Norveççe Bokmål" },
            { "nd", "Kuzey Ndebele" },
            { "ne", "Nepalce" },
            { "ng", "Ndonga" },
            { "nl", "Felemenkçe" },
            { "nn", "Norveççe Nynorsk" },
            { "no", "Norveççe" },
            { "nr", "Güney Ndebele" },
            { "nv", "Navaho dili" },
            { "ny", "Nyanja" },
            { "oc", "Oksitan dili" },
            { "oj", "Ojibva dili" },
            { "om", "Oromo dili" },
            { "or", "Oriya dili" },
            { "os", "Osetçe" },
            { "pa", "Pencapça" },
            { "pi", "Pali" },
            { "pl", "Lehçe" },
            { "ps", "Peştuca" },
            { "pt", "Portekizce" },
            { "qu", "Keçuva dili" },
            { "rm", "Romanşça" },
            { "rn", "Kirundi" },
            { "ro", "Rumence" },
            { "ru", "Rusça" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskrit" },
            { "sc", "Sardunya dili" },
            { "sd", "Sindhi dili" },
            { "se", "Kuzey Laponcası" },
            { "sg", "Sango" },
            { "sh", "Sırp-Hırvat Dili" },
            { "si", "Sinhali dili" },
            { "sk", "Slovakça" },
            { "sl", "Slovence" },
            { "sm", "Samoa dili" },
            { "sn", "Şona dili" },
            { "so", "Somalice" },
            { "sq", "Arnavutça" },
            { "sr", "Sırpça" },
            { "ss", "Sisvati" },
            { "st", "Güney Sotho dili" },
            { "su", "Sunda dili" },
            { "sv", "İsveççe" },
            { "sw", "Svahili dili" },
            { "ta", "Tamilce" },
            { "te", "Telugu dili" },
            { "tg", "Tacikçe" },
            { "th", "Tayca" },
            { "ti", "Tigrinya dili" },
            { "tk", "Türkmence" },
            { "tl", "Tagalogca" },
            { "tn", "Setsvana" },
            { "to", "Tonga dili" },
            { "tr", "Türkçe" },
            { "ts", "Tsonga" },
            { "tt", "Tatarca" },
            { "tw", "Tvi" },
            { "ty", "Tahiti dili" },
            { "ug", "Uygurca" },
            { "uk", "Ukraynaca" },
            { "ur", "Urduca" },
            { "uz", "Özbekçe" },
            { "ve", "Venda dili" },
            { "vi", "Vietnamca" },
            { "vo", "Volapük" },
            { "wa", "Valonca" },
            { "wo", "Volofça" },
            { "xh", "Zosa dili" },
            { "yi", "Yidiş" },
            { "yo", "Yorubaca" },
            { "za", "Zhuangca" },
            { "zh", "Çince" },
            { "zu", "Zuluca" },
            { "ace", "Açece" },
            { "ach", "Acoli" },
            { "ada", "Adangme" },
            { "ady", "Adigece" },
            { "aeb", "Tunus Arapçası" },
            { "afh", "Afrihili" },
            { "agq", "Aghem" },
            { "ain", "Aynuca" },
            { "akk", "Akad Dili" },
            { "akz", "Alabamaca" },
            { "ale", "Aleut dili" },
            { "aln", "Gheg Arnavutçası" },
            { "alt", "Güney Altayca" },
            { "ang", "Eski İngilizce" },
            { "ann", "Obolo dili" },
            { "anp", "Angika" },
            { "arc", "Aramice" },
            { "arn", "Mapuçe dili" },
            { "aro", "Araona" },
            { "arp", "Arapaho dili" },
            { "arq", "Cezayir Arapçası" },
            { "ars", "Necd Arapçası" },
            { "arw", "Arawak Dili" },
            { "ary", "Fas Arapçası" },
            { "arz", "Mısır Arapçası" },
            { "asa", "Asu" },
            { "ase", "Amerikan İşaret Dili" },
            { "ast", "Asturyasça" },
            { "atj", "Atikamekçe" },
            { "avk", "Kotava" },
            { "awa", "Awadhi" },
            { "bal", "Beluçça" },
            { "ban", "Bali dili" },
            { "bar", "Bavyera dili" },
            { "bas", "Basa Dili" },
            { "bax", "Bamun" },
            { "bbc", "Batak Toba" },
            { "bbj", "Ghomala" },
            { "bej", "Beja dili" },
            { "bem", "Bemba" },
            { "bew", "Betawi" },
            { "bez", "Bena" },
            { "bfd", "Bafut" },
            { "bfq", "Badaga" },
            { "bgc", "Haryanvi dili" },
            { "bgn", "Batı Balochi" },
            { "bho", "Arayanice" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "bjn", "Banjar Dili" },
            { "bkm", "Kom" },
            { "bla", "Karaayak dili" },
            { "blo", "Aniice" },
            { "bpy", "Bishnupriya" },
            { "bqi", "Bahtiyari" },
            { "bra", "Braj" },
            { "brh", "Brohice" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bua", "Buryatça" },
            { "bug", metaValue_bug },
            { "bum", "Bulu" },
            { "byn", "Blin" },
            { "byv", "Medumba" },
            { "cad", "Kado dili" },
            { "car", "Carib" },
            { "cay", "Kayuga dili" },
            { "cch", "Atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "Sebuano dili" },
            { "cgg", "Kiga" },
            { "chb", "Çibça dili" },
            { "chg", "Çağatayca" },
            { "chk", "Chuukese" },
            { "chm", "Mari dili" },
            { "chn", "Çinuk dili" },
            { "cho", "Çoktav dili" },
            { "chp", "Çipevya dili" },
            { "chr", "Çerokice" },
            { "chy", "Şayence" },
            { "ckb", "Orta Kürtçe" },
            { "clc", "Çilkotince" },
            { "cop", "Kıptice" },
            { "cps", "Capiznon" },
            { "crg", "Michif dili" },
            { "crh", "Kırım Tatarcası" },
            { "crj", "Güney Doğu Kricesi" },
            { "crk", "Ova Kricesi" },
            { "crl", "Kuzey Doğu Kricesi" },
            { "crm", "Moose Kricesi" },
            { "crr", "Carolina Algonkin dili" },
            { "crs", "Seselwa Kreole Fransızcası" },
            { "csb", "Kashubian" },
            { "csw", "Bataklık Kricesi" },
            { "dak", "Dakotaca" },
            { "dar", "Dargince" },
            { "dav", "Taita" },
            { "del", "Delaware" },
            { "den", "Slavey dili" },
            { "dgr", "Dogrib" },
            { "din", "Dinka dili" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Aşağı Sorbça" },
            { "dtp", "Orta Kadazan" },
            { "dua", "Duala" },
            { "dum", "Ortaçağ Felemenkçesi" },
            { "dyo", "Jola-Fonyi" },
            { "dyu", "Dyula" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egl", "Emilia Dili" },
            { "egy", "Eski Mısır Dili" },
            { "eka", "Ekajuk" },
            { "elx", "Elam" },
            { "enm", "Ortaçağ İngilizcesi" },
            { "esu", "Merkezi Yupikçe" },
            { "ewo", "Ewondo" },
            { "ext", "Ekstremadura Dili" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "fil", "Filipince" },
            { "fit", "Tornedalin Fincesi" },
            { "fon", "Fon" },
            { "frc", "Cajun Fransızcası" },
            { "frm", "Ortaçağ Fransızcası" },
            { "fro", "Eski Fransızca" },
            { "frp", "Arpitanca" },
            { "frr", "Kuzey Frizce" },
            { "frs", "Doğu Frizcesi" },
            { "fur", "Friuli dili" },
            { "gaa", "Ga dili" },
            { "gag", "Gagavuzca" },
            { "gan", "Gan Çincesi" },
            { "gay", "Gayo dili" },
            { "gba", "Gbaya" },
            { "gbz", "Zerdüşt Daricesi" },
            { "gez", "Geez" },
            { "gil", "Kiribatice" },
            { "glk", "Gilanice" },
            { "gmh", "Ortaçağ Yüksek Almancası" },
            { "goh", "Eski Yüksek Almanca" },
            { "gon", "Gondi dili" },
            { "gor", "Gorontalo dili" },
            { "got", "Gotça" },
            { "grb", "Grebo dili" },
            { "grc", "Antik Yunanca" },
            { "gsw", "İsviçre Almancası" },
            { "guc", "Wayuu dili" },
            { "gur", "Frafra" },
            { "guz", "Gusii" },
            { "gwi", "Guçince" },
            { "hai", "Haydaca" },
            { "hak", "Hakka Çincesi" },
            { "haw", "Hawaii dili" },
            { "hax", "Güney Haydaca" },
            { "hif", "Fiji Hintçesi" },
            { "hil", "Hiligaynon dili" },
            { "hit", "Hititçe" },
            { "hmn", "Hmong" },
            { "hsb", "Yukarı Sorbça" },
            { "hsn", "Xiang Çincesi" },
            { "hup", "Hupaca" },
            { "hur", "Halkomelemce" },
            { "iba", "Iban" },
            { "ibb", "İbibio dili" },
            { "ikt", "Batı Kanada İnuktitut dili" },
            { "ilo", "Iloko" },
            { "inh", "İnguşça" },
            { "izh", "İngriya Dili" },
            { "jam", "Jamaika Patois Dili" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jpr", "Yahudi Farsçası" },
            { "jrb", "Yahudi Arapçası" },
            { "jut", "Yutland Dili" },
            { "kaa", "Karakalpakça" },
            { "kab", "Kabiliyece" },
            { "kac", "Kaçin dili" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardeyce" },
            { "kbl", "Kanembu" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "ken", "Kenyang" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi dili" },
            { "kho", "Hotanca" },
            { "khq", "Koyra Chiini" },
            { "khw", "Çitral Dili" },
            { "kiu", "Kırmançça" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Komi-Permyak" },
            { "kok", "Konkani dili" },
            { "kos", "Kosraean" },
            { "kpe", "Kpelle dili" },
            { "krc", "Karaçay-Balkarca" },
            { "kri", "Krio" },
            { "krj", "Kinaray-a" },
            { "krl", "Karelyaca" },
            { "kru", "Kurukh dili" },
            { "ksb", "Şambala" },
            { "ksf", "Bafia" },
            { "ksh", "Köln lehçesi" },
            { "kum", "Kumukça" },
            { "kut", "Kutenai dili" },
            { "kwk", "Kwakʼwala dili" },
            { "kxv", "Kuvi" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba dili" },
            { "lez", "Lezgice" },
            { "lfn", "Lingua Franca Nova" },
            { "lij", "Ligurca" },
            { "lil", "Lillooet dili" },
            { "liv", "Livonca" },
            { "lkt", "Lakotaca" },
            { "lmo", "Lombardça" },
            { "lol", "Mongo" },
            { "lou", "Louisiana Kreolcesi" },
            { "loz", "Lozi" },
            { "lrc", "Kuzey Luri" },
            { "lsm", "Samia dili" },
            { "ltg", "Latgalian" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Lushai" },
            { "luy", "Luyia" },
            { "lzh", "Edebi Çince" },
            { "lzz", "Lazca" },
            { "mad", "Madura Dili" },
            { "maf", "Mafa" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makasar" },
            { "man", "Mandingo" },
            { "mas", "Masai" },
            { "mde", "Maba" },
            { "mdf", "Mokşa dili" },
            { "mdr", "Mandar" },
            { "men", "Mende dili" },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mga", "Ortaçağ İrlandacası" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta’" },
            { "mic", "Micmac" },
            { "min", "Minangkabau" },
            { "mnc", "Mançurya dili" },
            { "mni", "Manipuri dili" },
            { "moe", "Doğu İnnucası" },
            { "moh", "Mohavk dili" },
            { "mos", "Mossi" },
            { "mrj", "Ova Çirmişçesi" },
            { "mua", "Mundang" },
            { "mul", "Birden Fazla Dil" },
            { "mus", "Krikçe" },
            { "mwl", "Miranda dili" },
            { "mwr", "Marvari" },
            { "mwv", "Mentawai" },
            { "mye", "Myene" },
            { "myv", "Erzya" },
            { "mzn", "Mazenderanca" },
            { "nan", "Min Nan Çincesi" },
            { "nap", "Napolice" },
            { "naq", "Nama" },
            { "nds", "Aşağı Almanca" },
            { "new", "Nevari" },
            { "nia", "Nias" },
            { "niu", "Niue dili" },
            { "njo", "Ao Naga" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogayca" },
            { "non", "Eski Nors dili" },
            { "nov", "Novial" },
            { "nqo", metaValue_nqo },
            { "nso", "Kuzey Sotho dili" },
            { "nus", "Nuer" },
            { "nwc", "Klasik Nevari" },
            { "nym", "Nyamvezi" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima dili" },
            { "ojb", "Kuzeybatı Ojibwe dili" },
            { "ojc", "Orta Ojibwe dili" },
            { "ojs", "Anişininice" },
            { "ojw", "Batı Ojibwe dili" },
            { "oka", "Okanagan dili" },
            { "osa", "Osage" },
            { "ota", "Osmanlı Türkçesi" },
            { "pag", "Pangasinan dili" },
            { "pal", "Pehlevi Dili" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palau dili" },
            { "pcd", "Picard Dili" },
            { "pcm", "Nijerya Pidgin dili" },
            { "pdc", "Pensilvanya Almancası" },
            { "pdt", "Plautdietsch" },
            { "peo", "Eski Farsça" },
            { "pfl", "Palatin Almancası" },
            { "phn", "Fenike dili" },
            { "pis", "Pijin dili" },
            { "pms", "Piyemontece" },
            { "pnt", "Kuzeybatı Kafkasya" },
            { "pon", "Pohnpeian" },
            { "pqm", "Malisetçe-Passamaquoddy" },
            { "prg", "Prusyaca" },
            { "pro", "Eski Provensal" },
            { "quc", "Kiçece" },
            { "qug", "Chimborazo Highland Quichua" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui dili" },
            { "rar", "Rarotongan" },
            { "rgn", "Romanyolca" },
            { "rhg", "Rohingya dili" },
            { "rif", "Rif Berbericesi" },
            { "rof", "Rombo" },
            { "rom", "Romanca" },
            { "rtm", "Rotuman" },
            { "rue", "Rusince" },
            { "rug", "Roviana" },
            { "rup", "Ulahça" },
            { "rwk", "Rwa" },
            { "sad", "Sandave" },
            { "sah", "Yakutça" },
            { "sam", "Samarit Aramcası" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "saz", metaValue_saz },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sicilyaca" },
            { "sco", "İskoçça" },
            { "sdc", "Sassari Sarduca" },
            { "sdh", "Güney Kürtçesi" },
            { "see", "Seneca dili" },
            { "seh", "Sena" },
            { "sei", "Seri" },
            { "sel", "Selkup dili" },
            { "ses", "Koyraboro Senni" },
            { "sga", "Eski İrlandaca" },
            { "sgs", "Samogitçe" },
            { "shi", "Taşelit" },
            { "shn", "Shan dili" },
            { "shu", "Çad Arapçası" },
            { "sid", "Sidamo dili" },
            { "slh", "Güney Lushootseed" },
            { "sli", "Aşağı Silezyaca" },
            { "sly", "Selayar" },
            { "sma", "Güney Laponcası" },
            { "smj", "Lule Laponcası" },
            { "smn", "İnari Laponcası" },
            { "sms", "Skolt Laponcası" },
            { "snk", "Soninke" },
            { "sog", "Sogdiana Dili" },
            { "srn", "Sranan Tongo" },
            { "srr", "Serer dili" },
            { "ssy", metaValue_ssy },
            { "stq", "Saterland Frizcesi" },
            { "str", "Boğazlar Saliş dili" },
            { "suk", "Sukuma dili" },
            { "sus", "Susu" },
            { "sux", "Sümerce" },
            { "swb", "Komorca" },
            { "syc", "Klasik Süryanice" },
            { "syr", "Süryanice" },
            { "szl", "Silezyaca" },
            { "tce", "Güney Tuçoncası" },
            { "tcy", "Tuluca" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "ter", "Tereno" },
            { "tet", "Tetum" },
            { "tgx", "Tagişçe" },
            { "tht", "Tahltanca" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", "Tokelau dili" },
            { "tkr", "Sahurca" },
            { "tlh", "Klingonca" },
            { "tli", "Tlingitçe" },
            { "tly", "Talışça" },
            { "tmh", "Tamaşek" },
            { "tog", "Nyasa Tonga" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "tru", "Turoyo" },
            { "trv", "Taroko" },
            { "tsd", "Tsakonca" },
            { "tsi", "Tsimshian" },
            { "ttm", "Kuzey Tuçoncası" },
            { "ttt", "Tatça" },
            { "tum", "Tumbuka" },
            { "tvl", "Tuvalyanca" },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvaca" },
            { "tzm", "Orta Atlas Tamazigti" },
            { "udm", "Udmurtça" },
            { "uga", "Ugarit dili" },
            { "umb", "Umbundu" },
            { "und", "Bilinmeyen Dil" },
            { "vai", metaValue_vai },
            { "vec", "Venedikçe" },
            { "vep", "Veps dili" },
            { "vls", "Batı Flamanca" },
            { "vmf", "Main Frankonya Dili" },
            { "vmw", "Makuaca" },
            { "vot", "Votça" },
            { "vro", "Võro" },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Valamo" },
            { "war", "Varay" },
            { "was", "Vaşo" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wu Çincesi" },
            { "xal", "Kalmıkça" },
            { "xmf", "Megrelce" },
            { "xnr", "Kangrice" },
            { "xog", "Soga" },
            { "yao", "Yao" },
            { "yap", "Yapça" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Kantonca" },
            { "zap", "Zapotek dili" },
            { "zbl", metaValue_zbl },
            { "zea", "Zelandaca" },
            { "zen", "Zenaga dili" },
            { "zgh", "Standart Fas Tamazigti" },
            { "zun", "Zunice" },
            { "zxx", "Dilbilim içeriği yok" },
            { "zza", "Zazaca" },
            { "Adlm", "Adlam" },
            { "Afak", "Afaka" },
            { "Aghb", "Kafkas Albanyası" },
            { "Arab", "Arap" },
            { "Aran", "Nestâlik" },
            { "Armi", "İmparatorluk Aramicesi" },
            { "Armn", "Ermeni" },
            { "Avst", "Avesta" },
            { "Bali", "Bali Dili" },
            { "Bamu", "Bamum" },
            { "Bass", "Bassa Vah" },
            { "Batk", "Batak" },
            { "Beng", "Bengal" },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "Buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "UCAS" },
            { "Cari", "Karya" },
            { "Cher", "Çeroki" },
            { "Cirt", "Cirth" },
            { "Copt", "Kıpti" },
            { "Cprt", metaValue_CY },
            { "Cyrl", "Kiril" },
            { "Cyrs", "Eski Kilise Slavcası Kiril" },
            { "Deva", "Devanagari" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Duployé Stenografi" },
            { "Egyd", "Demotik Mısır" },
            { "Egyh", "Hiyeratik Mısır" },
            { "Egyp", "Mısır Hiyeroglifleri" },
            { "Elba", "Elbasan" },
            { "Ethi", metaValue_ET },
            { "Geok", "Hutsuri Gürcü" },
            { "Geor", "Gürcü" },
            { "Glag", "Glagolit" },
            { "Goth", "Gotik" },
            { "Gran", "Grantha" },
            { "Grek", "Yunan" },
            { "Gujr", "Gücerat" },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han - Bopomofo" },
            { "Hang", "Hangıl" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Basitleştirilmiş" },
            { "Hant", "Geleneksel" },
            { "Hebr", "İbrani" },
            { "Hira", "Hiragana" },
            { "Hluw", "Anadolu Hiyeroglifleri" },
            { "Hmng", "Pahavh Hmong" },
            { "Hrkt", "Japon hece alfabeleri" },
            { "Hung", "Eski Macar" },
            { "Inds", "Indus" },
            { "Ital", "Eski İtalyan" },
            { "Java", "Cava Dili" },
            { "Jpan", "Japon" },
            { "Jurc", "Jurchen" },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", "Kmer" },
            { "Khoj", "Khojki" },
            { "Knda", "Kannada" },
            { "Kore", metaValue_ko },
            { "Kpel", "Kpelle" },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", "Lao" },
            { "Latf", "Fraktur Latin" },
            { "Latg", "Gael Latin" },
            { "Latn", "Latin" },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Lineer A" },
            { "Linb", "Lineer B" },
            { "Lisu", "Fraser" },
            { "Loma", "Loma" },
            { "Lyci", "Likya" },
            { "Lydi", "Lidya" },
            { "Mahj", "Mahajani" },
            { "Mand", "Manden" },
            { "Mani", "Maniheist" },
            { "Maya", "Maya Hiyeroglifleri" },
            { "Mend", "Mende" },
            { "Merc", "Meroitik El Yazısı" },
            { "Mero", "Meroitik" },
            { "Mlym", "Malayalam" },
            { "Mong", "Moğol" },
            { "Moon", "Moon" },
            { "Mroo", "Mro" },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", "Burma" },
            { "Narb", "Eski Kuzey Arap" },
            { "Nbat", "Nebati" },
            { "Nkgb", "Naksi Geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "Nüshu" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orhun" },
            { "Orya", "Oriya" },
            { "Osma", "Osmanya" },
            { "Palm", "Palmira" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "Eski Permik" },
            { "Phag", "Phags-pa" },
            { "Phli", "Pehlevi Kitabe Dili" },
            { "Phlp", "Psalter Pehlevi" },
            { "Phlv", "Kitap Pehlevi Dili" },
            { "Phnx", "Fenike" },
            { "Plrd", "Pollard Fonetik" },
            { "Prti", "Partça Kitabe Dili" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanifi" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runik" },
            { "Samr", "Samarit" },
            { "Sara", "Sarati" },
            { "Sarb", "Eski Güney Arap" },
            { "Saur", metaValue_saz },
            { "Sgnw", "İşaret Dili" },
            { "Shaw", "Shavian" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sind", "Khudabadi" },
            { "Sinh", "Seylan" },
            { "Sora", "Sora Sompeng" },
            { "Sund", "Sunda" },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", "Süryani" },
            { "Syre", "Estrangela Süryani" },
            { "Syrj", "Batı Süryani" },
            { "Syrn", "Doğu Süryani" },
            { "Tagb", "Tagbanva" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "New Tai Lue" },
            { "Taml", "Tamil" },
            { "Tang", "Tangut" },
            { "Tavt", "Tai Viet" },
            { "Telu", "Telugu" },
            { "Teng", "Tengvar" },
            { "Tfng", "Tifinag" },
            { "Tglg", "Takalot" },
            { "Thaa", "Thaana" },
            { "Thai", "Tay" },
            { "Tibt", "Tibet" },
            { "Tirh", "Tirhuta" },
            { "Ugar", "Ugarit Çivi Yazısı" },
            { "Vaii", metaValue_vai },
            { "Visp", "Konuşma Sesleri Çizimlemesi" },
            { "Wara", "Varang Kshiti" },
            { "Wole", "Woleai" },
            { "Xpeo", "Eski Fars" },
            { "Xsux", "Sümer-Akad Çivi Yazısı" },
            { "Yiii", "Yi" },
            { "Zinh", "Kalıtsal" },
            { "Zmth", "Matematiksel Gösterim" },
            { "Zsye", "Emoji" },
            { "Zsym", "Sembol" },
            { "Zxxx", "Yazılı Olmayan" },
            { "Zyyy", "Ortak" },
            { "Zzzz", "Bilinmeyen Alfabe" },
            { "de_AT", "Avusturya Almancası" },
            { "de_CH", "İsviçre Yüksek Almancası" },
            { "en_AU", "Avustralya İngilizcesi" },
            { "en_CA", "Kanada İngilizcesi" },
            { "en_GB", "İngiliz İngilizcesi" },
            { "en_US", "Amerikan İngilizcesi" },
            { "es_ES", "Avrupa İspanyolcası" },
            { "es_MX", "Meksika İspanyolcası" },
            { "fa_AF", "Darice" },
            { "fr_CA", "Kanada Fransızcası" },
            { "fr_CH", "İsviçre Fransızcası" },
            { "nl_BE", "Flamanca" },
            { "pt_BR", "Brezilya Portekizcesi" },
            { "pt_PT", "Avrupa Portekizcesi" },
            { "ro_MD", "Moldovaca" },
            { "sw_CD", "Kongo Svahili" },
            { "%%1901", "Geleneksel Almanca Yazım Kuralları" },
            { "%%1994", "Standart Resia Yazım Kuralları" },
            { "%%1996", "1996 Almanca Yazım Kuralları" },
            { "ar_001", "Modern Standart Arapça" },
            { "es_419", "Latin Amerika İspanyolcası" },
            { "key.ca", "Takvim" },
            { "key.cf", "Para Birimi Biçimi" },
            { "key.co", "Sıralama Düzeni" },
            { "key.cu", "Para Birimi" },
            { "key.hc", "Saat Sistemi (12 - 24)" },
            { "key.lb", "Satır Sonu Stili" },
            { "key.ms", "Ölçü Sistemi" },
            { "key.nu", "Rakamlar" },
            { "key.tz", "Saat Dilimi" },
            { "key.va", "Yerel Varyant" },
            { "nds_NL", "Aşağı Saksonca" },
            { "%%BISKE", "San Giorgio/Bila Lehçesi" },
            { "%%BOONT", "Boontling" },
            { "%%KKCOR", "Ortak Yazım Kuralları" },
            { "%%LIPAW", "Resia Lipovaz Lehçesi" },
            { "%%NEDIS", "Natisone Lehçesi" },
            { "%%NJIVA", "Gniva/Njiva Lehçesi" },
            { "%%OSOJS", "Oseacco/Osojane Lehçesi" },
            { "%%POSIX", "Bilgisayar" },
            { "%%ROZAJ", "Resia Lehçesi" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Stolvizza/Solbica Lehçesi" },
            { "%%UCCOR", "Birleştirilmiş Yazım Kuralları" },
            { "az_Arab", "Güney Azerice" },
            { "zh_Hans", "Basitleştirilmiş Çince" },
            { "zh_Hant", "Geleneksel Çince" },
            { "%%FONIPA", "IPA Ses Bilimi" },
            { "%%FONUPA", "UPA Ses Bilimi" },
            { "%%PINYIN", "Pinyin (Latin Alfabesinde Yazımı)" },
            { "%%SCOUSE", "Scouse" },
            { "%%TARASK", "Taraskievica Yazım Kuralları" },
            { "%%UCRCOR", "Gözden Geçirilmiş Birleştirilmiş Yazım Kuralları" },
            { "%%AREVELA", "Doğu Ermenicesi" },
            { "%%AREVMDA", "Batı Ermenicesi" },
            { "%%MONOTON", "Monotonik" },
            { "%%POLYTON", "Politonik" },
            { "%%REVISED", "Gözden Geçirilmiş Yazım Kuralları" },
            { "%%1606NICT", "1606‘ya Dek Geç Ortaçağ Fransızcası" },
            { "%%1694ACAD", "Erken Modern Fransızca" },
            { "%%1959ACAD", "Akademik" },
            { "%%BAKU1926", "Birleştirilmiş Yeni Türk Alfabesi" },
            { "%%SCOTLAND", "Standart İskoç İngilizcesi" },
            { "%%VALENCIA", "Valensiyaca" },
            { "%%WADEGILE", "Wade-Giles (Latin Alfabesinde Yazımı)" },
            { "type.ca.roc", "Çin Cumhuriyeti Takvimi" },
            { "type.co.eor", "Avrupa Sıralama Kuralları" },
            { "type.hc.h11", "12 Saat Sistemi (0–11)" },
            { "type.hc.h12", "12 Saat Sistemi (1–12)" },
            { "type.hc.h23", "24 Saat Sistemi (0–23)" },
            { "type.hc.h24", "24 Saat Sistemi (1–24)" },
            { "type.m0.bgn", "US BGN Transliterasyon" },
            { "type.nu.ahom", "Ahom Rakamları" },
            { "type.nu.arab", "Hint-Arap Rakamları" },
            { "type.nu.armn", "Ermeni Rakamları" },
            { "type.nu.bali", "Bali Rakamları" },
            { "type.nu.beng", "Bengal Rakamları" },
            { "type.nu.brah", "Brahmi Rakamları" },
            { "type.nu.cakm", "Chakma Rakamları" },
            { "type.nu.cham", "Cham Rakamları" },
            { "type.nu.cyrl", "Kiril Rakamları" },
            { "type.nu.deva", "Devanagari Rakamları" },
            { "type.nu.ethi", "Ge’ez Rakamları" },
            { "type.nu.geor", "Gürcü Rakamları" },
            { "type.nu.gonm", "Masaram Gondi Rakamları" },
            { "type.nu.grek", "Yunan Rakamları" },
            { "type.nu.gujr", "Gücerat Rakamları" },
            { "type.nu.guru", "Gurmukhi Rakamları" },
            { "type.nu.hans", "Basitleştirilmiş Çin Rakamları" },
            { "type.nu.hant", "Geleneksel Çin Rakamları" },
            { "type.nu.hebr", "İbrani Rakamları" },
            { "type.nu.hmng", "Pahawh Hmong Rakamları" },
            { "type.nu.java", "Cava Rakamları" },
            { "type.nu.jpan", "Japon Rakamları" },
            { "type.nu.kali", "Kayah Li Rakamları" },
            { "type.nu.khmr", "Kmer Rakamları" },
            { "type.nu.knda", "Kannada Rakamları" },
            { "type.nu.lana", "Tai Tham Hora Rakamları" },
            { "type.nu.laoo", "Lao Rakamları" },
            { "type.nu.latn", "Batı Rakamları" },
            { "type.nu.lepc", "Lepça Rakamları" },
            { "type.nu.limb", "Limbu Rakamları" },
            { "type.nu.mlym", "Malayalam Rakamları" },
            { "type.nu.modi", "Modi Rakamları" },
            { "type.nu.mong", "Moğolca Rakamlar" },
            { "type.nu.mroo", "Mro Rakamları" },
            { "type.nu.mtei", "Meetei Mayek Rakamları" },
            { "type.nu.mymr", "Myanmar Rakamları" },
            { "type.nu.nkoo", "N’Ko Rakamları" },
            { "type.nu.olck", "Ol Chiki Rakamları" },
            { "type.nu.orya", "Oriya Rakamları" },
            { "type.nu.osma", "Osmanya Rakamları" },
            { "type.nu.saur", "Saurashtra Rakamları" },
            { "type.nu.shrd", "Sharada Rakamları" },
            { "type.nu.sind", "Khudawadi Rakamları" },
            { "type.nu.sinh", "Sinhala Lith Rakamları" },
            { "type.nu.sora", "Sora Sompeng Rakamları" },
            { "type.nu.sund", "Sunda Rakamları" },
            { "type.nu.takr", "Takri Basamakları" },
            { "type.nu.talu", "New Tai Lue Rakamları" },
            { "type.nu.taml", "Geleneksel Tamil Rakamları" },
            { "type.nu.telu", "Telugu Rakamları" },
            { "type.nu.thai", "Tay Rakamları" },
            { "type.nu.tibt", "Tibet Rakamları" },
            { "type.nu.tirh", "Tirhuta Rakamları" },
            { "type.nu.vaii", "Vai Rakamları" },
            { "type.nu.wara", "Warang Citi Rakamları" },
            { "type.ca.dangi", "Dangi Takvimi" },
            { "type.co.ducet", "Saptanmış Unicode Sıralama Düzeni" },
            { "type.co.emoji", "Emoji Sıralama Düzeni" },
            { "type.lb.loose", "Serbest Satır Sonu Stili" },
            { "type.nu.roman", "Roma Rakamları" },
            { "type.ca.coptic", "Kıpti Takvim" },
            { "type.ca.hebrew", "İbrani Takvimi" },
            { "type.ca.indian", "Ulusal Hint Takvimi" },
            { "type.co.compat", "Önceki Sıralama Düzeni (uyumluluk için)" },
            { "type.co.pinyin", "Pinyin Sıralama Düzeni" },
            { "type.co.search", "Genel Amaçlı Arama" },
            { "type.co.stroke", "Vuruş Sıralama Düzeni" },
            { "type.co.unihan", "Radikal-Vuruş Sıralama Düzeni" },
            { "type.co.zhuyin", "Zhuyin Sıralama Düzeni" },
            { "type.d0.fwidth", "Tam Genişlik" },
            { "type.d0.hwidth", "Yarım genişlik" },
            { "type.lb.normal", "Normal Satır Sonu Stili" },
            { "type.lb.strict", "Katı Satır Sonu Stili" },
            { "type.m0.ungegn", "UN GEGN Transliterasyon" },
            { "type.ms.metric", "Metrik Sistem" },
            { "type.nu.native", "Yerel Rakamlar" },
            { "type.ca.chinese", "Çin Takvimi" },
            { "type.ca.islamic", "Hicri Takvim" },
            { "type.ca.iso8601", "ISO-8601 Takvimi" },
            { "type.ca.persian", "İran Takvimi" },
            { "type.cf.account", "Muhasebe Para Biçimi" },
            { "type.co.big5han", "Geleneksel Çince Sıralama Düzeni - Big5" },
            { "type.d0.npinyin", "Rakam" },
            { "type.nu.arabext", "Genişletilmiş Hint-Arap Rakamları" },
            { "type.nu.armnlow", "Küçük Harf Ermeni Rakamları" },
            { "type.nu.finance", "Finansal Sayılar" },
            { "type.nu.greklow", "Küçük Harf Yunan Rakamları" },
            { "type.nu.hanidec", "Çin Ondalık Rakamları" },
            { "type.nu.hansfin", "Finansal Basitleştirilmiş Çin Rakamları" },
            { "type.nu.hantfin", "Finansal Geleneksel Çin Rakamları" },
            { "type.nu.jpanfin", "Finansal Japon Rakamları" },
            { "type.nu.mathdbl", "Çift Çizgili Matematiksel Rakamlar" },
            { "type.nu.tamldec", "Tamil Rakamları" },
            { "type.ca.buddhist", "Budist Takvimi" },
            { "type.ca.ethiopic", "Etiyopik Takvim" },
            { "type.ca.japanese", "Japon Takvimi" },
            { "type.cf.standard", "Standart Para Biçimi" },
            { "type.co.phonetic", "Fonetik Sıralama Düzeni" },
            { "type.co.searchjl", "Hangul İlk Sessiz Harfe Göre Arama" },
            { "type.co.standard", "Standart Sıralama Düzeni" },
            { "type.ms.uksystem", "İngiliz Ölçü Sistemi" },
            { "type.ms.ussystem", "ABD Ölçü Sistemi" },
            { "type.nu.fullwide", "Tam Genişlikte Rakamlar" },
            { "type.nu.lanatham", "Tai Tham Tham Rakamları" },
            { "type.nu.mathbold", "Kalın Matematiksel Rakamlar" },
            { "type.nu.mathmono", "Eşit Aralıklı Matematiksel Rakamlar" },
            { "type.nu.mathsanb", "Kalın Sans Serif Matematiksel Rakamlar" },
            { "type.nu.mathsans", "Sans Serif Matematiksel Rakamlar" },
            { "type.nu.mymrshan", "Myanmar Shan Rakamları" },
            { "type.nu.mymrtlng", "Myanmar Tai Laing Rakamları" },
            { "type.nu.romanlow", "Küçük Harf Roma Rakamları" },
            { "type.ca.gregorian", "Miladi Takvim" },
            { "type.co.gb2312han", "Basitleştirilmiş Çince Sıralama Düzeni - GB2312" },
            { "type.co.phonebook", "Telefon Defteri Sıralama Düzeni" },
            { "type.co.dictionary", "Sözlük Sıralama Düzeni" },
            { "type.co.traditional", "Geleneksel Sıralama Düzeni" },
            { "type.nu.traditional", "Geleneksel Rakamlar" },
            { "type.ca.islamic-rgsa", "Hicri Takvim (Suudi)" },
            { "type.ca.islamic-tbla", "Hicri Takvim (15 Temmuz 622)" },
            { "type.ca.islamic-civil", "Hicri Takvim (16 Temmuz 622)" },
            { "type.ca.islamic-umalqura", "Hicri Takvim (Ümmü-l Kurra Takvimi)" },
            { "type.ca.ethiopic-amete-alem", "Etiyopik Amete Alem Takvimi" },
        };
        return data;
    }
}
