/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.statespace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.algebra.Vector;
import org.eclipse.lsat.common.ludus.backend.algorithms.Tarjan;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.statespace.Configuration;
import org.eclipse.lsat.common.ludus.backend.statespace.MaxPlusStateSpace;
import org.eclipse.lsat.common.ludus.backend.statespace.Transition;
import org.eclipse.lsat.common.mpt.api.UnconnectedResourceException;

public final class ComputeStateSpace {
    private static final Value DEFAULT_REWARD = new Value(1.0);

    private ComputeStateSpace() {
    }

    public static <V, E> MaxPlusStateSpace computeMaxPlusStateSpace(FSM<V, E> fsm, Integer vectorSize, Map<String, Matrix> matrices) throws UnconnectedResourceException {
        return ComputeStateSpace.computeMaxPlusStateSpace(fsm, vectorSize, matrices, new HashMap<String, Value>());
    }

    public static <V, E> MaxPlusStateSpace computeMaxPlusStateSpace(FSM<V, E> fsm, Integer vectorSize, Map<String, Matrix> matrices, Map<String, Value> rewardMap) throws UnconnectedResourceException {
        Value maxValue = new Value(0.0);
        for (Matrix m : matrices.values()) {
            int row = 0;
            while (row < vectorSize) {
                int column = 0;
                while (column < vectorSize) {
                    maxValue = maxValue.max(m.get(row, column));
                    ++column;
                }
                ++row;
            }
        }
        Value minVectorValue = maxValue.multiply(new Value(fsm.getVertices().size() * -1));
        Vector vInitial = new Vector(vectorSize, new Value(0.0));
        Configuration<V> cInitial = new Configuration<V>(fsm.getInitial(), vInitial);
        MaxPlusStateSpace s = new MaxPlusStateSpace();
        s.addConfiguration(cInitial);
        s.setInitialConfiguration(cInitial);
        Stack stack = new Stack();
        HashSet visited = new HashSet();
        stack.add(cInitial);
        visited.add(cInitial);
        while (!stack.isEmpty()) {
            Configuration c = (Configuration)stack.pop();
            for (Object e : fsm.outgoingEdgesOf(c.getLocation())) {
                String event = fsm.getEvent(e);
                Matrix eventMatrix = matrices.get(event);
                Vector newVector = eventMatrix.multiply(c.getVector());
                Vector newVectorNormalized = newVector.normalize();
                int i = 0;
                while (i < newVectorNormalized.size()) {
                    if (newVectorNormalized.get(i).smallerThan(minVectorValue)) {
                        throw new UnconnectedResourceException(i);
                    }
                    ++i;
                }
                Configuration cTarget = new Configuration(fsm.getEdgeTarget(e), newVectorNormalized);
                s.addConfiguration(cTarget);
                Value duration = newVector.getNorm();
                Value reward = rewardMap.getOrDefault(event, DEFAULT_REWARD);
                Transition t = new Transition(c, fsm.getEvent(e), reward, duration, cTarget);
                s.addTransition(t);
                if (visited.contains(cTarget)) continue;
                visited.add(cTarget);
                stack.push(cTarget);
            }
        }
        return s;
    }

    public static MaxPlusStateSpace negateWeights(MaxPlusStateSpace stateSpace) {
        HashMap mapping = new HashMap();
        MaxPlusStateSpace mpss = new MaxPlusStateSpace();
        for (Configuration c : stateSpace.getVertices()) {
            Configuration c_new = new Configuration(c.getLocation(), c.getVector());
            mpss.addConfiguration(c_new);
            if (stateSpace.hasInitialConfiguration() && stateSpace.getInitialConfiguration().equals(c)) {
                mpss.setInitialConfiguration(c_new);
            }
            mapping.put(c, c_new);
        }
        for (Configuration c : stateSpace.getVertices()) {
            for (Transition t : stateSpace.outgoingEdgesOf(c)) {
                Value negate = new Value(-1.0);
                mpss.addTransition(new Transition((Configuration)mapping.get(t.getSource()), t.getEvent(), t.getReward().multiply(negate), t.getDuration().multiply(negate), (Configuration)mapping.get(t.getTarget())));
            }
        }
        return mpss;
    }

    public static MaxPlusStateSpace swapWeights(MaxPlusStateSpace stateSpace) {
        HashMap mapping = new HashMap();
        MaxPlusStateSpace mpss = new MaxPlusStateSpace();
        for (Configuration c : stateSpace.getVertices()) {
            Configuration c_new = new Configuration(c.getLocation(), c.getVector());
            mpss.addConfiguration(c_new);
            if (stateSpace.hasInitialConfiguration() && stateSpace.getInitialConfiguration().equals(c)) {
                mpss.setInitialConfiguration(c_new);
            }
            mapping.put(c, c_new);
        }
        for (Configuration c : stateSpace.getVertices()) {
            for (Transition t : stateSpace.outgoingEdgesOf(c)) {
                mpss.addTransition(new Transition((Configuration)mapping.get(t.getSource()), t.getEvent(), t.getDuration(), t.getReward(), (Configuration)mapping.get(t.getTarget())));
            }
        }
        return mpss;
    }

    public static List<MaxPlusStateSpace> getSCCs(MaxPlusStateSpace stateSpace) {
        ArrayList<MaxPlusStateSpace> sccList = new ArrayList<MaxPlusStateSpace>();
        Tarjan<Configuration, Transition> tarjan = new Tarjan<Configuration, Transition>();
        List<Set<Configuration>> sccVerticesList = tarjan.computeSCCs(stateSpace);
        for (Set<Configuration> scc : sccVerticesList) {
            MaxPlusStateSpace mpssSCC = new MaxPlusStateSpace();
            for (Configuration c : scc) {
                mpssSCC.addConfiguration(c);
                for (Transition t : stateSpace.outgoingEdgesOf(c)) {
                    if (!scc.contains(t.getTarget())) continue;
                    mpssSCC.addTransition(t);
                }
            }
            if (mpssSCC.getEdges().size() <= 0) continue;
            sccList.add(mpssSCC);
        }
        return sccList;
    }
}

