/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.activity.teditor.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.services.TerminalsGrammarAccess;
import org.eclipse.xtext.service.AbstractElementFinder;
import org.eclipse.xtext.service.GrammarProvider;

@Singleton
public class ActivityGrammarAccess extends AbstractElementFinder.AbstractGrammarElementFinder {
	
	public class ActivitySetElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ActivitySet");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cActivitySetAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cImportsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cImportsImportParserRuleCall_1_0 = (RuleCall)cImportsAssignment_1.eContents().get(0);
		private final Alternatives cAlternatives_2 = (Alternatives)cGroup.eContents().get(2);
		private final Assignment cActivitiesAssignment_2_0 = (Assignment)cAlternatives_2.eContents().get(0);
		private final RuleCall cActivitiesActivityParserRuleCall_2_0_0 = (RuleCall)cActivitiesAssignment_2_0.eContents().get(0);
		private final Assignment cEventsAssignment_2_1 = (Assignment)cAlternatives_2.eContents().get(1);
		private final RuleCall cEventsEventParserRuleCall_2_1_0 = (RuleCall)cEventsAssignment_2_1.eContents().get(0);
		
		//ActivitySet returns ActivitySet:
		//    {ActivitySet}
		//    imports+= Import*
		//    (activities+=Activity | events+=Event) *;
		@Override public ParserRule getRule() { return rule; }
		
		//{ActivitySet}
		//imports+= Import*
		//(activities+=Activity | events+=Event) *
		public Group getGroup() { return cGroup; }
		
		//{ActivitySet}
		public Action getActivitySetAction_0() { return cActivitySetAction_0; }
		
		//imports+= Import*
		public Assignment getImportsAssignment_1() { return cImportsAssignment_1; }
		
		//Import
		public RuleCall getImportsImportParserRuleCall_1_0() { return cImportsImportParserRuleCall_1_0; }
		
		//(activities+=Activity | events+=Event) *
		public Alternatives getAlternatives_2() { return cAlternatives_2; }
		
		//activities+=Activity
		public Assignment getActivitiesAssignment_2_0() { return cActivitiesAssignment_2_0; }
		
		//Activity
		public RuleCall getActivitiesActivityParserRuleCall_2_0_0() { return cActivitiesActivityParserRuleCall_2_0_0; }
		
		//events+=Event
		public Assignment getEventsAssignment_2_1() { return cEventsAssignment_2_1; }
		
		//Event
		public RuleCall getEventsEventParserRuleCall_2_1_0() { return cEventsEventParserRuleCall_2_1_0; }
	}
	public class ImportElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Import");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cImportKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cImportURIAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cImportURISTRINGTerminalRuleCall_1_0 = (RuleCall)cImportURIAssignment_1.eContents().get(0);
		
		//Import returns common::Import:
		//     "import" importURI=STRING;
		@Override public ParserRule getRule() { return rule; }
		
		//"import" importURI=STRING
		public Group getGroup() { return cGroup; }
		
		//"import"
		public Keyword getImportKeyword_0() { return cImportKeyword_0; }
		
		//importURI=STRING
		public Assignment getImportURIAssignment_1() { return cImportURIAssignment_1; }
		
		//STRING
		public RuleCall getImportURISTRINGTerminalRuleCall_1_0() { return cImportURISTRINGTerminalRuleCall_1_0; }
	}
	public class ActivityElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Activity");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cActivityKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cLeftParenthesisKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cParameterDeclarationsAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cParameterDeclarationsParameterDeclarationParserRuleCall_2_1_0 = (RuleCall)cParameterDeclarationsAssignment_2_1.eContents().get(0);
		private final Group cGroup_2_2 = (Group)cGroup_2.eContents().get(2);
		private final Keyword cCommaKeyword_2_2_0 = (Keyword)cGroup_2_2.eContents().get(0);
		private final Assignment cParameterDeclarationsAssignment_2_2_1 = (Assignment)cGroup_2_2.eContents().get(1);
		private final RuleCall cParameterDeclarationsParameterDeclarationParserRuleCall_2_2_1_0 = (RuleCall)cParameterDeclarationsAssignment_2_2_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_2_3 = (Keyword)cGroup_2.eContents().get(3);
		private final Keyword cLeftCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cPrerequisitesKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_4_1 = (Keyword)cGroup_4.eContents().get(1);
		private final Assignment cPrerequisitesAssignment_4_2 = (Assignment)cGroup_4.eContents().get(2);
		private final RuleCall cPrerequisitesLocationPrerequisiteParserRuleCall_4_2_0 = (RuleCall)cPrerequisitesAssignment_4_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_4_3 = (Keyword)cGroup_4.eContents().get(3);
		private final Keyword cActionsKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Keyword cLeftCurlyBracketKeyword_6 = (Keyword)cGroup.eContents().get(6);
		private final Assignment cNodesAssignment_7 = (Assignment)cGroup.eContents().get(7);
		private final RuleCall cNodesNodeParserRuleCall_7_0 = (RuleCall)cNodesAssignment_7.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_8 = (Keyword)cGroup.eContents().get(8);
		private final Keyword cActionFlowKeyword_9 = (Keyword)cGroup.eContents().get(9);
		private final Keyword cLeftCurlyBracketKeyword_10 = (Keyword)cGroup.eContents().get(10);
		private final Assignment cEdgesAssignment_11 = (Assignment)cGroup.eContents().get(11);
		private final RuleCall cEdgesEdgesParserRuleCall_11_0 = (RuleCall)cEdgesAssignment_11.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_12 = (Keyword)cGroup.eContents().get(12);
		private final Group cGroup_13 = (Group)cGroup.eContents().get(13);
		private final Keyword cConstraintsKeyword_13_0 = (Keyword)cGroup_13.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_13_1 = (Keyword)cGroup_13.eContents().get(1);
		private final Assignment cConstraintsAssignment_13_2 = (Assignment)cGroup_13.eContents().get(2);
		private final RuleCall cConstraintsEdgesWithConstraintsParserRuleCall_13_2_0 = (RuleCall)cConstraintsAssignment_13_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_13_3 = (Keyword)cGroup_13.eContents().get(3);
		private final Keyword cRightCurlyBracketKeyword_14 = (Keyword)cGroup.eContents().get(14);
		
		//Activity returns Activity:
		//    'activity' name = ID
		//    ('(' (parameterDeclarations+=ParameterDeclaration)? (',' parameterDeclarations+=ParameterDeclaration)* ')' )?
		//    '{'
		//       ('prerequisites' '{' prerequisites+=LocationPrerequisite* '}' )?
		//       'actions' '{' nodes+=Node* '}'
		//       'action flow' '{' edges+=Edges* '}'
		//       ('constraints'
		//        '{'
		//            constraints+=EdgesWithConstraints*
		//        '}'
		//        )?
		//    '}';
		@Override public ParserRule getRule() { return rule; }
		
		//'activity' name = ID
		//('(' (parameterDeclarations+=ParameterDeclaration)? (',' parameterDeclarations+=ParameterDeclaration)* ')' )?
		//'{'
		//   ('prerequisites' '{' prerequisites+=LocationPrerequisite* '}' )?
		//   'actions' '{' nodes+=Node* '}'
		//   'action flow' '{' edges+=Edges* '}'
		//   ('constraints'
		//    '{'
		//        constraints+=EdgesWithConstraints*
		//    '}'
		//    )?
		//'}'
		public Group getGroup() { return cGroup; }
		
		//'activity'
		public Keyword getActivityKeyword_0() { return cActivityKeyword_0; }
		
		//name = ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//('(' (parameterDeclarations+=ParameterDeclaration)? (',' parameterDeclarations+=ParameterDeclaration)* ')' )?
		public Group getGroup_2() { return cGroup_2; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_2_0() { return cLeftParenthesisKeyword_2_0; }
		
		//(parameterDeclarations+=ParameterDeclaration)?
		public Assignment getParameterDeclarationsAssignment_2_1() { return cParameterDeclarationsAssignment_2_1; }
		
		//ParameterDeclaration
		public RuleCall getParameterDeclarationsParameterDeclarationParserRuleCall_2_1_0() { return cParameterDeclarationsParameterDeclarationParserRuleCall_2_1_0; }
		
		//(',' parameterDeclarations+=ParameterDeclaration)*
		public Group getGroup_2_2() { return cGroup_2_2; }
		
		//','
		public Keyword getCommaKeyword_2_2_0() { return cCommaKeyword_2_2_0; }
		
		//parameterDeclarations+=ParameterDeclaration
		public Assignment getParameterDeclarationsAssignment_2_2_1() { return cParameterDeclarationsAssignment_2_2_1; }
		
		//ParameterDeclaration
		public RuleCall getParameterDeclarationsParameterDeclarationParserRuleCall_2_2_1_0() { return cParameterDeclarationsParameterDeclarationParserRuleCall_2_2_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_2_3() { return cRightParenthesisKeyword_2_3; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_3() { return cLeftCurlyBracketKeyword_3; }
		
		//('prerequisites' '{' prerequisites+=LocationPrerequisite* '}' )?
		public Group getGroup_4() { return cGroup_4; }
		
		//'prerequisites'
		public Keyword getPrerequisitesKeyword_4_0() { return cPrerequisitesKeyword_4_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_4_1() { return cLeftCurlyBracketKeyword_4_1; }
		
		//prerequisites+=LocationPrerequisite*
		public Assignment getPrerequisitesAssignment_4_2() { return cPrerequisitesAssignment_4_2; }
		
		//LocationPrerequisite
		public RuleCall getPrerequisitesLocationPrerequisiteParserRuleCall_4_2_0() { return cPrerequisitesLocationPrerequisiteParserRuleCall_4_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_4_3() { return cRightCurlyBracketKeyword_4_3; }
		
		//'actions'
		public Keyword getActionsKeyword_5() { return cActionsKeyword_5; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_6() { return cLeftCurlyBracketKeyword_6; }
		
		//nodes+=Node*
		public Assignment getNodesAssignment_7() { return cNodesAssignment_7; }
		
		//Node
		public RuleCall getNodesNodeParserRuleCall_7_0() { return cNodesNodeParserRuleCall_7_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_8() { return cRightCurlyBracketKeyword_8; }
		
		//'action flow'
		public Keyword getActionFlowKeyword_9() { return cActionFlowKeyword_9; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_10() { return cLeftCurlyBracketKeyword_10; }
		
		//edges+=Edges*
		public Assignment getEdgesAssignment_11() { return cEdgesAssignment_11; }
		
		//Edges
		public RuleCall getEdgesEdgesParserRuleCall_11_0() { return cEdgesEdgesParserRuleCall_11_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_12() { return cRightCurlyBracketKeyword_12; }
		
		//('constraints'
		// '{'
		//     constraints+=EdgesWithConstraints*
		// '}'
		// )?
		public Group getGroup_13() { return cGroup_13; }
		
		//'constraints'
		public Keyword getConstraintsKeyword_13_0() { return cConstraintsKeyword_13_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_13_1() { return cLeftCurlyBracketKeyword_13_1; }
		
		//constraints+=EdgesWithConstraints*
		public Assignment getConstraintsAssignment_13_2() { return cConstraintsAssignment_13_2; }
		
		//EdgesWithConstraints
		public RuleCall getConstraintsEdgesWithConstraintsParserRuleCall_13_2_0() { return cConstraintsEdgesWithConstraintsParserRuleCall_13_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_13_3() { return cRightCurlyBracketKeyword_13_3; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_14() { return cRightCurlyBracketKeyword_14; }
	}
	public class ParameterDeclarationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ParameterDeclaration");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cEventDeclarationParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cActionDeclarationParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cResourceDeclarationParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cSymbolicPositionDeclarationParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cProfileDeclarationParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		private final RuleCall cDistanceDeclarationParserRuleCall_5 = (RuleCall)cAlternatives.eContents().get(5);
		private final RuleCall cModelTypeDefinitionRefDeclarationParserRuleCall_6 = (RuleCall)cAlternatives.eContents().get(6);
		
		//ParameterDeclaration returns common::ParameterDeclaration:
		//    EventDeclaration | ActionDeclaration | ResourceDeclaration | SymbolicPositionDeclaration | ProfileDeclaration | DistanceDeclaration |
		//    ModelTypeDefinitionRefDeclaration;
		@Override public ParserRule getRule() { return rule; }
		
		//EventDeclaration | ActionDeclaration | ResourceDeclaration | SymbolicPositionDeclaration | ProfileDeclaration | DistanceDeclaration |
		//ModelTypeDefinitionRefDeclaration
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//EventDeclaration
		public RuleCall getEventDeclarationParserRuleCall_0() { return cEventDeclarationParserRuleCall_0; }
		
		//ActionDeclaration
		public RuleCall getActionDeclarationParserRuleCall_1() { return cActionDeclarationParserRuleCall_1; }
		
		//ResourceDeclaration
		public RuleCall getResourceDeclarationParserRuleCall_2() { return cResourceDeclarationParserRuleCall_2; }
		
		//SymbolicPositionDeclaration
		public RuleCall getSymbolicPositionDeclarationParserRuleCall_3() { return cSymbolicPositionDeclarationParserRuleCall_3; }
		
		//ProfileDeclaration
		public RuleCall getProfileDeclarationParserRuleCall_4() { return cProfileDeclarationParserRuleCall_4; }
		
		//DistanceDeclaration
		public RuleCall getDistanceDeclarationParserRuleCall_5() { return cDistanceDeclarationParserRuleCall_5; }
		
		//ModelTypeDefinitionRefDeclaration
		public RuleCall getModelTypeDefinitionRefDeclarationParserRuleCall_6() { return cModelTypeDefinitionRefDeclarationParserRuleCall_6; }
	}
	public class EventDeclarationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.EventDeclaration");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cParameterDeclarationAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cDeclarationsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cDeclarationsEventDefParserRuleCall_1_0 = (RuleCall)cDeclarationsAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cCommaKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cDeclarationsAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cDeclarationsEventDefParserRuleCall_2_1_0 = (RuleCall)cDeclarationsAssignment_2_1.eContents().get(0);
		private final Keyword cColonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Keyword cEventKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//EventDeclaration returns common::ParameterDeclaration:
		//    {common::ParameterDeclaration}
		//    declarations+=EventDef (',' declarations+=EventDef)* ':' 'Event';
		@Override public ParserRule getRule() { return rule; }
		
		//{common::ParameterDeclaration}
		//declarations+=EventDef (',' declarations+=EventDef)* ':' 'Event'
		public Group getGroup() { return cGroup; }
		
		//{common::ParameterDeclaration}
		public Action getParameterDeclarationAction_0() { return cParameterDeclarationAction_0; }
		
		//declarations+=EventDef
		public Assignment getDeclarationsAssignment_1() { return cDeclarationsAssignment_1; }
		
		//EventDef
		public RuleCall getDeclarationsEventDefParserRuleCall_1_0() { return cDeclarationsEventDefParserRuleCall_1_0; }
		
		//(',' declarations+=EventDef)*
		public Group getGroup_2() { return cGroup_2; }
		
		//','
		public Keyword getCommaKeyword_2_0() { return cCommaKeyword_2_0; }
		
		//declarations+=EventDef
		public Assignment getDeclarationsAssignment_2_1() { return cDeclarationsAssignment_2_1; }
		
		//EventDef
		public RuleCall getDeclarationsEventDefParserRuleCall_2_1_0() { return cDeclarationsEventDefParserRuleCall_2_1_0; }
		
		//':'
		public Keyword getColonKeyword_3() { return cColonKeyword_3; }
		
		//'Event'
		public Keyword getEventKeyword_4() { return cEventKeyword_4; }
	}
	public class ActionDeclarationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ActionDeclaration");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cParameterDeclarationAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cDeclarationsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cDeclarationsActionDefParserRuleCall_1_0 = (RuleCall)cDeclarationsAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cCommaKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cDeclarationsAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cDeclarationsActionDefParserRuleCall_2_1_0 = (RuleCall)cDeclarationsAssignment_2_1.eContents().get(0);
		private final Keyword cColonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Keyword cActionKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//ActionDeclaration returns common::ParameterDeclaration:
		//    {common::ParameterDeclaration}
		//    declarations+=ActionDef (',' declarations+=ActionDef)* ':' 'Action';
		@Override public ParserRule getRule() { return rule; }
		
		//{common::ParameterDeclaration}
		//declarations+=ActionDef (',' declarations+=ActionDef)* ':' 'Action'
		public Group getGroup() { return cGroup; }
		
		//{common::ParameterDeclaration}
		public Action getParameterDeclarationAction_0() { return cParameterDeclarationAction_0; }
		
		//declarations+=ActionDef
		public Assignment getDeclarationsAssignment_1() { return cDeclarationsAssignment_1; }
		
		//ActionDef
		public RuleCall getDeclarationsActionDefParserRuleCall_1_0() { return cDeclarationsActionDefParserRuleCall_1_0; }
		
		//(',' declarations+=ActionDef)*
		public Group getGroup_2() { return cGroup_2; }
		
		//','
		public Keyword getCommaKeyword_2_0() { return cCommaKeyword_2_0; }
		
		//declarations+=ActionDef
		public Assignment getDeclarationsAssignment_2_1() { return cDeclarationsAssignment_2_1; }
		
		//ActionDef
		public RuleCall getDeclarationsActionDefParserRuleCall_2_1_0() { return cDeclarationsActionDefParserRuleCall_2_1_0; }
		
		//':'
		public Keyword getColonKeyword_3() { return cColonKeyword_3; }
		
		//'Action'
		public Keyword getActionKeyword_4() { return cActionKeyword_4; }
	}
	public class SymbolicPositionDeclarationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.SymbolicPositionDeclaration");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cParameterDeclarationAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cDeclarationsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cDeclarationsSymbolicPositionDefParserRuleCall_1_0 = (RuleCall)cDeclarationsAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cCommaKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cDeclarationsAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cDeclarationsSymbolicPositionDefParserRuleCall_2_1_0 = (RuleCall)cDeclarationsAssignment_2_1.eContents().get(0);
		private final Keyword cColonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Keyword cSymbolicPositionKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//SymbolicPositionDeclaration returns common::ParameterDeclaration:
		//    {common::ParameterDeclaration}
		//    declarations+=SymbolicPositionDef (',' declarations+=SymbolicPositionDef)* ':' 'SymbolicPosition';
		@Override public ParserRule getRule() { return rule; }
		
		//{common::ParameterDeclaration}
		//declarations+=SymbolicPositionDef (',' declarations+=SymbolicPositionDef)* ':' 'SymbolicPosition'
		public Group getGroup() { return cGroup; }
		
		//{common::ParameterDeclaration}
		public Action getParameterDeclarationAction_0() { return cParameterDeclarationAction_0; }
		
		//declarations+=SymbolicPositionDef
		public Assignment getDeclarationsAssignment_1() { return cDeclarationsAssignment_1; }
		
		//SymbolicPositionDef
		public RuleCall getDeclarationsSymbolicPositionDefParserRuleCall_1_0() { return cDeclarationsSymbolicPositionDefParserRuleCall_1_0; }
		
		//(',' declarations+=SymbolicPositionDef)*
		public Group getGroup_2() { return cGroup_2; }
		
		//','
		public Keyword getCommaKeyword_2_0() { return cCommaKeyword_2_0; }
		
		//declarations+=SymbolicPositionDef
		public Assignment getDeclarationsAssignment_2_1() { return cDeclarationsAssignment_2_1; }
		
		//SymbolicPositionDef
		public RuleCall getDeclarationsSymbolicPositionDefParserRuleCall_2_1_0() { return cDeclarationsSymbolicPositionDefParserRuleCall_2_1_0; }
		
		//':'
		public Keyword getColonKeyword_3() { return cColonKeyword_3; }
		
		//'SymbolicPosition'
		public Keyword getSymbolicPositionKeyword_4() { return cSymbolicPositionKeyword_4; }
	}
	public class ProfileDeclarationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ProfileDeclaration");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cParameterDeclarationAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cDeclarationsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cDeclarationsProfileDefParserRuleCall_1_0 = (RuleCall)cDeclarationsAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cCommaKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cDeclarationsAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cDeclarationsProfileDefParserRuleCall_2_1_0 = (RuleCall)cDeclarationsAssignment_2_1.eContents().get(0);
		private final Keyword cColonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Keyword cProfileKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//ProfileDeclaration returns common::ParameterDeclaration:
		//    {common::ParameterDeclaration}
		//    declarations+=ProfileDef (',' declarations+=ProfileDef)* ':' 'Profile';
		@Override public ParserRule getRule() { return rule; }
		
		//{common::ParameterDeclaration}
		//declarations+=ProfileDef (',' declarations+=ProfileDef)* ':' 'Profile'
		public Group getGroup() { return cGroup; }
		
		//{common::ParameterDeclaration}
		public Action getParameterDeclarationAction_0() { return cParameterDeclarationAction_0; }
		
		//declarations+=ProfileDef
		public Assignment getDeclarationsAssignment_1() { return cDeclarationsAssignment_1; }
		
		//ProfileDef
		public RuleCall getDeclarationsProfileDefParserRuleCall_1_0() { return cDeclarationsProfileDefParserRuleCall_1_0; }
		
		//(',' declarations+=ProfileDef)*
		public Group getGroup_2() { return cGroup_2; }
		
		//','
		public Keyword getCommaKeyword_2_0() { return cCommaKeyword_2_0; }
		
		//declarations+=ProfileDef
		public Assignment getDeclarationsAssignment_2_1() { return cDeclarationsAssignment_2_1; }
		
		//ProfileDef
		public RuleCall getDeclarationsProfileDefParserRuleCall_2_1_0() { return cDeclarationsProfileDefParserRuleCall_2_1_0; }
		
		//':'
		public Keyword getColonKeyword_3() { return cColonKeyword_3; }
		
		//'Profile'
		public Keyword getProfileKeyword_4() { return cProfileKeyword_4; }
	}
	public class DistanceDeclarationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.DistanceDeclaration");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cParameterDeclarationAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cDeclarationsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cDeclarationsDistanceDefParserRuleCall_1_0 = (RuleCall)cDeclarationsAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cCommaKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cDeclarationsAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cDeclarationsDistanceDefParserRuleCall_2_1_0 = (RuleCall)cDeclarationsAssignment_2_1.eContents().get(0);
		private final Keyword cColonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Keyword cDistanceKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//DistanceDeclaration returns common::ParameterDeclaration:
		//    {common::ParameterDeclaration}
		//    declarations+=DistanceDef (',' declarations+=DistanceDef)* ':' 'Distance';
		@Override public ParserRule getRule() { return rule; }
		
		//{common::ParameterDeclaration}
		//declarations+=DistanceDef (',' declarations+=DistanceDef)* ':' 'Distance'
		public Group getGroup() { return cGroup; }
		
		//{common::ParameterDeclaration}
		public Action getParameterDeclarationAction_0() { return cParameterDeclarationAction_0; }
		
		//declarations+=DistanceDef
		public Assignment getDeclarationsAssignment_1() { return cDeclarationsAssignment_1; }
		
		//DistanceDef
		public RuleCall getDeclarationsDistanceDefParserRuleCall_1_0() { return cDeclarationsDistanceDefParserRuleCall_1_0; }
		
		//(',' declarations+=DistanceDef)*
		public Group getGroup_2() { return cGroup_2; }
		
		//','
		public Keyword getCommaKeyword_2_0() { return cCommaKeyword_2_0; }
		
		//declarations+=DistanceDef
		public Assignment getDeclarationsAssignment_2_1() { return cDeclarationsAssignment_2_1; }
		
		//DistanceDef
		public RuleCall getDeclarationsDistanceDefParserRuleCall_2_1_0() { return cDeclarationsDistanceDefParserRuleCall_2_1_0; }
		
		//':'
		public Keyword getColonKeyword_3() { return cColonKeyword_3; }
		
		//'Distance'
		public Keyword getDistanceKeyword_4() { return cDistanceKeyword_4; }
	}
	public class ResourceDeclarationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ResourceDeclaration");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cParameterDeclarationAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cDeclarationsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cDeclarationsResourceDefParserRuleCall_1_0 = (RuleCall)cDeclarationsAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cCommaKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cDeclarationsAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cDeclarationsResourceDefParserRuleCall_2_1_0 = (RuleCall)cDeclarationsAssignment_2_1.eContents().get(0);
		private final Keyword cColonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Keyword cResourceKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//ResourceDeclaration returns common::ParameterDeclaration:
		//    {common::ParameterDeclaration}
		//    declarations+=ResourceDef (',' declarations+=ResourceDef)* ':' 'Resource';
		@Override public ParserRule getRule() { return rule; }
		
		//{common::ParameterDeclaration}
		//declarations+=ResourceDef (',' declarations+=ResourceDef)* ':' 'Resource'
		public Group getGroup() { return cGroup; }
		
		//{common::ParameterDeclaration}
		public Action getParameterDeclarationAction_0() { return cParameterDeclarationAction_0; }
		
		//declarations+=ResourceDef
		public Assignment getDeclarationsAssignment_1() { return cDeclarationsAssignment_1; }
		
		//ResourceDef
		public RuleCall getDeclarationsResourceDefParserRuleCall_1_0() { return cDeclarationsResourceDefParserRuleCall_1_0; }
		
		//(',' declarations+=ResourceDef)*
		public Group getGroup_2() { return cGroup_2; }
		
		//','
		public Keyword getCommaKeyword_2_0() { return cCommaKeyword_2_0; }
		
		//declarations+=ResourceDef
		public Assignment getDeclarationsAssignment_2_1() { return cDeclarationsAssignment_2_1; }
		
		//ResourceDef
		public RuleCall getDeclarationsResourceDefParserRuleCall_2_1_0() { return cDeclarationsResourceDefParserRuleCall_2_1_0; }
		
		//':'
		public Keyword getColonKeyword_3() { return cColonKeyword_3; }
		
		//'Resource'
		public Keyword getResourceKeyword_4() { return cResourceKeyword_4; }
	}
	public class ModelTypeDefinitionRefDeclarationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ModelTypeDefinitionRefDeclaration");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cParameterDeclarationAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cDeclarationsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cDeclarationsModelTypeDefinitionRefParserRuleCall_1_0 = (RuleCall)cDeclarationsAssignment_1.eContents().get(0);
		
		//ModelTypeDefinitionRefDeclaration returns common::ParameterDeclaration:
		//    {common::ParameterDeclaration}
		//    declarations+=ModelTypeDefinitionRef;
		@Override public ParserRule getRule() { return rule; }
		
		//{common::ParameterDeclaration}
		//declarations+=ModelTypeDefinitionRef
		public Group getGroup() { return cGroup; }
		
		//{common::ParameterDeclaration}
		public Action getParameterDeclarationAction_0() { return cParameterDeclarationAction_0; }
		
		//declarations+=ModelTypeDefinitionRef
		public Assignment getDeclarationsAssignment_1() { return cDeclarationsAssignment_1; }
		
		//ModelTypeDefinitionRef
		public RuleCall getDeclarationsModelTypeDefinitionRefParserRuleCall_1_0() { return cDeclarationsModelTypeDefinitionRefParserRuleCall_1_0; }
	}
	public class EventDefElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.EventDef");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cEventAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		
		//EventDef returns Event:
		//    {Event} name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//{Event} name=ID
		public Group getGroup() { return cGroup; }
		
		//{Event}
		public Action getEventAction_0() { return cEventAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
	}
	public class ActionDefElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ActionDef");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cActionTypeAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		
		//ActionDef returns machine::ActionType:
		//    {machine::ActionType} name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//{machine::ActionType} name=ID
		public Group getGroup() { return cGroup; }
		
		//{machine::ActionType}
		public Action getActionTypeAction_0() { return cActionTypeAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
	}
	public class SymbolicPositionDefElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.SymbolicPositionDef");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cSymbolicPositionAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		
		//SymbolicPositionDef returns machine::SymbolicPosition:
		//    {machine::SymbolicPosition} name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//{machine::SymbolicPosition} name=ID
		public Group getGroup() { return cGroup; }
		
		//{machine::SymbolicPosition}
		public Action getSymbolicPositionAction_0() { return cSymbolicPositionAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
	}
	public class ProfileDefElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ProfileDef");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cProfileAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		
		//ProfileDef returns machine::Profile:
		//    {machine::Profile} name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//{machine::Profile} name=ID
		public Group getGroup() { return cGroup; }
		
		//{machine::Profile}
		public Action getProfileAction_0() { return cProfileAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
	}
	public class DistanceDefElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.DistanceDef");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cDistanceAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		
		//DistanceDef returns machine::Distance:
		//    {machine::Distance} name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//{machine::Distance} name=ID
		public Group getGroup() { return cGroup; }
		
		//{machine::Distance}
		public Action getDistanceAction_0() { return cDistanceAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
	}
	public class ResourceDefElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ResourceDef");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cResourceAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		
		//ResourceDef returns machine::Resource:
		//    {machine::Resource} name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//{machine::Resource} name=ID
		public Group getGroup() { return cGroup; }
		
		//{machine::Resource}
		public Action getResourceAction_0() { return cResourceAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
	}
	public class ModelTypeDefinitionRefElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ModelTypeDefinitionRef");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cModelTypeDefinitionRefAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cTypeDefinitionAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cTypeDefinitionTypeDefinitionCrossReference_3_0 = (CrossReference)cTypeDefinitionAssignment_3.eContents().get(0);
		private final RuleCall cTypeDefinitionTypeDefinitionIDTerminalRuleCall_3_0_1 = (RuleCall)cTypeDefinitionTypeDefinitionCrossReference_3_0.eContents().get(1);
		
		//ModelTypeDefinitionRef returns ModelTypeDefinitionRef:
		//    {ModelTypeDefinitionRef} name=ID ':' typeDefinition=[common::TypeDefinition|ID];
		@Override public ParserRule getRule() { return rule; }
		
		//{ModelTypeDefinitionRef} name=ID ':' typeDefinition=[common::TypeDefinition|ID]
		public Group getGroup() { return cGroup; }
		
		//{ModelTypeDefinitionRef}
		public Action getModelTypeDefinitionRefAction_0() { return cModelTypeDefinitionRefAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//typeDefinition=[common::TypeDefinition|ID]
		public Assignment getTypeDefinitionAssignment_3() { return cTypeDefinitionAssignment_3; }
		
		//[common::TypeDefinition|ID]
		public CrossReference getTypeDefinitionTypeDefinitionCrossReference_3_0() { return cTypeDefinitionTypeDefinitionCrossReference_3_0; }
		
		//ID
		public RuleCall getTypeDefinitionTypeDefinitionIDTerminalRuleCall_3_0_1() { return cTypeDefinitionTypeDefinitionIDTerminalRuleCall_3_0_1; }
	}
	public class LocationPrerequisiteElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.LocationPrerequisite");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cResourceDefinitionAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cResourceDefinitionResourceCrossReference_0_0 = (CrossReference)cResourceDefinitionAssignment_0.eContents().get(0);
		private final RuleCall cResourceDefinitionResourceIDTerminalRuleCall_0_0_1 = (RuleCall)cResourceDefinitionResourceCrossReference_0_0.eContents().get(1);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cFullStopKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cResourceItemAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final CrossReference cResourceItemResourceItemCrossReference_1_1_0 = (CrossReference)cResourceItemAssignment_1_1.eContents().get(0);
		private final RuleCall cResourceItemResourceItemIIDParserRuleCall_1_1_0_1 = (RuleCall)cResourceItemResourceItemCrossReference_1_1_0.eContents().get(1);
		private final Keyword cFullStopKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cPeripheralAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cPeripheralPeripheralCrossReference_3_0 = (CrossReference)cPeripheralAssignment_3.eContents().get(0);
		private final RuleCall cPeripheralPeripheralIDTerminalRuleCall_3_0_1 = (RuleCall)cPeripheralPeripheralCrossReference_3_0.eContents().get(1);
		private final Keyword cAtKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cPositionAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final CrossReference cPositionSymbolicPositionCrossReference_5_0 = (CrossReference)cPositionAssignment_5.eContents().get(0);
		private final RuleCall cPositionSymbolicPositionIDTerminalRuleCall_5_0_1 = (RuleCall)cPositionSymbolicPositionCrossReference_5_0.eContents().get(1);
		
		//LocationPrerequisite returns LocationPrerequisite:
		//     resourceDefinition=[machine::Resource|ID] ('.' resourceItem=[machine::ResourceItem|IID])? '.' => peripheral=[machine::Peripheral|ID] 'at' position=[machine::SymbolicPosition|ID];
		@Override public ParserRule getRule() { return rule; }
		
		//resourceDefinition=[machine::Resource|ID] ('.' resourceItem=[machine::ResourceItem|IID])? '.' => peripheral=[machine::Peripheral|ID] 'at' position=[machine::SymbolicPosition|ID]
		public Group getGroup() { return cGroup; }
		
		//resourceDefinition=[machine::Resource|ID]
		public Assignment getResourceDefinitionAssignment_0() { return cResourceDefinitionAssignment_0; }
		
		//[machine::Resource|ID]
		public CrossReference getResourceDefinitionResourceCrossReference_0_0() { return cResourceDefinitionResourceCrossReference_0_0; }
		
		//ID
		public RuleCall getResourceDefinitionResourceIDTerminalRuleCall_0_0_1() { return cResourceDefinitionResourceIDTerminalRuleCall_0_0_1; }
		
		//('.' resourceItem=[machine::ResourceItem|IID])?
		public Group getGroup_1() { return cGroup_1; }
		
		//'.'
		public Keyword getFullStopKeyword_1_0() { return cFullStopKeyword_1_0; }
		
		//resourceItem=[machine::ResourceItem|IID]
		public Assignment getResourceItemAssignment_1_1() { return cResourceItemAssignment_1_1; }
		
		//[machine::ResourceItem|IID]
		public CrossReference getResourceItemResourceItemCrossReference_1_1_0() { return cResourceItemResourceItemCrossReference_1_1_0; }
		
		//IID
		public RuleCall getResourceItemResourceItemIIDParserRuleCall_1_1_0_1() { return cResourceItemResourceItemIIDParserRuleCall_1_1_0_1; }
		
		//'.'
		public Keyword getFullStopKeyword_2() { return cFullStopKeyword_2; }
		
		//=> peripheral=[machine::Peripheral|ID]
		public Assignment getPeripheralAssignment_3() { return cPeripheralAssignment_3; }
		
		//[machine::Peripheral|ID]
		public CrossReference getPeripheralPeripheralCrossReference_3_0() { return cPeripheralPeripheralCrossReference_3_0; }
		
		//ID
		public RuleCall getPeripheralPeripheralIDTerminalRuleCall_3_0_1() { return cPeripheralPeripheralIDTerminalRuleCall_3_0_1; }
		
		//'at'
		public Keyword getAtKeyword_4() { return cAtKeyword_4; }
		
		//position=[machine::SymbolicPosition|ID]
		public Assignment getPositionAssignment_5() { return cPositionAssignment_5; }
		
		//[machine::SymbolicPosition|ID]
		public CrossReference getPositionSymbolicPositionCrossReference_5_0() { return cPositionSymbolicPositionCrossReference_5_0; }
		
		//ID
		public RuleCall getPositionSymbolicPositionIDTerminalRuleCall_5_0_1() { return cPositionSymbolicPositionIDTerminalRuleCall_5_0_1; }
	}
	public class NodeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Node");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cClaimParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cReleaseParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cSimpleActionParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cMoveParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cRequireEventParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		private final RuleCall cRaiseEventParserRuleCall_5 = (RuleCall)cAlternatives.eContents().get(5);
		
		//Node returns Node:
		//    Claim | Release | SimpleAction | Move |RequireEvent |RaiseEvent;
		@Override public ParserRule getRule() { return rule; }
		
		//Claim | Release | SimpleAction | Move |RequireEvent |RaiseEvent
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//Claim
		public RuleCall getClaimParserRuleCall_0() { return cClaimParserRuleCall_0; }
		
		//Release
		public RuleCall getReleaseParserRuleCall_1() { return cReleaseParserRuleCall_1; }
		
		//SimpleAction
		public RuleCall getSimpleActionParserRuleCall_2() { return cSimpleActionParserRuleCall_2; }
		
		//Move
		public RuleCall getMoveParserRuleCall_3() { return cMoveParserRuleCall_3; }
		
		//RequireEvent
		public RuleCall getRequireEventParserRuleCall_4() { return cRequireEventParserRuleCall_4; }
		
		//RaiseEvent
		public RuleCall getRaiseEventParserRuleCall_5() { return cRaiseEventParserRuleCall_5; }
	}
	public class ClaimElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Claim");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cClaimAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cEntryAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cEntryTracePointParserRuleCall_3_0_0 = (RuleCall)cEntryAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cAlternatives_3.eContents().get(1);
		private final Assignment cOuterEntryAssignment_3_1_0 = (Assignment)cGroup_3_1.eContents().get(0);
		private final RuleCall cOuterEntryTracePointParserRuleCall_3_1_0_0 = (RuleCall)cOuterEntryAssignment_3_1_0.eContents().get(0);
		private final Assignment cEntryAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cEntryTracePointParserRuleCall_3_1_1_0 = (RuleCall)cEntryAssignment_3_1_1.eContents().get(0);
		private final Assignment cPassiveAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final Keyword cPassivePassiveKeyword_4_0 = (Keyword)cPassiveAssignment_4.eContents().get(0);
		private final Keyword cClaimKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cResourceDefinitionAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final CrossReference cResourceDefinitionResourceCrossReference_6_0 = (CrossReference)cResourceDefinitionAssignment_6.eContents().get(0);
		private final RuleCall cResourceDefinitionResourceIDTerminalRuleCall_6_0_1 = (RuleCall)cResourceDefinitionResourceCrossReference_6_0.eContents().get(1);
		private final Group cGroup_7 = (Group)cGroup.eContents().get(7);
		private final Keyword cFullStopKeyword_7_0 = (Keyword)cGroup_7.eContents().get(0);
		private final Assignment cResourceItemAssignment_7_1 = (Assignment)cGroup_7.eContents().get(1);
		private final CrossReference cResourceItemResourceItemCrossReference_7_1_0 = (CrossReference)cResourceItemAssignment_7_1.eContents().get(0);
		private final RuleCall cResourceItemResourceItemIIDParserRuleCall_7_1_0_1 = (RuleCall)cResourceItemResourceItemCrossReference_7_1_0.eContents().get(1);
		private final Alternatives cAlternatives_8 = (Alternatives)cGroup.eContents().get(8);
		private final Assignment cExitAssignment_8_0 = (Assignment)cAlternatives_8.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_8_0_0 = (RuleCall)cExitAssignment_8_0.eContents().get(0);
		private final Group cGroup_8_1 = (Group)cAlternatives_8.eContents().get(1);
		private final Assignment cExitAssignment_8_1_0 = (Assignment)cGroup_8_1.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_8_1_0_0 = (RuleCall)cExitAssignment_8_1_0.eContents().get(0);
		private final Assignment cOuterExitAssignment_8_1_1 = (Assignment)cGroup_8_1.eContents().get(1);
		private final RuleCall cOuterExitTracePointParserRuleCall_8_1_1_0 = (RuleCall)cOuterExitAssignment_8_1_1.eContents().get(0);
		
		//Claim returns Claim:
		//    {Claim}
		//    name=ID ':'
		//    ((entry=TracePoint)| (outerEntry=TracePoint entry=TracePoint))?
		//    ( passive?='passive')? 'claim' resourceDefinition=[machine::Resource|ID]('.' resourceItem=[machine::ResourceItem|IID])?
		//    ((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{Claim}
		//name=ID ':'
		//((entry=TracePoint)| (outerEntry=TracePoint entry=TracePoint))?
		//( passive?='passive')? 'claim' resourceDefinition=[machine::Resource|ID]('.' resourceItem=[machine::ResourceItem|IID])?
		//((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
		public Group getGroup() { return cGroup; }
		
		//{Claim}
		public Action getClaimAction_0() { return cClaimAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//((entry=TracePoint)| (outerEntry=TracePoint entry=TracePoint))?
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//(entry=TracePoint)
		public Assignment getEntryAssignment_3_0() { return cEntryAssignment_3_0; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_0_0() { return cEntryTracePointParserRuleCall_3_0_0; }
		
		//(outerEntry=TracePoint entry=TracePoint)
		public Group getGroup_3_1() { return cGroup_3_1; }
		
		//outerEntry=TracePoint
		public Assignment getOuterEntryAssignment_3_1_0() { return cOuterEntryAssignment_3_1_0; }
		
		//TracePoint
		public RuleCall getOuterEntryTracePointParserRuleCall_3_1_0_0() { return cOuterEntryTracePointParserRuleCall_3_1_0_0; }
		
		//entry=TracePoint
		public Assignment getEntryAssignment_3_1_1() { return cEntryAssignment_3_1_1; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_1_1_0() { return cEntryTracePointParserRuleCall_3_1_1_0; }
		
		//( passive?='passive')?
		public Assignment getPassiveAssignment_4() { return cPassiveAssignment_4; }
		
		//'passive'
		public Keyword getPassivePassiveKeyword_4_0() { return cPassivePassiveKeyword_4_0; }
		
		//'claim'
		public Keyword getClaimKeyword_5() { return cClaimKeyword_5; }
		
		//resourceDefinition=[machine::Resource|ID]
		public Assignment getResourceDefinitionAssignment_6() { return cResourceDefinitionAssignment_6; }
		
		//[machine::Resource|ID]
		public CrossReference getResourceDefinitionResourceCrossReference_6_0() { return cResourceDefinitionResourceCrossReference_6_0; }
		
		//ID
		public RuleCall getResourceDefinitionResourceIDTerminalRuleCall_6_0_1() { return cResourceDefinitionResourceIDTerminalRuleCall_6_0_1; }
		
		//('.' resourceItem=[machine::ResourceItem|IID])?
		public Group getGroup_7() { return cGroup_7; }
		
		//'.'
		public Keyword getFullStopKeyword_7_0() { return cFullStopKeyword_7_0; }
		
		//resourceItem=[machine::ResourceItem|IID]
		public Assignment getResourceItemAssignment_7_1() { return cResourceItemAssignment_7_1; }
		
		//[machine::ResourceItem|IID]
		public CrossReference getResourceItemResourceItemCrossReference_7_1_0() { return cResourceItemResourceItemCrossReference_7_1_0; }
		
		//IID
		public RuleCall getResourceItemResourceItemIIDParserRuleCall_7_1_0_1() { return cResourceItemResourceItemIIDParserRuleCall_7_1_0_1; }
		
		//((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
		public Alternatives getAlternatives_8() { return cAlternatives_8; }
		
		//(exit=TracePoint)
		public Assignment getExitAssignment_8_0() { return cExitAssignment_8_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_8_0_0() { return cExitTracePointParserRuleCall_8_0_0; }
		
		//(exit=TracePoint outerExit=TracePoint)
		public Group getGroup_8_1() { return cGroup_8_1; }
		
		//exit=TracePoint
		public Assignment getExitAssignment_8_1_0() { return cExitAssignment_8_1_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_8_1_0_0() { return cExitTracePointParserRuleCall_8_1_0_0; }
		
		//outerExit=TracePoint
		public Assignment getOuterExitAssignment_8_1_1() { return cOuterExitAssignment_8_1_1; }
		
		//TracePoint
		public RuleCall getOuterExitTracePointParserRuleCall_8_1_1_0() { return cOuterExitTracePointParserRuleCall_8_1_1_0; }
	}
	public class ReleaseElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Release");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cReleaseAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cEntryAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cEntryTracePointParserRuleCall_3_0_0 = (RuleCall)cEntryAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cAlternatives_3.eContents().get(1);
		private final Assignment cOuterEntryAssignment_3_1_0 = (Assignment)cGroup_3_1.eContents().get(0);
		private final RuleCall cOuterEntryTracePointParserRuleCall_3_1_0_0 = (RuleCall)cOuterEntryAssignment_3_1_0.eContents().get(0);
		private final Assignment cEntryAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cEntryTracePointParserRuleCall_3_1_1_0 = (RuleCall)cEntryAssignment_3_1_1.eContents().get(0);
		private final Keyword cReleaseKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cResourceDefinitionAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final CrossReference cResourceDefinitionResourceCrossReference_5_0 = (CrossReference)cResourceDefinitionAssignment_5.eContents().get(0);
		private final RuleCall cResourceDefinitionResourceIDTerminalRuleCall_5_0_1 = (RuleCall)cResourceDefinitionResourceCrossReference_5_0.eContents().get(1);
		private final Group cGroup_6 = (Group)cGroup.eContents().get(6);
		private final Keyword cFullStopKeyword_6_0 = (Keyword)cGroup_6.eContents().get(0);
		private final Assignment cResourceItemAssignment_6_1 = (Assignment)cGroup_6.eContents().get(1);
		private final CrossReference cResourceItemResourceItemCrossReference_6_1_0 = (CrossReference)cResourceItemAssignment_6_1.eContents().get(0);
		private final RuleCall cResourceItemResourceItemIIDParserRuleCall_6_1_0_1 = (RuleCall)cResourceItemResourceItemCrossReference_6_1_0.eContents().get(1);
		private final Alternatives cAlternatives_7 = (Alternatives)cGroup.eContents().get(7);
		private final Assignment cExitAssignment_7_0 = (Assignment)cAlternatives_7.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_7_0_0 = (RuleCall)cExitAssignment_7_0.eContents().get(0);
		private final Group cGroup_7_1 = (Group)cAlternatives_7.eContents().get(1);
		private final Assignment cExitAssignment_7_1_0 = (Assignment)cGroup_7_1.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_7_1_0_0 = (RuleCall)cExitAssignment_7_1_0.eContents().get(0);
		private final Assignment cOuterExitAssignment_7_1_1 = (Assignment)cGroup_7_1.eContents().get(1);
		private final RuleCall cOuterExitTracePointParserRuleCall_7_1_1_0 = (RuleCall)cOuterExitAssignment_7_1_1.eContents().get(0);
		
		//Release returns Release:
		//    {Release}
		//    name=ID ':'
		//    ((entry=TracePoint)| (outerEntry=TracePoint entry=TracePoint))?
		//    'release' resourceDefinition=[machine::Resource|ID]('.' resourceItem=[machine::ResourceItem|IID])?
		//    ((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{Release}
		//name=ID ':'
		//((entry=TracePoint)| (outerEntry=TracePoint entry=TracePoint))?
		//'release' resourceDefinition=[machine::Resource|ID]('.' resourceItem=[machine::ResourceItem|IID])?
		//((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
		public Group getGroup() { return cGroup; }
		
		//{Release}
		public Action getReleaseAction_0() { return cReleaseAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//((entry=TracePoint)| (outerEntry=TracePoint entry=TracePoint))?
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//(entry=TracePoint)
		public Assignment getEntryAssignment_3_0() { return cEntryAssignment_3_0; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_0_0() { return cEntryTracePointParserRuleCall_3_0_0; }
		
		//(outerEntry=TracePoint entry=TracePoint)
		public Group getGroup_3_1() { return cGroup_3_1; }
		
		//outerEntry=TracePoint
		public Assignment getOuterEntryAssignment_3_1_0() { return cOuterEntryAssignment_3_1_0; }
		
		//TracePoint
		public RuleCall getOuterEntryTracePointParserRuleCall_3_1_0_0() { return cOuterEntryTracePointParserRuleCall_3_1_0_0; }
		
		//entry=TracePoint
		public Assignment getEntryAssignment_3_1_1() { return cEntryAssignment_3_1_1; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_1_1_0() { return cEntryTracePointParserRuleCall_3_1_1_0; }
		
		//'release'
		public Keyword getReleaseKeyword_4() { return cReleaseKeyword_4; }
		
		//resourceDefinition=[machine::Resource|ID]
		public Assignment getResourceDefinitionAssignment_5() { return cResourceDefinitionAssignment_5; }
		
		//[machine::Resource|ID]
		public CrossReference getResourceDefinitionResourceCrossReference_5_0() { return cResourceDefinitionResourceCrossReference_5_0; }
		
		//ID
		public RuleCall getResourceDefinitionResourceIDTerminalRuleCall_5_0_1() { return cResourceDefinitionResourceIDTerminalRuleCall_5_0_1; }
		
		//('.' resourceItem=[machine::ResourceItem|IID])?
		public Group getGroup_6() { return cGroup_6; }
		
		//'.'
		public Keyword getFullStopKeyword_6_0() { return cFullStopKeyword_6_0; }
		
		//resourceItem=[machine::ResourceItem|IID]
		public Assignment getResourceItemAssignment_6_1() { return cResourceItemAssignment_6_1; }
		
		//[machine::ResourceItem|IID]
		public CrossReference getResourceItemResourceItemCrossReference_6_1_0() { return cResourceItemResourceItemCrossReference_6_1_0; }
		
		//IID
		public RuleCall getResourceItemResourceItemIIDParserRuleCall_6_1_0_1() { return cResourceItemResourceItemIIDParserRuleCall_6_1_0_1; }
		
		//((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
		public Alternatives getAlternatives_7() { return cAlternatives_7; }
		
		//(exit=TracePoint)
		public Assignment getExitAssignment_7_0() { return cExitAssignment_7_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_7_0_0() { return cExitTracePointParserRuleCall_7_0_0; }
		
		//(exit=TracePoint outerExit=TracePoint)
		public Group getGroup_7_1() { return cGroup_7_1; }
		
		//exit=TracePoint
		public Assignment getExitAssignment_7_1_0() { return cExitAssignment_7_1_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_7_1_0_0() { return cExitTracePointParserRuleCall_7_1_0_0; }
		
		//outerExit=TracePoint
		public Assignment getOuterExitAssignment_7_1_1() { return cOuterExitAssignment_7_1_1; }
		
		//TracePoint
		public RuleCall getOuterExitTracePointParserRuleCall_7_1_1_0() { return cOuterExitTracePointParserRuleCall_7_1_1_0; }
	}
	public class RaiseEventElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.RaiseEvent");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cRaiseEventAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cRaiseKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cResourceDefinitionAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cResourceDefinitionEventCrossReference_4_0 = (CrossReference)cResourceDefinitionAssignment_4.eContents().get(0);
		private final RuleCall cResourceDefinitionEventIDTerminalRuleCall_4_0_1 = (RuleCall)cResourceDefinitionEventCrossReference_4_0.eContents().get(1);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cFullStopKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cResourceItemAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final CrossReference cResourceItemEventItemCrossReference_5_1_0 = (CrossReference)cResourceItemAssignment_5_1.eContents().get(0);
		private final RuleCall cResourceItemEventItemIDTerminalRuleCall_5_1_0_1 = (RuleCall)cResourceItemEventItemCrossReference_5_1_0.eContents().get(1);
		
		//RaiseEvent returns RaiseEvent:
		//    {RaiseEvent}
		//    name=ID ':'
		//    'raise' resourceDefinition=[Event|ID]('.' resourceItem=[EventItem])?
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{RaiseEvent}
		//name=ID ':'
		//'raise' resourceDefinition=[Event|ID]('.' resourceItem=[EventItem])?
		public Group getGroup() { return cGroup; }
		
		//{RaiseEvent}
		public Action getRaiseEventAction_0() { return cRaiseEventAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//'raise'
		public Keyword getRaiseKeyword_3() { return cRaiseKeyword_3; }
		
		//resourceDefinition=[Event|ID]
		public Assignment getResourceDefinitionAssignment_4() { return cResourceDefinitionAssignment_4; }
		
		//[Event|ID]
		public CrossReference getResourceDefinitionEventCrossReference_4_0() { return cResourceDefinitionEventCrossReference_4_0; }
		
		//ID
		public RuleCall getResourceDefinitionEventIDTerminalRuleCall_4_0_1() { return cResourceDefinitionEventIDTerminalRuleCall_4_0_1; }
		
		//('.' resourceItem=[EventItem])?
		public Group getGroup_5() { return cGroup_5; }
		
		//'.'
		public Keyword getFullStopKeyword_5_0() { return cFullStopKeyword_5_0; }
		
		//resourceItem=[EventItem]
		public Assignment getResourceItemAssignment_5_1() { return cResourceItemAssignment_5_1; }
		
		//[EventItem]
		public CrossReference getResourceItemEventItemCrossReference_5_1_0() { return cResourceItemEventItemCrossReference_5_1_0; }
		
		//ID
		public RuleCall getResourceItemEventItemIDTerminalRuleCall_5_1_0_1() { return cResourceItemEventItemIDTerminalRuleCall_5_1_0_1; }
	}
	public class RequireEventElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.RequireEvent");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cRequireEventAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cRequireKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cResourceDefinitionAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cResourceDefinitionEventCrossReference_4_0 = (CrossReference)cResourceDefinitionAssignment_4.eContents().get(0);
		private final RuleCall cResourceDefinitionEventIDTerminalRuleCall_4_0_1 = (RuleCall)cResourceDefinitionEventCrossReference_4_0.eContents().get(1);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cFullStopKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Assignment cResourceItemAssignment_5_1 = (Assignment)cGroup_5.eContents().get(1);
		private final CrossReference cResourceItemEventItemCrossReference_5_1_0 = (CrossReference)cResourceItemAssignment_5_1.eContents().get(0);
		private final RuleCall cResourceItemEventItemIDTerminalRuleCall_5_1_0_1 = (RuleCall)cResourceItemEventItemCrossReference_5_1_0.eContents().get(1);
		
		//RequireEvent returns RequireEvent:
		//    {RequireEvent}
		//    name=ID ':'
		//    'require' resourceDefinition=[Event|ID]('.' resourceItem=[EventItem])?
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{RequireEvent}
		//name=ID ':'
		//'require' resourceDefinition=[Event|ID]('.' resourceItem=[EventItem])?
		public Group getGroup() { return cGroup; }
		
		//{RequireEvent}
		public Action getRequireEventAction_0() { return cRequireEventAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//'require'
		public Keyword getRequireKeyword_3() { return cRequireKeyword_3; }
		
		//resourceDefinition=[Event|ID]
		public Assignment getResourceDefinitionAssignment_4() { return cResourceDefinitionAssignment_4; }
		
		//[Event|ID]
		public CrossReference getResourceDefinitionEventCrossReference_4_0() { return cResourceDefinitionEventCrossReference_4_0; }
		
		//ID
		public RuleCall getResourceDefinitionEventIDTerminalRuleCall_4_0_1() { return cResourceDefinitionEventIDTerminalRuleCall_4_0_1; }
		
		//('.' resourceItem=[EventItem])?
		public Group getGroup_5() { return cGroup_5; }
		
		//'.'
		public Keyword getFullStopKeyword_5_0() { return cFullStopKeyword_5_0; }
		
		//resourceItem=[EventItem]
		public Assignment getResourceItemAssignment_5_1() { return cResourceItemAssignment_5_1; }
		
		//[EventItem]
		public CrossReference getResourceItemEventItemCrossReference_5_1_0() { return cResourceItemEventItemCrossReference_5_1_0; }
		
		//ID
		public RuleCall getResourceItemEventItemIDTerminalRuleCall_5_1_0_1() { return cResourceItemEventItemIDTerminalRuleCall_5_1_0_1; }
	}
	public class MoveElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Move");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cMoveAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cEntryAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cEntryTracePointParserRuleCall_3_0_0 = (RuleCall)cEntryAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cAlternatives_3.eContents().get(1);
		private final Assignment cOuterEntryAssignment_3_1_0 = (Assignment)cGroup_3_1.eContents().get(0);
		private final RuleCall cOuterEntryTracePointParserRuleCall_3_1_0_0 = (RuleCall)cOuterEntryAssignment_3_1_0.eContents().get(0);
		private final Assignment cEntryAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cEntryTracePointParserRuleCall_3_1_1_0 = (RuleCall)cEntryAssignment_3_1_1.eContents().get(0);
		private final Keyword cMoveKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cResourceDefinitionAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final CrossReference cResourceDefinitionResourceCrossReference_5_0 = (CrossReference)cResourceDefinitionAssignment_5.eContents().get(0);
		private final RuleCall cResourceDefinitionResourceIDTerminalRuleCall_5_0_1 = (RuleCall)cResourceDefinitionResourceCrossReference_5_0.eContents().get(1);
		private final Group cGroup_6 = (Group)cGroup.eContents().get(6);
		private final Keyword cFullStopKeyword_6_0 = (Keyword)cGroup_6.eContents().get(0);
		private final Assignment cResourceItemAssignment_6_1 = (Assignment)cGroup_6.eContents().get(1);
		private final CrossReference cResourceItemResourceItemCrossReference_6_1_0 = (CrossReference)cResourceItemAssignment_6_1.eContents().get(0);
		private final RuleCall cResourceItemResourceItemIIDParserRuleCall_6_1_0_1 = (RuleCall)cResourceItemResourceItemCrossReference_6_1_0.eContents().get(1);
		private final Keyword cFullStopKeyword_7 = (Keyword)cGroup.eContents().get(7);
		private final Assignment cPeripheralAssignment_8 = (Assignment)cGroup.eContents().get(8);
		private final CrossReference cPeripheralPeripheralCrossReference_8_0 = (CrossReference)cPeripheralAssignment_8.eContents().get(0);
		private final RuleCall cPeripheralPeripheralIDTerminalRuleCall_8_0_1 = (RuleCall)cPeripheralPeripheralCrossReference_8_0.eContents().get(1);
		private final Alternatives cAlternatives_9 = (Alternatives)cGroup.eContents().get(9);
		private final Group cGroup_9_0 = (Group)cAlternatives_9.eContents().get(0);
		private final Alternatives cAlternatives_9_0_0 = (Alternatives)cGroup_9_0.eContents().get(0);
		private final Assignment cPassingAssignment_9_0_0_0 = (Assignment)cAlternatives_9_0_0.eContents().get(0);
		private final Keyword cPassingPassingKeyword_9_0_0_0_0 = (Keyword)cPassingAssignment_9_0_0_0.eContents().get(0);
		private final Keyword cToKeyword_9_0_0_1 = (Keyword)cAlternatives_9_0_0.eContents().get(1);
		private final Assignment cTargetPositionAssignment_9_0_1 = (Assignment)cGroup_9_0.eContents().get(1);
		private final CrossReference cTargetPositionSymbolicPositionCrossReference_9_0_1_0 = (CrossReference)cTargetPositionAssignment_9_0_1.eContents().get(0);
		private final RuleCall cTargetPositionSymbolicPositionIDTerminalRuleCall_9_0_1_0_1 = (RuleCall)cTargetPositionSymbolicPositionCrossReference_9_0_1_0.eContents().get(1);
		private final Group cGroup_9_1 = (Group)cAlternatives_9.eContents().get(1);
		private final Alternatives cAlternatives_9_1_0 = (Alternatives)cGroup_9_1.eContents().get(0);
		private final Assignment cContinuingAssignment_9_1_0_0 = (Assignment)cAlternatives_9_1_0.eContents().get(0);
		private final Keyword cContinuingContinuingKeyword_9_1_0_0_0 = (Keyword)cContinuingAssignment_9_1_0_0.eContents().get(0);
		private final Keyword cForKeyword_9_1_0_1 = (Keyword)cAlternatives_9_1_0.eContents().get(1);
		private final Assignment cDistanceAssignment_9_1_1 = (Assignment)cGroup_9_1.eContents().get(1);
		private final CrossReference cDistanceDistanceCrossReference_9_1_1_0 = (CrossReference)cDistanceAssignment_9_1_1.eContents().get(0);
		private final RuleCall cDistanceDistanceIDTerminalRuleCall_9_1_1_0_1 = (RuleCall)cDistanceDistanceCrossReference_9_1_1_0.eContents().get(1);
		private final Group cGroup_10 = (Group)cGroup.eContents().get(10);
		private final Keyword cWithSpeedProfileKeyword_10_0 = (Keyword)cGroup_10.eContents().get(0);
		private final Assignment cProfileAssignment_10_1 = (Assignment)cGroup_10.eContents().get(1);
		private final CrossReference cProfileProfileCrossReference_10_1_0 = (CrossReference)cProfileAssignment_10_1.eContents().get(0);
		private final RuleCall cProfileProfileIDTerminalRuleCall_10_1_0_1 = (RuleCall)cProfileProfileCrossReference_10_1_0.eContents().get(1);
		private final Assignment cSchedulingTypeAssignment_11 = (Assignment)cGroup.eContents().get(11);
		private final RuleCall cSchedulingTypeSchedulingEnumRuleCall_11_0 = (RuleCall)cSchedulingTypeAssignment_11.eContents().get(0);
		private final Group cGroup_12 = (Group)cGroup.eContents().get(12);
		private final Assignment cProductChangesAssignment_12_0 = (Assignment)cGroup_12.eContents().get(0);
		private final RuleCall cProductChangesProductChangeParserRuleCall_12_0_0 = (RuleCall)cProductChangesAssignment_12_0.eContents().get(0);
		private final Assignment cProductChangesAssignment_12_1 = (Assignment)cGroup_12.eContents().get(1);
		private final RuleCall cProductChangesProductChangeWithTransferTypeParserRuleCall_12_1_0 = (RuleCall)cProductChangesAssignment_12_1.eContents().get(0);
		private final Alternatives cAlternatives_13 = (Alternatives)cGroup.eContents().get(13);
		private final Assignment cExitAssignment_13_0 = (Assignment)cAlternatives_13.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_13_0_0 = (RuleCall)cExitAssignment_13_0.eContents().get(0);
		private final Group cGroup_13_1 = (Group)cAlternatives_13.eContents().get(1);
		private final Assignment cExitAssignment_13_1_0 = (Assignment)cGroup_13_1.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_13_1_0_0 = (RuleCall)cExitAssignment_13_1_0.eContents().get(0);
		private final Assignment cOuterExitAssignment_13_1_1 = (Assignment)cGroup_13_1.eContents().get(1);
		private final RuleCall cOuterExitTracePointParserRuleCall_13_1_1_0 = (RuleCall)cOuterExitAssignment_13_1_1.eContents().get(0);
		
		//Move returns Move:
		//    {Move}
		//    name=ID ':'
		//    ((entry=TracePoint) | (outerEntry=TracePoint entry=TracePoint))?
		//    'move' resourceDefinition=[machine::Resource|ID]('.' resourceItem=[machine::ResourceItem|IID])? '.' peripheral=[machine::Peripheral|ID]
		//    (((passing?='passing'|'to') targetPosition=[machine::SymbolicPosition|ID])|
		//    ((continuing?='continuing'|'for') distance=[machine::Distance|ID]))
		//    ('with speed profile'  profile=[machine::Profile|ID] )
		//    (schedulingType=Scheduling)?
		//    (productChanges+=ProductChange (productChanges+=ProductChangeWithTransferType)* )?
		//    ((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
		//    ;
		@Override public ParserRule getRule() { return rule; }
		
		//{Move}
		//name=ID ':'
		//((entry=TracePoint) | (outerEntry=TracePoint entry=TracePoint))?
		//'move' resourceDefinition=[machine::Resource|ID]('.' resourceItem=[machine::ResourceItem|IID])? '.' peripheral=[machine::Peripheral|ID]
		//(((passing?='passing'|'to') targetPosition=[machine::SymbolicPosition|ID])|
		//((continuing?='continuing'|'for') distance=[machine::Distance|ID]))
		//('with speed profile'  profile=[machine::Profile|ID] )
		//(schedulingType=Scheduling)?
		//(productChanges+=ProductChange (productChanges+=ProductChangeWithTransferType)* )?
		//((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
		public Group getGroup() { return cGroup; }
		
		//{Move}
		public Action getMoveAction_0() { return cMoveAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//((entry=TracePoint) | (outerEntry=TracePoint entry=TracePoint))?
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//(entry=TracePoint)
		public Assignment getEntryAssignment_3_0() { return cEntryAssignment_3_0; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_0_0() { return cEntryTracePointParserRuleCall_3_0_0; }
		
		//(outerEntry=TracePoint entry=TracePoint)
		public Group getGroup_3_1() { return cGroup_3_1; }
		
		//outerEntry=TracePoint
		public Assignment getOuterEntryAssignment_3_1_0() { return cOuterEntryAssignment_3_1_0; }
		
		//TracePoint
		public RuleCall getOuterEntryTracePointParserRuleCall_3_1_0_0() { return cOuterEntryTracePointParserRuleCall_3_1_0_0; }
		
		//entry=TracePoint
		public Assignment getEntryAssignment_3_1_1() { return cEntryAssignment_3_1_1; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_1_1_0() { return cEntryTracePointParserRuleCall_3_1_1_0; }
		
		//'move'
		public Keyword getMoveKeyword_4() { return cMoveKeyword_4; }
		
		//resourceDefinition=[machine::Resource|ID]
		public Assignment getResourceDefinitionAssignment_5() { return cResourceDefinitionAssignment_5; }
		
		//[machine::Resource|ID]
		public CrossReference getResourceDefinitionResourceCrossReference_5_0() { return cResourceDefinitionResourceCrossReference_5_0; }
		
		//ID
		public RuleCall getResourceDefinitionResourceIDTerminalRuleCall_5_0_1() { return cResourceDefinitionResourceIDTerminalRuleCall_5_0_1; }
		
		//('.' resourceItem=[machine::ResourceItem|IID])?
		public Group getGroup_6() { return cGroup_6; }
		
		//'.'
		public Keyword getFullStopKeyword_6_0() { return cFullStopKeyword_6_0; }
		
		//resourceItem=[machine::ResourceItem|IID]
		public Assignment getResourceItemAssignment_6_1() { return cResourceItemAssignment_6_1; }
		
		//[machine::ResourceItem|IID]
		public CrossReference getResourceItemResourceItemCrossReference_6_1_0() { return cResourceItemResourceItemCrossReference_6_1_0; }
		
		//IID
		public RuleCall getResourceItemResourceItemIIDParserRuleCall_6_1_0_1() { return cResourceItemResourceItemIIDParserRuleCall_6_1_0_1; }
		
		//'.'
		public Keyword getFullStopKeyword_7() { return cFullStopKeyword_7; }
		
		//peripheral=[machine::Peripheral|ID]
		public Assignment getPeripheralAssignment_8() { return cPeripheralAssignment_8; }
		
		//[machine::Peripheral|ID]
		public CrossReference getPeripheralPeripheralCrossReference_8_0() { return cPeripheralPeripheralCrossReference_8_0; }
		
		//ID
		public RuleCall getPeripheralPeripheralIDTerminalRuleCall_8_0_1() { return cPeripheralPeripheralIDTerminalRuleCall_8_0_1; }
		
		//(((passing?='passing'|'to') targetPosition=[machine::SymbolicPosition|ID])|
		//((continuing?='continuing'|'for') distance=[machine::Distance|ID]))
		public Alternatives getAlternatives_9() { return cAlternatives_9; }
		
		//((passing?='passing'|'to') targetPosition=[machine::SymbolicPosition|ID])
		public Group getGroup_9_0() { return cGroup_9_0; }
		
		//(passing?='passing'|'to')
		public Alternatives getAlternatives_9_0_0() { return cAlternatives_9_0_0; }
		
		//passing?='passing'
		public Assignment getPassingAssignment_9_0_0_0() { return cPassingAssignment_9_0_0_0; }
		
		//'passing'
		public Keyword getPassingPassingKeyword_9_0_0_0_0() { return cPassingPassingKeyword_9_0_0_0_0; }
		
		//'to'
		public Keyword getToKeyword_9_0_0_1() { return cToKeyword_9_0_0_1; }
		
		//targetPosition=[machine::SymbolicPosition|ID]
		public Assignment getTargetPositionAssignment_9_0_1() { return cTargetPositionAssignment_9_0_1; }
		
		//[machine::SymbolicPosition|ID]
		public CrossReference getTargetPositionSymbolicPositionCrossReference_9_0_1_0() { return cTargetPositionSymbolicPositionCrossReference_9_0_1_0; }
		
		//ID
		public RuleCall getTargetPositionSymbolicPositionIDTerminalRuleCall_9_0_1_0_1() { return cTargetPositionSymbolicPositionIDTerminalRuleCall_9_0_1_0_1; }
		
		//((continuing?='continuing'|'for') distance=[machine::Distance|ID])
		public Group getGroup_9_1() { return cGroup_9_1; }
		
		//(continuing?='continuing'|'for')
		public Alternatives getAlternatives_9_1_0() { return cAlternatives_9_1_0; }
		
		//continuing?='continuing'
		public Assignment getContinuingAssignment_9_1_0_0() { return cContinuingAssignment_9_1_0_0; }
		
		//'continuing'
		public Keyword getContinuingContinuingKeyword_9_1_0_0_0() { return cContinuingContinuingKeyword_9_1_0_0_0; }
		
		//'for'
		public Keyword getForKeyword_9_1_0_1() { return cForKeyword_9_1_0_1; }
		
		//distance=[machine::Distance|ID]
		public Assignment getDistanceAssignment_9_1_1() { return cDistanceAssignment_9_1_1; }
		
		//[machine::Distance|ID]
		public CrossReference getDistanceDistanceCrossReference_9_1_1_0() { return cDistanceDistanceCrossReference_9_1_1_0; }
		
		//ID
		public RuleCall getDistanceDistanceIDTerminalRuleCall_9_1_1_0_1() { return cDistanceDistanceIDTerminalRuleCall_9_1_1_0_1; }
		
		//('with speed profile'  profile=[machine::Profile|ID] )
		public Group getGroup_10() { return cGroup_10; }
		
		//'with speed profile'
		public Keyword getWithSpeedProfileKeyword_10_0() { return cWithSpeedProfileKeyword_10_0; }
		
		//profile=[machine::Profile|ID]
		public Assignment getProfileAssignment_10_1() { return cProfileAssignment_10_1; }
		
		//[machine::Profile|ID]
		public CrossReference getProfileProfileCrossReference_10_1_0() { return cProfileProfileCrossReference_10_1_0; }
		
		//ID
		public RuleCall getProfileProfileIDTerminalRuleCall_10_1_0_1() { return cProfileProfileIDTerminalRuleCall_10_1_0_1; }
		
		//(schedulingType=Scheduling)?
		public Assignment getSchedulingTypeAssignment_11() { return cSchedulingTypeAssignment_11; }
		
		//Scheduling
		public RuleCall getSchedulingTypeSchedulingEnumRuleCall_11_0() { return cSchedulingTypeSchedulingEnumRuleCall_11_0; }
		
		//(productChanges+=ProductChange (productChanges+=ProductChangeWithTransferType)* )?
		public Group getGroup_12() { return cGroup_12; }
		
		//productChanges+=ProductChange
		public Assignment getProductChangesAssignment_12_0() { return cProductChangesAssignment_12_0; }
		
		//ProductChange
		public RuleCall getProductChangesProductChangeParserRuleCall_12_0_0() { return cProductChangesProductChangeParserRuleCall_12_0_0; }
		
		//(productChanges+=ProductChangeWithTransferType)*
		public Assignment getProductChangesAssignment_12_1() { return cProductChangesAssignment_12_1; }
		
		//ProductChangeWithTransferType
		public RuleCall getProductChangesProductChangeWithTransferTypeParserRuleCall_12_1_0() { return cProductChangesProductChangeWithTransferTypeParserRuleCall_12_1_0; }
		
		//((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
		public Alternatives getAlternatives_13() { return cAlternatives_13; }
		
		//(exit=TracePoint)
		public Assignment getExitAssignment_13_0() { return cExitAssignment_13_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_13_0_0() { return cExitTracePointParserRuleCall_13_0_0; }
		
		//(exit=TracePoint outerExit=TracePoint)
		public Group getGroup_13_1() { return cGroup_13_1; }
		
		//exit=TracePoint
		public Assignment getExitAssignment_13_1_0() { return cExitAssignment_13_1_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_13_1_0_0() { return cExitTracePointParserRuleCall_13_1_0_0; }
		
		//outerExit=TracePoint
		public Assignment getOuterExitAssignment_13_1_1() { return cOuterExitAssignment_13_1_1; }
		
		//TracePoint
		public RuleCall getOuterExitTracePointParserRuleCall_13_1_1_0() { return cOuterExitTracePointParserRuleCall_13_1_1_0; }
	}
	public class SimpleActionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.SimpleAction");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cSimpleActionAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cEntryAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cEntryTracePointParserRuleCall_3_0_0 = (RuleCall)cEntryAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cAlternatives_3.eContents().get(1);
		private final Assignment cOuterEntryAssignment_3_1_0 = (Assignment)cGroup_3_1.eContents().get(0);
		private final RuleCall cOuterEntryTracePointParserRuleCall_3_1_0_0 = (RuleCall)cOuterEntryAssignment_3_1_0.eContents().get(0);
		private final Assignment cEntryAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cEntryTracePointParserRuleCall_3_1_1_0 = (RuleCall)cEntryAssignment_3_1_1.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Assignment cResourceDefinitionAssignment_4_0 = (Assignment)cGroup_4.eContents().get(0);
		private final CrossReference cResourceDefinitionResourceCrossReference_4_0_0 = (CrossReference)cResourceDefinitionAssignment_4_0.eContents().get(0);
		private final RuleCall cResourceDefinitionResourceIDTerminalRuleCall_4_0_0_1 = (RuleCall)cResourceDefinitionResourceCrossReference_4_0_0.eContents().get(1);
		private final Keyword cFullStopKeyword_4_1 = (Keyword)cGroup_4.eContents().get(1);
		private final Group cGroup_4_2 = (Group)cGroup_4.eContents().get(2);
		private final Assignment cResourceItemAssignment_4_2_0 = (Assignment)cGroup_4_2.eContents().get(0);
		private final CrossReference cResourceItemResourceItemCrossReference_4_2_0_0 = (CrossReference)cResourceItemAssignment_4_2_0.eContents().get(0);
		private final RuleCall cResourceItemResourceItemIIDParserRuleCall_4_2_0_0_1 = (RuleCall)cResourceItemResourceItemCrossReference_4_2_0_0.eContents().get(1);
		private final Keyword cFullStopKeyword_4_2_1 = (Keyword)cGroup_4_2.eContents().get(1);
		private final Assignment cPeripheralAssignment_4_3 = (Assignment)cGroup_4.eContents().get(3);
		private final CrossReference cPeripheralPeripheralCrossReference_4_3_0 = (CrossReference)cPeripheralAssignment_4_3.eContents().get(0);
		private final RuleCall cPeripheralPeripheralIDTerminalRuleCall_4_3_0_1 = (RuleCall)cPeripheralPeripheralCrossReference_4_3_0.eContents().get(1);
		private final Keyword cFullStopKeyword_4_4 = (Keyword)cGroup_4.eContents().get(4);
		private final Assignment cTypeAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final CrossReference cTypeActionTypeCrossReference_5_0 = (CrossReference)cTypeAssignment_5.eContents().get(0);
		private final RuleCall cTypeActionTypeIDTerminalRuleCall_5_0_1 = (RuleCall)cTypeActionTypeCrossReference_5_0.eContents().get(1);
		private final Assignment cSchedulingTypeAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cSchedulingTypeSchedulingEnumRuleCall_6_0 = (RuleCall)cSchedulingTypeAssignment_6.eContents().get(0);
		private final Group cGroup_7 = (Group)cGroup.eContents().get(7);
		private final Assignment cProductChangesAssignment_7_0 = (Assignment)cGroup_7.eContents().get(0);
		private final RuleCall cProductChangesProductChangeParserRuleCall_7_0_0 = (RuleCall)cProductChangesAssignment_7_0.eContents().get(0);
		private final Assignment cProductChangesAssignment_7_1 = (Assignment)cGroup_7.eContents().get(1);
		private final RuleCall cProductChangesProductChangeWithTransferTypeParserRuleCall_7_1_0 = (RuleCall)cProductChangesAssignment_7_1.eContents().get(0);
		private final Alternatives cAlternatives_8 = (Alternatives)cGroup.eContents().get(8);
		private final Assignment cExitAssignment_8_0 = (Assignment)cAlternatives_8.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_8_0_0 = (RuleCall)cExitAssignment_8_0.eContents().get(0);
		private final Group cGroup_8_1 = (Group)cAlternatives_8.eContents().get(1);
		private final Assignment cExitAssignment_8_1_0 = (Assignment)cGroup_8_1.eContents().get(0);
		private final RuleCall cExitTracePointParserRuleCall_8_1_0_0 = (RuleCall)cExitAssignment_8_1_0.eContents().get(0);
		private final Assignment cOuterExitAssignment_8_1_1 = (Assignment)cGroup_8_1.eContents().get(1);
		private final RuleCall cOuterExitTracePointParserRuleCall_8_1_1_0 = (RuleCall)cOuterExitAssignment_8_1_1.eContents().get(0);
		
		///**
		// * The '=>' below helps the parser to first check peripheral and type before analysing Resource.
		// * see https://dslmeinte.wordpress.com/2011/12/05/using-syntactic-predicates-in-xtext-part-1/
		// * for more info.
		// */
		//SimpleAction returns SimpleAction:
		//    {SimpleAction}
		//    name=ID ':'
		//    ((entry=TracePoint)| (outerEntry=TracePoint entry=TracePoint))?
		//    (resourceDefinition=[machine::Resource|ID] '.' ( resourceItem=[machine::ResourceItem|IID] '.' )? peripheral=[machine::Peripheral|ID] '.') ? type=[machine::ActionType|ID]
		//    (schedulingType=Scheduling)?
		//    (productChanges+=ProductChange (productChanges+=ProductChangeWithTransferType)* )?
		//    ((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{SimpleAction}
		//name=ID ':'
		//((entry=TracePoint)| (outerEntry=TracePoint entry=TracePoint))?
		//(resourceDefinition=[machine::Resource|ID] '.' ( resourceItem=[machine::ResourceItem|IID] '.' )? peripheral=[machine::Peripheral|ID] '.') ? type=[machine::ActionType|ID]
		//(schedulingType=Scheduling)?
		//(productChanges+=ProductChange (productChanges+=ProductChangeWithTransferType)* )?
		//((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
		public Group getGroup() { return cGroup; }
		
		//{SimpleAction}
		public Action getSimpleActionAction_0() { return cSimpleActionAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//((entry=TracePoint)| (outerEntry=TracePoint entry=TracePoint))?
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//(entry=TracePoint)
		public Assignment getEntryAssignment_3_0() { return cEntryAssignment_3_0; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_0_0() { return cEntryTracePointParserRuleCall_3_0_0; }
		
		//(outerEntry=TracePoint entry=TracePoint)
		public Group getGroup_3_1() { return cGroup_3_1; }
		
		//outerEntry=TracePoint
		public Assignment getOuterEntryAssignment_3_1_0() { return cOuterEntryAssignment_3_1_0; }
		
		//TracePoint
		public RuleCall getOuterEntryTracePointParserRuleCall_3_1_0_0() { return cOuterEntryTracePointParserRuleCall_3_1_0_0; }
		
		//entry=TracePoint
		public Assignment getEntryAssignment_3_1_1() { return cEntryAssignment_3_1_1; }
		
		//TracePoint
		public RuleCall getEntryTracePointParserRuleCall_3_1_1_0() { return cEntryTracePointParserRuleCall_3_1_1_0; }
		
		//(resourceDefinition=[machine::Resource|ID] '.' ( resourceItem=[machine::ResourceItem|IID] '.' )? peripheral=[machine::Peripheral|ID] '.') ?
		public Group getGroup_4() { return cGroup_4; }
		
		//resourceDefinition=[machine::Resource|ID]
		public Assignment getResourceDefinitionAssignment_4_0() { return cResourceDefinitionAssignment_4_0; }
		
		//[machine::Resource|ID]
		public CrossReference getResourceDefinitionResourceCrossReference_4_0_0() { return cResourceDefinitionResourceCrossReference_4_0_0; }
		
		//ID
		public RuleCall getResourceDefinitionResourceIDTerminalRuleCall_4_0_0_1() { return cResourceDefinitionResourceIDTerminalRuleCall_4_0_0_1; }
		
		//'.'
		public Keyword getFullStopKeyword_4_1() { return cFullStopKeyword_4_1; }
		
		//( resourceItem=[machine::ResourceItem|IID] '.' )?
		public Group getGroup_4_2() { return cGroup_4_2; }
		
		//resourceItem=[machine::ResourceItem|IID]
		public Assignment getResourceItemAssignment_4_2_0() { return cResourceItemAssignment_4_2_0; }
		
		//[machine::ResourceItem|IID]
		public CrossReference getResourceItemResourceItemCrossReference_4_2_0_0() { return cResourceItemResourceItemCrossReference_4_2_0_0; }
		
		//IID
		public RuleCall getResourceItemResourceItemIIDParserRuleCall_4_2_0_0_1() { return cResourceItemResourceItemIIDParserRuleCall_4_2_0_0_1; }
		
		//'.'
		public Keyword getFullStopKeyword_4_2_1() { return cFullStopKeyword_4_2_1; }
		
		//peripheral=[machine::Peripheral|ID]
		public Assignment getPeripheralAssignment_4_3() { return cPeripheralAssignment_4_3; }
		
		//[machine::Peripheral|ID]
		public CrossReference getPeripheralPeripheralCrossReference_4_3_0() { return cPeripheralPeripheralCrossReference_4_3_0; }
		
		//ID
		public RuleCall getPeripheralPeripheralIDTerminalRuleCall_4_3_0_1() { return cPeripheralPeripheralIDTerminalRuleCall_4_3_0_1; }
		
		//'.'
		public Keyword getFullStopKeyword_4_4() { return cFullStopKeyword_4_4; }
		
		//type=[machine::ActionType|ID]
		public Assignment getTypeAssignment_5() { return cTypeAssignment_5; }
		
		//[machine::ActionType|ID]
		public CrossReference getTypeActionTypeCrossReference_5_0() { return cTypeActionTypeCrossReference_5_0; }
		
		//ID
		public RuleCall getTypeActionTypeIDTerminalRuleCall_5_0_1() { return cTypeActionTypeIDTerminalRuleCall_5_0_1; }
		
		//(schedulingType=Scheduling)?
		public Assignment getSchedulingTypeAssignment_6() { return cSchedulingTypeAssignment_6; }
		
		//Scheduling
		public RuleCall getSchedulingTypeSchedulingEnumRuleCall_6_0() { return cSchedulingTypeSchedulingEnumRuleCall_6_0; }
		
		//(productChanges+=ProductChange (productChanges+=ProductChangeWithTransferType)* )?
		public Group getGroup_7() { return cGroup_7; }
		
		//productChanges+=ProductChange
		public Assignment getProductChangesAssignment_7_0() { return cProductChangesAssignment_7_0; }
		
		//ProductChange
		public RuleCall getProductChangesProductChangeParserRuleCall_7_0_0() { return cProductChangesProductChangeParserRuleCall_7_0_0; }
		
		//(productChanges+=ProductChangeWithTransferType)*
		public Assignment getProductChangesAssignment_7_1() { return cProductChangesAssignment_7_1; }
		
		//ProductChangeWithTransferType
		public RuleCall getProductChangesProductChangeWithTransferTypeParserRuleCall_7_1_0() { return cProductChangesProductChangeWithTransferTypeParserRuleCall_7_1_0; }
		
		//((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
		public Alternatives getAlternatives_8() { return cAlternatives_8; }
		
		//(exit=TracePoint)
		public Assignment getExitAssignment_8_0() { return cExitAssignment_8_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_8_0_0() { return cExitTracePointParserRuleCall_8_0_0; }
		
		//(exit=TracePoint outerExit=TracePoint)
		public Group getGroup_8_1() { return cGroup_8_1; }
		
		//exit=TracePoint
		public Assignment getExitAssignment_8_1_0() { return cExitAssignment_8_1_0; }
		
		//TracePoint
		public RuleCall getExitTracePointParserRuleCall_8_1_0_0() { return cExitTracePointParserRuleCall_8_1_0_0; }
		
		//outerExit=TracePoint
		public Assignment getOuterExitAssignment_8_1_1() { return cOuterExitAssignment_8_1_1; }
		
		//TracePoint
		public RuleCall getOuterExitTracePointParserRuleCall_8_1_1_0() { return cOuterExitTracePointParserRuleCall_8_1_1_0; }
	}
	public class ProductChangeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ProductChange");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cProductChangeWithTransferTypeParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cProductChangeNoTransferTypeParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//ProductChange returns ProductChange:
		//    ProductChangeWithTransferType | ProductChangeNoTransferType
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//ProductChangeWithTransferType | ProductChangeNoTransferType
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ProductChangeWithTransferType
		public RuleCall getProductChangeWithTransferTypeParserRuleCall_0() { return cProductChangeWithTransferTypeParserRuleCall_0; }
		
		//ProductChangeNoTransferType
		public RuleCall getProductChangeNoTransferTypeParserRuleCall_1() { return cProductChangeNoTransferTypeParserRuleCall_1; }
	}
	public class ProductChangeNoTransferTypeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ProductChangeNoTransferType");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cProductChangeAction_0 = (Action)cGroup.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Group cGroup_1_0 = (Group)cAlternatives_1.eContents().get(0);
		private final Group cGroup_1_0_0 = (Group)cGroup_1_0.eContents().get(0);
		private final Keyword cProductKeyword_1_0_0_0 = (Keyword)cGroup_1_0_0.eContents().get(0);
		private final Assignment cProductAssignment_1_0_0_1 = (Assignment)cGroup_1_0_0.eContents().get(1);
		private final CrossReference cProductProductDefinitionCrossReference_1_0_0_1_0 = (CrossReference)cProductAssignment_1_0_0_1.eContents().get(0);
		private final RuleCall cProductProductDefinitionIDTerminalRuleCall_1_0_0_1_0_1 = (RuleCall)cProductProductDefinitionCrossReference_1_0_0_1_0.eContents().get(1);
		private final Group cGroup_1_0_1 = (Group)cGroup_1_0.eContents().get(1);
		private final Keyword cSlotKeyword_1_0_1_0 = (Keyword)cGroup_1_0_1.eContents().get(0);
		private final Assignment cSlotAssignment_1_0_1_1 = (Assignment)cGroup_1_0_1.eContents().get(1);
		private final RuleCall cSlotIIDParserRuleCall_1_0_1_1_0 = (RuleCall)cSlotAssignment_1_0_1_1.eContents().get(0);
		private final Group cGroup_1_0_2 = (Group)cGroup_1_0.eContents().get(2);
		private final Keyword cStartKeyword_1_0_2_0 = (Keyword)cGroup_1_0_2.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1_0_2_1 = (Keyword)cGroup_1_0_2.eContents().get(1);
		private final Assignment cStartPropertiesAssignment_1_0_2_2 = (Assignment)cGroup_1_0_2.eContents().get(2);
		private final RuleCall cStartPropertiesPropertyParserRuleCall_1_0_2_2_0 = (RuleCall)cStartPropertiesAssignment_1_0_2_2.eContents().get(0);
		private final Group cGroup_1_0_2_3 = (Group)cGroup_1_0_2.eContents().get(3);
		private final Keyword cCommaKeyword_1_0_2_3_0 = (Keyword)cGroup_1_0_2_3.eContents().get(0);
		private final Assignment cStartPropertiesAssignment_1_0_2_3_1 = (Assignment)cGroup_1_0_2_3.eContents().get(1);
		private final RuleCall cStartPropertiesPropertyParserRuleCall_1_0_2_3_1_0 = (RuleCall)cStartPropertiesAssignment_1_0_2_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_1_0_2_4 = (Keyword)cGroup_1_0_2.eContents().get(4);
		private final Group cGroup_1_0_3 = (Group)cGroup_1_0.eContents().get(3);
		private final Keyword cEndKeyword_1_0_3_0 = (Keyword)cGroup_1_0_3.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1_0_3_1 = (Keyword)cGroup_1_0_3.eContents().get(1);
		private final Assignment cEndPropertiesAssignment_1_0_3_2 = (Assignment)cGroup_1_0_3.eContents().get(2);
		private final RuleCall cEndPropertiesPropertyParserRuleCall_1_0_3_2_0 = (RuleCall)cEndPropertiesAssignment_1_0_3_2.eContents().get(0);
		private final Group cGroup_1_0_3_3 = (Group)cGroup_1_0_3.eContents().get(3);
		private final Keyword cCommaKeyword_1_0_3_3_0 = (Keyword)cGroup_1_0_3_3.eContents().get(0);
		private final Assignment cEndPropertiesAssignment_1_0_3_3_1 = (Assignment)cGroup_1_0_3_3.eContents().get(1);
		private final RuleCall cEndPropertiesPropertyParserRuleCall_1_0_3_3_1_0 = (RuleCall)cEndPropertiesAssignment_1_0_3_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_1_0_3_4 = (Keyword)cGroup_1_0_3.eContents().get(4);
		private final Group cGroup_1_1 = (Group)cAlternatives_1.eContents().get(1);
		private final Group cGroup_1_1_0 = (Group)cGroup_1_1.eContents().get(0);
		private final Keyword cSlotKeyword_1_1_0_0 = (Keyword)cGroup_1_1_0.eContents().get(0);
		private final Assignment cSlotAssignment_1_1_0_1 = (Assignment)cGroup_1_1_0.eContents().get(1);
		private final RuleCall cSlotIIDParserRuleCall_1_1_0_1_0 = (RuleCall)cSlotAssignment_1_1_0_1.eContents().get(0);
		private final Group cGroup_1_1_1 = (Group)cGroup_1_1.eContents().get(1);
		private final Keyword cStartKeyword_1_1_1_0 = (Keyword)cGroup_1_1_1.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1_1_1_1 = (Keyword)cGroup_1_1_1.eContents().get(1);
		private final Assignment cStartPropertiesAssignment_1_1_1_2 = (Assignment)cGroup_1_1_1.eContents().get(2);
		private final RuleCall cStartPropertiesPropertyParserRuleCall_1_1_1_2_0 = (RuleCall)cStartPropertiesAssignment_1_1_1_2.eContents().get(0);
		private final Group cGroup_1_1_1_3 = (Group)cGroup_1_1_1.eContents().get(3);
		private final Keyword cCommaKeyword_1_1_1_3_0 = (Keyword)cGroup_1_1_1_3.eContents().get(0);
		private final Assignment cStartPropertiesAssignment_1_1_1_3_1 = (Assignment)cGroup_1_1_1_3.eContents().get(1);
		private final RuleCall cStartPropertiesPropertyParserRuleCall_1_1_1_3_1_0 = (RuleCall)cStartPropertiesAssignment_1_1_1_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_1_1_1_4 = (Keyword)cGroup_1_1_1.eContents().get(4);
		private final Group cGroup_1_1_2 = (Group)cGroup_1_1.eContents().get(2);
		private final Keyword cEndKeyword_1_1_2_0 = (Keyword)cGroup_1_1_2.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1_1_2_1 = (Keyword)cGroup_1_1_2.eContents().get(1);
		private final Assignment cEndPropertiesAssignment_1_1_2_2 = (Assignment)cGroup_1_1_2.eContents().get(2);
		private final RuleCall cEndPropertiesPropertyParserRuleCall_1_1_2_2_0 = (RuleCall)cEndPropertiesAssignment_1_1_2_2.eContents().get(0);
		private final Group cGroup_1_1_2_3 = (Group)cGroup_1_1_2.eContents().get(3);
		private final Keyword cCommaKeyword_1_1_2_3_0 = (Keyword)cGroup_1_1_2_3.eContents().get(0);
		private final Assignment cEndPropertiesAssignment_1_1_2_3_1 = (Assignment)cGroup_1_1_2_3.eContents().get(1);
		private final RuleCall cEndPropertiesPropertyParserRuleCall_1_1_2_3_1_0 = (RuleCall)cEndPropertiesAssignment_1_1_2_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_1_1_2_4 = (Keyword)cGroup_1_1_2.eContents().get(4);
		private final Group cGroup_1_2 = (Group)cAlternatives_1.eContents().get(2);
		private final Group cGroup_1_2_0 = (Group)cGroup_1_2.eContents().get(0);
		private final Keyword cStartKeyword_1_2_0_0 = (Keyword)cGroup_1_2_0.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1_2_0_1 = (Keyword)cGroup_1_2_0.eContents().get(1);
		private final Assignment cStartPropertiesAssignment_1_2_0_2 = (Assignment)cGroup_1_2_0.eContents().get(2);
		private final RuleCall cStartPropertiesPropertyParserRuleCall_1_2_0_2_0 = (RuleCall)cStartPropertiesAssignment_1_2_0_2.eContents().get(0);
		private final Group cGroup_1_2_0_3 = (Group)cGroup_1_2_0.eContents().get(3);
		private final Keyword cCommaKeyword_1_2_0_3_0 = (Keyword)cGroup_1_2_0_3.eContents().get(0);
		private final Assignment cStartPropertiesAssignment_1_2_0_3_1 = (Assignment)cGroup_1_2_0_3.eContents().get(1);
		private final RuleCall cStartPropertiesPropertyParserRuleCall_1_2_0_3_1_0 = (RuleCall)cStartPropertiesAssignment_1_2_0_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_1_2_0_4 = (Keyword)cGroup_1_2_0.eContents().get(4);
		private final Group cGroup_1_2_1 = (Group)cGroup_1_2.eContents().get(1);
		private final Keyword cEndKeyword_1_2_1_0 = (Keyword)cGroup_1_2_1.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1_2_1_1 = (Keyword)cGroup_1_2_1.eContents().get(1);
		private final Assignment cEndPropertiesAssignment_1_2_1_2 = (Assignment)cGroup_1_2_1.eContents().get(2);
		private final RuleCall cEndPropertiesPropertyParserRuleCall_1_2_1_2_0 = (RuleCall)cEndPropertiesAssignment_1_2_1_2.eContents().get(0);
		private final Group cGroup_1_2_1_3 = (Group)cGroup_1_2_1.eContents().get(3);
		private final Keyword cCommaKeyword_1_2_1_3_0 = (Keyword)cGroup_1_2_1_3.eContents().get(0);
		private final Assignment cEndPropertiesAssignment_1_2_1_3_1 = (Assignment)cGroup_1_2_1_3.eContents().get(1);
		private final RuleCall cEndPropertiesPropertyParserRuleCall_1_2_1_3_1_0 = (RuleCall)cEndPropertiesAssignment_1_2_1_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_1_2_1_4 = (Keyword)cGroup_1_2_1.eContents().get(4);
		private final Group cGroup_1_3 = (Group)cAlternatives_1.eContents().get(3);
		private final Keyword cEndKeyword_1_3_0 = (Keyword)cGroup_1_3.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1_3_1 = (Keyword)cGroup_1_3.eContents().get(1);
		private final Assignment cEndPropertiesAssignment_1_3_2 = (Assignment)cGroup_1_3.eContents().get(2);
		private final RuleCall cEndPropertiesPropertyParserRuleCall_1_3_2_0 = (RuleCall)cEndPropertiesAssignment_1_3_2.eContents().get(0);
		private final Group cGroup_1_3_3 = (Group)cGroup_1_3.eContents().get(3);
		private final Keyword cCommaKeyword_1_3_3_0 = (Keyword)cGroup_1_3_3.eContents().get(0);
		private final Assignment cEndPropertiesAssignment_1_3_3_1 = (Assignment)cGroup_1_3_3.eContents().get(1);
		private final RuleCall cEndPropertiesPropertyParserRuleCall_1_3_3_1_0 = (RuleCall)cEndPropertiesAssignment_1_3_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_1_3_4 = (Keyword)cGroup_1_3.eContents().get(4);
		
		//ProductChangeNoTransferType returns ProductChange:
		//    {ProductChange}
		//    (
		//        (
		//            ( 'product' product=[product::ProductDefinition|ID])
		//            (('slot')?  slot=IID)?
		//            ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		//            ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//        ) |
		//        (
		//            (('slot')?  slot=IID)
		//            ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		//            ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//        ) |
		//        (
		//            ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')
		//            ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//        ) |
		//        (
		//            ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')
		//        )
		//    )
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{ProductChange}
		//(
		//    (
		//        ( 'product' product=[product::ProductDefinition|ID])
		//        (('slot')?  slot=IID)?
		//        ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		//        ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//    ) |
		//    (
		//        (('slot')?  slot=IID)
		//        ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		//        ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//    ) |
		//    (
		//        ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')
		//        ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//    ) |
		//    (
		//        ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')
		//    )
		//)
		public Group getGroup() { return cGroup; }
		
		//{ProductChange}
		public Action getProductChangeAction_0() { return cProductChangeAction_0; }
		
		//(
		//    (
		//        ( 'product' product=[product::ProductDefinition|ID])
		//        (('slot')?  slot=IID)?
		//        ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		//        ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//    ) |
		//    (
		//        (('slot')?  slot=IID)
		//        ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		//        ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//    ) |
		//    (
		//        ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')
		//        ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//    ) |
		//    (
		//        ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')
		//    )
		//)
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//(
		//    ( 'product' product=[product::ProductDefinition|ID])
		//    (('slot')?  slot=IID)?
		//    ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		//    ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//)
		public Group getGroup_1_0() { return cGroup_1_0; }
		
		//( 'product' product=[product::ProductDefinition|ID])
		public Group getGroup_1_0_0() { return cGroup_1_0_0; }
		
		//'product'
		public Keyword getProductKeyword_1_0_0_0() { return cProductKeyword_1_0_0_0; }
		
		//product=[product::ProductDefinition|ID]
		public Assignment getProductAssignment_1_0_0_1() { return cProductAssignment_1_0_0_1; }
		
		//[product::ProductDefinition|ID]
		public CrossReference getProductProductDefinitionCrossReference_1_0_0_1_0() { return cProductProductDefinitionCrossReference_1_0_0_1_0; }
		
		//ID
		public RuleCall getProductProductDefinitionIDTerminalRuleCall_1_0_0_1_0_1() { return cProductProductDefinitionIDTerminalRuleCall_1_0_0_1_0_1; }
		
		//(('slot')?  slot=IID)?
		public Group getGroup_1_0_1() { return cGroup_1_0_1; }
		
		//('slot')?
		public Keyword getSlotKeyword_1_0_1_0() { return cSlotKeyword_1_0_1_0; }
		
		//slot=IID
		public Assignment getSlotAssignment_1_0_1_1() { return cSlotAssignment_1_0_1_1; }
		
		//IID
		public RuleCall getSlotIIDParserRuleCall_1_0_1_1_0() { return cSlotIIDParserRuleCall_1_0_1_1_0; }
		
		//('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		public Group getGroup_1_0_2() { return cGroup_1_0_2; }
		
		//'@start'
		public Keyword getStartKeyword_1_0_2_0() { return cStartKeyword_1_0_2_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1_0_2_1() { return cLeftParenthesisKeyword_1_0_2_1; }
		
		//startProperties+=Property
		public Assignment getStartPropertiesAssignment_1_0_2_2() { return cStartPropertiesAssignment_1_0_2_2; }
		
		//Property
		public RuleCall getStartPropertiesPropertyParserRuleCall_1_0_2_2_0() { return cStartPropertiesPropertyParserRuleCall_1_0_2_2_0; }
		
		//(',' startProperties+=Property)*
		public Group getGroup_1_0_2_3() { return cGroup_1_0_2_3; }
		
		//','
		public Keyword getCommaKeyword_1_0_2_3_0() { return cCommaKeyword_1_0_2_3_0; }
		
		//startProperties+=Property
		public Assignment getStartPropertiesAssignment_1_0_2_3_1() { return cStartPropertiesAssignment_1_0_2_3_1; }
		
		//Property
		public RuleCall getStartPropertiesPropertyParserRuleCall_1_0_2_3_1_0() { return cStartPropertiesPropertyParserRuleCall_1_0_2_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_1_0_2_4() { return cRightParenthesisKeyword_1_0_2_4; }
		
		//('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		public Group getGroup_1_0_3() { return cGroup_1_0_3; }
		
		//'@end'
		public Keyword getEndKeyword_1_0_3_0() { return cEndKeyword_1_0_3_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1_0_3_1() { return cLeftParenthesisKeyword_1_0_3_1; }
		
		//endProperties+=Property
		public Assignment getEndPropertiesAssignment_1_0_3_2() { return cEndPropertiesAssignment_1_0_3_2; }
		
		//Property
		public RuleCall getEndPropertiesPropertyParserRuleCall_1_0_3_2_0() { return cEndPropertiesPropertyParserRuleCall_1_0_3_2_0; }
		
		//(',' endProperties+=Property)*
		public Group getGroup_1_0_3_3() { return cGroup_1_0_3_3; }
		
		//','
		public Keyword getCommaKeyword_1_0_3_3_0() { return cCommaKeyword_1_0_3_3_0; }
		
		//endProperties+=Property
		public Assignment getEndPropertiesAssignment_1_0_3_3_1() { return cEndPropertiesAssignment_1_0_3_3_1; }
		
		//Property
		public RuleCall getEndPropertiesPropertyParserRuleCall_1_0_3_3_1_0() { return cEndPropertiesPropertyParserRuleCall_1_0_3_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_1_0_3_4() { return cRightParenthesisKeyword_1_0_3_4; }
		
		//(
		//    (('slot')?  slot=IID)
		//    ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		//    ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//)
		public Group getGroup_1_1() { return cGroup_1_1; }
		
		//(('slot')?  slot=IID)
		public Group getGroup_1_1_0() { return cGroup_1_1_0; }
		
		//('slot')?
		public Keyword getSlotKeyword_1_1_0_0() { return cSlotKeyword_1_1_0_0; }
		
		//slot=IID
		public Assignment getSlotAssignment_1_1_0_1() { return cSlotAssignment_1_1_0_1; }
		
		//IID
		public RuleCall getSlotIIDParserRuleCall_1_1_0_1_0() { return cSlotIIDParserRuleCall_1_1_0_1_0; }
		
		//('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		public Group getGroup_1_1_1() { return cGroup_1_1_1; }
		
		//'@start'
		public Keyword getStartKeyword_1_1_1_0() { return cStartKeyword_1_1_1_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1_1_1_1() { return cLeftParenthesisKeyword_1_1_1_1; }
		
		//startProperties+=Property
		public Assignment getStartPropertiesAssignment_1_1_1_2() { return cStartPropertiesAssignment_1_1_1_2; }
		
		//Property
		public RuleCall getStartPropertiesPropertyParserRuleCall_1_1_1_2_0() { return cStartPropertiesPropertyParserRuleCall_1_1_1_2_0; }
		
		//(',' startProperties+=Property)*
		public Group getGroup_1_1_1_3() { return cGroup_1_1_1_3; }
		
		//','
		public Keyword getCommaKeyword_1_1_1_3_0() { return cCommaKeyword_1_1_1_3_0; }
		
		//startProperties+=Property
		public Assignment getStartPropertiesAssignment_1_1_1_3_1() { return cStartPropertiesAssignment_1_1_1_3_1; }
		
		//Property
		public RuleCall getStartPropertiesPropertyParserRuleCall_1_1_1_3_1_0() { return cStartPropertiesPropertyParserRuleCall_1_1_1_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_1_1_1_4() { return cRightParenthesisKeyword_1_1_1_4; }
		
		//('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		public Group getGroup_1_1_2() { return cGroup_1_1_2; }
		
		//'@end'
		public Keyword getEndKeyword_1_1_2_0() { return cEndKeyword_1_1_2_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1_1_2_1() { return cLeftParenthesisKeyword_1_1_2_1; }
		
		//endProperties+=Property
		public Assignment getEndPropertiesAssignment_1_1_2_2() { return cEndPropertiesAssignment_1_1_2_2; }
		
		//Property
		public RuleCall getEndPropertiesPropertyParserRuleCall_1_1_2_2_0() { return cEndPropertiesPropertyParserRuleCall_1_1_2_2_0; }
		
		//(',' endProperties+=Property)*
		public Group getGroup_1_1_2_3() { return cGroup_1_1_2_3; }
		
		//','
		public Keyword getCommaKeyword_1_1_2_3_0() { return cCommaKeyword_1_1_2_3_0; }
		
		//endProperties+=Property
		public Assignment getEndPropertiesAssignment_1_1_2_3_1() { return cEndPropertiesAssignment_1_1_2_3_1; }
		
		//Property
		public RuleCall getEndPropertiesPropertyParserRuleCall_1_1_2_3_1_0() { return cEndPropertiesPropertyParserRuleCall_1_1_2_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_1_1_2_4() { return cRightParenthesisKeyword_1_1_2_4; }
		
		//(
		//    ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')
		//    ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//)
		public Group getGroup_1_2() { return cGroup_1_2; }
		
		//('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')
		public Group getGroup_1_2_0() { return cGroup_1_2_0; }
		
		//'@start'
		public Keyword getStartKeyword_1_2_0_0() { return cStartKeyword_1_2_0_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1_2_0_1() { return cLeftParenthesisKeyword_1_2_0_1; }
		
		//startProperties+=Property
		public Assignment getStartPropertiesAssignment_1_2_0_2() { return cStartPropertiesAssignment_1_2_0_2; }
		
		//Property
		public RuleCall getStartPropertiesPropertyParserRuleCall_1_2_0_2_0() { return cStartPropertiesPropertyParserRuleCall_1_2_0_2_0; }
		
		//(',' startProperties+=Property)*
		public Group getGroup_1_2_0_3() { return cGroup_1_2_0_3; }
		
		//','
		public Keyword getCommaKeyword_1_2_0_3_0() { return cCommaKeyword_1_2_0_3_0; }
		
		//startProperties+=Property
		public Assignment getStartPropertiesAssignment_1_2_0_3_1() { return cStartPropertiesAssignment_1_2_0_3_1; }
		
		//Property
		public RuleCall getStartPropertiesPropertyParserRuleCall_1_2_0_3_1_0() { return cStartPropertiesPropertyParserRuleCall_1_2_0_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_1_2_0_4() { return cRightParenthesisKeyword_1_2_0_4; }
		
		//('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		public Group getGroup_1_2_1() { return cGroup_1_2_1; }
		
		//'@end'
		public Keyword getEndKeyword_1_2_1_0() { return cEndKeyword_1_2_1_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1_2_1_1() { return cLeftParenthesisKeyword_1_2_1_1; }
		
		//endProperties+=Property
		public Assignment getEndPropertiesAssignment_1_2_1_2() { return cEndPropertiesAssignment_1_2_1_2; }
		
		//Property
		public RuleCall getEndPropertiesPropertyParserRuleCall_1_2_1_2_0() { return cEndPropertiesPropertyParserRuleCall_1_2_1_2_0; }
		
		//(',' endProperties+=Property)*
		public Group getGroup_1_2_1_3() { return cGroup_1_2_1_3; }
		
		//','
		public Keyword getCommaKeyword_1_2_1_3_0() { return cCommaKeyword_1_2_1_3_0; }
		
		//endProperties+=Property
		public Assignment getEndPropertiesAssignment_1_2_1_3_1() { return cEndPropertiesAssignment_1_2_1_3_1; }
		
		//Property
		public RuleCall getEndPropertiesPropertyParserRuleCall_1_2_1_3_1_0() { return cEndPropertiesPropertyParserRuleCall_1_2_1_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_1_2_1_4() { return cRightParenthesisKeyword_1_2_1_4; }
		
		//(
		//    ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')
		//)
		public Group getGroup_1_3() { return cGroup_1_3; }
		
		//'@end'
		public Keyword getEndKeyword_1_3_0() { return cEndKeyword_1_3_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1_3_1() { return cLeftParenthesisKeyword_1_3_1; }
		
		//endProperties+=Property
		public Assignment getEndPropertiesAssignment_1_3_2() { return cEndPropertiesAssignment_1_3_2; }
		
		//Property
		public RuleCall getEndPropertiesPropertyParserRuleCall_1_3_2_0() { return cEndPropertiesPropertyParserRuleCall_1_3_2_0; }
		
		//(',' endProperties+=Property)*
		public Group getGroup_1_3_3() { return cGroup_1_3_3; }
		
		//','
		public Keyword getCommaKeyword_1_3_3_0() { return cCommaKeyword_1_3_3_0; }
		
		//endProperties+=Property
		public Assignment getEndPropertiesAssignment_1_3_3_1() { return cEndPropertiesAssignment_1_3_3_1; }
		
		//Property
		public RuleCall getEndPropertiesPropertyParserRuleCall_1_3_3_1_0() { return cEndPropertiesPropertyParserRuleCall_1_3_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_1_3_4() { return cRightParenthesisKeyword_1_3_4; }
	}
	public class ProductChangeWithTransferTypeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.ProductChangeWithTransferType");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cProductChangeAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cTransferTypeAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cTransferTypeTransferTypeEnumRuleCall_1_0 = (RuleCall)cTransferTypeAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cProductKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cProductAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final CrossReference cProductProductDefinitionCrossReference_2_1_0 = (CrossReference)cProductAssignment_2_1.eContents().get(0);
		private final RuleCall cProductProductDefinitionIDTerminalRuleCall_2_1_0_1 = (RuleCall)cProductProductDefinitionCrossReference_2_1_0.eContents().get(1);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cSlotKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cSlotAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cSlotIIDParserRuleCall_3_1_0 = (RuleCall)cSlotAssignment_3_1.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cStartKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_4_1 = (Keyword)cGroup_4.eContents().get(1);
		private final Assignment cStartPropertiesAssignment_4_2 = (Assignment)cGroup_4.eContents().get(2);
		private final RuleCall cStartPropertiesPropertyParserRuleCall_4_2_0 = (RuleCall)cStartPropertiesAssignment_4_2.eContents().get(0);
		private final Group cGroup_4_3 = (Group)cGroup_4.eContents().get(3);
		private final Keyword cCommaKeyword_4_3_0 = (Keyword)cGroup_4_3.eContents().get(0);
		private final Assignment cStartPropertiesAssignment_4_3_1 = (Assignment)cGroup_4_3.eContents().get(1);
		private final RuleCall cStartPropertiesPropertyParserRuleCall_4_3_1_0 = (RuleCall)cStartPropertiesAssignment_4_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_4_4 = (Keyword)cGroup_4.eContents().get(4);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cEndKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_5_1 = (Keyword)cGroup_5.eContents().get(1);
		private final Assignment cEndPropertiesAssignment_5_2 = (Assignment)cGroup_5.eContents().get(2);
		private final RuleCall cEndPropertiesPropertyParserRuleCall_5_2_0 = (RuleCall)cEndPropertiesAssignment_5_2.eContents().get(0);
		private final Group cGroup_5_3 = (Group)cGroup_5.eContents().get(3);
		private final Keyword cCommaKeyword_5_3_0 = (Keyword)cGroup_5_3.eContents().get(0);
		private final Assignment cEndPropertiesAssignment_5_3_1 = (Assignment)cGroup_5_3.eContents().get(1);
		private final RuleCall cEndPropertiesPropertyParserRuleCall_5_3_1_0 = (RuleCall)cEndPropertiesAssignment_5_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_5_4 = (Keyword)cGroup_5.eContents().get(4);
		
		//ProductChangeWithTransferType returns ProductChange:
		//    {ProductChange}
		//    (transferType = TransferType)
		//    ( 'product' product=[product::ProductDefinition|ID])?
		//    (('slot')? slot=IID)?
		//    ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		//    ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{ProductChange}
		//(transferType = TransferType)
		//( 'product' product=[product::ProductDefinition|ID])?
		//(('slot')? slot=IID)?
		//('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		//('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		public Group getGroup() { return cGroup; }
		
		//{ProductChange}
		public Action getProductChangeAction_0() { return cProductChangeAction_0; }
		
		//(transferType = TransferType)
		public Assignment getTransferTypeAssignment_1() { return cTransferTypeAssignment_1; }
		
		//TransferType
		public RuleCall getTransferTypeTransferTypeEnumRuleCall_1_0() { return cTransferTypeTransferTypeEnumRuleCall_1_0; }
		
		//( 'product' product=[product::ProductDefinition|ID])?
		public Group getGroup_2() { return cGroup_2; }
		
		//'product'
		public Keyword getProductKeyword_2_0() { return cProductKeyword_2_0; }
		
		//product=[product::ProductDefinition|ID]
		public Assignment getProductAssignment_2_1() { return cProductAssignment_2_1; }
		
		//[product::ProductDefinition|ID]
		public CrossReference getProductProductDefinitionCrossReference_2_1_0() { return cProductProductDefinitionCrossReference_2_1_0; }
		
		//ID
		public RuleCall getProductProductDefinitionIDTerminalRuleCall_2_1_0_1() { return cProductProductDefinitionIDTerminalRuleCall_2_1_0_1; }
		
		//(('slot')? slot=IID)?
		public Group getGroup_3() { return cGroup_3; }
		
		//('slot')?
		public Keyword getSlotKeyword_3_0() { return cSlotKeyword_3_0; }
		
		//slot=IID
		public Assignment getSlotAssignment_3_1() { return cSlotAssignment_3_1; }
		
		//IID
		public RuleCall getSlotIIDParserRuleCall_3_1_0() { return cSlotIIDParserRuleCall_3_1_0; }
		
		//('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
		public Group getGroup_4() { return cGroup_4; }
		
		//'@start'
		public Keyword getStartKeyword_4_0() { return cStartKeyword_4_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_4_1() { return cLeftParenthesisKeyword_4_1; }
		
		//startProperties+=Property
		public Assignment getStartPropertiesAssignment_4_2() { return cStartPropertiesAssignment_4_2; }
		
		//Property
		public RuleCall getStartPropertiesPropertyParserRuleCall_4_2_0() { return cStartPropertiesPropertyParserRuleCall_4_2_0; }
		
		//(',' startProperties+=Property)*
		public Group getGroup_4_3() { return cGroup_4_3; }
		
		//','
		public Keyword getCommaKeyword_4_3_0() { return cCommaKeyword_4_3_0; }
		
		//startProperties+=Property
		public Assignment getStartPropertiesAssignment_4_3_1() { return cStartPropertiesAssignment_4_3_1; }
		
		//Property
		public RuleCall getStartPropertiesPropertyParserRuleCall_4_3_1_0() { return cStartPropertiesPropertyParserRuleCall_4_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_4_4() { return cRightParenthesisKeyword_4_4; }
		
		//('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
		public Group getGroup_5() { return cGroup_5; }
		
		//'@end'
		public Keyword getEndKeyword_5_0() { return cEndKeyword_5_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_5_1() { return cLeftParenthesisKeyword_5_1; }
		
		//endProperties+=Property
		public Assignment getEndPropertiesAssignment_5_2() { return cEndPropertiesAssignment_5_2; }
		
		//Property
		public RuleCall getEndPropertiesPropertyParserRuleCall_5_2_0() { return cEndPropertiesPropertyParserRuleCall_5_2_0; }
		
		//(',' endProperties+=Property)*
		public Group getGroup_5_3() { return cGroup_5_3; }
		
		//','
		public Keyword getCommaKeyword_5_3_0() { return cCommaKeyword_5_3_0; }
		
		//endProperties+=Property
		public Assignment getEndPropertiesAssignment_5_3_1() { return cEndPropertiesAssignment_5_3_1; }
		
		//Property
		public RuleCall getEndPropertiesPropertyParserRuleCall_5_3_1_0() { return cEndPropertiesPropertyParserRuleCall_5_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_5_4() { return cRightParenthesisKeyword_5_4; }
	}
	public class PropertyElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Property");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cPropertyAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cDefinitionAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cDefinitionPropertyDefinitionCrossReference_1_0 = (CrossReference)cDefinitionAssignment_1.eContents().get(0);
		private final RuleCall cDefinitionPropertyDefinitionIDTerminalRuleCall_1_0_1 = (RuleCall)cDefinitionPropertyDefinitionCrossReference_1_0.eContents().get(1);
		private final Keyword cColonKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cValueAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final Alternatives cValueAlternatives_3_0 = (Alternatives)cValueAssignment_3.eContents().get(0);
		private final RuleCall cValueBooleanValueParserRuleCall_3_0_0 = (RuleCall)cValueAlternatives_3_0.eContents().get(0);
		private final RuleCall cValueIntegerValueParserRuleCall_3_0_1 = (RuleCall)cValueAlternatives_3_0.eContents().get(1);
		private final RuleCall cValueStringValueParserRuleCall_3_0_2 = (RuleCall)cValueAlternatives_3_0.eContents().get(2);
		
		//Property returns product::Property:
		//    {product::Property}
		//    definition=[product::PropertyDefinition|ID] ':' value=(BooleanValue | IntegerValue | StringValue)
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{product::Property}
		//definition=[product::PropertyDefinition|ID] ':' value=(BooleanValue | IntegerValue | StringValue)
		public Group getGroup() { return cGroup; }
		
		//{product::Property}
		public Action getPropertyAction_0() { return cPropertyAction_0; }
		
		//definition=[product::PropertyDefinition|ID]
		public Assignment getDefinitionAssignment_1() { return cDefinitionAssignment_1; }
		
		//[product::PropertyDefinition|ID]
		public CrossReference getDefinitionPropertyDefinitionCrossReference_1_0() { return cDefinitionPropertyDefinitionCrossReference_1_0; }
		
		//ID
		public RuleCall getDefinitionPropertyDefinitionIDTerminalRuleCall_1_0_1() { return cDefinitionPropertyDefinitionIDTerminalRuleCall_1_0_1; }
		
		//':'
		public Keyword getColonKeyword_2() { return cColonKeyword_2; }
		
		//value=(BooleanValue | IntegerValue | StringValue)
		public Assignment getValueAssignment_3() { return cValueAssignment_3; }
		
		//(BooleanValue | IntegerValue | StringValue)
		public Alternatives getValueAlternatives_3_0() { return cValueAlternatives_3_0; }
		
		//BooleanValue
		public RuleCall getValueBooleanValueParserRuleCall_3_0_0() { return cValueBooleanValueParserRuleCall_3_0_0; }
		
		//IntegerValue
		public RuleCall getValueIntegerValueParserRuleCall_3_0_1() { return cValueIntegerValueParserRuleCall_3_0_1; }
		
		//StringValue
		public RuleCall getValueStringValueParserRuleCall_3_0_2() { return cValueStringValueParserRuleCall_3_0_2; }
	}
	public class BooleanValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.BooleanValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cBooleanValueAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cValueAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cValueBooleanLiteralParserRuleCall_1_0 = (RuleCall)cValueAssignment_1.eContents().get(0);
		
		//BooleanValue returns product::BooleanValue:
		//    {product::BooleanValue}
		//    value=  BooleanLiteral
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{product::BooleanValue}
		//value=  BooleanLiteral
		public Group getGroup() { return cGroup; }
		
		//{product::BooleanValue}
		public Action getBooleanValueAction_0() { return cBooleanValueAction_0; }
		
		//value=  BooleanLiteral
		public Assignment getValueAssignment_1() { return cValueAssignment_1; }
		
		//BooleanLiteral
		public RuleCall getValueBooleanLiteralParserRuleCall_1_0() { return cValueBooleanLiteralParserRuleCall_1_0; }
	}
	public class BooleanLiteralElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.BooleanLiteral");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Keyword cTrueKeyword_0 = (Keyword)cAlternatives.eContents().get(0);
		private final Keyword cFalseKeyword_1 = (Keyword)cAlternatives.eContents().get(1);
		
		//BooleanLiteral returns ecore::EBooleanObject:
		//    'True' | 'False';
		@Override public ParserRule getRule() { return rule; }
		
		//'True' | 'False'
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//'True'
		public Keyword getTrueKeyword_0() { return cTrueKeyword_0; }
		
		//'False'
		public Keyword getFalseKeyword_1() { return cFalseKeyword_1; }
	}
	public class IntegerValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.IntegerValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cIntegerValueAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cValueAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cValueINTTerminalRuleCall_1_0 = (RuleCall)cValueAssignment_1.eContents().get(0);
		
		//IntegerValue returns product::IntegerValue:
		//    {product::IntegerValue}
		//    value=INT
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{product::IntegerValue}
		//value=INT
		public Group getGroup() { return cGroup; }
		
		//{product::IntegerValue}
		public Action getIntegerValueAction_0() { return cIntegerValueAction_0; }
		
		//value=INT
		public Assignment getValueAssignment_1() { return cValueAssignment_1; }
		
		//INT
		public RuleCall getValueINTTerminalRuleCall_1_0() { return cValueINTTerminalRuleCall_1_0; }
	}
	public class StringValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.StringValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cStringValueAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cValueAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cValueEStringParserRuleCall_1_0 = (RuleCall)cValueAssignment_1.eContents().get(0);
		
		//StringValue returns product::StringValue:
		//    {product::StringValue}
		//    value=EString
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{product::StringValue}
		//value=EString
		public Group getGroup() { return cGroup; }
		
		//{product::StringValue}
		public Action getStringValueAction_0() { return cStringValueAction_0; }
		
		//value=EString
		public Assignment getValueAssignment_1() { return cValueAssignment_1; }
		
		//EString
		public RuleCall getValueEStringParserRuleCall_1_0() { return cValueEStringParserRuleCall_1_0; }
	}
	public class TracePointElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.TracePoint");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftSquareBracketKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cRegexAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final Keyword cRegexTildeKeyword_1_0 = (Keyword)cRegexAssignment_1.eContents().get(0);
		private final Assignment cValueAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValueEStringParserRuleCall_2_0 = (RuleCall)cValueAssignment_2.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//TracePoint returns TracePoint:
		//    '[' (regex?='~')? value=EString ']';
		@Override public ParserRule getRule() { return rule; }
		
		//'[' (regex?='~')? value=EString ']'
		public Group getGroup() { return cGroup; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_0() { return cLeftSquareBracketKeyword_0; }
		
		//(regex?='~')?
		public Assignment getRegexAssignment_1() { return cRegexAssignment_1; }
		
		//'~'
		public Keyword getRegexTildeKeyword_1_0() { return cRegexTildeKeyword_1_0; }
		
		//value=EString
		public Assignment getValueAssignment_2() { return cValueAssignment_2; }
		
		//EString
		public RuleCall getValueEStringParserRuleCall_2_0() { return cValueEStringParserRuleCall_2_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_3() { return cRightSquareBracketKeyword_3; }
	}
	public class EdgesElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Edges");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cEdgeParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cJitConstraintEdgeParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cTimeConstraintEdgeParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//Edges returns Dependency:
		//    Edge | JitConstraintEdge | TimeConstraintEdge;
		@Override public ParserRule getRule() { return rule; }
		
		//Edge | JitConstraintEdge | TimeConstraintEdge
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//Edge
		public RuleCall getEdgeParserRuleCall_0() { return cEdgeParserRuleCall_0; }
		
		//JitConstraintEdge
		public RuleCall getJitConstraintEdgeParserRuleCall_1() { return cJitConstraintEdgeParserRuleCall_1; }
		
		//TimeConstraintEdge
		public RuleCall getTimeConstraintEdgeParserRuleCall_2() { return cTimeConstraintEdgeParserRuleCall_2; }
	}
	public class EdgeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Edge");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cDependencyAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cSourceAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cSourceSourceReferenceParserRuleCall_1_0 = (RuleCall)cSourceAssignment_1.eContents().get(0);
		private final Keyword cHyphenMinusGreaterThanSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cTargetAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cTargetDependencyTargetParserRuleCall_3_0 = (RuleCall)cTargetAssignment_3.eContents().get(0);
		
		//Edge returns Dependency:
		//    {Dependency}
		//    source=SourceReference '->' target=DependencyTarget;
		@Override public ParserRule getRule() { return rule; }
		
		//{Dependency}
		//source=SourceReference '->' target=DependencyTarget
		public Group getGroup() { return cGroup; }
		
		//{Dependency}
		public Action getDependencyAction_0() { return cDependencyAction_0; }
		
		//source=SourceReference
		public Assignment getSourceAssignment_1() { return cSourceAssignment_1; }
		
		//SourceReference
		public RuleCall getSourceSourceReferenceParserRuleCall_1_0() { return cSourceSourceReferenceParserRuleCall_1_0; }
		
		//'->'
		public Keyword getHyphenMinusGreaterThanSignKeyword_2() { return cHyphenMinusGreaterThanSignKeyword_2; }
		
		//target=DependencyTarget
		public Assignment getTargetAssignment_3() { return cTargetAssignment_3; }
		
		//DependencyTarget
		public RuleCall getTargetDependencyTargetParserRuleCall_3_0() { return cTargetDependencyTargetParserRuleCall_3_0; }
	}
	public class JitConstraintEdgeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.JitConstraintEdge");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cDependencyAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cSourceAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cSourceSourceReferenceParserRuleCall_1_0 = (RuleCall)cSourceAssignment_1.eContents().get(0);
		private final Keyword cJitKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cBoundsAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cBoundsJitConstraintParserRuleCall_3_0 = (RuleCall)cBoundsAssignment_3.eContents().get(0);
		private final Assignment cTargetAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cTargetDependencyTargetParserRuleCall_4_0 = (RuleCall)cTargetAssignment_4.eContents().get(0);
		
		//JitConstraintEdge returns Dependency:
		//    {Dependency}
		//    source=SourceReference '-jit->' bounds=JitConstraint target=DependencyTarget;
		@Override public ParserRule getRule() { return rule; }
		
		//{Dependency}
		//source=SourceReference '-jit->' bounds=JitConstraint target=DependencyTarget
		public Group getGroup() { return cGroup; }
		
		//{Dependency}
		public Action getDependencyAction_0() { return cDependencyAction_0; }
		
		//source=SourceReference
		public Assignment getSourceAssignment_1() { return cSourceAssignment_1; }
		
		//SourceReference
		public RuleCall getSourceSourceReferenceParserRuleCall_1_0() { return cSourceSourceReferenceParserRuleCall_1_0; }
		
		//'-jit->'
		public Keyword getJitKeyword_2() { return cJitKeyword_2; }
		
		//bounds=JitConstraint
		public Assignment getBoundsAssignment_3() { return cBoundsAssignment_3; }
		
		//JitConstraint
		public RuleCall getBoundsJitConstraintParserRuleCall_3_0() { return cBoundsJitConstraintParserRuleCall_3_0; }
		
		//target=DependencyTarget
		public Assignment getTargetAssignment_4() { return cTargetAssignment_4; }
		
		//DependencyTarget
		public RuleCall getTargetDependencyTargetParserRuleCall_4_0() { return cTargetDependencyTargetParserRuleCall_4_0; }
	}
	public class TimeConstraintEdgeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.TimeConstraintEdge");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cDependencyAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cSourceAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cSourceSourceReferenceParserRuleCall_1_0 = (RuleCall)cSourceAssignment_1.eContents().get(0);
		private final Keyword cHyphenMinusLeftSquareBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cBoundsAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cBoundsTimeConstraintParserRuleCall_3_0 = (RuleCall)cBoundsAssignment_3.eContents().get(0);
		private final Keyword cRightSquareBracketHyphenMinusGreaterThanSignKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cTargetAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final RuleCall cTargetDependencyTargetParserRuleCall_5_0 = (RuleCall)cTargetAssignment_5.eContents().get(0);
		
		//TimeConstraintEdge returns Dependency:
		//    {Dependency}
		//    source=SourceReference '-[' bounds=TimeConstraint ']->' target=DependencyTarget;
		@Override public ParserRule getRule() { return rule; }
		
		//{Dependency}
		//source=SourceReference '-[' bounds=TimeConstraint ']->' target=DependencyTarget
		public Group getGroup() { return cGroup; }
		
		//{Dependency}
		public Action getDependencyAction_0() { return cDependencyAction_0; }
		
		//source=SourceReference
		public Assignment getSourceAssignment_1() { return cSourceAssignment_1; }
		
		//SourceReference
		public RuleCall getSourceSourceReferenceParserRuleCall_1_0() { return cSourceSourceReferenceParserRuleCall_1_0; }
		
		//'-['
		public Keyword getHyphenMinusLeftSquareBracketKeyword_2() { return cHyphenMinusLeftSquareBracketKeyword_2; }
		
		//bounds=TimeConstraint
		public Assignment getBoundsAssignment_3() { return cBoundsAssignment_3; }
		
		//TimeConstraint
		public RuleCall getBoundsTimeConstraintParserRuleCall_3_0() { return cBoundsTimeConstraintParserRuleCall_3_0; }
		
		//']->'
		public Keyword getRightSquareBracketHyphenMinusGreaterThanSignKeyword_4() { return cRightSquareBracketHyphenMinusGreaterThanSignKeyword_4; }
		
		//target=DependencyTarget
		public Assignment getTargetAssignment_5() { return cTargetAssignment_5; }
		
		//DependencyTarget
		public RuleCall getTargetDependencyTargetParserRuleCall_5_0() { return cTargetDependencyTargetParserRuleCall_5_0; }
	}
	public class EdgesWithConstraintsElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.EdgesWithConstraints");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cEdgeWithJitConstraintParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cEdgeWithTimeConstraintParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cEdgeWithInfiniteTimeConstraintParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//EdgesWithConstraints returns ConstraintEdge:
		//    EdgeWithJitConstraint | EdgeWithTimeConstraint | EdgeWithInfiniteTimeConstraint;
		@Override public ParserRule getRule() { return rule; }
		
		//EdgeWithJitConstraint | EdgeWithTimeConstraint | EdgeWithInfiniteTimeConstraint
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//EdgeWithJitConstraint
		public RuleCall getEdgeWithJitConstraintParserRuleCall_0() { return cEdgeWithJitConstraintParserRuleCall_0; }
		
		//EdgeWithTimeConstraint
		public RuleCall getEdgeWithTimeConstraintParserRuleCall_1() { return cEdgeWithTimeConstraintParserRuleCall_1; }
		
		//EdgeWithInfiniteTimeConstraint
		public RuleCall getEdgeWithInfiniteTimeConstraintParserRuleCall_2() { return cEdgeWithInfiniteTimeConstraintParserRuleCall_2; }
	}
	public class EdgeWithJitConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.EdgeWithJitConstraint");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cConstraintEdgeAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cSourceAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cSourceResourceActionCrossReference_1_0 = (CrossReference)cSourceAssignment_1.eContents().get(0);
		private final RuleCall cSourceResourceActionIIDParserRuleCall_1_0_1 = (RuleCall)cSourceResourceActionCrossReference_1_0.eContents().get(1);
		private final Keyword cJitKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cBoundsAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cBoundsJitConstraintParserRuleCall_3_0 = (RuleCall)cBoundsAssignment_3.eContents().get(0);
		private final Assignment cTargetAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cTargetResourceActionCrossReference_4_0 = (CrossReference)cTargetAssignment_4.eContents().get(0);
		private final RuleCall cTargetResourceActionIIDParserRuleCall_4_0_1 = (RuleCall)cTargetResourceActionCrossReference_4_0.eContents().get(1);
		
		//EdgeWithJitConstraint returns ConstraintEdge:
		//    {ConstraintEdge}
		//    (source=[ResourceAction|IID]) '-jit->' bounds=JitConstraint (target=[ResourceAction|IID]);
		@Override public ParserRule getRule() { return rule; }
		
		//{ConstraintEdge}
		//(source=[ResourceAction|IID]) '-jit->' bounds=JitConstraint (target=[ResourceAction|IID])
		public Group getGroup() { return cGroup; }
		
		//{ConstraintEdge}
		public Action getConstraintEdgeAction_0() { return cConstraintEdgeAction_0; }
		
		//(source=[ResourceAction|IID])
		public Assignment getSourceAssignment_1() { return cSourceAssignment_1; }
		
		//[ResourceAction|IID]
		public CrossReference getSourceResourceActionCrossReference_1_0() { return cSourceResourceActionCrossReference_1_0; }
		
		//IID
		public RuleCall getSourceResourceActionIIDParserRuleCall_1_0_1() { return cSourceResourceActionIIDParserRuleCall_1_0_1; }
		
		//'-jit->'
		public Keyword getJitKeyword_2() { return cJitKeyword_2; }
		
		//bounds=JitConstraint
		public Assignment getBoundsAssignment_3() { return cBoundsAssignment_3; }
		
		//JitConstraint
		public RuleCall getBoundsJitConstraintParserRuleCall_3_0() { return cBoundsJitConstraintParserRuleCall_3_0; }
		
		//(target=[ResourceAction|IID])
		public Assignment getTargetAssignment_4() { return cTargetAssignment_4; }
		
		//[ResourceAction|IID]
		public CrossReference getTargetResourceActionCrossReference_4_0() { return cTargetResourceActionCrossReference_4_0; }
		
		//IID
		public RuleCall getTargetResourceActionIIDParserRuleCall_4_0_1() { return cTargetResourceActionIIDParserRuleCall_4_0_1; }
	}
	public class EdgeWithTimeConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.EdgeWithTimeConstraint");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cConstraintEdgeAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cSourceAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cSourceResourceActionCrossReference_1_0 = (CrossReference)cSourceAssignment_1.eContents().get(0);
		private final RuleCall cSourceResourceActionIIDParserRuleCall_1_0_1 = (RuleCall)cSourceResourceActionCrossReference_1_0.eContents().get(1);
		private final Keyword cHyphenMinusLeftSquareBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cBoundsAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cBoundsTimeConstraintParserRuleCall_3_0 = (RuleCall)cBoundsAssignment_3.eContents().get(0);
		private final Keyword cRightSquareBracketHyphenMinusGreaterThanSignKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Assignment cTargetAssignment_5 = (Assignment)cGroup.eContents().get(5);
		private final CrossReference cTargetResourceActionCrossReference_5_0 = (CrossReference)cTargetAssignment_5.eContents().get(0);
		private final RuleCall cTargetResourceActionIIDParserRuleCall_5_0_1 = (RuleCall)cTargetResourceActionCrossReference_5_0.eContents().get(1);
		
		//EdgeWithTimeConstraint returns ConstraintEdge:
		//    {ConstraintEdge}
		//    (source=[ResourceAction|IID]) '-[' bounds=TimeConstraint ']->' (target=[ResourceAction|IID]);
		@Override public ParserRule getRule() { return rule; }
		
		//{ConstraintEdge}
		//(source=[ResourceAction|IID]) '-[' bounds=TimeConstraint ']->' (target=[ResourceAction|IID])
		public Group getGroup() { return cGroup; }
		
		//{ConstraintEdge}
		public Action getConstraintEdgeAction_0() { return cConstraintEdgeAction_0; }
		
		//(source=[ResourceAction|IID])
		public Assignment getSourceAssignment_1() { return cSourceAssignment_1; }
		
		//[ResourceAction|IID]
		public CrossReference getSourceResourceActionCrossReference_1_0() { return cSourceResourceActionCrossReference_1_0; }
		
		//IID
		public RuleCall getSourceResourceActionIIDParserRuleCall_1_0_1() { return cSourceResourceActionIIDParserRuleCall_1_0_1; }
		
		//'-['
		public Keyword getHyphenMinusLeftSquareBracketKeyword_2() { return cHyphenMinusLeftSquareBracketKeyword_2; }
		
		//bounds=TimeConstraint
		public Assignment getBoundsAssignment_3() { return cBoundsAssignment_3; }
		
		//TimeConstraint
		public RuleCall getBoundsTimeConstraintParserRuleCall_3_0() { return cBoundsTimeConstraintParserRuleCall_3_0; }
		
		//']->'
		public Keyword getRightSquareBracketHyphenMinusGreaterThanSignKeyword_4() { return cRightSquareBracketHyphenMinusGreaterThanSignKeyword_4; }
		
		//(target=[ResourceAction|IID])
		public Assignment getTargetAssignment_5() { return cTargetAssignment_5; }
		
		//[ResourceAction|IID]
		public CrossReference getTargetResourceActionCrossReference_5_0() { return cTargetResourceActionCrossReference_5_0; }
		
		//IID
		public RuleCall getTargetResourceActionIIDParserRuleCall_5_0_1() { return cTargetResourceActionIIDParserRuleCall_5_0_1; }
	}
	public class EdgeWithInfiniteTimeConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.EdgeWithInfiniteTimeConstraint");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cConstraintEdgeAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cSourceAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cSourceResourceActionCrossReference_1_0 = (CrossReference)cSourceAssignment_1.eContents().get(0);
		private final RuleCall cSourceResourceActionIIDParserRuleCall_1_0_1 = (RuleCall)cSourceResourceActionCrossReference_1_0.eContents().get(1);
		private final Keyword cHyphenMinusGreaterThanSignKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cBoundsAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cBoundsInfiniteTimeConstraintParserRuleCall_3_0 = (RuleCall)cBoundsAssignment_3.eContents().get(0);
		private final Assignment cTargetAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final CrossReference cTargetResourceActionCrossReference_4_0 = (CrossReference)cTargetAssignment_4.eContents().get(0);
		private final RuleCall cTargetResourceActionIIDParserRuleCall_4_0_1 = (RuleCall)cTargetResourceActionCrossReference_4_0.eContents().get(1);
		
		//EdgeWithInfiniteTimeConstraint returns ConstraintEdge:
		//    {ConstraintEdge}
		//    (source=[ResourceAction|IID]) '->' bounds=InfiniteTimeConstraint (target=[ResourceAction|IID]);
		@Override public ParserRule getRule() { return rule; }
		
		//{ConstraintEdge}
		//(source=[ResourceAction|IID]) '->' bounds=InfiniteTimeConstraint (target=[ResourceAction|IID])
		public Group getGroup() { return cGroup; }
		
		//{ConstraintEdge}
		public Action getConstraintEdgeAction_0() { return cConstraintEdgeAction_0; }
		
		//(source=[ResourceAction|IID])
		public Assignment getSourceAssignment_1() { return cSourceAssignment_1; }
		
		//[ResourceAction|IID]
		public CrossReference getSourceResourceActionCrossReference_1_0() { return cSourceResourceActionCrossReference_1_0; }
		
		//IID
		public RuleCall getSourceResourceActionIIDParserRuleCall_1_0_1() { return cSourceResourceActionIIDParserRuleCall_1_0_1; }
		
		//'->'
		public Keyword getHyphenMinusGreaterThanSignKeyword_2() { return cHyphenMinusGreaterThanSignKeyword_2; }
		
		//bounds=InfiniteTimeConstraint
		public Assignment getBoundsAssignment_3() { return cBoundsAssignment_3; }
		
		//InfiniteTimeConstraint
		public RuleCall getBoundsInfiniteTimeConstraintParserRuleCall_3_0() { return cBoundsInfiniteTimeConstraintParserRuleCall_3_0; }
		
		//(target=[ResourceAction|IID])
		public Assignment getTargetAssignment_4() { return cTargetAssignment_4; }
		
		//[ResourceAction|IID]
		public CrossReference getTargetResourceActionCrossReference_4_0() { return cTargetResourceActionCrossReference_4_0; }
		
		//IID
		public RuleCall getTargetResourceActionIIDParserRuleCall_4_0_1() { return cTargetResourceActionIIDParserRuleCall_4_0_1; }
	}
	public class JitConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.JitConstraint");
		private final Action cJitBoundsAction = (Action)rule.eContents().get(1);
		
		//JitConstraint returns JitBounds:
		//    {JitBounds};
		@Override public ParserRule getRule() { return rule; }
		
		//{JitBounds}
		public Action getJitBoundsAction() { return cJitBoundsAction; }
	}
	public class TimeConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.TimeConstraint");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cTimeBoundsAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cLowerAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cLowerEBigDecimalParserRuleCall_1_0 = (RuleCall)cLowerAssignment_1.eContents().get(0);
		private final Keyword cCommaKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cUpperAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cUpperEBigDecimalParserRuleCall_3_0 = (RuleCall)cUpperAssignment_3.eContents().get(0);
		
		//TimeConstraint returns TimeBounds:
		//    {TimeBounds}
		//    (lower=EBigDecimal) ',' (upper=EBigDecimal);
		@Override public ParserRule getRule() { return rule; }
		
		//{TimeBounds}
		//(lower=EBigDecimal) ',' (upper=EBigDecimal)
		public Group getGroup() { return cGroup; }
		
		//{TimeBounds}
		public Action getTimeBoundsAction_0() { return cTimeBoundsAction_0; }
		
		//(lower=EBigDecimal)
		public Assignment getLowerAssignment_1() { return cLowerAssignment_1; }
		
		//EBigDecimal
		public RuleCall getLowerEBigDecimalParserRuleCall_1_0() { return cLowerEBigDecimalParserRuleCall_1_0; }
		
		//','
		public Keyword getCommaKeyword_2() { return cCommaKeyword_2; }
		
		//(upper=EBigDecimal)
		public Assignment getUpperAssignment_3() { return cUpperAssignment_3; }
		
		//EBigDecimal
		public RuleCall getUpperEBigDecimalParserRuleCall_3_0() { return cUpperEBigDecimalParserRuleCall_3_0; }
	}
	public class InfiniteTimeConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.InfiniteTimeConstraint");
		private final Action cTimeBoundsAction = (Action)rule.eContents().get(1);
		
		//InfiniteTimeConstraint returns TimeBounds:
		//    {TimeBounds};
		@Override public ParserRule getRule() { return rule; }
		
		//{TimeBounds}
		public Action getTimeBoundsAction() { return cTimeBoundsAction; }
	}
	public class SourceReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.SourceReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cSourceReferenceAction_0 = (Action)cGroup.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Assignment cNodeAssignment_1_0 = (Assignment)cAlternatives_1.eContents().get(0);
		private final CrossReference cNodeActionCrossReference_1_0_0 = (CrossReference)cNodeAssignment_1_0.eContents().get(0);
		private final RuleCall cNodeActionIDTerminalRuleCall_1_0_0_1 = (RuleCall)cNodeActionCrossReference_1_0_0.eContents().get(1);
		private final Group cGroup_1_1 = (Group)cAlternatives_1.eContents().get(1);
		private final Keyword cVerticalLineKeyword_1_1_0 = (Keyword)cGroup_1_1.eContents().get(0);
		private final Assignment cNodeAssignment_1_1_1 = (Assignment)cGroup_1_1.eContents().get(1);
		private final CrossReference cNodeSyncBarCrossReference_1_1_1_0 = (CrossReference)cNodeAssignment_1_1_1.eContents().get(0);
		private final RuleCall cNodeSyncBarIDTerminalRuleCall_1_1_1_0_1 = (RuleCall)cNodeSyncBarCrossReference_1_1_1_0.eContents().get(1);
		
		//SourceReference returns SourceReference:
		//    {SourceReference}
		//    ((node=[Action|ID]) | ('|'node=[SyncBar|ID]));
		@Override public ParserRule getRule() { return rule; }
		
		//{SourceReference}
		//((node=[Action|ID]) | ('|'node=[SyncBar|ID]))
		public Group getGroup() { return cGroup; }
		
		//{SourceReference}
		public Action getSourceReferenceAction_0() { return cSourceReferenceAction_0; }
		
		//((node=[Action|ID]) | ('|'node=[SyncBar|ID]))
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//(node=[Action|ID])
		public Assignment getNodeAssignment_1_0() { return cNodeAssignment_1_0; }
		
		//[Action|ID]
		public CrossReference getNodeActionCrossReference_1_0_0() { return cNodeActionCrossReference_1_0_0; }
		
		//ID
		public RuleCall getNodeActionIDTerminalRuleCall_1_0_0_1() { return cNodeActionIDTerminalRuleCall_1_0_0_1; }
		
		//('|'node=[SyncBar|ID])
		public Group getGroup_1_1() { return cGroup_1_1; }
		
		//'|'
		public Keyword getVerticalLineKeyword_1_1_0() { return cVerticalLineKeyword_1_1_0; }
		
		//node=[SyncBar|ID]
		public Assignment getNodeAssignment_1_1_1() { return cNodeAssignment_1_1_1; }
		
		//[SyncBar|ID]
		public CrossReference getNodeSyncBarCrossReference_1_1_1_0() { return cNodeSyncBarCrossReference_1_1_1_0; }
		
		//ID
		public RuleCall getNodeSyncBarIDTerminalRuleCall_1_1_1_0_1() { return cNodeSyncBarIDTerminalRuleCall_1_1_1_0_1; }
	}
	public class DependencyTargetElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.DependencyTarget");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cTargetReferenceParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cAlternatives.eContents().get(1);
		private final RuleCall cEdgeParserRuleCall_1_0 = (RuleCall)cAlternatives_1.eContents().get(0);
		private final RuleCall cJitConstraintEdgeParserRuleCall_1_1 = (RuleCall)cAlternatives_1.eContents().get(1);
		private final RuleCall cTimeConstraintEdgeParserRuleCall_1_2 = (RuleCall)cAlternatives_1.eContents().get(2);
		
		//DependencyTarget returns EdgeTarget:
		//    TargetReference | (Edge | JitConstraintEdge | TimeConstraintEdge);
		@Override public ParserRule getRule() { return rule; }
		
		//TargetReference | (Edge | JitConstraintEdge | TimeConstraintEdge)
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//TargetReference
		public RuleCall getTargetReferenceParserRuleCall_0() { return cTargetReferenceParserRuleCall_0; }
		
		//(Edge | JitConstraintEdge | TimeConstraintEdge)
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//Edge
		public RuleCall getEdgeParserRuleCall_1_0() { return cEdgeParserRuleCall_1_0; }
		
		//JitConstraintEdge
		public RuleCall getJitConstraintEdgeParserRuleCall_1_1() { return cJitConstraintEdgeParserRuleCall_1_1; }
		
		//TimeConstraintEdge
		public RuleCall getTimeConstraintEdgeParserRuleCall_1_2() { return cTimeConstraintEdgeParserRuleCall_1_2; }
	}
	public class TargetReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.TargetReference");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cTargetReferenceAction_0 = (Action)cGroup.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Assignment cNodeAssignment_1_0 = (Assignment)cAlternatives_1.eContents().get(0);
		private final CrossReference cNodeActionCrossReference_1_0_0 = (CrossReference)cNodeAssignment_1_0.eContents().get(0);
		private final RuleCall cNodeActionIDTerminalRuleCall_1_0_0_1 = (RuleCall)cNodeActionCrossReference_1_0_0.eContents().get(1);
		private final Group cGroup_1_1 = (Group)cAlternatives_1.eContents().get(1);
		private final Keyword cVerticalLineKeyword_1_1_0 = (Keyword)cGroup_1_1.eContents().get(0);
		private final Assignment cNodeAssignment_1_1_1 = (Assignment)cGroup_1_1.eContents().get(1);
		private final CrossReference cNodeSyncBarCrossReference_1_1_1_0 = (CrossReference)cNodeAssignment_1_1_1.eContents().get(0);
		private final RuleCall cNodeSyncBarIDTerminalRuleCall_1_1_1_0_1 = (RuleCall)cNodeSyncBarCrossReference_1_1_1_0.eContents().get(1);
		
		//TargetReference returns TargetReference:
		//    {TargetReference}
		//    ((node=[Action|ID]) | ('|'node=[SyncBar|ID]));
		@Override public ParserRule getRule() { return rule; }
		
		//{TargetReference}
		//((node=[Action|ID]) | ('|'node=[SyncBar|ID]))
		public Group getGroup() { return cGroup; }
		
		//{TargetReference}
		public Action getTargetReferenceAction_0() { return cTargetReferenceAction_0; }
		
		//((node=[Action|ID]) | ('|'node=[SyncBar|ID]))
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//(node=[Action|ID])
		public Assignment getNodeAssignment_1_0() { return cNodeAssignment_1_0; }
		
		//[Action|ID]
		public CrossReference getNodeActionCrossReference_1_0_0() { return cNodeActionCrossReference_1_0_0; }
		
		//ID
		public RuleCall getNodeActionIDTerminalRuleCall_1_0_0_1() { return cNodeActionIDTerminalRuleCall_1_0_0_1; }
		
		//('|'node=[SyncBar|ID])
		public Group getGroup_1_1() { return cGroup_1_1; }
		
		//'|'
		public Keyword getVerticalLineKeyword_1_1_0() { return cVerticalLineKeyword_1_1_0; }
		
		//node=[SyncBar|ID]
		public Assignment getNodeAssignment_1_1_1() { return cNodeAssignment_1_1_1; }
		
		//[SyncBar|ID]
		public CrossReference getNodeSyncBarCrossReference_1_1_1_0() { return cNodeSyncBarCrossReference_1_1_1_0; }
		
		//ID
		public RuleCall getNodeSyncBarIDTerminalRuleCall_1_1_1_0_1() { return cNodeSyncBarIDTerminalRuleCall_1_1_1_0_1; }
	}
	public class EventElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Event");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cEventKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cLeftParenthesisKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cItemsAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cItemsEventItemParserRuleCall_2_1_0 = (RuleCall)cItemsAssignment_2_1.eContents().get(0);
		private final Group cGroup_2_2 = (Group)cGroup_2.eContents().get(2);
		private final Keyword cCommaKeyword_2_2_0 = (Keyword)cGroup_2_2.eContents().get(0);
		private final Assignment cItemsAssignment_2_2_1 = (Assignment)cGroup_2_2.eContents().get(1);
		private final RuleCall cItemsEventItemParserRuleCall_2_2_1_0 = (RuleCall)cItemsAssignment_2_2_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_2_3 = (Keyword)cGroup_2.eContents().get(3);
		
		//Event returns Event:
		//   'event'   name=ID ('(' items+=EventItem(',' items+=EventItem)*')')?
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//'event'   name=ID ('(' items+=EventItem(',' items+=EventItem)*')')?
		public Group getGroup() { return cGroup; }
		
		//'event'
		public Keyword getEventKeyword_0() { return cEventKeyword_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//('(' items+=EventItem(',' items+=EventItem)*')')?
		public Group getGroup_2() { return cGroup_2; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_2_0() { return cLeftParenthesisKeyword_2_0; }
		
		//items+=EventItem
		public Assignment getItemsAssignment_2_1() { return cItemsAssignment_2_1; }
		
		//EventItem
		public RuleCall getItemsEventItemParserRuleCall_2_1_0() { return cItemsEventItemParserRuleCall_2_1_0; }
		
		//(',' items+=EventItem)*
		public Group getGroup_2_2() { return cGroup_2_2; }
		
		//','
		public Keyword getCommaKeyword_2_2_0() { return cCommaKeyword_2_2_0; }
		
		//items+=EventItem
		public Assignment getItemsAssignment_2_2_1() { return cItemsAssignment_2_2_1; }
		
		//EventItem
		public RuleCall getItemsEventItemParserRuleCall_2_2_1_0() { return cItemsEventItemParserRuleCall_2_2_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_2_3() { return cRightParenthesisKeyword_2_3; }
	}
	public class EventItemElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.EventItem");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cEventItemAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		
		//EventItem returns EventItem:
		//    {EventItem}
		//    name=ID;
		@Override public ParserRule getRule() { return rule; }
		
		//{EventItem}
		//name=ID
		public Group getGroup() { return cGroup; }
		
		//{EventItem}
		public Action getEventItemAction_0() { return cEventItemAction_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
	}
	public class IIDElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.IID");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cINTTerminalRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cIDTerminalRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//IID returns ecore::EString:
		//    INT | ID;
		@Override public ParserRule getRule() { return rule; }
		
		//INT | ID
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//INT
		public RuleCall getINTTerminalRuleCall_0() { return cINTTerminalRuleCall_0; }
		
		//ID
		public RuleCall getIDTerminalRuleCall_1() { return cIDTerminalRuleCall_1; }
	}
	public class EBigDecimalElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.EBigDecimal");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cHyphenMinusKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final RuleCall cINTTerminalRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cFullStopKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final RuleCall cINTTerminalRuleCall_2_1 = (RuleCall)cGroup_2.eContents().get(1);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Alternatives cAlternatives_3_0 = (Alternatives)cGroup_3.eContents().get(0);
		private final Keyword cEKeyword_3_0_0 = (Keyword)cAlternatives_3_0.eContents().get(0);
		private final Keyword cEKeyword_3_0_1 = (Keyword)cAlternatives_3_0.eContents().get(1);
		private final Alternatives cAlternatives_3_1 = (Alternatives)cGroup_3.eContents().get(1);
		private final Keyword cPlusSignKeyword_3_1_0 = (Keyword)cAlternatives_3_1.eContents().get(0);
		private final Keyword cHyphenMinusKeyword_3_1_1 = (Keyword)cAlternatives_3_1.eContents().get(1);
		private final RuleCall cINTTerminalRuleCall_3_2 = (RuleCall)cGroup_3.eContents().get(2);
		
		//EBigDecimal returns ecore::EBigDecimal:
		//    '-'? INT ('.' INT)? (('E'|'e') ('+' | '-') INT)?;
		@Override public ParserRule getRule() { return rule; }
		
		//'-'? INT ('.' INT)? (('E'|'e') ('+' | '-') INT)?
		public Group getGroup() { return cGroup; }
		
		//'-'?
		public Keyword getHyphenMinusKeyword_0() { return cHyphenMinusKeyword_0; }
		
		//INT
		public RuleCall getINTTerminalRuleCall_1() { return cINTTerminalRuleCall_1; }
		
		//('.' INT)?
		public Group getGroup_2() { return cGroup_2; }
		
		//'.'
		public Keyword getFullStopKeyword_2_0() { return cFullStopKeyword_2_0; }
		
		//INT
		public RuleCall getINTTerminalRuleCall_2_1() { return cINTTerminalRuleCall_2_1; }
		
		//(('E'|'e') ('+' | '-') INT)?
		public Group getGroup_3() { return cGroup_3; }
		
		//('E'|'e')
		public Alternatives getAlternatives_3_0() { return cAlternatives_3_0; }
		
		//'E'
		public Keyword getEKeyword_3_0_0() { return cEKeyword_3_0_0; }
		
		//'e'
		public Keyword getEKeyword_3_0_1() { return cEKeyword_3_0_1; }
		
		//('+' | '-')
		public Alternatives getAlternatives_3_1() { return cAlternatives_3_1; }
		
		//'+'
		public Keyword getPlusSignKeyword_3_1_0() { return cPlusSignKeyword_3_1_0; }
		
		//'-'
		public Keyword getHyphenMinusKeyword_3_1_1() { return cHyphenMinusKeyword_3_1_1; }
		
		//INT
		public RuleCall getINTTerminalRuleCall_3_2() { return cINTTerminalRuleCall_3_2; }
	}
	public class EStringElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.EString");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cSTRINGTerminalRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cIDTerminalRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//EString returns ecore::EString:
		//    STRING | ID;
		@Override public ParserRule getRule() { return rule; }
		
		//STRING | ID
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//STRING
		public RuleCall getSTRINGTerminalRuleCall_0() { return cSTRINGTerminalRuleCall_0; }
		
		//ID
		public RuleCall getIDTerminalRuleCall_1() { return cIDTerminalRuleCall_1; }
	}
	
	public class SchedulingElements extends AbstractElementFinder.AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.Scheduling");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cASAPEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cASAPASAPKeyword_0_0 = (Keyword)cASAPEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cALAPEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cALAPALAPKeyword_1_0 = (Keyword)cALAPEnumLiteralDeclaration_1.eContents().get(0);
		
		//enum Scheduling returns SchedulingType:
		//    ASAP='ASAP' | ALAP='ALAP'
		//;
		public EnumRule getRule() { return rule; }
		
		//ASAP='ASAP' | ALAP='ALAP'
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ASAP='ASAP'
		public EnumLiteralDeclaration getASAPEnumLiteralDeclaration_0() { return cASAPEnumLiteralDeclaration_0; }
		
		//'ASAP'
		public Keyword getASAPASAPKeyword_0_0() { return cASAPASAPKeyword_0_0; }
		
		//ALAP='ALAP'
		public EnumLiteralDeclaration getALAPEnumLiteralDeclaration_1() { return cALAPEnumLiteralDeclaration_1; }
		
		//'ALAP'
		public Keyword getALAPALAPKeyword_1_0() { return cALAPALAPKeyword_1_0; }
	}
	public class TransferTypeElements extends AbstractElementFinder.AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.activity.teditor.Activity.TransferType");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cINEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cINInKeyword_0_0 = (Keyword)cINEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cOUTEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cOUTOutKeyword_1_0 = (Keyword)cOUTEnumLiteralDeclaration_1.eContents().get(0);
		private final EnumLiteralDeclaration cENTRYEnumLiteralDeclaration_2 = (EnumLiteralDeclaration)cAlternatives.eContents().get(2);
		private final Keyword cENTRYEntryKeyword_2_0 = (Keyword)cENTRYEnumLiteralDeclaration_2.eContents().get(0);
		private final EnumLiteralDeclaration cEXITEnumLiteralDeclaration_3 = (EnumLiteralDeclaration)cAlternatives.eContents().get(3);
		private final Keyword cEXITExitKeyword_3_0 = (Keyword)cEXITEnumLiteralDeclaration_3.eContents().get(0);
		private final EnumLiteralDeclaration cUNKNOWNEnumLiteralDeclaration_4 = (EnumLiteralDeclaration)cAlternatives.eContents().get(4);
		private final Keyword cUNKNOWNHangeKeyword_4_0 = (Keyword)cUNKNOWNEnumLiteralDeclaration_4.eContents().get(0);
		
		//enum TransferType returns product::TransferType:
		//    IN='in' | OUT='out' |  ENTRY='entry' | EXIT='exit' | UNKNOWN = 'çhange'
		//;
		public EnumRule getRule() { return rule; }
		
		//IN='in' | OUT='out' |  ENTRY='entry' | EXIT='exit' | UNKNOWN = 'çhange'
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//IN='in'
		public EnumLiteralDeclaration getINEnumLiteralDeclaration_0() { return cINEnumLiteralDeclaration_0; }
		
		//'in'
		public Keyword getINInKeyword_0_0() { return cINInKeyword_0_0; }
		
		//OUT='out'
		public EnumLiteralDeclaration getOUTEnumLiteralDeclaration_1() { return cOUTEnumLiteralDeclaration_1; }
		
		//'out'
		public Keyword getOUTOutKeyword_1_0() { return cOUTOutKeyword_1_0; }
		
		//ENTRY='entry'
		public EnumLiteralDeclaration getENTRYEnumLiteralDeclaration_2() { return cENTRYEnumLiteralDeclaration_2; }
		
		//'entry'
		public Keyword getENTRYEntryKeyword_2_0() { return cENTRYEntryKeyword_2_0; }
		
		//EXIT='exit'
		public EnumLiteralDeclaration getEXITEnumLiteralDeclaration_3() { return cEXITEnumLiteralDeclaration_3; }
		
		//'exit'
		public Keyword getEXITExitKeyword_3_0() { return cEXITExitKeyword_3_0; }
		
		//UNKNOWN = 'çhange'
		public EnumLiteralDeclaration getUNKNOWNEnumLiteralDeclaration_4() { return cUNKNOWNEnumLiteralDeclaration_4; }
		
		//'çhange'
		public Keyword getUNKNOWNHangeKeyword_4_0() { return cUNKNOWNHangeKeyword_4_0; }
	}
	
	private final ActivitySetElements pActivitySet;
	private final ImportElements pImport;
	private final ActivityElements pActivity;
	private final ParameterDeclarationElements pParameterDeclaration;
	private final EventDeclarationElements pEventDeclaration;
	private final ActionDeclarationElements pActionDeclaration;
	private final SymbolicPositionDeclarationElements pSymbolicPositionDeclaration;
	private final ProfileDeclarationElements pProfileDeclaration;
	private final DistanceDeclarationElements pDistanceDeclaration;
	private final ResourceDeclarationElements pResourceDeclaration;
	private final ModelTypeDefinitionRefDeclarationElements pModelTypeDefinitionRefDeclaration;
	private final EventDefElements pEventDef;
	private final ActionDefElements pActionDef;
	private final SymbolicPositionDefElements pSymbolicPositionDef;
	private final ProfileDefElements pProfileDef;
	private final DistanceDefElements pDistanceDef;
	private final ResourceDefElements pResourceDef;
	private final ModelTypeDefinitionRefElements pModelTypeDefinitionRef;
	private final LocationPrerequisiteElements pLocationPrerequisite;
	private final NodeElements pNode;
	private final ClaimElements pClaim;
	private final ReleaseElements pRelease;
	private final RaiseEventElements pRaiseEvent;
	private final RequireEventElements pRequireEvent;
	private final MoveElements pMove;
	private final SchedulingElements eScheduling;
	private final SimpleActionElements pSimpleAction;
	private final ProductChangeElements pProductChange;
	private final ProductChangeNoTransferTypeElements pProductChangeNoTransferType;
	private final ProductChangeWithTransferTypeElements pProductChangeWithTransferType;
	private final TransferTypeElements eTransferType;
	private final PropertyElements pProperty;
	private final BooleanValueElements pBooleanValue;
	private final BooleanLiteralElements pBooleanLiteral;
	private final IntegerValueElements pIntegerValue;
	private final StringValueElements pStringValue;
	private final TracePointElements pTracePoint;
	private final EdgesElements pEdges;
	private final EdgeElements pEdge;
	private final JitConstraintEdgeElements pJitConstraintEdge;
	private final TimeConstraintEdgeElements pTimeConstraintEdge;
	private final EdgesWithConstraintsElements pEdgesWithConstraints;
	private final EdgeWithJitConstraintElements pEdgeWithJitConstraint;
	private final EdgeWithTimeConstraintElements pEdgeWithTimeConstraint;
	private final EdgeWithInfiniteTimeConstraintElements pEdgeWithInfiniteTimeConstraint;
	private final JitConstraintElements pJitConstraint;
	private final TimeConstraintElements pTimeConstraint;
	private final InfiniteTimeConstraintElements pInfiniteTimeConstraint;
	private final SourceReferenceElements pSourceReference;
	private final DependencyTargetElements pDependencyTarget;
	private final TargetReferenceElements pTargetReference;
	private final EventElements pEvent;
	private final EventItemElements pEventItem;
	private final IIDElements pIID;
	private final EBigDecimalElements pEBigDecimal;
	private final EStringElements pEString;
	
	private final Grammar grammar;
	
	private final TerminalsGrammarAccess gaTerminals;

	@Inject
	public ActivityGrammarAccess(GrammarProvider grammarProvider,
			TerminalsGrammarAccess gaTerminals) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.gaTerminals = gaTerminals;
		this.pActivitySet = new ActivitySetElements();
		this.pImport = new ImportElements();
		this.pActivity = new ActivityElements();
		this.pParameterDeclaration = new ParameterDeclarationElements();
		this.pEventDeclaration = new EventDeclarationElements();
		this.pActionDeclaration = new ActionDeclarationElements();
		this.pSymbolicPositionDeclaration = new SymbolicPositionDeclarationElements();
		this.pProfileDeclaration = new ProfileDeclarationElements();
		this.pDistanceDeclaration = new DistanceDeclarationElements();
		this.pResourceDeclaration = new ResourceDeclarationElements();
		this.pModelTypeDefinitionRefDeclaration = new ModelTypeDefinitionRefDeclarationElements();
		this.pEventDef = new EventDefElements();
		this.pActionDef = new ActionDefElements();
		this.pSymbolicPositionDef = new SymbolicPositionDefElements();
		this.pProfileDef = new ProfileDefElements();
		this.pDistanceDef = new DistanceDefElements();
		this.pResourceDef = new ResourceDefElements();
		this.pModelTypeDefinitionRef = new ModelTypeDefinitionRefElements();
		this.pLocationPrerequisite = new LocationPrerequisiteElements();
		this.pNode = new NodeElements();
		this.pClaim = new ClaimElements();
		this.pRelease = new ReleaseElements();
		this.pRaiseEvent = new RaiseEventElements();
		this.pRequireEvent = new RequireEventElements();
		this.pMove = new MoveElements();
		this.eScheduling = new SchedulingElements();
		this.pSimpleAction = new SimpleActionElements();
		this.pProductChange = new ProductChangeElements();
		this.pProductChangeNoTransferType = new ProductChangeNoTransferTypeElements();
		this.pProductChangeWithTransferType = new ProductChangeWithTransferTypeElements();
		this.eTransferType = new TransferTypeElements();
		this.pProperty = new PropertyElements();
		this.pBooleanValue = new BooleanValueElements();
		this.pBooleanLiteral = new BooleanLiteralElements();
		this.pIntegerValue = new IntegerValueElements();
		this.pStringValue = new StringValueElements();
		this.pTracePoint = new TracePointElements();
		this.pEdges = new EdgesElements();
		this.pEdge = new EdgeElements();
		this.pJitConstraintEdge = new JitConstraintEdgeElements();
		this.pTimeConstraintEdge = new TimeConstraintEdgeElements();
		this.pEdgesWithConstraints = new EdgesWithConstraintsElements();
		this.pEdgeWithJitConstraint = new EdgeWithJitConstraintElements();
		this.pEdgeWithTimeConstraint = new EdgeWithTimeConstraintElements();
		this.pEdgeWithInfiniteTimeConstraint = new EdgeWithInfiniteTimeConstraintElements();
		this.pJitConstraint = new JitConstraintElements();
		this.pTimeConstraint = new TimeConstraintElements();
		this.pInfiniteTimeConstraint = new InfiniteTimeConstraintElements();
		this.pSourceReference = new SourceReferenceElements();
		this.pDependencyTarget = new DependencyTargetElements();
		this.pTargetReference = new TargetReferenceElements();
		this.pEvent = new EventElements();
		this.pEventItem = new EventItemElements();
		this.pIID = new IIDElements();
		this.pEBigDecimal = new EBigDecimalElements();
		this.pEString = new EStringElements();
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.lsat.activity.teditor.Activity".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	@Override
	public Grammar getGrammar() {
		return grammar;
	}
	
	
	public TerminalsGrammarAccess getTerminalsGrammarAccess() {
		return gaTerminals;
	}

	
	//ActivitySet returns ActivitySet:
	//    {ActivitySet}
	//    imports+= Import*
	//    (activities+=Activity | events+=Event) *;
	public ActivitySetElements getActivitySetAccess() {
		return pActivitySet;
	}
	
	public ParserRule getActivitySetRule() {
		return getActivitySetAccess().getRule();
	}
	
	//Import returns common::Import:
	//     "import" importURI=STRING;
	public ImportElements getImportAccess() {
		return pImport;
	}
	
	public ParserRule getImportRule() {
		return getImportAccess().getRule();
	}
	
	//Activity returns Activity:
	//    'activity' name = ID
	//    ('(' (parameterDeclarations+=ParameterDeclaration)? (',' parameterDeclarations+=ParameterDeclaration)* ')' )?
	//    '{'
	//       ('prerequisites' '{' prerequisites+=LocationPrerequisite* '}' )?
	//       'actions' '{' nodes+=Node* '}'
	//       'action flow' '{' edges+=Edges* '}'
	//       ('constraints'
	//        '{'
	//            constraints+=EdgesWithConstraints*
	//        '}'
	//        )?
	//    '}';
	public ActivityElements getActivityAccess() {
		return pActivity;
	}
	
	public ParserRule getActivityRule() {
		return getActivityAccess().getRule();
	}
	
	//ParameterDeclaration returns common::ParameterDeclaration:
	//    EventDeclaration | ActionDeclaration | ResourceDeclaration | SymbolicPositionDeclaration | ProfileDeclaration | DistanceDeclaration |
	//    ModelTypeDefinitionRefDeclaration;
	public ParameterDeclarationElements getParameterDeclarationAccess() {
		return pParameterDeclaration;
	}
	
	public ParserRule getParameterDeclarationRule() {
		return getParameterDeclarationAccess().getRule();
	}
	
	//EventDeclaration returns common::ParameterDeclaration:
	//    {common::ParameterDeclaration}
	//    declarations+=EventDef (',' declarations+=EventDef)* ':' 'Event';
	public EventDeclarationElements getEventDeclarationAccess() {
		return pEventDeclaration;
	}
	
	public ParserRule getEventDeclarationRule() {
		return getEventDeclarationAccess().getRule();
	}
	
	//ActionDeclaration returns common::ParameterDeclaration:
	//    {common::ParameterDeclaration}
	//    declarations+=ActionDef (',' declarations+=ActionDef)* ':' 'Action';
	public ActionDeclarationElements getActionDeclarationAccess() {
		return pActionDeclaration;
	}
	
	public ParserRule getActionDeclarationRule() {
		return getActionDeclarationAccess().getRule();
	}
	
	//SymbolicPositionDeclaration returns common::ParameterDeclaration:
	//    {common::ParameterDeclaration}
	//    declarations+=SymbolicPositionDef (',' declarations+=SymbolicPositionDef)* ':' 'SymbolicPosition';
	public SymbolicPositionDeclarationElements getSymbolicPositionDeclarationAccess() {
		return pSymbolicPositionDeclaration;
	}
	
	public ParserRule getSymbolicPositionDeclarationRule() {
		return getSymbolicPositionDeclarationAccess().getRule();
	}
	
	//ProfileDeclaration returns common::ParameterDeclaration:
	//    {common::ParameterDeclaration}
	//    declarations+=ProfileDef (',' declarations+=ProfileDef)* ':' 'Profile';
	public ProfileDeclarationElements getProfileDeclarationAccess() {
		return pProfileDeclaration;
	}
	
	public ParserRule getProfileDeclarationRule() {
		return getProfileDeclarationAccess().getRule();
	}
	
	//DistanceDeclaration returns common::ParameterDeclaration:
	//    {common::ParameterDeclaration}
	//    declarations+=DistanceDef (',' declarations+=DistanceDef)* ':' 'Distance';
	public DistanceDeclarationElements getDistanceDeclarationAccess() {
		return pDistanceDeclaration;
	}
	
	public ParserRule getDistanceDeclarationRule() {
		return getDistanceDeclarationAccess().getRule();
	}
	
	//ResourceDeclaration returns common::ParameterDeclaration:
	//    {common::ParameterDeclaration}
	//    declarations+=ResourceDef (',' declarations+=ResourceDef)* ':' 'Resource';
	public ResourceDeclarationElements getResourceDeclarationAccess() {
		return pResourceDeclaration;
	}
	
	public ParserRule getResourceDeclarationRule() {
		return getResourceDeclarationAccess().getRule();
	}
	
	//ModelTypeDefinitionRefDeclaration returns common::ParameterDeclaration:
	//    {common::ParameterDeclaration}
	//    declarations+=ModelTypeDefinitionRef;
	public ModelTypeDefinitionRefDeclarationElements getModelTypeDefinitionRefDeclarationAccess() {
		return pModelTypeDefinitionRefDeclaration;
	}
	
	public ParserRule getModelTypeDefinitionRefDeclarationRule() {
		return getModelTypeDefinitionRefDeclarationAccess().getRule();
	}
	
	//EventDef returns Event:
	//    {Event} name=ID;
	public EventDefElements getEventDefAccess() {
		return pEventDef;
	}
	
	public ParserRule getEventDefRule() {
		return getEventDefAccess().getRule();
	}
	
	//ActionDef returns machine::ActionType:
	//    {machine::ActionType} name=ID;
	public ActionDefElements getActionDefAccess() {
		return pActionDef;
	}
	
	public ParserRule getActionDefRule() {
		return getActionDefAccess().getRule();
	}
	
	//SymbolicPositionDef returns machine::SymbolicPosition:
	//    {machine::SymbolicPosition} name=ID;
	public SymbolicPositionDefElements getSymbolicPositionDefAccess() {
		return pSymbolicPositionDef;
	}
	
	public ParserRule getSymbolicPositionDefRule() {
		return getSymbolicPositionDefAccess().getRule();
	}
	
	//ProfileDef returns machine::Profile:
	//    {machine::Profile} name=ID;
	public ProfileDefElements getProfileDefAccess() {
		return pProfileDef;
	}
	
	public ParserRule getProfileDefRule() {
		return getProfileDefAccess().getRule();
	}
	
	//DistanceDef returns machine::Distance:
	//    {machine::Distance} name=ID;
	public DistanceDefElements getDistanceDefAccess() {
		return pDistanceDef;
	}
	
	public ParserRule getDistanceDefRule() {
		return getDistanceDefAccess().getRule();
	}
	
	//ResourceDef returns machine::Resource:
	//    {machine::Resource} name=ID;
	public ResourceDefElements getResourceDefAccess() {
		return pResourceDef;
	}
	
	public ParserRule getResourceDefRule() {
		return getResourceDefAccess().getRule();
	}
	
	//ModelTypeDefinitionRef returns ModelTypeDefinitionRef:
	//    {ModelTypeDefinitionRef} name=ID ':' typeDefinition=[common::TypeDefinition|ID];
	public ModelTypeDefinitionRefElements getModelTypeDefinitionRefAccess() {
		return pModelTypeDefinitionRef;
	}
	
	public ParserRule getModelTypeDefinitionRefRule() {
		return getModelTypeDefinitionRefAccess().getRule();
	}
	
	//LocationPrerequisite returns LocationPrerequisite:
	//     resourceDefinition=[machine::Resource|ID] ('.' resourceItem=[machine::ResourceItem|IID])? '.' => peripheral=[machine::Peripheral|ID] 'at' position=[machine::SymbolicPosition|ID];
	public LocationPrerequisiteElements getLocationPrerequisiteAccess() {
		return pLocationPrerequisite;
	}
	
	public ParserRule getLocationPrerequisiteRule() {
		return getLocationPrerequisiteAccess().getRule();
	}
	
	//Node returns Node:
	//    Claim | Release | SimpleAction | Move |RequireEvent |RaiseEvent;
	public NodeElements getNodeAccess() {
		return pNode;
	}
	
	public ParserRule getNodeRule() {
		return getNodeAccess().getRule();
	}
	
	//Claim returns Claim:
	//    {Claim}
	//    name=ID ':'
	//    ((entry=TracePoint)| (outerEntry=TracePoint entry=TracePoint))?
	//    ( passive?='passive')? 'claim' resourceDefinition=[machine::Resource|ID]('.' resourceItem=[machine::ResourceItem|IID])?
	//    ((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
	//;
	public ClaimElements getClaimAccess() {
		return pClaim;
	}
	
	public ParserRule getClaimRule() {
		return getClaimAccess().getRule();
	}
	
	//Release returns Release:
	//    {Release}
	//    name=ID ':'
	//    ((entry=TracePoint)| (outerEntry=TracePoint entry=TracePoint))?
	//    'release' resourceDefinition=[machine::Resource|ID]('.' resourceItem=[machine::ResourceItem|IID])?
	//    ((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
	//;
	public ReleaseElements getReleaseAccess() {
		return pRelease;
	}
	
	public ParserRule getReleaseRule() {
		return getReleaseAccess().getRule();
	}
	
	//RaiseEvent returns RaiseEvent:
	//    {RaiseEvent}
	//    name=ID ':'
	//    'raise' resourceDefinition=[Event|ID]('.' resourceItem=[EventItem])?
	//;
	public RaiseEventElements getRaiseEventAccess() {
		return pRaiseEvent;
	}
	
	public ParserRule getRaiseEventRule() {
		return getRaiseEventAccess().getRule();
	}
	
	//RequireEvent returns RequireEvent:
	//    {RequireEvent}
	//    name=ID ':'
	//    'require' resourceDefinition=[Event|ID]('.' resourceItem=[EventItem])?
	//;
	public RequireEventElements getRequireEventAccess() {
		return pRequireEvent;
	}
	
	public ParserRule getRequireEventRule() {
		return getRequireEventAccess().getRule();
	}
	
	//Move returns Move:
	//    {Move}
	//    name=ID ':'
	//    ((entry=TracePoint) | (outerEntry=TracePoint entry=TracePoint))?
	//    'move' resourceDefinition=[machine::Resource|ID]('.' resourceItem=[machine::ResourceItem|IID])? '.' peripheral=[machine::Peripheral|ID]
	//    (((passing?='passing'|'to') targetPosition=[machine::SymbolicPosition|ID])|
	//    ((continuing?='continuing'|'for') distance=[machine::Distance|ID]))
	//    ('with speed profile'  profile=[machine::Profile|ID] )
	//    (schedulingType=Scheduling)?
	//    (productChanges+=ProductChange (productChanges+=ProductChangeWithTransferType)* )?
	//    ((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
	//    ;
	public MoveElements getMoveAccess() {
		return pMove;
	}
	
	public ParserRule getMoveRule() {
		return getMoveAccess().getRule();
	}
	
	//enum Scheduling returns SchedulingType:
	//    ASAP='ASAP' | ALAP='ALAP'
	//;
	public SchedulingElements getSchedulingAccess() {
		return eScheduling;
	}
	
	public EnumRule getSchedulingRule() {
		return getSchedulingAccess().getRule();
	}
	
	///**
	// * The '=>' below helps the parser to first check peripheral and type before analysing Resource.
	// * see https://dslmeinte.wordpress.com/2011/12/05/using-syntactic-predicates-in-xtext-part-1/
	// * for more info.
	// */
	//SimpleAction returns SimpleAction:
	//    {SimpleAction}
	//    name=ID ':'
	//    ((entry=TracePoint)| (outerEntry=TracePoint entry=TracePoint))?
	//    (resourceDefinition=[machine::Resource|ID] '.' ( resourceItem=[machine::ResourceItem|IID] '.' )? peripheral=[machine::Peripheral|ID] '.') ? type=[machine::ActionType|ID]
	//    (schedulingType=Scheduling)?
	//    (productChanges+=ProductChange (productChanges+=ProductChangeWithTransferType)* )?
	//    ((exit=TracePoint) | (exit=TracePoint outerExit=TracePoint))?
	//;
	public SimpleActionElements getSimpleActionAccess() {
		return pSimpleAction;
	}
	
	public ParserRule getSimpleActionRule() {
		return getSimpleActionAccess().getRule();
	}
	
	//ProductChange returns ProductChange:
	//    ProductChangeWithTransferType | ProductChangeNoTransferType
	//;
	public ProductChangeElements getProductChangeAccess() {
		return pProductChange;
	}
	
	public ParserRule getProductChangeRule() {
		return getProductChangeAccess().getRule();
	}
	
	//ProductChangeNoTransferType returns ProductChange:
	//    {ProductChange}
	//    (
	//        (
	//            ( 'product' product=[product::ProductDefinition|ID])
	//            (('slot')?  slot=IID)?
	//            ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
	//            ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
	//        ) |
	//        (
	//            (('slot')?  slot=IID)
	//            ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
	//            ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
	//        ) |
	//        (
	//            ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')
	//            ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
	//        ) |
	//        (
	//            ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')
	//        )
	//    )
	//;
	public ProductChangeNoTransferTypeElements getProductChangeNoTransferTypeAccess() {
		return pProductChangeNoTransferType;
	}
	
	public ParserRule getProductChangeNoTransferTypeRule() {
		return getProductChangeNoTransferTypeAccess().getRule();
	}
	
	//ProductChangeWithTransferType returns ProductChange:
	//    {ProductChange}
	//    (transferType = TransferType)
	//    ( 'product' product=[product::ProductDefinition|ID])?
	//    (('slot')? slot=IID)?
	//    ('@start' '(' startProperties+=Property (',' startProperties+=Property)* ')')?
	//    ('@end' '(' endProperties+=Property (',' endProperties+=Property)* ')')?
	//;
	public ProductChangeWithTransferTypeElements getProductChangeWithTransferTypeAccess() {
		return pProductChangeWithTransferType;
	}
	
	public ParserRule getProductChangeWithTransferTypeRule() {
		return getProductChangeWithTransferTypeAccess().getRule();
	}
	
	//enum TransferType returns product::TransferType:
	//    IN='in' | OUT='out' |  ENTRY='entry' | EXIT='exit' | UNKNOWN = 'çhange'
	//;
	public TransferTypeElements getTransferTypeAccess() {
		return eTransferType;
	}
	
	public EnumRule getTransferTypeRule() {
		return getTransferTypeAccess().getRule();
	}
	
	//Property returns product::Property:
	//    {product::Property}
	//    definition=[product::PropertyDefinition|ID] ':' value=(BooleanValue | IntegerValue | StringValue)
	//;
	public PropertyElements getPropertyAccess() {
		return pProperty;
	}
	
	public ParserRule getPropertyRule() {
		return getPropertyAccess().getRule();
	}
	
	//BooleanValue returns product::BooleanValue:
	//    {product::BooleanValue}
	//    value=  BooleanLiteral
	//;
	public BooleanValueElements getBooleanValueAccess() {
		return pBooleanValue;
	}
	
	public ParserRule getBooleanValueRule() {
		return getBooleanValueAccess().getRule();
	}
	
	//BooleanLiteral returns ecore::EBooleanObject:
	//    'True' | 'False';
	public BooleanLiteralElements getBooleanLiteralAccess() {
		return pBooleanLiteral;
	}
	
	public ParserRule getBooleanLiteralRule() {
		return getBooleanLiteralAccess().getRule();
	}
	
	//IntegerValue returns product::IntegerValue:
	//    {product::IntegerValue}
	//    value=INT
	//;
	public IntegerValueElements getIntegerValueAccess() {
		return pIntegerValue;
	}
	
	public ParserRule getIntegerValueRule() {
		return getIntegerValueAccess().getRule();
	}
	
	//StringValue returns product::StringValue:
	//    {product::StringValue}
	//    value=EString
	//;
	public StringValueElements getStringValueAccess() {
		return pStringValue;
	}
	
	public ParserRule getStringValueRule() {
		return getStringValueAccess().getRule();
	}
	
	//TracePoint returns TracePoint:
	//    '[' (regex?='~')? value=EString ']';
	public TracePointElements getTracePointAccess() {
		return pTracePoint;
	}
	
	public ParserRule getTracePointRule() {
		return getTracePointAccess().getRule();
	}
	
	//Edges returns Dependency:
	//    Edge | JitConstraintEdge | TimeConstraintEdge;
	public EdgesElements getEdgesAccess() {
		return pEdges;
	}
	
	public ParserRule getEdgesRule() {
		return getEdgesAccess().getRule();
	}
	
	//Edge returns Dependency:
	//    {Dependency}
	//    source=SourceReference '->' target=DependencyTarget;
	public EdgeElements getEdgeAccess() {
		return pEdge;
	}
	
	public ParserRule getEdgeRule() {
		return getEdgeAccess().getRule();
	}
	
	//JitConstraintEdge returns Dependency:
	//    {Dependency}
	//    source=SourceReference '-jit->' bounds=JitConstraint target=DependencyTarget;
	public JitConstraintEdgeElements getJitConstraintEdgeAccess() {
		return pJitConstraintEdge;
	}
	
	public ParserRule getJitConstraintEdgeRule() {
		return getJitConstraintEdgeAccess().getRule();
	}
	
	//TimeConstraintEdge returns Dependency:
	//    {Dependency}
	//    source=SourceReference '-[' bounds=TimeConstraint ']->' target=DependencyTarget;
	public TimeConstraintEdgeElements getTimeConstraintEdgeAccess() {
		return pTimeConstraintEdge;
	}
	
	public ParserRule getTimeConstraintEdgeRule() {
		return getTimeConstraintEdgeAccess().getRule();
	}
	
	//EdgesWithConstraints returns ConstraintEdge:
	//    EdgeWithJitConstraint | EdgeWithTimeConstraint | EdgeWithInfiniteTimeConstraint;
	public EdgesWithConstraintsElements getEdgesWithConstraintsAccess() {
		return pEdgesWithConstraints;
	}
	
	public ParserRule getEdgesWithConstraintsRule() {
		return getEdgesWithConstraintsAccess().getRule();
	}
	
	//EdgeWithJitConstraint returns ConstraintEdge:
	//    {ConstraintEdge}
	//    (source=[ResourceAction|IID]) '-jit->' bounds=JitConstraint (target=[ResourceAction|IID]);
	public EdgeWithJitConstraintElements getEdgeWithJitConstraintAccess() {
		return pEdgeWithJitConstraint;
	}
	
	public ParserRule getEdgeWithJitConstraintRule() {
		return getEdgeWithJitConstraintAccess().getRule();
	}
	
	//EdgeWithTimeConstraint returns ConstraintEdge:
	//    {ConstraintEdge}
	//    (source=[ResourceAction|IID]) '-[' bounds=TimeConstraint ']->' (target=[ResourceAction|IID]);
	public EdgeWithTimeConstraintElements getEdgeWithTimeConstraintAccess() {
		return pEdgeWithTimeConstraint;
	}
	
	public ParserRule getEdgeWithTimeConstraintRule() {
		return getEdgeWithTimeConstraintAccess().getRule();
	}
	
	//EdgeWithInfiniteTimeConstraint returns ConstraintEdge:
	//    {ConstraintEdge}
	//    (source=[ResourceAction|IID]) '->' bounds=InfiniteTimeConstraint (target=[ResourceAction|IID]);
	public EdgeWithInfiniteTimeConstraintElements getEdgeWithInfiniteTimeConstraintAccess() {
		return pEdgeWithInfiniteTimeConstraint;
	}
	
	public ParserRule getEdgeWithInfiniteTimeConstraintRule() {
		return getEdgeWithInfiniteTimeConstraintAccess().getRule();
	}
	
	//JitConstraint returns JitBounds:
	//    {JitBounds};
	public JitConstraintElements getJitConstraintAccess() {
		return pJitConstraint;
	}
	
	public ParserRule getJitConstraintRule() {
		return getJitConstraintAccess().getRule();
	}
	
	//TimeConstraint returns TimeBounds:
	//    {TimeBounds}
	//    (lower=EBigDecimal) ',' (upper=EBigDecimal);
	public TimeConstraintElements getTimeConstraintAccess() {
		return pTimeConstraint;
	}
	
	public ParserRule getTimeConstraintRule() {
		return getTimeConstraintAccess().getRule();
	}
	
	//InfiniteTimeConstraint returns TimeBounds:
	//    {TimeBounds};
	public InfiniteTimeConstraintElements getInfiniteTimeConstraintAccess() {
		return pInfiniteTimeConstraint;
	}
	
	public ParserRule getInfiniteTimeConstraintRule() {
		return getInfiniteTimeConstraintAccess().getRule();
	}
	
	//SourceReference returns SourceReference:
	//    {SourceReference}
	//    ((node=[Action|ID]) | ('|'node=[SyncBar|ID]));
	public SourceReferenceElements getSourceReferenceAccess() {
		return pSourceReference;
	}
	
	public ParserRule getSourceReferenceRule() {
		return getSourceReferenceAccess().getRule();
	}
	
	//DependencyTarget returns EdgeTarget:
	//    TargetReference | (Edge | JitConstraintEdge | TimeConstraintEdge);
	public DependencyTargetElements getDependencyTargetAccess() {
		return pDependencyTarget;
	}
	
	public ParserRule getDependencyTargetRule() {
		return getDependencyTargetAccess().getRule();
	}
	
	//TargetReference returns TargetReference:
	//    {TargetReference}
	//    ((node=[Action|ID]) | ('|'node=[SyncBar|ID]));
	public TargetReferenceElements getTargetReferenceAccess() {
		return pTargetReference;
	}
	
	public ParserRule getTargetReferenceRule() {
		return getTargetReferenceAccess().getRule();
	}
	
	//Event returns Event:
	//   'event'   name=ID ('(' items+=EventItem(',' items+=EventItem)*')')?
	//;
	public EventElements getEventAccess() {
		return pEvent;
	}
	
	public ParserRule getEventRule() {
		return getEventAccess().getRule();
	}
	
	//EventItem returns EventItem:
	//    {EventItem}
	//    name=ID;
	public EventItemElements getEventItemAccess() {
		return pEventItem;
	}
	
	public ParserRule getEventItemRule() {
		return getEventItemAccess().getRule();
	}
	
	//IID returns ecore::EString:
	//    INT | ID;
	public IIDElements getIIDAccess() {
		return pIID;
	}
	
	public ParserRule getIIDRule() {
		return getIIDAccess().getRule();
	}
	
	//EBigDecimal returns ecore::EBigDecimal:
	//    '-'? INT ('.' INT)? (('E'|'e') ('+' | '-') INT)?;
	public EBigDecimalElements getEBigDecimalAccess() {
		return pEBigDecimal;
	}
	
	public ParserRule getEBigDecimalRule() {
		return getEBigDecimalAccess().getRule();
	}
	
	//EString returns ecore::EString:
	//    STRING | ID;
	public EStringElements getEStringAccess() {
		return pEString;
	}
	
	public ParserRule getEStringRule() {
		return getEStringAccess().getRule();
	}
	
	//terminal ID: '^'?('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;
	public TerminalRule getIDRule() {
		return gaTerminals.getIDRule();
	}
	
	//terminal INT returns ecore::EInt: ('0'..'9')+;
	public TerminalRule getINTRule() {
		return gaTerminals.getINTRule();
	}
	
	//terminal STRING:
	//            '"' ( '\\' . /* 'b'|'t'|'n'|'f'|'r'|'u'|'"'|"'"|'\\' */ | !('\\'|'"') )* '"' |
	//            "'" ( '\\' . /* 'b'|'t'|'n'|'f'|'r'|'u'|'"'|"'"|'\\' */ | !('\\'|"'") )* "'"
	//        ;
	public TerminalRule getSTRINGRule() {
		return gaTerminals.getSTRINGRule();
	}
	
	//terminal ML_COMMENT : '/*' -> '*/';
	public TerminalRule getML_COMMENTRule() {
		return gaTerminals.getML_COMMENTRule();
	}
	
	//terminal SL_COMMENT : '//' !('\n'|'\r')* ('\r'? '\n')?;
	public TerminalRule getSL_COMMENTRule() {
		return gaTerminals.getSL_COMMENTRule();
	}
	
	//terminal WS         : (' '|'\t'|'\r'|'\n')+;
	public TerminalRule getWSRule() {
		return gaTerminals.getWSRule();
	}
	
	//terminal ANY_OTHER: .;
	public TerminalRule getANY_OTHERRule() {
		return gaTerminals.getANY_OTHERRule();
	}
}
