/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package expressions;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

import distributions.Distribution;

/**
 * Utils for Expressions
 */
public class ExpressionsUtil {
    private ExpressionsUtil() {
        // Empty for utilities
    }

    public static Collection<Distribution> getDistributions( Expression expression) {
        return getExpressionsOfType(expression, Distribution.class);
    }

    public static <T extends Expression> Collection<T> getExpressionsOfType(Expression expression, Class<T> type) {
        var result = new LinkedHashSet<T>();
        var visited = new LinkedHashSet<Expression>();
        getExpressionsOfType(expression, visited, result, type);
        return result;
    }

    private static <T extends Expression> void getExpressionsOfType(Expression expression, Set<Expression> visited, Set<T> result, Class<T> type) {
        if (expression instanceof DeclarationRef dr) {
            getExpressionsOfType(dr.getDeclaration().getExpression(), visited, result, type);
        } else if (visited.add(expression) ) {
            if (type.isInstance(expression)) {
                result.add(type.cast(expression));
            }
            expression.eContents().stream()
                .filter(Expression.class::isInstance).map(Expression.class::cast)
                .forEach(exp -> getExpressionsOfType(exp, visited, result, type));
        }
    }
}
