/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.jsonrpc.ProtocolDraft;
import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

/**
 * Client supports the tag property on a code action. Clients
 * supporting tags have to handle unknown tags gracefully.
 */
@ProtocolDraft
@ProtocolSince("3.18.0")
@SuppressWarnings("all")
public class CodeActionTagSupportCapabilities {
  /**
   * The tags supported by the client.
   */
  @NonNull
  private List<CodeActionTag> valueSet;

  public CodeActionTagSupportCapabilities() {
    ArrayList<CodeActionTag> _arrayList = new ArrayList<CodeActionTag>();
    this.valueSet = _arrayList;
  }

  public CodeActionTagSupportCapabilities(@NonNull final List<CodeActionTag> valueSet) {
    this.valueSet = Preconditions.<List<CodeActionTag>>checkNotNull(valueSet, "valueSet");
  }

  /**
   * The tags supported by the client.
   */
  @NonNull
  public List<CodeActionTag> getValueSet() {
    return this.valueSet;
  }

  /**
   * The tags supported by the client.
   */
  public void setValueSet(@NonNull final List<CodeActionTag> valueSet) {
    this.valueSet = Preconditions.checkNotNull(valueSet, "valueSet");
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("valueSet", this.valueSet);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    CodeActionTagSupportCapabilities other = (CodeActionTagSupportCapabilities) obj;
    if (this.valueSet == null) {
      if (other.valueSet != null)
        return false;
    } else if (!this.valueSet.equals(other.valueSet))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * 1 + ((this.valueSet== null) ? 0 : this.valueSet.hashCode());
  }
}
