/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import org.eclipse.lsp4j.jsonrpc.ProtocolDraft;
import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

/**
 * Result of the {@code workspace/textDocumentContent} request.
 */
@ProtocolDraft
@ProtocolSince("3.18.0")
@SuppressWarnings("all")
public class TextDocumentContentResult {
  /**
   * The text content of the text document. Please note, that the content of
   * any subsequent open notifications for the text document might differ
   * from the returned content due to whitespace and line ending
   * normalizations done on the client.
   */
  @NonNull
  private String text;

  public TextDocumentContentResult() {
  }

  public TextDocumentContentResult(@NonNull final String text) {
    this.text = Preconditions.<String>checkNotNull(text, "text");
  }

  /**
   * The text content of the text document. Please note, that the content of
   * any subsequent open notifications for the text document might differ
   * from the returned content due to whitespace and line ending
   * normalizations done on the client.
   */
  @NonNull
  public String getText() {
    return this.text;
  }

  /**
   * The text content of the text document. Please note, that the content of
   * any subsequent open notifications for the text document might differ
   * from the returned content due to whitespace and line ending
   * normalizations done on the client.
   */
  public void setText(@NonNull final String text) {
    this.text = Preconditions.checkNotNull(text, "text");
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("text", this.text);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    TextDocumentContentResult other = (TextDocumentContentResult) obj;
    if (this.text == null) {
      if (other.text != null)
        return false;
    } else if (!this.text.equals(other.text))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * 1 + ((this.text== null) ? 0 : this.text.hashCode());
  }
}
