/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.codeaction;

import java.text.MessageFormat;
import java.util.Collections;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4mp.commons.codeaction.CodeActionData;
import org.eclipse.lsp4mp.commons.codeaction.MicroProfileCodeActionId;
import org.eclipse.lsp4mp.ls.commons.client.ConfigurationItemEdit;
import org.eclipse.lsp4mp.ls.commons.client.ConfigurationItemEditType;

public class MicroProfileCodeActionFactory {
    private static final String UNASSIGNED_EXCLUDED_SECTION = "microprofile.tools.validation.unassigned.excluded";
    private static final String UNASSIGNED_EXCLUDE_CODE_ACTION_TITLE = "Exclude ''{0}'' from property validation?";
    private static final String UNASSIGNED_EXCLUDE_COMMAND_TITLE = "Add ''{0}'' to unassigned excluded array";
    private static final String UNKNOWN_EXCLUDED_SECTION = "microprofile.tools.validation.unknown.excluded";
    private static final String UNKNOWN_EXCLUDE_CODE_ACTION_TITLE = "Exclude ''{0}'' from unknown property validation?";
    private static final String UNKNOWN_EXCLUDE_COMMAND_TITLE = "Add ''{0}'' to unknown excluded array";

    public static CodeAction createAddToUnassignedExcludedCodeAction(String item, Diagnostic diagnostic) {
        String codeActionTitle = MessageFormat.format(UNASSIGNED_EXCLUDE_CODE_ACTION_TITLE, item);
        String commandTitle = MessageFormat.format(UNASSIGNED_EXCLUDE_COMMAND_TITLE, item);
        ConfigurationItemEditType editType = ConfigurationItemEditType.add;
        CodeAction codeAction = MicroProfileCodeActionFactory.createConfigurationUpdateCodeAction(codeActionTitle, commandTitle, UNASSIGNED_EXCLUDED_SECTION, editType, item, diagnostic);
        codeAction.setData((Object)new CodeActionData(MicroProfileCodeActionId.IgnoreUnknownProperty));
        return codeAction;
    }

    public static CodeAction createAddToUnknownExcludedCodeAction(String item, Diagnostic diagnostic) {
        String codeActionTitle = MessageFormat.format(UNKNOWN_EXCLUDE_CODE_ACTION_TITLE, item);
        String commandTitle = MessageFormat.format(UNKNOWN_EXCLUDE_COMMAND_TITLE, item);
        ConfigurationItemEditType editType = ConfigurationItemEditType.add;
        CodeAction codeAction = MicroProfileCodeActionFactory.createConfigurationUpdateCodeAction(codeActionTitle, commandTitle, UNKNOWN_EXCLUDED_SECTION, editType, item, diagnostic);
        codeAction.setData((Object)new CodeActionData(MicroProfileCodeActionId.IgnoreUnknownProperty));
        return codeAction;
    }

    private static CodeAction createConfigurationUpdateCodeAction(String codeActionTitle, String commandTitle, String section, ConfigurationItemEditType editType, String item, Diagnostic diagnostic) {
        CodeAction updateCodeAction = new CodeAction(codeActionTitle);
        ConfigurationItemEdit configItemEdit = new ConfigurationItemEdit(section, editType, item);
        Command command = new Command(commandTitle, "microprofile.command.configuration.update", Collections.singletonList(configItemEdit));
        updateCodeAction.setCommand(command);
        updateCodeAction.setKind("quickfix");
        updateCodeAction.setDiagnostics(Collections.singletonList(diagnostic));
        return updateCodeAction;
    }
}

