/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.AbstractPartialRegionElementAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.runtime.evaluation.AbstractDispatch;

public abstract class AbstractPartialRegionClassAnalysis<PRA extends PartialRegionsAnalysis<@NonNull PRA>>
extends AbstractPartialRegionElementAnalysis<PRA>
implements PartialRegionClassAnalysis<PRA> {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ClassDatum classDatum;
    private @NonNull List<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> subClassAnalyses = new ArrayList<PartialRegionClassAnalysis<PRA>>();
    private @NonNull List<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> superClassAnalyses = new ArrayList<PartialRegionClassAnalysis<PRA>>();
    private @Nullable Boolean isDispatcher = null;
    private @Nullable List<@NonNull Property> discriminatingProperties = null;

    protected AbstractPartialRegionClassAnalysis(@NonNull ScheduleManager scheduleManager, @NonNull ClassDatum classDatum) {
        this.scheduleManager = scheduleManager;
        this.classDatum = classDatum;
        this.subClassAnalyses.add(this);
        this.superClassAnalyses.add(this);
    }

    @Override
    public void addSubClassAnalysis(@NonNull PartialRegionClassAnalysis<@NonNull PRA> classAnalysis) {
        if (!this.subClassAnalyses.contains(classAnalysis)) {
            this.subClassAnalyses.add(classAnalysis);
        }
    }

    @Override
    public void addSuperClassAnalysis(@NonNull PartialRegionClassAnalysis<@NonNull PRA> classAnalysis) {
        if (!this.superClassAnalyses.contains(classAnalysis)) {
            this.superClassAnalyses.add(classAnalysis);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void discriminate() throws CompilerChainException {
        if (this.producers.size() <= 1 || this.consumers.size() <= 1) {
            TransformationPartitioner.DISCRIMINATION.println("Not required for " + this);
            return;
        }
        HashMap<@NonNull @NonNull PartialRegionAnalysis, @NonNull HashMap<@NonNull K, @NonNull V>> partitioner2property2edge = new HashMap();
        HashSet<@NonNull E> commonProperties = null;
        for (PartialRegionAnalysis producer : this.producers) {
            HashMap<@NonNull Property, @NonNull NavigationEdge> property2edge = new HashMap<Property, NavigationEdge>();
            partitioner2property2edge.put(producer, property2edge);
            for (Node traceNode : producer.getTraceNodes()) {
                for (Iterator<Object> edge : QVTscheduleUtil.getOutgoingEdges((Node)traceNode)) {
                    NavigationEdge navigationEdge;
                    if (!edge.isRealized() || !edge.isNavigation() || (navigationEdge = (NavigationEdge)edge).getEdgeTarget().isRealized()) continue;
                    property2edge.put(QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge), navigationEdge);
                }
            }
            Set partionerProperties = property2edge.keySet();
            if (commonProperties == null) {
                commonProperties = new HashSet(partionerProperties);
                continue;
            }
            commonProperties.retainAll(partionerProperties);
        }
        if (commonProperties == null || commonProperties.isEmpty()) {
            TransformationPartitioner.DISCRIMINATION.println("No common properties to disambiguate " + this);
            return;
        }
        ArrayList<@NonNull E> sortedProperties = new ArrayList(commonProperties);
        Collections.sort(sortedProperties, NameUtil.NAMEABLE_COMPARATOR);
        HashMap<@NonNull Property, @Nullable HashMap<@Nullable K, @NonNull @NonNull @NonNull V>> property2classDatum2regionAnalyses = new HashMap();
        for (Property property : sortedProperties) {
            for (PartialRegionAnalysis producer : this.producers) {
                Node targetNode;
                ClassDatum classDatum;
                ArrayList<PartialRegionAnalysis> regionAnalyses;
                @NonNull @NonNull Map property2edge = (Map)partitioner2property2edge.get(producer);
                assert (property2edge != null);
                NavigableEdge edge = (NavigableEdge)property2edge.get(property);
                if (edge == null) {
                    property2classDatum2regionAnalyses.put(property, null);
                    continue;
                }
                HashMap<@Nullable ClassDatum, @NonNull ArrayList<@NonNull @NonNull PartialRegionAnalysis>> classDatum2regionAnalyses = (HashMap<ClassDatum, ArrayList<PartialRegionAnalysis>>)property2classDatum2regionAnalyses.get(property);
                if (classDatum2regionAnalyses == null) {
                    classDatum2regionAnalyses = new HashMap<ClassDatum, ArrayList<PartialRegionAnalysis>>();
                    property2classDatum2regionAnalyses.put(property, classDatum2regionAnalyses);
                }
                if ((regionAnalyses = (ArrayList<PartialRegionAnalysis>)classDatum2regionAnalyses.get(classDatum = (targetNode = QVTscheduleUtil.getTargetNode((Edge)edge)).isNullLiteral() ? null : targetNode.getClassDatum())) == null) {
                    regionAnalyses = new ArrayList<PartialRegionAnalysis>();
                    classDatum2regionAnalyses.put(classDatum, regionAnalyses);
                }
                regionAnalyses.add(producer);
            }
        }
        int bestSize = 0;
        Property bestProperty = null;
        for (Property property : property2classDatum2regionAnalyses.keySet()) {
            int size;
            @Nullable @NonNull @NonNull @NonNull Map classDatum2regionAnalyses = (Map)property2classDatum2regionAnalyses.get(property);
            if (classDatum2regionAnalyses == null || (size = classDatum2regionAnalyses.size()) <= bestSize) continue;
            bestSize = size;
            bestProperty = property;
        }
        if (TransformationPartitioner.DISCRIMINATION.isActive()) {
            StringBuilder s = new StringBuilder();
            s.append("property->classDatum->regionAnalyses");
            for (Property property : property2classDatum2regionAnalyses.keySet()) {
                s.append("\n\t" + property);
                @Nullable @NonNull @NonNull @NonNull Map classDatum2regionAnalyses = (Map)property2classDatum2regionAnalyses.get(property);
                if (classDatum2regionAnalyses == null) continue;
                for (ClassDatum classDatum : classDatum2regionAnalyses.keySet()) {
                    s.append("\n\t\t" + classDatum);
                    @NonNull @NonNull List regionAnalyses = (List)classDatum2regionAnalyses.get(classDatum);
                    assert (regionAnalyses != null);
                    for (PartialRegionAnalysis regionAnalysis : regionAnalyses) {
                        s.append("\n\t\t\t" + regionAnalysis);
                    }
                }
            }
            TransformationPartitioner.DISCRIMINATION.println(s.toString());
        }
        if (bestProperty != null) {
            TransformationPartitioner.DISCRIMINATION.println("Best property : " + bestProperty);
            this.discriminatingProperties = Collections.singletonList(bestProperty);
            return;
        }
        throw new CompilerChainException("Unable to disambiguate " + this, new Object[0]);
    }

    @Override
    public @NonNull ClassDatum getClassDatum() {
        return this.classDatum;
    }

    @Override
    public @NonNull Iterable<@NonNull PartialRegionAnalysis<@NonNull PRA>> getCompatibleProducers() {
        return this.producers;
    }

    @Override
    public @Nullable Iterable<@NonNull Property> getDiscriminatingProperties() {
        return this.discriminatingProperties;
    }

    public String getName() {
        return this.classDatum.getName();
    }

    @Override
    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    @Override
    public @NonNull Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> getSubClassAnalyses() {
        return this.subClassAnalyses;
    }

    @Override
    public @NonNull Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> getSuperClassAnalyses() {
        return this.superClassAnalyses;
    }

    public boolean isDispatcher() {
        Boolean isDispatcher2 = this.isDispatcher;
        if (isDispatcher2 == null) {
            String abstractDispatchClassName = AbstractDispatch.class.getName();
            for (Class superClass : QVTbaseUtil.getSuperClasses((Class)this.classDatum.getPrimaryClass())) {
                if (!abstractDispatchClassName.equals(superClass.getInstanceClassName())) continue;
                isDispatcher2 = this.isDispatcher = Boolean.valueOf(true);
                return isDispatcher2;
            }
            isDispatcher2 = this.isDispatcher = Boolean.valueOf(false);
        }
        return isDispatcher2;
    }

    public String toString() {
        return this.classDatum.toString();
    }
}

