/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.format;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.qvt.declarative.editor.ui.format.IFormatHelper;
import org.eclipse.qvt.declarative.editor.ui.format.IFormatManager;
import org.eclipse.qvt.declarative.editor.ui.format.IFormatResult;
import org.eclipse.qvt.declarative.editor.ui.format.IFormatSelf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFormatManager
implements IFormatManager {
    private Map<Class<?>, IFormatHelper<?>> map = new HashMap();

    @Override
    public <T> void format(IFormatResult s, T object) {
        if (object == null) {
            s.append("<null-Object>");
            return;
        }
        Boolean showClassName = s.getOption(IFormatResult.SHOW_CLASS_NAME);
        if (showClassName != null && showClassName.booleanValue()) {
            s.append(object.getClass().getName());
            s.append(" ");
        } else {
            Boolean showClassSimpleName = s.getOption(IFormatResult.SHOW_CLASS_SIMPLE_NAME);
            if (showClassSimpleName != null && showClassSimpleName.booleanValue()) {
                s.append(object.getClass().getSimpleName());
                s.append(" ");
            }
        }
        if (object instanceof IFormatSelf) {
            ((IFormatSelf)object).format(s);
            return;
        }
        this.subformat(s, object);
    }

    @Override
    public IFormatHelper<?> get(Class<?> formattedClass) {
        return this.map.get(formattedClass);
    }

    protected IFormatHelper<?> getFormatHelper(Class<?> cls) {
        IFormatHelper<?> methodCall;
        Class<?> iCls;
        Class<?> sCls = cls;
        while (sCls != null) {
            IFormatHelper<?> methodCall2 = this.map.get(sCls);
            if (methodCall2 != null) {
                return methodCall2;
            }
            sCls = sCls.getSuperclass();
        }
        Class<?>[] classArray = cls.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            iCls = classArray[n2];
            methodCall = this.map.get(iCls);
            if (methodCall != null) {
                return methodCall;
            }
            ++n2;
        }
        classArray = cls.getInterfaces();
        n = classArray.length;
        n2 = 0;
        while (n2 < n) {
            iCls = classArray[n2];
            methodCall = this.getFormatHelper(iCls);
            if (methodCall != null) {
                return methodCall;
            }
            ++n2;
        }
        sCls = cls.getSuperclass();
        if (sCls != null) {
            return this.getFormatHelper(sCls);
        }
        return null;
    }

    @Override
    public void install(IFormatHelper<?> debugClass) {
        this.map.put(debugClass.getFormattedClass(), debugClass);
    }

    @Override
    public <T> void subformat(IFormatResult s, T object) {
        if (object == null) {
            s.append("<null-Object>");
            return;
        }
        IFormatHelper<?> formatHelper = this.map.get(object.getClass());
        if (formatHelper == null && (formatHelper = this.getFormatHelper(object.getClass())) != null) {
            this.map.put(object.getClass(), formatHelper);
        }
        if (formatHelper != null) {
            IFormatHelper<?> castFormatHelper = formatHelper;
            castFormatHelper.format(s, object);
            return;
        }
        this.getFormatHelper(object.getClass());
        s.append("<unknown-");
        s.append(object.getClass().getSimpleName());
        s.append(" ");
        s.append(object.toString());
        s.append(">");
    }
}

