/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal.reporting;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ide.runtime.impl.namespace.OSGiQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.Activator;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.reporting.HtmlReportGenerator;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Benchmark;
import org.osgi.framework.Bundle;

public class HtmlReportGeneratorEclipse
extends HtmlReportGenerator {
    private final List<EObject> values;

    public HtmlReportGeneratorEclipse(IFile selected, String target) {
        super(Collections.singletonList(URI.createFileURI((String)selected.getLocation().toString()).toString()), target);
        this.values = null;
    }

    public HtmlReportGeneratorEclipse(Benchmark selected, String target) {
        super(Collections.emptyList(), target);
        this.values = Collections.singletonList(selected);
    }

    @Override
    protected List<EObject> getValues(IQualifiedNameQueryEnvironment queryEnvironment, Map<EClass, List<EObject>> valuesCache, TypeLiteral type, ResourceSet resourceSetForModels, List<Resource> modelResources, Monitor monitor) {
        List<EObject> res = this.values != null ? this.values : super.getValues(queryEnvironment, valuesCache, type, resourceSetForModels, modelResources, monitor);
        return res;
    }

    @Override
    protected void standaloneInitialization(ResourceSet resourceSetForModels) {
    }

    @Override
    protected IQualifiedNameResolver createResolver() {
        String bundleIdentifier = "org.eclipse.modisco.infra.discovery.benchmark.core";
        Bundle bundle = Platform.getBundle((String)"org.eclipse.modisco.infra.discovery.benchmark.core");
        if (bundle == null || bundle.getState() == 1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass(), "The Bundle org.eclipse.modisco.infra.discovery.benchmark.core must be available in the target platform."));
        }
        return new OSGiQualifiedNameResolver(bundle, EPackage.Registry.INSTANCE, "::");
    }

    @Override
    public void generate(Monitor monitor) {
        if (this.target != null) {
            super.generate(monitor);
        }
    }

    @Override
    protected void printDiagnostics(GenerationResult generationResult) {
        if (generationResult.getDiagnostic().getSeverity() > 1) {
            this.printDiagnostic(generationResult.getDiagnostic());
        }
        this.printSummary(generationResult);
    }

    protected void printDiagnostic(Diagnostic diagnostic) {
        if (diagnostic.getMessage() != null) {
            String location = !diagnostic.getData().isEmpty() && diagnostic.getData().get(0) instanceof ASTNode ? String.valueOf(AcceleoUtil.getLocation((ASTNode)((ASTNode)diagnostic.getData().get(0)))) + ": " : "";
            switch (diagnostic.getSeverity()) {
                case 1: {
                    Activator.getDefault().getLog().log((IStatus)new Status(1, diagnostic.getSource(), String.valueOf(location) + diagnostic.getMessage(), diagnostic.getException()));
                    break;
                }
                case 2: {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, diagnostic.getSource(), String.valueOf(location) + diagnostic.getMessage(), diagnostic.getException()));
                    break;
                }
                case 4: {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, diagnostic.getSource(), String.valueOf(location) + diagnostic.getMessage(), diagnostic.getException()));
                }
            }
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            this.printDiagnostic(child);
        }
    }

    protected void printSummary(GenerationResult result) {
        int nbErrors = 0;
        int nbWarnings = 0;
        int nbInfos = 0;
        for (Diagnostic diagnostic : result.getDiagnostic().getChildren()) {
            switch (diagnostic.getSeverity()) {
                case 4: {
                    ++nbErrors;
                    break;
                }
                case 2: {
                    ++nbWarnings;
                    break;
                }
                case 1: {
                    ++nbInfos;
                    break;
                }
            }
        }
        String message = "Files: " + result.getGeneratedFiles().size() + ", Lost Files: " + result.getLostFiles().size() + ", Errors: " + nbErrors + ", Warnings: " + nbWarnings + ", Infos: " + nbInfos + ".";
        Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass(), message));
    }

    @Override
    protected void afterGeneration(GenerationResult generationResult) {
        super.afterGeneration(generationResult);
        File targetFolder = new File(this.target);
        IContainer targetWorkspaceContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(targetFolder.getAbsolutePath()));
        if (targetWorkspaceContainer != null) {
            try {
                targetWorkspaceContainer.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.modisco.infra.discovery.benchmark.collab", "could not refresh " + targetWorkspaceContainer.getFullPath(), (Throwable)e));
            }
        }
    }
}

