/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.sort;

import prefuse.Visualization;
import prefuse.visual.AggregateItem;
import prefuse.visual.DecoratorItem;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;
import prefuse.visual.sort.ItemSorter;

public class TreeDepthItemSorter
extends ItemSorter {
    protected static final int AGGREGATE = 0;
    protected static final int EDGE = 1;
    protected static final int ITEM = 2;
    protected static final int NODE = 3;
    protected static final int DECORATOR = 4;
    private int m_childrenAbove;
    private int m_hover;
    private int m_highlight;
    private int m_depth;

    public TreeDepthItemSorter() {
        this(false);
    }

    public TreeDepthItemSorter(boolean childrenAbove) {
        if (childrenAbove) {
            this.m_childrenAbove = 1;
            this.m_hover = 13;
            this.m_highlight = 12;
            this.m_depth = 14;
        } else {
            this.m_childrenAbove = -1;
            this.m_hover = 24;
            this.m_highlight = 23;
            this.m_depth = 12;
        }
    }

    public int score(VisualItem item) {
        int type = 2;
        if (item instanceof EdgeItem) {
            type = 1;
        } else if (item instanceof AggregateItem) {
            type = 0;
        } else if (item instanceof DecoratorItem) {
            type = 4;
        }
        int score = 1 << 25 + type;
        if (item instanceof NodeItem) {
            int depth = ((NodeItem)item).getDepth();
            score += this.m_childrenAbove * (depth << this.m_depth);
        }
        if (item.isHover()) {
            score += 1 << this.m_hover;
        }
        if (item.isHighlighted()) {
            score += 1 << this.m_highlight;
        }
        if (item.isInGroup(Visualization.FOCUS_ITEMS)) {
            score += 2048;
        }
        if (item.isInGroup(Visualization.SEARCH_ITEMS)) {
            score += 1024;
        }
        return score;
    }
}

