package prefuse.util.collections;

import java.util.NoSuchElementException;

/**
 * IntIterator implementation that combines the results of multiple
 * int iterators.
 * 
 * @author <a href="http://jheer.org">jeffrey heer</a>
 */
public class CompositeIntIterator extends IntIterator {

    private IntIterator[] m_iters;
    private int m_cur;
    
    public CompositeIntIterator(IntIterator iter1, IntIterator iter2) {
        this(new IntIterator[] { iter1, iter2 });
    }
    
    public CompositeIntIterator(IntIterator[] iters) {
        this.m_iters = iters;
        this.m_cur = 0;
    }
    
    /**
     * @see prefuse.util.collections.IntIterator#nextInt()
     */
    public int nextInt() {
        if ( hasNext() ) {
            return this.m_iters[this.m_cur].nextInt();
        } else {
            throw new NoSuchElementException();
        }
    }

    /**
     * @see java.util.Iterator#hasNext()
     */
    public boolean hasNext() {
        if ( this.m_iters == null )
            return false;
        
        while ( true ) {
            if ( this.m_iters[this.m_cur].hasNext() ) {
                return true;
            } else if ( ++this.m_cur >= this.m_iters.length ) {
                this.m_iters = null;
                return false;
            }
        }
    }
    
    public void remove() {
        throw new UnsupportedOperationException();
    }

} // end of class CompositeIntIterator
