/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.drivers.mdr4atl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2m.atl.drivers.mdr4atl.ASMMDRModel;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class AtlMDRModelHandler
extends AtlModelHandler {
    private ASMMDRModel atlmm;
    private ASMMDRModel mofmm;
    static /* synthetic */ Class class$0;

    public void saveModel(ASMModel model, IProject project) {
        this.saveModel(model, String.valueOf(model.getName()) + ".xmi", project);
    }

    public void saveModel(ASMModel model, String fileName, IProject project) {
        IFile file = project.getFile(fileName);
        this.saveModel(model, file);
    }

    public void saveModel(ASMModel model, String uri) {
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri));
            this.saveModel(model, file);
        }
        catch (Throwable throwable) {
            try {
                ((ASMMDRModel)model).save(uri);
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, ioe.getLocalizedMessage(), ioe);
            }
        }
    }

    private void saveModel(final ASMModel model, IFile file) {
        try {
            PipedInputStream in = new PipedInputStream();
            final PipedOutputStream out = new PipedOutputStream(in);
            new Thread(){

                public void run() {
                    AtlMDRModelHandler.this.saveModel(model, out);
                }
            }.start();
            if (file.exists()) {
                file.setContents((InputStream)in, 1, null);
            } else {
                file.create((InputStream)in, 1, null);
            }
            file.setDerived(true);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public void saveModel(ASMModel model, OutputStream out) {
        try {
            ((ASMMDRModel)model).save(out);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public ASMModel getAtl() {
        return this.atlmm;
    }

    public ASMModel getMof() {
        return this.mofmm;
    }

    public ASMModel loadModel(String name, ASMModel metamodel, InputStream in) {
        ASMMDRModel ret = null;
        try {
            ret = ASMMDRModel.loadASMMDRModel(name, (ASMMDRModel)metamodel, in, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public ASMModel newModel(String name, ASMModel metamodel) {
        ASMMDRModel ret = null;
        try {
            ret = ASMMDRModel.newASMMDRModel(name, (ASMMDRModel)metamodel, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public ASMModel newModel(String name, String uri, ASMModel metamodel) {
        ASMMDRModel ret = null;
        try {
            ret = ASMMDRModel.newASMMDRModel(name, uri, (ASMMDRModel)metamodel, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }

    public AtlMDRModelHandler() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.m2m.atl.drivers.mdr4atl.AtlMDRModelHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL atlurl = clazz.getResource("resources/ATL-0.2.xmi");
        this.mofmm = ASMMDRModel.createMOF(null);
        try {
            this.atlmm = ASMMDRModel.loadASMMDRModel("ATL", this.mofmm, atlurl, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public ASMModel getBuiltInMetaModel(String name) {
        ASMModel ret = null;
        return ret;
    }

    public boolean isHandling(ASMModel model) {
        return model instanceof ASMMDRModel;
    }

    public void disposeOfModel(ASMModel model) {
        ((ASMMDRModel)model).dispose();
    }
}

