/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractFallibilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicFallibilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.FallibilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.LoadingPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.SelfCyclicFallibilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseHelper;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleConstants;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class PartitionedTransformationAnalysis
extends QVTbaseHelper
implements Nameable {
    protected final @NonNull TransformationPartitioner transformationPartitioner;
    protected final @NonNull ScheduleManager scheduleManager;
    private final @NonNull Map<@NonNull ClassDatum, @NonNull TraceClassPartitionAnalysis> classDatum2traceClassAnalysis = new HashMap<ClassDatum, TraceClassPartitionAnalysis>();
    private final @NonNull Map<@NonNull PropertyDatum, @NonNull TracePropertyPartitionAnalysis> propertyDatum2tracePropertyAnalysis = new HashMap<PropertyDatum, TracePropertyPartitionAnalysis>();
    private final @NonNull Map<@NonNull Partition, @NonNull AbstractPartitionAnalysis<?>> partition2partitionAnalysis = new HashMap();
    private final @NonNull Map<@NonNull Partition, @NonNull AbstractFallibilityAnalysis> partition2fallibilityAnalysis = new HashMap<Partition, AbstractFallibilityAnalysis>();
    private @Nullable RootPartitionAnalysis rootPartitionAnalysis = null;
    private @Nullable Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2predicatedEdges = null;
    private @Nullable Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges = null;

    public PartitionedTransformationAnalysis(@NonNull TransformationPartitioner transformationPartitioner) {
        super(transformationPartitioner.getScheduleManager().getEnvironmentFactory());
        this.transformationPartitioner = transformationPartitioner;
        this.scheduleManager = transformationPartitioner.getScheduleManager();
    }

    public void addCheckedEdge(@NonNull TypedModel typedModel, @NonNull NavigationEdge predicatedEdge) {
        List<NavigableEdge> predicatedEdges;
        Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2predicatedEdges2 = this.typedModel2property2predicatedEdges;
        assert (typedModel2property2predicatedEdges2 != null);
        Property property = QVTscheduleUtil.getProperty((NavigableEdge)predicatedEdge);
        Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>> property2predicatedEdges = typedModel2property2predicatedEdges2.get(typedModel);
        if (property2predicatedEdges == null) {
            property2predicatedEdges = new HashMap<Property, List<NavigableEdge>>();
            typedModel2property2predicatedEdges2.put(typedModel, property2predicatedEdges);
        }
        if ((predicatedEdges = property2predicatedEdges.get(property)) == null) {
            predicatedEdges = new ArrayList<NavigableEdge>();
            property2predicatedEdges.put(property, predicatedEdges);
        }
        predicatedEdges.add((NavigableEdge)predicatedEdge);
        QVTscheduleConstants.POLLED_PROPERTIES.println("  " + typedModel + " predicated for " + property);
    }

    public @NonNull TraceClassPartitionAnalysis addConsumer(@NonNull ClassDatum classDatum, @NonNull PartitionAnalysis consumer) {
        TraceClassPartitionAnalysis traceClassAnalysis = this.lazyCreateTraceClassAnalysis(classDatum);
        traceClassAnalysis.addConsumer(consumer);
        return traceClassAnalysis;
    }

    public @NonNull TracePropertyPartitionAnalysis addConsumer(@NonNull PropertyDatum tracePropertyDatum, @NonNull PartitionAnalysis consumer) {
        TracePropertyPartitionAnalysis tracePropertyAnalysis = this.lazyCreateTracePropertyAnalysis(tracePropertyDatum);
        tracePropertyAnalysis.addConsumer(consumer);
        return tracePropertyAnalysis;
    }

    public void addPartitionAnalysis(@NonNull AbstractPartitionAnalysis<?> partitionAnalysis) {
        this.partition2partitionAnalysis.put((Partition)partitionAnalysis.getPartition(), partitionAnalysis);
    }

    public @NonNull TraceClassPartitionAnalysis addProducer(@NonNull ClassDatum classDatum, @NonNull PartitionAnalysis producer) {
        TraceClassPartitionAnalysis traceClassAnalysis = this.lazyCreateTraceClassAnalysis(classDatum);
        traceClassAnalysis.addProducer(producer);
        return traceClassAnalysis;
    }

    public @NonNull TracePropertyPartitionAnalysis addProducer(@NonNull PropertyDatum tracePropertyDatum, @NonNull PartitionAnalysis producer) {
        TracePropertyPartitionAnalysis tracePropertyAnalysis = this.lazyCreateTracePropertyAnalysis(tracePropertyDatum);
        tracePropertyAnalysis.addProducer(producer);
        return tracePropertyAnalysis;
    }

    public void addRealizedEdge(@NonNull TypedModel typedModel, @NonNull NavigationEdge realizedEdge) {
        List<NavigableEdge> realizedEdges;
        Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges2 = this.typedModel2property2realizedEdges;
        assert (typedModel2property2realizedEdges2 != null);
        Property property = QVTscheduleUtil.getProperty((NavigableEdge)realizedEdge);
        Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>> property2realizedEdges = typedModel2property2realizedEdges2.get(typedModel);
        if (property2realizedEdges == null) {
            property2realizedEdges = new HashMap<Property, List<NavigableEdge>>();
            typedModel2property2realizedEdges2.put(typedModel, property2realizedEdges);
        }
        if ((realizedEdges = property2realizedEdges.get(property)) == null) {
            realizedEdges = new ArrayList<NavigableEdge>();
            property2realizedEdges.put(property, realizedEdges);
        }
        realizedEdges.add((NavigableEdge)realizedEdge);
        QVTscheduleConstants.POLLED_PROPERTIES.println("  " + typedModel + " realized for " + property);
    }

    public void analyzeFallibilities(@NonNull RootPartitionAnalysis rootPartitionAnalysis) {
        for (PartitionAnalysis nestedPartitionAnalysis : rootPartitionAnalysis.getPartitionAnalyses()) {
            if (nestedPartitionAnalysis instanceof CyclicPartitionAnalysis) {
                this.analyzeFallibilities((CyclicPartitionAnalysis)nestedPartitionAnalysis);
                continue;
            }
            if (nestedPartitionAnalysis instanceof LoadingPartitionAnalysis || nestedPartitionAnalysis instanceof MappingPartitionAnalysis) continue;
            throw new UnsupportedOperationException();
        }
    }

    protected @NonNull AbstractFallibilityAnalysis analyzeFallibilities(@NonNull CyclicPartitionAnalysis partitionAnalysis) {
        Iterable<@NonNull PartitionAnalysis> partitionAnalyses = partitionAnalysis.getPartitionAnalyses();
        if (Iterables.size(partitionAnalyses) == 1) {
            PartitionAnalysis nestedPartitionAnalysis = partitionAnalyses.iterator().next();
            if (nestedPartitionAnalysis instanceof CyclicPartitionAnalysis) {
                return this.analyzeFallibilities((CyclicPartitionAnalysis)nestedPartitionAnalysis);
            }
            assert (nestedPartitionAnalysis instanceof MappingPartitionAnalysis);
            return this.getFallibilityAnalysis(nestedPartitionAnalysis.getPartition());
        }
        CyclicFallibilityAnalysis cyclicFallibilityAnalysis = new CyclicFallibilityAnalysis(partitionAnalysis);
        for (PartitionAnalysis nestedPartitionAnalysis : partitionAnalyses) {
            if (nestedPartitionAnalysis instanceof CyclicPartitionAnalysis) {
                AbstractFallibilityAnalysis nestedFallibilityAnalysis = this.analyzeFallibilities((CyclicPartitionAnalysis)nestedPartitionAnalysis);
                cyclicFallibilityAnalysis.analyze(nestedFallibilityAnalysis);
                continue;
            }
            assert (nestedPartitionAnalysis instanceof MappingPartitionAnalysis);
            Partition nestedPartition = nestedPartitionAnalysis.getPartition();
            FallibilityAnalysis fallibilityAnalysis = this.partition2fallibilityAnalysis.get(nestedPartition);
            assert (fallibilityAnalysis == null);
            cyclicFallibilityAnalysis.analyze(nestedPartitionAnalysis);
            FallibilityAnalysis oldFallibilityAnalysis = this.partition2fallibilityAnalysis.put(nestedPartition, cyclicFallibilityAnalysis);
            assert (oldFallibilityAnalysis == null);
        }
        cyclicFallibilityAnalysis.analyze();
        return cyclicFallibilityAnalysis;
    }

    public void analyzePartitionEdges(@NonNull Iterable<@NonNull Concurrency> partitionSchedule) {
        this.typedModel2property2predicatedEdges = new HashMap<TypedModel, Map<Property, List<NavigableEdge>>>();
        this.typedModel2property2realizedEdges = new HashMap<TypedModel, Map<Property, List<NavigableEdge>>>();
        for (Concurrency concurrency : partitionSchedule) {
            for (PartitionAnalysis partitionAnalysis : concurrency) {
                Partition partition = partitionAnalysis.getPartition();
                QVTscheduleConstants.POLLED_PROPERTIES.println("building indexes for " + partition + " " + partition.getPassRangeText());
                partitionAnalysis.analyzePartitionEdges();
            }
        }
    }

    public void analyzePartitions(@NonNull Iterable<@NonNull PartitionAnalysis> partitionAnalyses) {
        for (PartitionAnalysis partitionAnalysis : partitionAnalyses) {
            ((AbstractPartitionAnalysis)partitionAnalysis).analyzePartition();
        }
        for (PartitionAnalysis partitionAnalysis : partitionAnalyses) {
            ((AbstractPartitionAnalysis)partitionAnalysis).analyzePartition2();
        }
    }

    public void computeCheckedOrEnforcedEdges(@NonNull List<@NonNull Concurrency> mergedPartitionSchedule) {
        Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges2 = this.typedModel2property2realizedEdges;
        assert (typedModel2property2realizedEdges2 != null);
        for (Concurrency concurrency : mergedPartitionSchedule) {
            for (PartitionAnalysis partitionAnalysis : concurrency) {
                partitionAnalysis.computeCheckedOrEnforcedEdges();
            }
        }
    }

    protected void computeTraceClassDiscrimination() throws CompilerChainException {
        for (TraceClassPartitionAnalysis traceClassAnalysis : this.classDatum2traceClassAnalysis.values()) {
            traceClassAnalysis.discriminate();
        }
    }

    public void computeTraceClassInheritance() {
        TraceClassPartitionAnalysis superTraceClassRegionAnalysis;
        ClassDatum classDatum;
        HashSet<@NonNull ClassDatum> missingClassDatums = new HashSet<ClassDatum>();
        for (TraceClassPartitionAnalysis subTraceClassRegionAnalysis : this.classDatum2traceClassAnalysis.values()) {
            classDatum = subTraceClassRegionAnalysis.getClassDatum();
            for (ClassDatum superClassDatum : QVTscheduleUtil.getSuperClassDatums((ClassDatum)classDatum)) {
                if (superClassDatum == classDatum || (superTraceClassRegionAnalysis = this.classDatum2traceClassAnalysis.get(superClassDatum)) != null) continue;
                missingClassDatums.add(superClassDatum);
            }
        }
        for (ClassDatum missingClassDatum : missingClassDatums) {
            this.lazyCreateTraceClassAnalysis(missingClassDatum);
        }
        for (TraceClassPartitionAnalysis subTraceClassRegionAnalysis : this.classDatum2traceClassAnalysis.values()) {
            classDatum = subTraceClassRegionAnalysis.getClassDatum();
            for (ClassDatum superClassDatum : QVTscheduleUtil.getSuperClassDatums((ClassDatum)classDatum)) {
                if (superClassDatum == classDatum) continue;
                superTraceClassRegionAnalysis = this.classDatum2traceClassAnalysis.get(superClassDatum);
                assert (superTraceClassRegionAnalysis != null);
                superTraceClassRegionAnalysis.addSubTraceClassAnalysis(subTraceClassRegionAnalysis);
                subTraceClassRegionAnalysis.addSuperTraceClassAnalysis(superTraceClassRegionAnalysis);
            }
        }
    }

    protected @NonNull TraceClassPartitionAnalysis createTraceClassAnalysis(@NonNull ClassDatum traceClassDatum) {
        return new TraceClassPartitionAnalysis(this.transformationPartitioner.getTransformationAnalysis().getTraceClassAnalysis(traceClassDatum));
    }

    protected @NonNull TracePropertyPartitionAnalysis createTracePropertyAnalysis(@NonNull TraceClassPartitionAnalysis traceClassAnalysis, @NonNull PropertyDatum tracePropertyDatum) {
        return new TracePropertyPartitionAnalysis(this.transformationPartitioner, traceClassAnalysis, tracePropertyDatum);
    }

    public @NonNull AbstractFallibilityAnalysis getFallibilityAnalysis(@NonNull Partition partition) {
        AbstractFallibilityAnalysis fallibilityAnalysis = this.partition2fallibilityAnalysis.get(partition);
        if (fallibilityAnalysis == null) {
            AbstractPartitionAnalysis<?> partitionAnalysis = this.getPartitionAnalysis(partition);
            fallibilityAnalysis = new SelfCyclicFallibilityAnalysis((MappingPartitionAnalysis)partitionAnalysis);
        }
        return fallibilityAnalysis;
    }

    public String getName() {
        return this.transformationPartitioner.getName();
    }

    public @NonNull AbstractPartitionAnalysis<?> getPartitionAnalysis(@NonNull Partition partition) {
        return (AbstractPartitionAnalysis)ClassUtil.nonNullState(this.partition2partitionAnalysis.get(partition));
    }

    public @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>> getProperty2RealizedEdges(@NonNull TypedModel typedModel) {
        Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges2 = this.typedModel2property2realizedEdges;
        assert (typedModel2property2realizedEdges2 != null);
        return (Map)ClassUtil.nonNullState(typedModel2property2realizedEdges2.get(typedModel));
    }

    public @NonNull RootPartitionAnalysis getRootPartitionAnalysis() {
        return (RootPartitionAnalysis)ClassUtil.nonNullState((Object)this.rootPartitionAnalysis);
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    private @NonNull TraceClassPartitionAnalysis lazyCreateTraceClassAnalysis(@NonNull ClassDatum classDatum) {
        TraceClassPartitionAnalysis traceClassAnalysis = this.classDatum2traceClassAnalysis.get(classDatum);
        if (traceClassAnalysis == null) {
            traceClassAnalysis = this.createTraceClassAnalysis(classDatum);
            this.classDatum2traceClassAnalysis.put(classDatum, traceClassAnalysis);
        }
        return traceClassAnalysis;
    }

    private @NonNull TracePropertyPartitionAnalysis lazyCreateTracePropertyAnalysis(@NonNull PropertyDatum tracePropertyDatum) {
        TracePropertyPartitionAnalysis tracePropertyAnalysis = this.propertyDatum2tracePropertyAnalysis.get(tracePropertyDatum);
        if (tracePropertyAnalysis == null) {
            ClassDatum classDatum = QVTscheduleUtil.getOwningClassDatum((PropertyDatum)tracePropertyDatum);
            TraceClassPartitionAnalysis traceClassAnalysis = this.lazyCreateTraceClassAnalysis(classDatum);
            tracePropertyAnalysis = this.createTracePropertyAnalysis(traceClassAnalysis, tracePropertyDatum);
            this.propertyDatum2tracePropertyAnalysis.put(tracePropertyDatum, tracePropertyAnalysis);
        }
        return tracePropertyAnalysis;
    }

    public void setLoadingRegionAnalysis(@NonNull LoadingPartitionAnalysis loadingPartitionAnalysis) {
        for (ClassDatum classDatum : this.classDatum2traceClassAnalysis.keySet()) {
            TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
            if (!this.scheduleManager.isInput(typedModel)) continue;
            TraceClassPartitionAnalysis classAnalysis = this.classDatum2traceClassAnalysis.get(classDatum);
            assert (classAnalysis != null);
            Iterable<@NonNull PartitionAnalysis> producers = classAnalysis.getProducers();
            if (!Iterables.isEmpty(producers)) continue;
            classAnalysis.addProducer(loadingPartitionAnalysis);
        }
        this.partition2partitionAnalysis.put((Partition)loadingPartitionAnalysis.getPartition(), loadingPartitionAnalysis);
    }

    public void setRootPartitionAnalysis(@NonNull RootPartitionAnalysis rootPartitionAnalysis) {
        this.rootPartitionAnalysis = rootPartitionAnalysis;
        this.partition2partitionAnalysis.put((Partition)rootPartitionAnalysis.getPartition(), rootPartitionAnalysis);
    }
}

