/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xml.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.xml.Attribute;
import org.eclipse.qvtd.xml.Characters;
import org.eclipse.qvtd.xml.ClassAttribute;
import org.eclipse.qvtd.xml.ClassElement;
import org.eclipse.qvtd.xml.Document;
import org.eclipse.qvtd.xml.Element;
import org.eclipse.qvtd.xml.Node;

public class XMLServices {
    private static final @NonNull String XMLNS_PREFIX_COLON = "xmlns:";

    private void gatherElements(@NonNull Node node, List<@NonNull Element> candidates) {
        if (node instanceof Element) {
            candidates.add((Element)node);
        }
        for (Node child : node.getChildren()) {
            if (!(child instanceof Element)) continue;
            this.gatherElements(child, candidates);
        }
    }

    private String getEPackagePrefix(EObject context, @NonNull EPackage ePackage) {
        EObject root = EcoreUtil.getRootContainer((EObject)context);
        if (!(root instanceof Document)) {
            return ePackage.getNsPrefix();
        }
        String nsURI = ePackage.getNsURI();
        if (nsURI == null) {
            return ePackage.getNsPrefix();
        }
        for (Node childNode : ((Document)root).getChildren()) {
            for (Node grandChildNode : childNode.getChildren()) {
                Attribute attribute;
                String prefix;
                if (!(grandChildNode instanceof Attribute) || (prefix = this.getXmlnsPrefix(attribute = (Attribute)grandChildNode)) == null || !nsURI.equals(attribute.getValue())) continue;
                return prefix;
            }
        }
        return ePackage.getNsPrefix();
    }

    private @Nullable String getXmlnsPrefix(@NonNull Attribute attribute) {
        String name = attribute.getName();
        if (name.startsWith(XMLNS_PREFIX_COLON)) {
            return name.substring(XMLNS_PREFIX_COLON.length());
        }
        return null;
    }

    private @Nullable String getXsiType(@NonNull Element element) {
        for (Node node : element.getChildren()) {
            Attribute attribute;
            if (!(node instanceof Attribute) || !this.isXsiType(attribute = (Attribute)node)) continue;
            return attribute.getValue();
        }
        return null;
    }

    private boolean isXsiType(@NonNull Attribute attribute) {
        String name = attribute.getName();
        return "xmi:type".equals(name) || "xsi:type".equals(name);
    }

    public @NonNull String xmlAttributeLabel(EObject context) {
        if (context instanceof Attribute) {
            Attribute attribute = (Attribute)context;
            return String.valueOf(attribute.getName()) + " = " + attribute.getValue();
        }
        return "\u00abxmlAttributeLabel - " + context.getClass().getName() + " - " + context.eClass().getName() + "\u00bb";
    }

    public @NonNull Collection<EObject> xmlAttributeSemanticsCandidatesExpression(EObject context) {
        ArrayList<EObject> candidates = new ArrayList<EObject>();
        if (context instanceof Element) {
            Element element = (Element)context;
            for (Node child : element.getChildren()) {
                if (!(child instanceof Attribute) || child instanceof ClassAttribute || this.isXsiType((Attribute)child)) continue;
                candidates.add(child);
            }
        } else {
            candidates.add(context);
        }
        return candidates;
    }

    public @NonNull String xmlCharactersLabel(EObject context) {
        if (context instanceof Characters) {
            Characters characters = (Characters)context;
            return characters.getData();
        }
        return "\u00abxmlCharactersLabel - " + context.getClass().getName() + " - " + context.eClass().getName() + "\u00bb";
    }

    public @NonNull Collection<EObject> xmlCharactersSemanticsCandidatesExpression(EObject context) {
        ArrayList<EObject> candidates = new ArrayList<EObject>();
        if (context instanceof Element) {
            Element element = (Element)context;
            for (Node child : element.getChildren()) {
                if (!(child instanceof Characters)) continue;
                candidates.add(child);
            }
        } else {
            candidates.add(context);
        }
        return candidates;
    }

    public @NonNull String xmlElement2ElementContainmentBeginLabel(EObject context) {
        if (context instanceof ClassElement) {
            EStructuralFeature eFeature;
            ClassElement parent;
            EClass eClass;
            Element element = (Element)context;
            EObject container = context.eContainer();
            if (container instanceof ClassElement && (eClass = (parent = (ClassElement)container).getEcoreClass()) != null && (eFeature = eClass.getEStructuralFeature(element.getQName())) instanceof EReference) {
                EReference eReference = (EReference)eFeature;
                return eReference.getName();
            }
        } else if (context instanceof Element) {
            Element element = (Element)context;
            return String.valueOf(element.getQName());
        }
        return "";
    }

    public @NonNull String xmlElement2ElementContainmentEndLabel(EObject context) {
        if (context instanceof ClassElement) {
            EReference eReference;
            EReference eOpposite;
            EStructuralFeature eFeature;
            ClassElement parent;
            EClass eClass;
            Element element = (Element)context;
            EObject container = context.eContainer();
            if (container instanceof ClassElement && (eClass = (parent = (ClassElement)container).getEcoreClass()) != null && (eFeature = eClass.getEStructuralFeature(element.getQName())) instanceof EReference && (eOpposite = (eReference = (EReference)eFeature).getEOpposite()) != null) {
                String string = eOpposite.getName();
                if (string.endsWith("appliedProperty")) {
                    this.getClass();
                }
                return string;
            }
        }
        return "";
    }

    public @NonNull Collection<EObject> xmlElement2ElementContainmentTargetFinderExpression(EObject context) {
        ArrayList<EObject> candidates = new ArrayList<EObject>();
        if (context instanceof Element && context.eContainer() instanceof Element) {
            candidates.add(context.eContainer());
        }
        return candidates;
    }

    public @NonNull Collection<EObject> xmlElement2ElementReference1SemanticCandidatesExpression(EObject context) {
        ArrayList<EObject> candidates = new ArrayList<EObject>();
        if (context instanceof Document) {
            ArrayList<Element> elements = new ArrayList<Element>();
            this.gatherElements((Document)context, elements);
            for (Element element : elements) {
                for (Node child : element.getChildren()) {
                    EReference eOpposite;
                    EReference eReference;
                    EList<EObject> eObjects;
                    if (!(child instanceof ClassAttribute) || (eObjects = ((ClassAttribute)child).getEObjects()) == null || (eReference = ((ClassAttribute)child).getEcoreReference()) == null || (eOpposite = eReference.getEOpposite()) != null) continue;
                    candidates.add(child);
                }
            }
        }
        return candidates;
    }

    public @NonNull Collection<EObject> xmlElement2ElementReference2SemanticCandidatesExpression(EObject context) {
        ArrayList<EObject> candidates = new ArrayList<EObject>();
        if (context instanceof Document) {
            ArrayList<Element> elements = new ArrayList<Element>();
            this.gatherElements((Document)context, elements);
            for (Element element : elements) {
                for (Node child : element.getChildren()) {
                    EReference eOpposite;
                    EReference eReference;
                    EList<EObject> eObjects;
                    if (!(child instanceof ClassAttribute) || (eObjects = ((ClassAttribute)child).getEObjects()) == null || (eReference = ((ClassAttribute)child).getEcoreReference()) == null || (eOpposite = eReference.getEOpposite()) == null || System.identityHashCode(eReference) >= System.identityHashCode(eOpposite)) continue;
                    candidates.add(child);
                }
            }
        }
        return candidates;
    }

    public @NonNull String xmlElement2ElementReferenceBeginLabel(EObject context) {
        EReference eReference;
        EReference eOpposite;
        if (context instanceof ClassAttribute && (eOpposite = (eReference = ((ClassAttribute)context).getEcoreReference()).getEOpposite()) != null) {
            return eOpposite.getName();
        }
        return "";
    }

    public @NonNull String xmlElement2ElementReferenceEndLabel(EObject context) {
        if (context instanceof ClassAttribute) {
            EReference eReference = ((ClassAttribute)context).getEcoreReference();
            return eReference.getName();
        }
        return "";
    }

    public @NonNull EObject xmlElement2ElementReferenceSourceFinderExpression(EObject context) {
        return context.eContainer();
    }

    public @NonNull EObject xmlElement2ElementReferenceTargetFinderExpression(EObject context) {
        return (EObject)((ClassAttribute)context).getEObjects().get(0);
    }

    public @NonNull String xmlElementLabel(EObject context) {
        if (context instanceof Element) {
            Element element = (Element)context;
            String xsiType = this.getXsiType(element);
            if (xsiType != null) {
                return xsiType;
            }
            EClassifier eClassifier = element.getEcoreClassifier();
            if (eClassifier != null) {
                return String.valueOf(this.getEPackagePrefix(context, eClassifier.getEPackage())) + ":" + eClassifier.getName();
            }
            return String.valueOf(element.getQName());
        }
        return "\u00abxmlElementLabel - " + context.getClass().getName() + " - " + context.eClass().getName() + "\u00bb";
    }

    public @NonNull Collection<? extends EObject> xmlElementSemanticsCandidatesExpression(EObject context) {
        ArrayList<Element> candidates = new ArrayList<Element>();
        if (context instanceof Document) {
            Document document = (Document)context;
            this.gatherElements(document, candidates);
        }
        return candidates;
    }
}

