/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.IQVTReconcilingListener;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.Messages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.QVTColorManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.QVTSemanticHighlighter;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.SemanticHighlightingManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.SemanticHighlightingPresenter;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.SemanticToken;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

class SemanticHighlightingReconciler
implements IQVTReconcilingListener,
ITextInputListener {
    private PositionCollector fCollector;
    private QvtEditor fEditor;
    private SemanticHighlightingPresenter fPresenter;
    private QVTColorManager.ColorDescriptor[] fSemanticHighlightings;
    private final ArrayList<SemanticHighlightingManager.HighlightedPosition> fAddedPositions = new ArrayList();
    private List<SemanticHighlightingManager.HighlightedPosition> fRemovedPositions = new ArrayList<SemanticHighlightingManager.HighlightedPosition>();
    private int fNOfRemovedPositions;
    private Job fJob;
    private final Object fJobLock = new Object();
    private final Object fReconcileLock = new Object();
    private boolean fIsReconciling = false;
    private SemanticHighlightingPresenter fJobPresenter;
    private QVTColorManager.ColorDescriptor[] fJobSemanticHighlightings;

    @Override
    public void aboutToBeReconciled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconciled(CompiledUnit model, IProgressMonitor progressMonitor) {
        block31: {
            block29: {
                block28: {
                    Object object = this.fReconcileLock;
                    synchronized (object) {
                        if (this.fIsReconciling) {
                            return;
                        }
                        this.fIsReconciling = true;
                    }
                    this.fJobPresenter = this.fPresenter;
                    this.fJobSemanticHighlightings = this.fSemanticHighlightings;
                    if (this.fJobPresenter != null && this.fJobSemanticHighlightings != null) break block28;
                    this.fJobPresenter = null;
                    this.fJobSemanticHighlightings = null;
                    Object object2 = this.fReconcileLock;
                    synchronized (object2) {
                        this.fIsReconciling = false;
                    }
                    return;
                }
                this.fJobPresenter.setCanceled(progressMonitor.isCanceled());
                if (model != null && !this.fJobPresenter.isCanceled()) break block29;
                this.fJobPresenter = null;
                this.fJobSemanticHighlightings = null;
                Object object = this.fReconcileLock;
                synchronized (object) {
                    this.fIsReconciling = false;
                }
                return;
            }
            try {
                try {
                    this.startReconcilingPositions();
                    if (!this.fJobPresenter.isCanceled()) {
                        this.reconcilePositions(model);
                    }
                    TextPresentation textPresentation = null;
                    if (!this.fJobPresenter.isCanceled()) {
                        textPresentation = this.fJobPresenter.createPresentation(this.fAddedPositions, this.fRemovedPositions);
                    }
                    if (!this.fJobPresenter.isCanceled()) {
                        this.updatePresentation(textPresentation, this.fAddedPositions, this.fRemovedPositions);
                    }
                    this.stopReconcilingPositions();
                }
                catch (RuntimeException e) {
                    Activator.log(e);
                    this.fJobPresenter = null;
                    this.fJobSemanticHighlightings = null;
                    Object object = this.fReconcileLock;
                    synchronized (object) {
                        this.fIsReconciling = false;
                        break block31;
                    }
                }
            }
            catch (Throwable throwable) {
                this.fJobPresenter = null;
                this.fJobSemanticHighlightings = null;
                Object object = this.fReconcileLock;
                synchronized (object) {
                    this.fIsReconciling = false;
                }
                throw throwable;
            }
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            Object object = this.fReconcileLock;
            synchronized (object) {
                this.fIsReconciling = false;
            }
        }
    }

    private void startReconcilingPositions() {
        this.fJobPresenter.addAllPositions(this.fRemovedPositions);
        this.fNOfRemovedPositions = this.fRemovedPositions.size();
    }

    private void reconcilePositions(CompiledUnit model) {
        if (model.getUnitCST() == null || this.fCollector == null) {
            return;
        }
        this.fCollector.enumerate(model);
        List<SemanticHighlightingManager.HighlightedPosition> oldPositions = this.fRemovedPositions;
        ArrayList<SemanticHighlightingManager.HighlightedPosition> newPositions = new ArrayList<SemanticHighlightingManager.HighlightedPosition>(this.fNOfRemovedPositions);
        int i = 0;
        int n = oldPositions.size();
        while (i < n) {
            SemanticHighlightingManager.HighlightedPosition current = oldPositions.get(i);
            if (current != null) {
                newPositions.add(current);
            }
            ++i;
        }
        this.fRemovedPositions = newPositions;
    }

    private void updatePresentation(TextPresentation textPresentation, List<SemanticHighlightingManager.HighlightedPosition> addedPositions, List<SemanticHighlightingManager.HighlightedPosition> removedPositions) {
        IWorkbenchPartSite site;
        Runnable runnable = this.fJobPresenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        Display display = null;
        QvtEditor editor = this.fEditor;
        if (editor != null && (site = editor.getSite()) != null) {
            Shell shell = site.getShell();
            if (shell == null || shell.isDisposed()) {
                return;
            }
            display = shell.getDisplay();
        }
        if (display == null) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    private void stopReconcilingPositions() {
        this.fRemovedPositions.clear();
        this.fNOfRemovedPositions = 0;
        this.fAddedPositions.clear();
    }

    public void install(QvtEditor editor, SourceViewer sourceViewer, SemanticHighlightingPresenter presenter, QVTColorManager.ColorDescriptor[] semanticHighlightings) {
        this.fPresenter = presenter;
        this.fSemanticHighlightings = semanticHighlightings;
        this.fEditor = editor;
        this.fCollector = new PositionCollector(new QVTSemanticHighlighter(semanticHighlightings));
        if (this.fEditor != null) {
            this.fEditor.addReconcilingListener(this);
        }
    }

    public void uninstall() {
        if (this.fPresenter != null) {
            this.fPresenter.setCanceled(true);
        }
        if (this.fEditor != null) {
            this.fEditor.removeReconcilingListener(this);
            this.fEditor = null;
        }
        this.fCollector = null;
        this.fSemanticHighlightings = null;
        this.fPresenter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        Object object = this.fJobLock;
        synchronized (object) {
            final Job oldJob = this.fJob;
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
            this.fJob = new Job(Messages.SemanticHighlightingReconciler_JobName0){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    if (oldJob != null) {
                        try {
                            oldJob.join();
                        }
                        catch (InterruptedException e) {
                            Activator.log(e);
                            return Status.CANCEL_STATUS;
                        }
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    CompiledUnit model = SemanticHighlightingReconciler.this.getModel();
                    SemanticHighlightingReconciler.this.reconciled(model, monitor);
                    Object object = SemanticHighlightingReconciler.this.fJobLock;
                    synchronized (object) {
                        if (SemanticHighlightingReconciler.this.fJob == this) {
                            SemanticHighlightingReconciler.this.fJob = null;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.fJob.setSystem(true);
            this.fJob.setPriority(50);
            this.fJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput != null) {
            this.scheduleJob();
        }
    }

    public void refresh() {
        this.scheduleJob();
    }

    protected CompiledUnit getModel() {
        return this.fEditor.getValidCompiledModule(5000L);
    }

    public class PositionCollector {
        private SemanticToken fToken = new SemanticToken();
        private final QVTSemanticHighlighter fHighlighter;

        private PositionCollector(QVTSemanticHighlighter highlighter) {
            this.fHighlighter = highlighter;
            this.fHighlighter.setCollector(this);
        }

        public boolean isEnabled(int highlighting) {
            if (highlighting >= 0 && highlighting < SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length) {
                QVTColorManager.ColorDescriptor semanticHighlighting = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[highlighting];
                QVTColorManager.Highlighting hl = semanticHighlighting.getHighlighting();
                return hl.isEnabled();
            }
            return false;
        }

        private boolean isValidNode(CSTNode node) {
            int offset = node.getStartOffset();
            return offset != 0 || node.eContainer() == null;
        }

        public boolean visitToken(CSTNode node, int highlighting) {
            QVTColorManager.ColorDescriptor semanticColor;
            QVTColorManager.Highlighting hl;
            if (!this.isValidNode(node)) {
                return false;
            }
            this.fToken.update(node, null);
            if (highlighting >= 0 && highlighting < SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length && (hl = (semanticColor = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[highlighting]).getHighlighting()).isEnabled()) {
                int offset = node.getStartOffset();
                int length = node.getEndOffset() - offset + 1;
                if (offset > -1 && length > 0) {
                    this.addPosition(offset, length, hl);
                }
            }
            this.fToken.clear();
            return false;
        }

        public boolean visitToken(CSTNode node, int offset, int length, int highlighting) {
            QVTColorManager.ColorDescriptor semanticColor;
            QVTColorManager.Highlighting hl;
            if (!this.isValidNode(node)) {
                return false;
            }
            this.fToken.update(node, null);
            if (highlighting >= 0 && highlighting < SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length && (hl = (semanticColor = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[highlighting]).getHighlighting()).isEnabled() && offset > -1 && length > 0) {
                this.addPosition(offset, length, hl);
            }
            this.fToken.clear();
            return false;
        }

        public void addPosition(int offset, int length, QVTColorManager.Highlighting highlighting) {
            boolean isExisting = false;
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            while (i < n) {
                SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)SemanticHighlightingReconciler.this.fRemovedPositions.get(i));
                if (position != null && position.isEqual(offset, length, highlighting)) {
                    isExisting = true;
                    SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                    SemanticHighlightingReconciler semanticHighlightingReconciler = SemanticHighlightingReconciler.this;
                    semanticHighlightingReconciler.fNOfRemovedPositions = semanticHighlightingReconciler.fNOfRemovedPositions - 1;
                    break;
                }
                ++i;
            }
            if (!isExisting) {
                SemanticHighlightingManager.HighlightedPosition position = SemanticHighlightingReconciler.this.fJobPresenter.createHighlightedPosition(offset, length, highlighting);
                if (SemanticHighlightingReconciler.this.fAddedPositions.size() == 0 || ((SemanticHighlightingManager.HighlightedPosition)((Object)((SemanticHighlightingReconciler)SemanticHighlightingReconciler.this).fAddedPositions.get((int)(((SemanticHighlightingReconciler)SemanticHighlightingReconciler.this).fAddedPositions.size() - 1)))).offset < offset) {
                    SemanticHighlightingReconciler.this.fAddedPositions.add(position);
                } else {
                    int insertIndex = SemanticHighlightingReconciler.this.fAddedPositions.size();
                    while (insertIndex > 0 && ((SemanticHighlightingManager.HighlightedPosition)((Object)SemanticHighlightingReconciler.this.fAddedPositions.get(insertIndex - 1))).getOffset() > offset) {
                        --insertIndex;
                    }
                    SemanticHighlightingReconciler.this.fAddedPositions.add(insertIndex, position);
                }
            }
        }

        public void retainPositions(int offset, int length) {
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            while (i < n) {
                SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)SemanticHighlightingReconciler.this.fRemovedPositions.get(i));
                if (position != null && position.isContained(offset, length)) {
                    SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                    SemanticHighlightingReconciler semanticHighlightingReconciler = SemanticHighlightingReconciler.this;
                    semanticHighlightingReconciler.fNOfRemovedPositions = semanticHighlightingReconciler.fNOfRemovedPositions - 1;
                }
                ++i;
            }
        }

        public void enumerate(CompiledUnit unit) {
            this.fHighlighter.visit(unit);
        }
    }
}

