/**
* Essential OCL Grammar
* <copyright>
*
* Copyright (c) 2005, 2010 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Elimination of some shift-reduce conflicts
*   E.D.Willink - Remove unnecessary warning suppression
*   E.D.Willink - Bugs 184048, 225493, 243976, 259818, 282882, 287993, 288040, 292112, 295166
*   Borland - Bug 242880
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias):
*        - 242153: LPG v 2.0.17 adoption.
*        - 299396: Introducing new LPG templates
*        - 300534: Removing the use of deprecated macros.
* </copyright>
*
* $Id: EssentialOCL.gi,v 1.5 2010/02/11 15:40:41 sboyko Exp $
*/
/**
* <copyright>
*
* Copyright (c) 2006, 2013 Borland Inc.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   Borland - Initial API and implementation
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - LPG v 2.0.17 adoption (297966)
*   Alex Paperno - bugs 314443, 274105, 274505, 419299 
*
* </copyright>
*
*/
/**
* <copyright>
*
* Copyright (c) 2006, 2013 Borland Inc.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   Borland - Initial API and implementation
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - LPG v 2.0.17 adoption (297966)
*   Alex Paperno - bugs 392429, 419299 
*
* </copyright>
*
*/

package org.eclipse.m2m.internal.qvt.oml.cst.completion.parser;

public class LightweightParserprs implements lpg.runtime.ParseTable, LightweightParsersym {
    public final static int ERROR_SYMBOL = 2;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 132;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 133;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 39;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 643;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 163;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 14758;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 2;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 839;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 345;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 508;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 3499;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 3;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 126;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 126;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 13903;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 13919;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = true;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return LightweightParsersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,1,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            1,0,0,0,0,0,0,0,0,0,
            1,0,0,0,0,0,0,0,0,0,
            0,0,0,0,1,0,0,0,0,0,
            0,0,0,0,0,0,0,0,1,0,
            0,0,0,0,0,0,0,1,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,1,0,0,0,0,0,0,0,
            1,0,0,0,1,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,1,0,0,0,1,0,0,0,0,
            0,0,0,0,0,0,1,0,0,0,
            0,1,0,1,0,0,0,0,1,1,
            0,1,0,0,0,0,1,1,0,0,
            0,1,0,0,1,0,0,0,1,0,
            1,0,0,1,0,0,0,1,0,0,
            1,1,0,0,0,1,0,0,1,0,
            1,0,1,0,0,0,0,0,0,0,
            1,1,1,1,0,0,0,0,0,0,
            0,0,0,0,0,0,0,1,0,0,
            1,1,0,0,1,1,0,1,0,0,
            1,1,1,1,0,0,0,1,1,1,
            1,1,1,0,0,0,0,0,0,1,
            1,1,0,0,0,1,1,0,0,0,
            0,1,1,0,0,0,0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static char prosthesesIndex[] = {0,
            12,13,9,10,15,17,18,39,37,41,
            32,38,40,42,43,331,332,334,335,11,
            29,30,31,46,47,48,49,50,51,52,
            53,54,59,60,61,89,90,91,93,95,
            97,103,104,122,179,180,198,209,211,212,
            323,325,86,88,83,84,85,102,80,81,
            82,190,113,117,120,148,193,77,78,79,
            74,75,76,71,72,73,68,69,70,65,
            66,67,24,55,62,63,64,108,94,96,
            16,173,175,176,177,178,170,171,172,167,
            168,169,56,164,165,166,270,58,161,162,
            163,158,159,160,155,156,157,214,21,152,
            153,154,136,145,146,147,149,150,151,22,
            27,57,285,344,345,25,138,143,248,118,
            137,144,210,234,23,140,87,131,142,224,
            249,254,255,256,307,343,6,8,14,26,
            35,36,112,114,115,121,123,128,139,141,
            174,228,229,230,231,232,233,242,268,269,
            274,275,286,287,288,289,290,293,294,295,
            296,297,298,300,301,302,304,342,33,34,
            99,100,107,110,116,119,135,181,183,184,
            187,188,205,206,213,216,217,222,238,246,
            257,258,259,261,267,271,272,273,277,291,
            292,322,324,327,328,329,338,340,2,3,
            4,19,20,44,92,98,101,105,106,109,
            111,124,125,126,127,129,130,132,133,134,
            182,185,186,189,191,192,194,195,196,197,
            199,200,201,202,203,204,207,208,215,218,
            219,220,221,223,225,226,227,235,236,237,
            239,240,241,243,244,245,247,250,251,252,
            253,260,262,263,264,265,266,276,278,279,
            280,281,282,283,284,299,303,305,306,308,
            309,310,311,312,313,314,315,316,317,318,
            319,320,321,326,330,333,336,337,339,341,
            1,5,7,28,45
        };
    };
    public final static char prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,1,1,0,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,0,1,1,0,0,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,0,1,1,1,1,1,1,
            1,1,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,1,1,1,1,1,1,1,0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,0,0,0,0,0,1,1,
            1,1,1,1,1,0,0,0,0,0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,0,0,1,1,1,1,1,1,
            1,1,1
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck0 {
        public final static short baseCheck0[] = {0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,2,1,1,1,
            3,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,4,4,
            0,1,1,3,1,3,3,5,1,1,
            1,1,1,1,1,1,1,1,1,4,
            0,1,1,3,1,1,3,1,1,1,
            1,1,1,1,4,1,3,1,1,1,
            2,1,1,1,1,1,1,1,1,1,
            1,1,1,8,10,10,8,10,1,1,
            1,5,6,8,8,7,7,5,6,9,
            1,4,6,4,0,0,1,1,3,1,
            1,1,1,1,1,1,1,1,3,1,
            3,1,1,1,3,1,3,1,1,1,
            3,1,3,1,1,1,3,1,3,1,
            1,1,3,3,1,3,3,1,1,1,
            3,3,3,3,1,3,3,3,3,1,
            1,1,3,3,1,3,3,1,1,1,
            3,3,1,3,3,1,1,1,2,2,
            1,2,2,1,1,1,1,1,1,3,
            4,1,3,1,1,1,1,1,4,4,
            1,6,4,1,1,1,3,1,0,1,
            3,2,1,1,3,2,1,0,3,3,
            1,2,5,7,1,0,1,2,1,0,
            1,2,4,4,1,2,4,4,2,3,
            3,5,5,3,3,3,3,1,1,1,
            1,3,3,3,3,1,7,7,5,3,
            5,1,3,1,1,1,3,0,2,2,
            6,2,1,1,1,1,1,1,0,2,
            0,1,4,1,2,2,7,6,4,2,
            5,6,7,8,9,3,6,7,6,7,
            1,5,1,2,0,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,3,1,3,1,1,1,
            3,1,3,1,1,1,3,1,3,1,
            1,1,3,1,3,1,1,1,3,3,
            1,3,3,1,1,1,3,3,3,3,
            1,3,3,3,3,1,1,1,3,3,
            1,3,3,1,1,1,3,3,1,3,
            3,1,1,1,2,1,2,1,1,1,
            1,3,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,2,1,
            2,1,1,3,8,7,2,4,4,2,
            1,2,5,5,0,1,2,2,1,1,
            2,1,0,5,1,1,1,0,2,1,
            0,6,5,1,3,1,1,1,1,1,
            1,1,1,4,4,2,1,3,5,5,
            1,3,0,1,2,0,1,6,3,1,
            5,1,1,1,1,1,1,3,5,5,
            3,1,0,0,1,2,1,1,3,2,
            3,2,2,2,1,6,4,2,4,4,
            1,1,3,1,2,1,2,0,1,1,
            1,1,1,1,1,1,1,2,1,1,
            1,2,5,1,1,2,5,5,0,1,
            1,1,1,2,4,1,2,0,1,1,
            1,2,0,1,1,1,3,3,0,1,
            1,1,1,3,2,2,2,0,1,1,
            1,1,1,1,2,1,7,1,2,0,
            1,2,1,3,2,1,4,1,0,1,
            1,1,8,7,0,2,1,3,2,0,
            2,1,3,2,9,1,0,2,0,3,
            1,3,2,0,2,2,1,1,1,1,
            1,0,3,1,1,3,3,3,3,1,
            0,0,4,1,0,6,6,7,5,5,
            6,8,1,1,1,3,2,2,1,1,
            2,2,4,3,1,1,4,2,2,3,
            1,1,2,2,2,3,4,0,2,1,
            1,2,5,3,3,6,5,3,2,0,
            1,2,1,1,1,1,0,2,2,1,
            0,2,2,3,0,1,2,2,0,1,
            1,2,2,0,1,2,2,0,1,1,
            1,1,1,3,3,3,5,5,7,7,
            5,5,0,2,2,0,2,0,1,3,
            1,1,1,1,0,1,5,5,3,2,
            1,1,1,1,7,5,7,5,4,3,
            1,1,3,3,1,3,3,1,1,1,
            1,1,3,4,4,3,3,4,3,1,
            7,0,2,1,1,1,0,2,2,0,
            1,3,0,1,3,3,1,1,4,2,
            0,1,1,1,1,1,3,1,1,1,
            1,1,3,3,1,1,1,3,3,1,
            3,2,1,3,3,2,1,1,1,-433,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,-113,1,2,3,4,-164,1,2,
            -356,62,63,64,65,66,67,-429,1,2,
            -313,-178,5,-176,1,2,3,4,8,9,
            10,11,12,13,14,15,-248,88,-161,1,
            2,92,93,94,95,96,97,98,99,100,
            101,102,-428,104,105,106,-2,-402,109,110,
            111,112,113,114,115,116,117,-30,-5,120,
            121,122,123,124,125,126,127,128,129,-471,
            1,2,-643,-19,1,2,137,138,5,-6,
            141,-616,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,-320,1,2,3,4,-235,
            1,2,145,62,63,64,65,66,67,157,
            158,159,152,153,154,-10,1,2,151,-17,
            5,-7,-490,8,136,-459,1,2,-8,88,
            157,158,159,92,93,94,95,96,97,98,
            99,100,101,102,-556,104,105,106,119,132,
            109,110,111,112,113,114,115,116,117,130,
            131,120,121,122,123,124,125,126,127,128,
            129,201,202,-306,142,204,-198,58,137,138,
            220,149,141,-627,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,-481,1,2,-124,
            -12,5,213,-488,8,62,63,64,65,66,
            67,157,158,159,-282,295,296,297,-552,1,
            2,136,255,5,142,-325,1,2,-20,1,
            2,88,-135,5,-15,92,93,94,95,96,
            97,98,99,100,101,102,142,104,105,106,
            146,169,109,110,111,112,113,114,115,116,
            117,-18,316,120,121,122,123,124,125,126,
            127,128,129,-236,1,2,-49,1,2,-23,
            137,138,320,-24,141,-634,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,-188,140,
            207,-130,1,2,119,-376,-89,62,63,64,
            65,66,67,-112,140,130,131,16,17,18,
            19,8,9,10,11,12,13,14,15,151,
            234,235,236,88,-84,179,-408,92,93,94,
            95,96,97,98,99,100,101,102,-349,104,
            105,106,259,260,109,110,111,112,113,114,
            115,116,117,-344,58,120,121,122,123,124,
            125,126,127,128,129,-351,-158,1,2,205,
            -90,225,137,138,-25,-585,141,-87,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-230,1,2,3,4,
            5,6,7,107,321,322,323,-53,1,2,
            3,4,5,6,7,-108,1,2,3,4,
            5,6,7,267,268,-59,-231,144,-327,211,
            123,319,-55,-618,201,202,-331,211,326,-129,
            1,2,9,10,5,-86,150,152,153,154,
            -66,146,-69,58,233,16,17,18,19,234,
            235,236,-378,-354,181,182,-26,167,-388,1,
            2,164,165,252,253,170,335,336,-455,246,
            247,263,264,58,89,90,91,-148,262,221,
            -125,223,271,272,273,274,89,90,91,-390,
            1,2,248,249,89,90,91,-48,58,209,
            227,228,-316,88,218,215,-478,-62,1,2,
            58,-430,-273,216,217,269,270,-422,-251,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,279,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,-21,1,2,3,
            4,5,6,7,107,-16,1,2,3,4,
            5,6,7,-165,1,2,3,4,5,6,
            7,-195,1,2,3,4,5,6,7,204,
            -27,123,-196,1,2,3,4,5,6,7,
            144,139,-264,1,2,3,4,5,6,7,
            -137,144,233,152,153,154,-348,1,2,240,
            241,5,254,231,8,-270,208,-153,-152,237,
            -339,-274,164,165,231,250,206,181,182,-28,
            237,265,266,277,278,89,90,91,181,182,
            -461,1,2,226,89,90,91,-29,206,257,
            -364,214,89,90,91,-110,1,2,58,-139,
            89,90,91,-254,1,2,3,4,5,6,
            7,89,90,91,216,217,58,314,58,58,
            318,89,90,91,227,228,306,325,-33,143,
            -457,1,2,3,4,5,6,7,143,-555,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,89,90,91,163,210,139,-34,119,
            139,62,63,64,65,66,67,152,153,154,
            130,131,-57,-35,119,155,156,118,232,89,
            90,91,-468,1,2,179,328,88,-36,331,
            140,92,93,94,95,96,97,98,99,100,
            101,102,-37,104,105,106,143,-379,109,110,
            111,112,113,114,115,116,117,-350,198,120,
            121,122,123,124,125,126,127,128,129,-38,
            58,225,-11,143,-157,220,219,-269,1,2,
            141,-586,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,-620,58,-39,242,243,-40,
            210,119,-154,62,63,64,65,66,67,-215,
            304,139,130,131,299,294,298,317,-54,301,
            88,-41,232,-311,1,2,8,327,-486,88,
            330,-42,-232,92,93,94,95,96,97,98,
            99,100,101,102,107,104,105,106,-140,-287,
            109,110,111,112,113,114,115,116,117,-234,
            58,120,121,122,123,124,125,126,127,128,
            129,-412,1,2,3,4,5,6,7,-64,
            1,2,141,-619,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,142,88,221,-116,
            223,132,119,149,-151,62,63,64,65,66,
            67,-626,8,219,-43,-47,-641,155,156,-183,
            89,90,91,169,132,258,118,139,-418,1,
            2,88,-147,1,2,92,93,94,95,96,
            97,98,99,100,101,102,107,104,105,106,
            -141,132,109,110,111,112,113,114,115,116,
            117,-44,-612,120,121,122,-266,124,125,126,
            127,128,129,58,143,166,-13,58,-355,-45,
            137,138,-640,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,107,58,118,-336,107,
            -417,-630,-98,-99,62,63,64,65,66,67,
            9,10,-631,142,-423,140,-160,146,142,-614,
            149,9,10,-386,88,149,-401,-150,1,2,
            88,-247,1,2,92,93,94,95,96,97,
            98,99,100,101,102,169,104,105,106,139,
            302,109,110,111,112,113,114,115,116,117,
            58,58,120,121,122,-58,124,125,126,127,
            128,129,58,214,58,-295,-431,139,-61,137,
            138,-642,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,107,-256,58,-377,107,-628,
            230,-14,-410,62,63,64,65,66,67,-484,
            8,229,226,88,-617,132,-214,8,132,-50,
            -621,-51,-52,88,88,146,88,303,230,88,
            -635,-629,-56,92,93,94,95,96,97,98,
            99,100,101,102,-365,104,105,106,-407,170,
            109,110,111,112,113,114,115,116,117,58,
            312,120,121,122,-542,124,125,126,127,128,
            129,-548,1,2,58,-637,1,2,137,138,
            -326,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,308,-309,
            1,2,-469,1,2,-63,146,-65,107,305,
            132,307,107,-68,140,-70,-72,329,179,-144,
            332,-335,-4,1,2,-352,132,-357,-371,119,
            170,-475,-73,-550,-74,-83,-85,-91,-92,208,
            130,131,-639,-93,-94,-95,136,-463,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,136,-96,118,136,118,
            311,-97,-100,118,145,118,118,145,-101,118,
            103,118,-103,309,-104,-105,-106,-114,136,160,
            310,334,160,-115,339,-126,119,145,-131,-133,
            -142,-143,-146,-159,-167,-472,315,130,131,-107,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,62,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,245,-168,-483,
            -534,229,-434,-544,-123,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,-169,59,60,61,-170,-171,-172,-173,
            161,162,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,88,88,337,
            88,88,-174,-175,-179,-180,-184,-185,-186,-187,
            -190,-191,-192,-194,-203,-204,-205,-206,199,200,
            -111,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,166,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-554,-207,
            -208,-209,-210,-211,-212,-75,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,-213,59,60,61,-217,-218,-219,
            -220,161,162,68,69,70,71,72,73,74,
            75,76,77,78,79,-221,88,-222,-223,-224,
            -225,-226,-227,-233,-237,-238,-239,-242,-243,-245,
            -246,-250,-253,-255,-259,-262,-263,-265,-267,199,
            200,-202,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            -268,-276,-277,-156,1,2,-278,-279,-280,-283,
            -284,-293,-297,-328,1,2,-298,-299,-302,-304,
            -305,-329,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,168,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,-315,
            107,-318,-319,-321,-322,-323,-330,-333,-338,-341,
            -342,-347,-353,-359,-360,-366,-367,-368,-369,-372,
            -374,-382,119,-384,-392,-393,-394,-395,-396,-397,
            119,-398,-399,130,131,-400,-403,-404,-405,-406,
            -413,130,131,150,-416,-421,-424,-425,-441,-443,
            -445,-447,-448,-449,-450,-451,-452,256,-1,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,213,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,-453,-454,-465,-466,
            -473,-474,-480,-482,-491,-492,-493,-494,-495,-496,
            -497,-498,-499,-500,-501,-502,-503,-504,-506,-507,
            -508,-509,-510,-511,-512,-513,-514,-515,-516,276,
            -517,-518,-519,-520,-522,-523,275,-132,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-228,-240,-241,-257,-258,
            -524,-525,-526,-527,-529,-535,-536,-537,-538,-539,
            103,-540,-541,-543,-545,108,-546,239,-547,-549,
            -551,-557,-558,-565,-575,-576,-577,-588,-589,-590,
            -591,-592,-593,-594,-595,-596,-597,-598,-599,-600,
            -601,-602,-603,-604,-605,-606,-607,-608,-609,-610,
            -611,-615,-622,58,58,58,58,58,280,281,
            -193,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-623,-625,
            -633,-638,0,0,0,0,0,0,0,0,
            0,0,0,103,0,0,0,0,108,-199,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,103,0,0,0,0,108,-200,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,103,0,0,0,0,108,-216,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            103,0,0,0,0,108,-286,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,-102,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,0,-291,-300,-301,-345,-361,
            -362,-363,-373,-415,-438,-442,-477,-485,-487,-489,
            -584,0,0,0,0,0,0,0,0,0,
            0,0,58,0,0,0,0,0,0,123,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,88,58,58,58,58,58,58,58,
            58,58,58,58,58,58,58,58,58,0,
            164,165,-292,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            88,-314,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,103,0,0,0,0,108,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,212,-385,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,103,0,
            0,0,0,108,-387,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,103,0,0,
            0,0,108,-389,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,103,0,0,0,
            0,108,-391,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,103,0,0,0,0,
            108,-440,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            -531,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,103,0,0,0,0,108,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,212,-532,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,103,0,0,
            0,0,108,-533,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,103,0,0,0,
            0,108,-22,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            -117,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,0,0,
            148,-182,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,0,
            0,-308,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,148,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,-119,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,0,59,60,
            61,0,0,0,0,0,0,68,69,70,
            0,0,161,162,-446,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,0,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,88,-122,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,0,59,60,61,0,0,0,0,0,
            0,68,69,70,71,72,73,74,75,76,
            0,0,168,-462,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,103,-528,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,0,0,-530,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,148,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,88,-76,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,0,59,60,61,0,0,
            0,0,0,0,68,69,70,71,72,73,
            0,0,0,0,0,168,-624,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,0,0,-46,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,148,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,-88,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,-136,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,203,
            58,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            88,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,167,-127,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            -128,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-163,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,-177,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,0,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,-189,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,203,
            -229,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-332,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,-383,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,-444,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,-467,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            -9,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,0,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-145,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,0,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,-162,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,0,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,-166,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,0,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,-244,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            0,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            -260,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,0,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,-285,1,
            2,3,4,5,6,7,8,9,10,11,
            12
        };
    };

    public interface BaseCheck1 {
        public final static short baseCheck1[] = {
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,0,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-288,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,0,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-290,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,0,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,-294,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,0,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,-296,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,0,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,-307,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,0,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-312,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,0,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-317,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,0,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,-334,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,0,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,-358,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,0,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,-370,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,0,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-380,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,0,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-409,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,0,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,-414,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,0,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,-435,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,0,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,-436,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,0,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-439,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,0,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-456,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,0,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,-458,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,0,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,-460,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,0,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,-470,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,0,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-479,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,0,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-505,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,0,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,-574,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,0,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,-578,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,0,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,-579,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,0,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-580,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,0,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-581,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,0,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,-582,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,0,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,-587,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,0,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,-632,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,0,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,-636,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,0,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,-559,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,-109,1,2,0,
            0,0,0,-419,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-426,1,2,0,0,5,0,0,
            0,0,0,0,0,92,93,94,95,96,
            97,98,99,100,101,102,0,104,105,106,
            0,0,109,110,111,112,113,114,115,116,
            117,58,0,120,121,122,-573,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,0,
            0,118,0,0,0,0,0,0,0,0,
            0,0,136,0,0,0,0,0,0,0,
            0,145,0,0,0,0,0,0,-201,1,
            2,3,4,5,6,7,160,0,92,93,
            94,95,96,97,98,99,100,101,102,0,
            104,105,106,151,0,109,110,111,112,113,
            114,115,116,117,-560,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,89,90,91,
            244,0,0,0,222,0,0,0,0,0,
            0,0,0,0,0,-427,1,2,0,0,
            5,0,0,-261,1,2,3,4,5,6,
            7,0,0,0,0,0,92,93,94,95,
            96,97,98,99,100,101,102,0,104,105,
            106,143,0,109,110,111,112,113,114,-572,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,89,90,91,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-289,1,2,3,4,
            5,6,7,-303,1,2,3,4,5,6,
            7,92,93,94,95,96,97,98,99,100,
            101,102,0,104,105,106,151,0,109,110,
            111,-561,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,89,90,91,0,0,0,
            0,0,89,90,91,0,0,222,0,0,
            0,333,-310,1,2,3,4,5,6,7,
            -343,1,2,3,4,5,6,7,0,0,
            0,0,0,92,93,94,95,96,97,98,
            99,100,101,102,0,104,105,106,-562,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,89,90,91,0,0,0,0,0,89,
            90,91,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-281,1,
            2,3,4,5,6,7,0,0,0,0,
            92,93,94,95,96,97,98,99,100,101,
            102,0,104,105,106,-120,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,0,59,60,61,89,90,91,
            0,0,0,68,69,70,-121,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,0,59,60,61,0,0,
            -437,163,0,0,68,69,70,-568,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-346,1,2,3,4,5,
            6,7,0,0,0,0,0,0,88,251,
            -375,1,2,3,4,5,6,7,0,92,
            93,94,95,96,97,98,99,100,101,102,
            -569,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,89,90,91,166,0,0,0,
            0,0,0,0,0,0,0,0,0,89,
            90,91,-420,1,2,3,4,5,6,7,
            -464,1,2,3,4,5,6,7,0,0,
            0,0,92,93,94,95,96,97,98,99,
            100,101,102,-570,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,0,0,0,0,
            0,89,90,91,0,0,0,0,0,89,
            90,91,-583,1,2,3,4,5,6,7,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,92,93,94,95,96,
            97,98,99,100,101,102,-571,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,0,
            0,89,90,91,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,92,93,
            94,95,96,97,98,99,100,101,102,-77,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,0,59,60,
            61,-78,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,0,
            59,60,61,-79,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,0,59,60,61,-80,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,-249,59,60,61,-563,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            0,58,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,88,0,0,0,0,0,0,0,92,
            93,94,95,96,97,98,99,-564,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,92,
            93,94,95,96,97,98,99,-521,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-432,1,2,3,4,5,6,7,92,
            93,94,95,96,-566,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,171,0,
            89,90,91,0,0,0,0,0,0,0,
            0,0,0,0,0,0,92,93,94,95,
            96,-567,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,163,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,171,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,92,93,94,95,96,-118,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,171,-31,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,-32,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,-252,-337,-411,0,0,0,0,
            -381,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            147,0,0,0,0,0,0,0,0,0,
            0,0,0,-324,0,0,0,0,0,0,
            0,58,58,58,0,0,0,0,58,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,88,88,88,0,147,-81,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,-82,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,-3,-60,-181,0,
            3,4,-197,6,7,3,4,207,6,7,
            167,-553,0,0,3,4,0,6,7,0,
            -134,0,-271,3,4,-149,6,7,3,4,
            0,6,7,147,0,-476,1,2,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,209,0,58,58,58,0,215,0,
            58,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-275,0,0,0,
            58,0,0,0,0,0,89,90,147,0,
            0,89,90,58,-71,1,2,0,0,0,
            89,90,0,0,261,0,0,0,0,89,
            90,0,0,0,89,90,0,0,0,-138,
            0,0,0,0,0,0,0,0,0,0,
            133,134,135,0,58,133,134,135,140,0,
            144,0,107,0,133,134,135,0,0,0,
            0,0,58,133,134,135,0,0,133,134,
            135,0,0,0,0,0,144,0,172,173,
            174,175,176,177,178,0,180,58,0,183,
            184,185,186,187,188,189,190,191,192,193,
            194,195,196,197,172,173,174,175,176,177,
            178,107,180,205,0,183,184,185,186,187,
            188,189,190,191,192,193,194,195,196,197,
            144,-155,0,0,3,4,-272,6,7,3,
            4,-613,6,7,3,4,-340,6,7,-67,
            1,2,0,0,150,0,224,0,172,173,
            174,175,176,177,178,0,180,0,0,183,
            184,185,186,187,188,189,190,191,192,193,
            194,195,196,197,155,156,0,0,282,283,
            0,285,286,287,288,289,290,291,292,293,
            0,0,0,0,58,0,0,58,0,0,
            224,0,0,0,0,0,0,0,0,0,
            89,90,218,0,0,89,90,198,0,0,
            89,90,0,0,0,0,0,0,0,0,
            0,0,0,0,338,324,0,0,0,0,
            0,0,0,0,0,0,107,0,313,0,
            0,0,0,0,133,134,135,238,0,133,
            134,135,0,0,133,134,135,0,0,0,
            0,0,0,0,0,0,0,0,284,0,
            0,0,0,0,0,0,0,0,0,150,
            0,155,156,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,198,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,340,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,238,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,300,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0
        };
    };

    public final static short baseCheck[] = new short[BaseCheck0.baseCheck0.length + BaseCheck1.baseCheck1.length];
    {
        int index = 0;
        System.arraycopy(BaseCheck0.baseCheck0, 0, baseCheck, index, BaseCheck0.baseCheck0.length);
        index += BaseCheck0.baseCheck0.length;
        System.arraycopy(BaseCheck1.baseCheck1, 0, baseCheck, index, BaseCheck1.baseCheck1.length);
    };
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction0 {
        public final static char baseAction0[] = {
            239,240,240,240,240,240,240,240,240,240,
            240,240,240,240,240,240,241,342,342,342,
            342,342,342,342,342,342,342,342,157,343,
            158,158,158,20,1,1,2,2,159,159,
            5,5,4,4,4,4,4,4,4,4,
            3,3,3,3,3,91,91,91,91,6,
            7,242,242,243,243,130,119,145,136,160,
            160,131,131,344,344,344,344,21,21,21,
            22,199,199,200,200,161,161,162,11,11,
            11,11,11,11,11,23,244,244,9,12,
            8,8,13,13,10,14,15,345,345,345,
            24,24,26,26,27,27,27,28,28,25,
            25,25,30,30,30,30,30,30,30,30,
            30,32,31,31,33,132,108,108,103,103,
            83,83,35,34,84,84,87,87,85,85,
            86,86,81,81,80,80,82,82,78,78,
            77,77,79,79,75,75,74,74,76,76,
            72,72,71,71,71,73,73,73,69,69,
            68,68,68,68,68,70,70,70,70,70,
            60,60,59,59,59,61,61,61,56,56,
            55,55,55,57,57,57,147,147,53,53,
            53,54,54,54,29,29,36,36,36,36,
            36,37,245,245,21,21,21,36,91,89,
            40,91,90,41,201,21,21,202,246,246,
            247,247,247,39,39,42,42,248,248,249,
            43,250,250,204,204,251,251,83,63,203,
            203,164,165,165,165,83,64,64,64,64,
            205,205,140,140,140,140,140,140,206,206,
            206,83,65,65,65,65,166,44,44,44,
            27,27,103,103,253,253,254,254,255,255,
            255,252,252,39,168,168,256,257,148,258,
            258,259,259,207,260,260,260,38,38,38,
            38,123,123,123,123,123,149,138,138,138,
            138,164,142,169,169,146,146,170,124,124,
            141,141,137,137,125,125,125,125,125,125,
            126,126,129,129,127,127,128,128,121,121,
            120,120,122,122,116,116,115,115,117,117,
            113,113,112,112,114,114,110,110,109,109,
            109,111,111,111,105,105,104,104,104,104,
            104,106,106,106,106,106,101,101,100,100,
            100,102,102,102,98,98,97,97,97,99,
            99,99,171,171,92,92,93,93,94,94,
            94,94,94,94,95,95,95,95,95,95,
            95,95,96,96,96,96,96,96,39,45,
            39,46,261,261,261,28,28,46,208,208,
            208,262,262,211,211,263,263,264,264,83,
            66,265,266,266,62,66,267,268,268,269,
            270,270,67,47,39,28,272,272,272,272,
            273,273,274,274,271,271,271,275,275,275,
            276,213,213,214,214,277,278,278,28,28,
            39,48,49,50,39,39,209,209,167,167,
            167,215,118,118,279,279,216,164,217,217,
            217,88,88,212,212,58,211,211,211,264,
            264,280,282,283,284,283,218,281,281,282,
            282,282,282,282,282,282,282,282,282,282,
            285,285,288,289,286,286,291,292,290,295,
            295,296,296,294,297,293,300,293,298,298,
            301,220,220,299,299,152,152,153,154,221,
            221,223,223,222,222,222,151,219,219,224,
            224,224,224,224,224,224,224,287,306,287,
            305,305,307,304,304,304,225,225,225,303,
            303,179,172,180,180,226,226,163,163,163,
            227,227,228,228,228,181,181,311,311,182,
            182,312,312,312,308,308,308,313,313,313,
            313,313,229,229,314,314,314,314,314,314,
            309,309,310,310,315,315,173,173,173,173,
            173,173,173,174,174,174,186,186,187,231,
            231,183,183,184,185,175,175,190,188,188,
            189,176,176,193,193,191,192,144,316,316,
            177,177,194,195,195,196,197,197,197,320,
            320,321,322,323,323,323,318,318,325,325,
            319,319,326,326,317,327,327,330,330,328,
            328,331,331,331,329,329,332,332,333,333,
            210,232,232,232,210,51,51,233,233,233,
            233,52,52,334,334,334,234,234,235,235,
            236,335,335,335,335,16,16,17,17,17,
            17,336,336,336,336,18,18,18,18,18,
            18,19,19,30,30,39,30,30,39,39,
            1,1,337,337,37,37,71,73,283,290,
            282,338,178,178,237,237,237,339,339,230,
            302,302,139,340,340,238,238,238,238,198,
            198,155,155,156,156,156,143,143,134,134,
            134,134,134,133,133,133,135,135,135,135,
            324,324,324,150,150,150,150,107,239,239,
            2481,958,1800,1264,3597,1818,3596,3595,3605,3607,
            92,79,3606,3604,3603,3602,1242,771,772,775,
            142,218,3601,3600,3611,110,111,112,113,1608,
            119,120,121,131,3617,3610,214,416,3609,3608,
            3599,3598,243,244,303,438,440,474,500,504,
            505,779,778,3797,38,1800,30,31,232,3337,
            1800,4035,460,346,347,348,349,465,232,40,
            1800,3425,3799,2099,3797,38,1800,30,31,1260,
            88,92,234,89,91,93,94,4571,339,232,
            3333,1800,406,409,414,420,426,3612,3625,401,
            3614,3624,391,581,3613,3626,381,64,1396,3616,
            3623,374,3615,3721,368,3619,3622,362,236,3405,
            3618,3722,356,341,3724,338,344,3723,351,3621,
            232,3468,1800,4471,232,40,1800,1063,343,2803,
            134,321,2546,958,1800,1264,3597,1818,3596,3595,
            3605,3607,92,79,3606,3604,3603,3602,1242,771,
            772,775,142,218,3601,3600,3611,110,111,112,
            113,1608,119,120,121,131,3617,3610,214,416,
            3609,3608,3599,3598,243,244,303,438,440,474,
            500,504,505,779,778,3797,38,1800,30,31,
            232,3445,1800,783,460,346,347,348,349,465,
            32,39,2080,571,575,576,2738,40,1800,564,
            69,1355,241,3360,2697,223,232,3333,1800,2790,
            339,32,39,41,406,409,414,420,426,3612,
            3625,401,3614,3624,391,4432,3613,3626,381,72,
            2818,3616,3623,374,3615,3721,368,3619,3622,362,
            71,491,3618,3722,356,341,3724,338,344,3723,
            351,3621,3194,241,4402,334,252,3293,760,2065,
            343,1622,328,321,3239,958,1800,1264,3597,1818,
            3596,3595,3605,3607,92,79,3606,3604,3603,3602,
            1242,771,772,775,142,218,3601,3600,3611,110,
            111,112,113,1608,119,120,121,131,3617,3610,
            214,416,3609,3608,3599,3598,243,244,303,438,
            440,474,500,504,505,779,778,2738,40,1800,
            3011,2544,3488,3737,3927,3487,460,346,347,348,
            349,465,32,39,2374,3011,558,560,562,232,
            40,1800,3727,3589,2099,333,232,3468,1800,232,
            40,1800,339,100,2809,2609,406,409,414,420,
            426,3612,3625,401,3614,3624,391,334,3613,3626,
            381,323,1085,3616,3623,374,3615,3721,368,3619,
            3622,362,2675,687,3618,3722,356,341,3724,338,
            344,3723,351,3621,232,3446,1800,3491,466,1800,
            2740,2521,343,1184,311,1406,3239,958,1800,1264,
            3597,1818,3596,3595,3605,3607,92,79,3606,3604,
            3603,3602,1242,771,772,775,142,218,3601,3600,
            3611,110,111,112,113,1608,119,120,121,131,
            3617,3610,214,416,3609,3608,3599,3598,243,244,
            303,438,440,474,500,504,505,779,778,4008,
            3716,314,3845,3227,1800,72,4532,3008,460,346,
            347,348,349,465,2848,4312,71,3467,1242,771,
            772,773,1260,88,92,234,89,91,93,94,
            584,11435,4308,749,339,3770,608,2600,406,409,
            414,420,426,3612,3625,401,3614,3624,391,4461,
            3613,3626,381,1978,13162,3616,3623,374,3615,3721,
            368,3619,3622,362,3483,450,3618,3722,356,341,
            3724,338,344,3723,351,3621,3895,232,837,1800,
            4311,2357,604,2521,343,3177,4806,2370,248,958,
            1800,1264,224,1818,225,226,1260,88,92,79,
            89,91,93,94,1242,771,772,775,142,218,
            77,78,216,110,111,112,113,1608,119,120,
            121,131,2512,217,1859,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,1959,1069,195,522,1929,1944,185,
            460,257,265,281,459,465,2067,1062,175,1973,
            2000,168,2102,980,162,2070,2092,156,2290,959,
            150,517,140,2225,145,2272,3522,40,1800,2704,
            55,2802,57,58,833,699,701,13373,95,40,
            1800,2704,55,2802,57,58,95,40,1800,2704,
            55,2802,57,58,467,2829,2871,3183,626,3434,
            452,331,695,91,3406,3194,240,4687,451,710,
            3432,2130,1800,3869,645,3224,3772,2367,572,575,
            576,1405,337,2752,277,776,1242,771,772,774,
            11435,4316,3490,4628,2846,622,2351,2791,506,232,
            3496,1800,518,261,290,3717,324,2354,2353,4405,
            3135,2507,4306,456,679,228,231,1613,3905,1319,
            11074,3916,580,475,3229,3228,3718,228,231,2830,
            232,3587,1800,245,247,228,231,3038,3795,598,
            3032,3485,11055,4004,2119,3332,507,4370,232,837,
            1800,307,4134,4607,515,2230,470,472,3483,2676,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,1608,119,
            120,121,131,2512,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,3026,1929,1944,
            185,460,257,265,281,459,465,2067,1062,175,
            1973,2000,168,2102,980,162,2070,2092,156,2290,
            959,150,517,140,2225,145,2272,67,40,1800,
            2704,55,2802,57,58,2833,95,40,1800,2704,
            55,2802,57,58,95,40,1800,2704,55,2802,
            57,58,95,40,1800,2704,55,2802,57,58,
            251,2950,331,95,40,1800,2704,55,2802,57,
            58,626,677,95,40,1800,2704,55,2802,57,
            58,1,626,777,572,575,576,2738,40,1800,
            16,2103,3488,948,668,3487,2665,446,55,4155,
            793,2763,3572,518,261,668,912,7211,623,2351,
            2743,793,462,464,497,8795,228,231,2699,622,
            2351,232,3468,1800,3237,228,231,2699,3551,7387,
            318,3011,2826,228,231,3338,3864,3132,1800,694,
            4106,228,231,3347,3662,40,1800,2704,55,2802,
            57,58,228,231,3348,721,2230,836,3773,806,
            836,1213,228,231,617,3593,11055,599,706,4196,
            730,67,40,1800,2704,55,2802,57,58,2698,
            3123,958,1800,1264,3597,1818,3596,3595,3605,3607,
            92,79,3606,3604,3603,3602,1242,771,772,775,
            142,218,3601,3600,3611,110,111,112,113,1608,
            119,120,121,131,3617,3610,214,416,3609,3608,
            3599,3598,243,244,303,438,440,474,500,504,
            505,779,778,228,231,2699,4309,4275,570,3596,
            72,563,460,346,347,348,349,465,571,575,
            576,71,3729,1148,3785,63,1834,812,686,2813,
            228,231,2699,232,3468,1800,608,2349,339,4072,
            720,271,406,409,414,420,426,3612,3625,401,
            3614,3624,391,3825,3613,3626,381,810,4243,3616,
            3623,374,3615,3721,368,3619,3622,362,4461,805,
            3618,3722,356,341,340,338,344,3723,351,3621,
            4186,684,603,2423,730,55,1396,13384,199,837,
            1800,1406,3123,958,1800,1264,3597,1818,3596,3595,
            3605,3607,92,79,3606,3604,3603,3602,1242,771,
            772,775,142,218,3601,3600,3611,110,111,112,
            113,1608,119,120,121,131,3617,3610,214,416,
            3609,3608,3599,3598,243,244,303,438,440,474,
            500,504,505,779,778,4441,835,2787,3131,3133,
            123,2931,72,3459,460,346,347,348,349,465,
            4173,2365,683,71,492,565,901,1786,3232,3546,
            569,1546,3356,2813,232,3132,1800,13382,1629,4561,
            339,716,2472,204,406,409,414,420,426,3612,
            3625,401,3614,3624,391,834,3613,3626,381,4106,
            2423,3616,3623,374,3615,3721,368,3619,3622,362,
            4573,698,3618,3722,356,341,340,338,344,3723,
            351,3621,95,40,1800,2704,55,2802,57,58,
            232,837,1800,2370,3181,958,1800,1264,3597,1818,
            3596,3595,3605,3607,92,79,3606,3604,3603,3602,
            1242,771,772,775,142,218,3601,3600,3611,110,
            111,112,113,1608,119,120,121,131,3617,3610,
            214,416,3609,3608,3599,3598,243,244,303,438,
            440,474,500,504,505,779,778,333,286,11307,
            3823,580,132,64,327,3722,460,346,347,348,
            349,465,4455,3331,13438,3604,242,4465,13588,812,
            4019,228,231,2699,2222,3443,3491,680,801,232,
            837,1800,339,232,837,1800,406,409,414,420,
            426,3612,3625,401,3614,3624,391,1588,3613,3626,
            381,4607,3444,3616,3623,374,3615,3721,368,3619,
            3622,362,3777,761,3618,3722,356,3905,342,338,
            344,3723,351,3621,269,809,289,2423,520,1148,
            3741,332,343,2611,958,1800,1264,3597,1818,3596,
            3595,3605,3607,92,79,3606,3604,3603,3602,1242,
            771,772,775,142,218,3601,3600,3611,110,111,
            112,113,1608,119,120,121,131,3617,3610,214,
            416,3609,3608,3599,3598,243,244,303,438,440,
            474,500,504,505,779,778,631,697,516,4699,
            3236,567,3406,3235,3486,460,346,347,348,349,
            465,647,649,3406,334,3993,266,3448,323,333,
            4806,328,646,648,4722,439,327,3489,232,837,
            1800,339,232,837,1800,406,409,414,420,426,
            3612,3625,401,3614,3624,391,973,3613,3626,381,
            2486,586,3616,3623,374,3615,3721,368,3619,3622,
            362,770,759,3618,3722,356,2946,342,338,344,
            3723,351,3621,605,2826,836,2423,2423,2486,66,
            2227,343,3181,958,1800,1264,3597,1818,3596,3595,
            3605,3607,92,79,3606,3604,3603,3602,1242,771,
            772,775,142,218,3601,3600,3611,110,111,112,
            113,1608,119,120,121,131,3617,3610,214,416,
            3609,3608,3599,3598,243,244,303,438,440,474,
            500,504,505,779,778,2277,4647,672,4717,3448,
            4843,666,2940,3546,460,346,347,348,349,465,
            3546,3591,2505,3452,1830,4833,3494,3554,3487,2818,
            2749,3623,3512,6,473,253,337,2680,3239,943,
            339,4845,4844,2681,406,409,414,420,426,3612,
            3625,401,3614,3624,391,3011,3613,3626,381,3526,
            325,3616,3623,374,3615,3721,368,3619,3622,362,
            447,4317,3618,3722,356,3827,342,338,344,3723,
            351,3621,232,837,1800,242,232,837,1800,2521,
            343,770,2377,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,291,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,3469,3476,2225,145,2272,13397,
            232,2695,1800,232,2695,1800,3492,337,4007,632,
            3594,2818,601,2703,3826,270,3970,2674,714,3741,
            4106,725,4106,232,2695,1800,4106,2818,4106,4106,
            3473,326,4106,4084,4106,3563,3446,3585,3179,2486,
            441,71,3472,761,3912,3955,4363,3470,2103,2555,
            1800,1264,224,1818,225,226,1260,88,92,79,
            89,91,93,94,1242,771,772,775,142,218,
            77,78,216,110,111,112,113,1608,119,120,
            121,131,2512,217,1859,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,1959,1069,195,292,1929,1944,185,
            460,257,265,281,459,465,2067,1062,175,1973,
            2000,168,2102,980,162,2070,2092,156,2290,959,
            150,138,140,2225,145,2272,70,4592,674,70,
            693,625,3611,4029,557,69,553,524,69,4088,
            614,3733,613,1333,2511,4023,4192,1151,4596,222,
            97,2490,750,3735,3910,799,441,72,782,4605,
            65,4001,4114,4014,4609,3882,3303,2566,71,3732,
            2883,958,1800,1264,224,1818,225,226,1260,88,
            92,79,89,91,93,94,1242,771,772,775,
            142,218,77,78,216,110,111,112,113,1608,
            119,120,121,131,2512,217,1859,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,1959,1069,195,469,1929,
            1944,185,460,257,265,281,459,465,2067,1062,
            175,1973,2000,168,2102,980,162,2070,2092,156,
            2290,959,150,3036,140,2225,145,2272,2677,3776,
            2423,2423,653,2423,2423,3301,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,2210,119,120,121,131,3222,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,4112,1929,1944,185,4187,3885,3881,
            4337,83,85,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,152,3223,151,602,445,
            2693,286,301,4466,4506,4612,246,3778,4610,4590,
            4614,4615,4314,4468,3071,4138,2420,630,4442,3035,
            3037,2883,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,287,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,3036,140,2225,145,2272,2423,
            247,4617,4618,1139,4197,4269,3301,958,1800,1264,
            224,1818,225,226,1260,88,92,79,89,91,
            93,94,1242,771,772,775,142,218,77,78,
            216,110,111,112,113,2210,119,120,121,131,
            2835,217,1859,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,1959,1069,195,2551,1929,1944,185,3992,4361,
            4371,3496,83,85,2067,1062,175,1973,2000,168,
            2102,980,162,158,2929,157,3666,254,3690,4122,
            3962,2856,3854,4053,4329,4619,4624,4626,4631,4642,
            4629,1347,4621,4645,4638,4649,4652,3901,4655,4079,
            3134,3037,576,958,1800,1264,224,1818,225,226,
            1260,88,92,79,89,91,93,94,1242,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1608,119,120,121,131,2512,217,1859,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,1959,1069,195,
            306,1929,1944,185,460,257,265,281,459,465,
            2067,1062,175,1973,2000,168,2102,980,162,2070,
            2092,156,2290,959,150,304,140,2225,145,2272,
            305,4657,4658,4659,232,837,1800,4661,4664,4667,
            4668,4669,4673,4674,232,3468,1800,4677,4670,4671,
            4683,4684,3015,2539,1800,1264,224,1818,225,226,
            1260,88,92,79,89,91,93,94,1242,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1608,119,120,121,131,2512,217,1859,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,1959,1069,195,
            1114,1929,1944,185,460,257,265,281,459,465,
            2067,1062,175,1973,2000,168,2102,980,162,2070,
            2092,156,2290,959,150,487,140,2225,145,2272,
            4685,833,4686,4692,4694,4484,4521,4697,4698,4700,
            4703,4458,4220,4704,4705,4701,4707,4708,4205,4709,
            4711,4716,4718,72,3549,4726,2882,4729,4719,4735,
            4727,72,3531,4739,71,491,4742,4741,4513,4743,
            4745,4747,71,3480,1792,4749,4482,4751,4553,4750,
            4752,4753,4754,4756,4758,4760,4762,4766,319,2355,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,1608,119,
            120,121,131,2512,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,3478,1929,1944,
            185,460,257,265,281,459,465,2067,1062,175,
            1973,2000,168,2102,980,162,2070,2092,156,2290,
            959,150,838,140,2225,145,2272,4778,4776,4780,
            4783,4536,4764,4772,4782,4219,4232,4246,4258,4271,
            4285,4288,4303,4315,4318,4171,4330,4333,4347,4360,
            4374,4386,4563,4415,4565,4784,3721,3710,4169,4788,
            3477,4331,4789,4518,4566,4572,4419,3479,324,958,
            1800,1264,224,1818,225,226,1260,88,92,79,
            89,91,93,94,1242,771,772,775,142,218,
            77,78,216,110,111,112,113,1608,119,120,
            121,131,2512,217,1859,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,1959,1069,195,292,1929,1944,185,
            460,257,265,281,459,465,2067,1062,175,1973,
            2000,168,2102,980,162,2070,2092,156,2290,959,
            150,138,140,2225,145,2272,94,3578,4628,3297,
            3428,4787,4435,4790,4427,4791,4793,4794,4800,4797,
            4578,3231,4801,4580,4803,4804,3230,4308,947,4811,
            4812,4808,4816,4814,4416,4818,4820,4821,4399,3934,
            4822,4082,4828,3857,4426,4431,4436,4582,4584,4227,
            4589,4591,4594,4595,4139,4570,4054,4829,4831,4832,
            4834,4835,4841,4842,268,302,486,824,829,839,
            13358,387,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,292,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,138,140,2225,145,2272,4179,
            4446,4459,4849,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,3231,13919,13919,13919,13919,3343,
            450,958,1800,1264,224,1818,225,226,1260,88,
            92,79,89,91,93,94,1242,771,772,775,
            142,218,77,78,216,110,111,112,113,1608,
            119,120,121,131,2512,217,1859,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,1959,1069,195,292,1929,
            1944,185,460,257,265,281,459,465,2067,1062,
            175,1973,2000,168,2102,980,162,2070,2092,156,
            2290,959,150,138,140,2225,145,2272,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,3231,13919,13919,13919,13919,3350,513,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,1608,119,
            120,121,131,2512,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,292,1929,1944,
            185,460,257,265,281,459,465,2067,1062,175,
            1973,2000,168,2102,980,162,2070,2092,156,2290,
            959,150,138,140,2225,145,2272,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,3231,13919,13919,13919,13919,3351,644,958,
            1800,1264,224,1818,225,226,1260,88,92,79,
            89,91,93,94,1242,771,772,775,142,218,
            77,78,216,110,111,112,113,1608,119,120,
            121,131,2512,217,1859,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,1959,1069,195,292,1929,1944,185,
            460,257,265,281,459,465,2067,1062,175,1973,
            2000,168,2102,980,162,2070,2092,156,2290,959,
            150,138,140,2225,145,2272,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,3231,13919,13919,13919,13919,3440,2792,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,4324,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            517,140,2225,145,2272,13919,4238,4165,3458,3874,
            4180,4237,4338,3873,4545,4557,4628,4022,4162,4212,
            4452,4140,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,736,13919,13919,13919,13919,13919,13919,
            331,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,735,449,768,758,619,619,264,
            268,527,657,530,767,633,585,585,619,832,
            13919,519,261,136,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1608,119,120,121,131,2512,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,458,1929,1944,185,460,257,265,281,459,
            465,2067,1062,175,1973,2000,168,2102,980,162,
            2070,2092,156,2290,959,150,3460,140,2225,145,
            2272,2689,707,958,1800,1264,224,1818,225,226,
            1260,88,92,79,89,91,93,94,1242,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1608,119,120,121,131,2512,217,1859,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,1959,1069,195,
            292,1929,1944,185,460,257,265,281,459,465,
            2067,1062,175,1973,2000,168,2102,980,162,2070,
            2092,156,2290,959,150,138,140,2225,145,2272,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,3231,13919,13919,13919,13919,
            3462,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,457,833,958,1800,1264,
            224,1818,225,226,1260,88,92,79,89,91,
            93,94,1242,771,772,775,142,218,77,78,
            216,110,111,112,113,1608,119,120,121,131,
            2512,217,1859,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,1959,1069,195,292,1929,1944,185,460,257,
            265,281,459,465,2067,1062,175,1973,2000,168,
            2102,980,162,2070,2092,156,2290,959,150,138,
            140,2225,145,2272,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,3231,
            13919,13919,13919,13919,3493,896,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,292,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,138,140,
            2225,145,2272,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,3231,13919,
            13919,13919,13919,3495,959,958,1800,1264,224,1818,
            225,226,1260,88,92,79,89,91,93,94,
            1242,771,772,775,142,218,77,78,216,110,
            111,112,113,1608,119,120,121,131,2512,217,
            1859,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,1959,
            1069,195,292,1929,1944,185,460,257,265,281,
            459,465,2067,1062,175,1973,2000,168,2102,980,
            162,2070,2092,156,2290,959,150,138,140,2225,
            145,2272,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,3231,13919,13919,
            13919,13919,3497,1022,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1608,119,120,121,131,2512,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,292,1929,1944,185,460,257,265,281,459,
            465,2067,1062,175,1973,2000,168,2102,980,162,
            2070,2092,156,2290,959,150,138,140,2225,145,
            2272,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,3231,13919,13919,13919,
            13919,3588,1085,958,1800,1264,224,1818,225,226,
            1260,88,92,79,89,91,93,94,1242,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1608,119,120,121,131,2512,217,1859,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,1959,1069,195,
            454,1929,1944,185,460,257,265,281,459,465,
            2067,1062,175,1973,2000,168,2102,980,162,2070,
            2092,156,2290,959,150,3460,140,2225,145,2272,
            2689,1153,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,292,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,138,140,2225,145,2272,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,3231,13919,13919,13919,13919,3745,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,453,1216,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,292,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,138,140,
            2225,145,2272,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,3231,13919,
            13919,13919,13919,3746,1279,958,1800,1264,224,1818,
            225,226,1260,88,92,79,89,91,93,94,
            1242,771,772,775,142,218,77,78,216,110,
            111,112,113,1608,119,120,121,131,2512,217,
            1859,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,1959,
            1069,195,292,1929,1944,185,460,257,265,281,
            459,465,2067,1062,175,1973,2000,168,2102,980,
            162,2070,2092,156,2290,959,150,138,140,2225,
            145,2272,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,3231,13919,13919,
            13919,13919,3747,1410,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1608,119,120,121,131,2512,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,308,1929,1944,185,460,257,265,281,459,
            465,2067,1062,175,1973,2000,168,2102,980,162,
            2070,2092,156,2290,959,150,2817,140,2225,145,
            2272,3301,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            2210,119,120,121,131,3198,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,198,3199,197,13919,
            13919,320,1662,958,1800,1264,224,1818,225,226,
            1260,88,92,79,89,91,93,94,1242,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1608,119,120,121,131,2512,217,1859,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,1959,1069,195,
            308,1929,1944,185,460,257,265,281,459,465,
            2067,1062,175,1973,2000,168,2102,980,162,2070,
            2092,156,2290,959,150,2817,140,2225,145,2272,
            13919,13919,3015,958,1800,1264,224,1818,225,226,
            1260,88,92,79,89,91,93,94,1242,771,
            772,775,142,218,77,78,216,110,111,112,
            113,1608,119,120,121,131,2512,217,1859,211,
            219,227,235,236,243,244,303,438,440,474,
            500,504,505,779,778,200,203,1959,1069,195,
            320,1929,1944,185,460,257,265,281,459,465,
            2067,1062,175,1973,2000,168,2102,980,162,2070,
            2092,156,2290,959,150,3036,140,2225,145,2272,
            3301,958,1800,1264,224,1818,225,226,1260,88,
            92,79,89,91,93,94,1242,771,772,775,
            142,218,77,78,216,110,111,112,113,2210,
            119,120,121,131,3201,217,1859,211,219,227,
            235,236,243,244,303,438,440,474,500,504,
            505,779,778,200,203,1959,1069,195,13919,1929,
            1944,185,13919,13919,13919,13919,13919,13919,178,3216,
            787,13919,13919,84,85,2953,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,13919,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,304,140,
            2225,145,2272,305,3301,958,1800,1264,224,1818,
            225,226,1260,88,92,79,89,91,93,94,
            1242,771,772,775,142,218,77,78,216,110,
            111,112,113,2210,119,120,121,131,3220,217,
            1859,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,1959,
            1069,195,13919,1929,1944,185,13919,13919,13919,13919,
            13919,13919,2067,1062,175,1973,2000,168,164,3221,
            163,13919,13919,310,2040,958,1800,1264,224,1818,
            225,226,1260,88,92,79,89,91,93,94,
            1242,771,772,775,142,218,77,78,216,110,
            111,112,113,1608,119,120,121,131,2512,217,
            1859,211,219,227,235,236,243,244,303,438,
            440,474,500,504,505,779,778,200,203,1959,
            1069,195,292,1929,1944,185,460,257,265,281,
            459,465,2067,1062,175,1973,2000,168,2102,980,
            162,2070,2092,156,2290,959,150,138,140,2225,
            145,2272,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,3730,2229,958,
            1800,1264,224,1818,225,226,1260,88,92,79,
            89,91,93,94,1242,771,772,775,142,218,
            77,78,216,110,111,112,113,1608,119,120,
            121,131,2512,217,1859,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,1959,1069,195,308,1929,1944,185,
            460,257,265,281,459,465,2067,1062,175,1973,
            2000,168,2102,980,162,2070,2092,156,2290,959,
            150,2817,140,2225,145,2272,13919,13919,2953,958,
            1800,1264,224,1818,225,226,1260,88,92,79,
            89,91,93,94,1242,771,772,775,142,218,
            77,78,216,110,111,112,113,1608,119,120,
            121,131,2512,217,1859,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,1959,1069,195,320,1929,1944,185,
            460,257,265,281,459,465,2067,1062,175,1973,
            2000,168,2102,980,162,2070,2092,156,2290,959,
            150,304,140,2225,145,2272,305,3301,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,2210,119,120,121,
            131,2993,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,13919,1929,1944,185,13919,
            13919,13919,13919,13919,13919,2067,1062,175,170,2997,
            169,13919,13919,13919,13919,13919,313,2292,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,308,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            2817,140,2225,145,2272,13919,13919,2418,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,320,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            259,140,2225,145,2272,3069,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,4324,1929,1944,185,460,257,265,
            3030,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,3027,140,
            2225,145,2272,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            258,709,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,708,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,3028,1473,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1608,119,120,121,131,2512,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,285,1929,1944,185,460,257,265,281,459,
            465,2067,1062,175,1973,2000,168,2102,980,162,
            2070,2092,156,2290,959,150,284,140,2225,145,
            2272,1536,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,283,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,282,140,2225,145,2272,1599,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,1608,119,
            120,121,131,2512,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,785,1929,1944,
            185,460,257,265,281,459,465,2067,1062,175,
            1973,2000,168,2102,980,162,2070,2092,156,2290,
            959,150,784,140,2225,145,2272,2418,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,13919,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            259,140,2225,145,2272,1725,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,528,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,3342,140,
            2225,145,2272,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            3339,1788,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,275,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,274,140,2225,145,2272,1851,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,1608,119,
            120,121,131,2512,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,293,1929,1944,
            185,460,257,265,281,459,465,2067,1062,175,
            1973,2000,168,2102,980,162,2070,2092,156,2290,
            959,150,139,140,2225,145,2272,1914,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,273,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            272,140,2225,145,2272,1977,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,745,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,744,140,
            2225,145,2272,2166,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1608,119,120,121,131,2512,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,300,1929,1944,185,460,257,265,281,459,
            465,2067,1062,175,1973,2000,168,2102,980,162,
            2070,2092,156,2290,959,150,299,140,2225,145,
            2272,3015,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,13919,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,2696,140,2225,145,2272,3015,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,1608,119,
            120,121,131,2512,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,13919,1929,1944,
            185,460,257,265,281,459,465,2067,1062,175,
            1973,2000,168,2102,980,162,2070,2092,156,2290,
            959,150,3235,140,2225,145,2272,3015,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,13919,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            221,140,2225,145,2272,3015,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,13919,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,67,140,
            2225,145,2272,3015,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1608,119,120,121,131,2512,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,13919,1929,1944,185,460,257,265,281,459,
            465,2067,1062,175,1973,2000,168,2102,980,162,
            2070,2092,156,2290,959,150,3447,140,2225,145,
            2272,3015,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,13919,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,3450,140,2225,145,2272,3015,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89
        };
    };

    public interface BaseAction1 {
        public final static char baseAction1[] = {
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,13919,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            3456,140,2225,145,2272,3015,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,13919,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,3457,140,
            2225,145,2272,3015,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1608,119,120,121,131,2512,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,13919,1929,1944,185,460,257,265,281,459,
            465,2067,1062,175,1973,2000,168,2102,980,162,
            2070,2092,156,2290,959,150,3459,140,2225,145,
            2272,3015,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,13919,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,3461,140,2225,145,2272,3015,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,1608,119,
            120,121,131,2512,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,13919,1929,1944,
            185,460,257,265,281,459,465,2067,1062,175,
            1973,2000,168,2102,980,162,2070,2092,156,2290,
            959,150,511,140,2225,145,2272,3015,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,13919,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            87,140,2225,145,2272,3015,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,13919,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,237,140,
            2225,145,2272,3015,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1608,119,120,121,131,2512,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,13919,1929,1944,185,460,257,265,281,459,
            465,2067,1062,175,1973,2000,168,2102,980,162,
            2070,2092,156,2290,959,150,3464,140,2225,145,
            2272,3015,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,13919,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,689,140,2225,145,2272,3015,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,1608,119,
            120,121,131,2512,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,13919,1929,1944,
            185,460,257,265,281,459,465,2067,1062,175,
            1973,2000,168,2102,980,162,2070,2092,156,2290,
            959,150,68,140,2225,145,2272,3015,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,13919,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            4315,140,2225,145,2272,3015,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,13919,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,3492,140,
            2225,145,2272,3015,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1608,119,120,121,131,2512,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,13919,1929,1944,185,460,257,265,281,459,
            465,2067,1062,175,1973,2000,168,2102,980,162,
            2070,2092,156,2290,959,150,461,140,2225,145,
            2272,3015,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,13919,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,3592,140,2225,145,2272,3015,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,1608,119,
            120,121,131,2512,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,13919,1929,1944,
            185,460,257,265,281,459,465,2067,1062,175,
            1973,2000,168,2102,980,162,2070,2092,156,2290,
            959,150,510,140,2225,145,2272,3015,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,13919,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            509,140,2225,145,2272,3015,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,13919,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,3725,140,
            2225,145,2272,3015,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1608,119,120,121,131,2512,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,13919,1929,1944,185,460,257,265,281,459,
            465,2067,1062,175,1973,2000,168,2102,980,162,
            2070,2092,156,2290,959,150,444,140,2225,145,
            2272,3015,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,13919,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,3726,140,2225,145,2272,3015,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,1608,119,
            120,121,131,2512,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,13919,1929,1944,
            185,460,257,265,281,459,465,2067,1062,175,
            1973,2000,168,2102,980,162,2070,2092,156,2290,
            959,150,3728,140,2225,145,2272,3015,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,13919,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            488,140,2225,145,2272,3015,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,13919,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,3740,140,
            2225,145,2272,3015,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1608,119,120,121,131,2512,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,13919,1929,1944,185,460,257,265,281,459,
            465,2067,1062,175,1973,2000,168,2102,980,162,
            2070,2092,156,2290,959,150,3743,140,2225,145,
            2272,3015,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,13919,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,3768,140,2225,145,2272,3015,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,1608,119,
            120,121,131,2512,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,13919,1929,1944,
            185,460,257,265,281,459,465,2067,1062,175,
            1973,2000,168,2102,980,162,2070,2092,156,2290,
            959,150,3769,140,2225,145,2272,3015,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,13919,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            3770,140,2225,145,2272,3015,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,13919,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,3771,140,
            2225,145,2272,3015,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,1608,119,120,121,131,2512,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,13919,1929,1944,185,460,257,265,281,459,
            465,2067,1062,175,1973,2000,168,2102,980,162,
            2070,2092,156,2290,959,150,490,140,2225,145,
            2272,3015,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            1608,119,120,121,131,2512,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,13919,
            1929,1944,185,460,257,265,281,459,465,2067,
            1062,175,1973,2000,168,2102,980,162,2070,2092,
            156,2290,959,150,489,140,2225,145,2272,3015,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,1608,119,
            120,121,131,2512,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,13919,1929,1944,
            185,460,257,265,281,459,465,2067,1062,175,
            1973,2000,168,2102,980,162,2070,2092,156,2290,
            959,150,3772,140,2225,145,2272,3015,958,1800,
            1264,224,1818,225,226,1260,88,92,79,89,
            91,93,94,1242,771,772,775,142,218,77,
            78,216,110,111,112,113,1608,119,120,121,
            131,2512,217,1859,211,219,227,235,236,243,
            244,303,438,440,474,500,504,505,779,778,
            200,203,1959,1069,195,13919,1929,1944,185,460,
            257,265,281,459,465,2067,1062,175,1973,2000,
            168,2102,980,162,2070,2092,156,2290,959,150,
            3872,140,2225,145,2272,3015,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,1608,119,120,121,131,2512,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,13919,1929,1944,185,460,257,265,
            281,459,465,2067,1062,175,1973,2000,168,2102,
            980,162,2070,2092,156,2290,959,150,628,140,
            2225,145,2272,3351,958,1800,1264,3597,1818,3596,
            3595,3605,3607,92,79,3606,3604,3603,3602,1242,
            771,772,775,142,218,3601,3600,3611,110,111,
            112,113,2210,119,120,121,131,3749,3610,214,
            416,3609,3608,3599,3598,243,244,303,438,440,
            474,500,504,505,779,778,232,2695,1800,13919,
            13919,13919,13919,4354,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,232,40,1800,13919,13919,2099,13919,13919,
            13919,13919,13919,13919,13919,406,409,414,420,426,
            3612,3625,401,3614,3624,391,13919,3613,3626,381,
            13919,13919,3616,3623,374,3615,3721,368,3619,3622,
            362,624,13919,358,3750,357,3351,958,1800,1264,
            3597,1818,3596,3595,3605,3607,92,79,3606,3604,
            3603,3602,1242,771,772,775,142,218,3601,3600,
            3611,110,111,112,113,2210,119,120,121,131,
            3766,3610,214,416,3609,3608,3599,3598,243,244,
            303,438,440,474,500,504,505,779,778,13919,
            13919,621,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,70,13919,13919,13919,13919,13919,13919,13919,
            13919,69,13919,13919,13919,13919,13919,13919,3634,40,
            1800,2704,55,2802,57,58,96,13919,406,409,
            414,420,426,3612,3625,401,3614,3624,391,13919,
            3613,3626,381,583,13919,3616,3623,374,3615,3721,
            368,364,3767,363,3351,958,1800,1264,3597,1818,
            3596,3595,3605,3607,92,79,3606,3604,3603,3602,
            1242,771,772,775,142,218,3601,3600,3611,110,
            111,112,113,2210,119,120,121,131,3751,3610,
            214,416,3609,3608,3599,3598,243,244,303,438,
            440,474,500,504,505,779,778,228,231,2699,
            3130,13919,13919,13919,4318,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,232,40,1800,13919,13919,
            2099,13919,13919,95,40,1800,2704,55,2802,57,
            58,13919,13919,13919,13919,13919,406,409,414,420,
            426,3612,3625,401,3614,3624,391,13919,3613,3626,
            381,729,13919,3616,3623,374,370,3752,369,3351,
            958,1800,1264,3597,1818,3596,3595,3605,3607,92,
            79,3606,3604,3603,3602,1242,771,772,775,142,
            218,3601,3600,3611,110,111,112,113,2210,119,
            120,121,131,3764,3610,214,416,3609,3608,3599,
            3598,243,244,303,438,440,474,500,504,505,
            779,778,228,231,3451,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,95,40,1800,2704,55,
            2802,57,58,95,40,1800,2704,55,2802,57,
            58,406,409,414,420,426,3612,3625,401,3614,
            3624,391,13919,3613,3626,381,583,13919,376,3765,
            375,3351,958,1800,1264,3597,1818,3596,3595,3605,
            3607,92,79,3606,3604,3603,3602,1242,771,772,
            775,142,218,3601,3600,3611,110,111,112,113,
            2210,119,120,121,131,3753,3610,214,416,3609,
            3608,3599,3598,243,244,303,438,440,474,500,
            504,505,779,778,228,231,3458,13919,13919,13919,
            13919,13919,228,231,2488,13919,13919,4319,13919,13919,
            13919,734,95,40,1800,2704,55,2802,57,58,
            95,40,1800,2704,55,2802,57,58,13919,13919,
            13919,13919,13919,406,409,414,420,426,3612,3625,
            401,3614,3624,391,13919,384,3754,383,3351,958,
            1800,1264,3597,1818,3596,3595,3605,3607,92,79,
            3606,3604,3603,3602,1242,771,772,775,142,218,
            3601,3600,3611,110,111,112,113,2210,119,120,
            121,131,3753,3610,214,416,3609,3608,3599,3598,
            243,244,303,438,440,474,500,504,505,779,
            778,228,231,66,13919,13919,13919,13919,13919,228,
            231,4314,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,3686,40,
            1800,2704,55,2802,57,58,13919,13919,13919,13919,
            406,409,414,420,426,3612,3625,401,3614,3624,
            391,13919,384,3755,382,3301,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,2210,119,120,121,131,3201,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,13919,1929,1944,185,228,231,617,
            13919,13919,13919,178,3218,177,3301,958,1800,1264,
            224,1818,225,226,1260,88,92,79,89,91,
            93,94,1242,771,772,775,142,218,77,78,
            216,110,111,112,113,2210,119,120,121,131,
            3201,217,1859,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,200,
            203,1959,1069,195,13919,1929,1944,185,13919,13919,
            2423,4310,13919,13919,178,3219,176,3351,958,1800,
            1264,3597,1818,3596,3595,3605,3607,92,79,3606,
            3604,3603,3602,1242,771,772,775,142,218,3601,
            3600,3611,110,111,112,113,2210,119,120,121,
            131,3759,3610,214,416,3609,3608,3599,3598,243,
            244,303,438,440,474,500,504,505,779,778,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,95,40,1800,2704,55,2802,
            57,58,13919,13919,13919,13919,13919,13919,286,3454,
            95,40,1800,2704,55,2802,57,58,13919,406,
            409,414,420,426,3612,3625,401,396,3760,395,
            3351,958,1800,1264,3597,1818,3596,3595,3605,3607,
            92,79,3606,3604,3603,3602,1242,771,772,775,
            142,218,3601,3600,3611,110,111,112,113,2210,
            119,120,121,131,3759,3610,214,416,3609,3608,
            3599,3598,243,244,303,438,440,474,500,504,
            505,779,778,228,231,3486,288,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,228,
            231,3489,95,40,1800,2704,55,2802,57,58,
            95,40,1800,2704,55,2802,57,58,13919,13919,
            13919,13919,406,409,414,420,426,3612,3625,401,
            396,3761,394,3351,958,1800,1264,3597,1818,3596,
            3595,3605,3607,92,79,3606,3604,3603,3602,1242,
            771,772,775,142,218,3601,3600,3611,110,111,
            112,113,2210,119,120,121,131,3759,3610,214,
            416,3609,3608,3599,3598,243,244,303,438,440,
            474,500,504,505,779,778,13919,13919,13919,13919,
            13919,228,231,618,13919,13919,13919,13919,13919,228,
            231,3734,95,40,1800,2704,55,2802,57,58,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,406,409,414,420,426,
            3612,3625,401,396,3762,393,3351,958,1800,1264,
            3597,1818,3596,3595,3605,3607,92,79,3606,3604,
            3603,3602,1242,771,772,775,142,218,3601,3600,
            3611,110,111,112,113,2210,119,120,121,131,
            3759,3610,214,416,3609,3608,3599,3598,243,244,
            303,438,440,474,500,504,505,779,778,13919,
            13919,228,231,2273,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,406,409,
            414,420,426,3612,3625,401,396,3763,392,3301,
            958,1800,1264,224,1818,225,226,1260,88,92,
            79,89,91,93,94,1242,771,772,775,142,
            218,77,78,216,110,111,112,113,2210,119,
            120,121,131,2998,217,1859,211,219,227,235,
            236,243,244,303,438,440,474,500,504,505,
            779,778,200,203,1959,1069,195,13919,190,2999,
            189,3301,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            2210,119,120,121,131,2998,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,200,203,1959,1069,195,13919,
            190,3000,188,3301,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,2210,119,120,121,131,2998,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,200,203,1959,1069,
            195,13919,190,3023,187,3301,958,1800,1264,224,
            1818,225,226,1260,88,92,79,89,91,93,
            94,1242,771,772,775,142,218,77,78,216,
            110,111,112,113,2210,119,120,121,131,2998,
            217,1859,211,219,227,235,236,243,244,303,
            438,440,474,500,504,505,779,778,200,203,
            1959,1069,195,4324,190,3024,186,3351,958,1800,
            1264,3597,1818,3596,3595,3605,3607,92,79,3606,
            3604,3603,3602,1242,771,772,775,142,218,3601,
            3600,3611,110,111,112,113,2210,119,120,121,
            131,3756,3610,214,416,3609,3608,3599,3598,243,
            244,303,438,440,474,500,504,505,779,778,
            13919,713,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,712,13919,13919,13919,13919,13919,13919,13919,406,
            409,414,420,426,404,3757,403,3351,958,1800,
            1264,3597,1818,3596,3595,3605,3607,92,79,3606,
            3604,3603,3602,1242,771,772,775,142,218,3601,
            3600,3611,110,111,112,113,2210,119,120,121,
            131,3756,3610,214,416,3609,3608,3599,3598,243,
            244,303,438,440,474,500,504,505,779,778,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,406,
            409,414,420,426,404,3758,402,3351,958,1800,
            1264,3597,1818,3596,3595,3605,3607,92,79,3606,
            3604,3603,3602,1242,771,772,775,142,218,3601,
            3600,3611,110,111,112,113,2210,119,120,121,
            131,3744,3610,214,416,3609,3608,3599,3598,243,
            244,303,438,440,474,500,504,505,779,778,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,95,40,1800,2704,55,2802,57,58,412,
            417,414,420,426,3351,958,1800,1264,3597,1818,
            3596,3595,3605,3607,92,79,3606,3604,3603,3602,
            1242,771,772,775,142,218,3601,3600,3611,110,
            111,112,113,2210,119,120,121,131,3744,3610,
            214,416,3609,3608,3599,3598,243,244,303,438,
            440,474,500,504,505,779,778,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,415,13919,
            228,231,617,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,412,411,414,420,
            426,3351,958,1800,1264,3597,1818,3596,3595,3605,
            3607,92,79,3606,3604,3603,3602,1242,771,772,
            775,142,218,3601,3600,3611,110,111,112,113,
            2210,119,120,121,131,3744,3610,214,416,3609,
            3608,3599,3598,243,244,303,438,440,474,500,
            504,505,779,778,4320,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,408,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,412,410,414,420,426,3301,958,
            1800,1264,224,1818,225,226,1260,88,92,79,
            89,91,93,94,1242,771,772,775,142,218,
            77,78,216,110,111,112,113,2210,119,120,
            121,131,3198,217,1859,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,200,203,198,3200,196,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,407,3301,958,1800,1264,224,1818,225,
            226,1260,88,92,79,89,91,93,94,1242,
            771,772,775,142,218,77,78,216,110,111,
            112,113,2210,119,120,121,131,2824,217,1859,
            211,219,227,235,236,243,244,303,438,440,
            474,500,504,505,779,778,206,213,3301,958,
            1800,1264,224,1818,225,226,1260,88,92,79,
            89,91,93,94,1242,771,772,775,142,218,
            77,78,216,110,111,112,113,2210,119,120,
            121,131,2824,217,1859,211,219,227,235,236,
            243,244,303,438,440,474,500,504,505,779,
            778,206,212,4324,4324,4324,13919,13919,13919,13919,
            3633,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            210,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,3238,13919,13919,13919,13919,13919,13919,
            13919,718,723,727,13919,13919,13919,13919,316,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,717,722,726,13919,209,3301,958,1800,1264,
            224,1818,225,226,1260,88,92,79,89,91,
            93,94,1242,771,772,775,142,218,77,78,
            216,110,111,112,113,2210,119,120,121,131,
            2824,217,1859,211,219,227,235,236,243,244,
            303,438,440,474,500,504,505,779,778,206,
            205,3301,958,1800,1264,224,1818,225,226,1260,
            88,92,79,89,91,93,94,1242,771,772,
            775,142,218,77,78,216,110,111,112,113,
            2210,119,120,121,131,2824,217,1859,211,219,
            227,235,236,243,244,303,438,440,474,500,
            504,505,779,778,206,204,3517,3713,639,13919,
            2704,818,3713,820,819,2704,818,315,820,819,
            506,3821,13919,13919,2704,818,13919,820,819,13919,
            3737,13919,3967,2704,818,3821,820,819,2704,818,
            13919,820,819,202,13919,3896,837,1800,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,442,13919,549,667,269,13919,507,13919,
            769,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,4000,13919,13919,13919,
            596,13919,13919,13919,13919,13919,821,822,201,13919,
            13919,821,822,636,2753,837,1800,13919,13919,13919,
            821,822,13919,13919,3465,13919,13919,13919,13919,821,
            822,13919,13919,13919,821,822,13919,13919,13919,208,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            2261,2831,2832,13919,596,4307,2831,2832,3341,13919,
            2513,13919,3739,13919,830,2831,2832,13919,13919,13919,
            13919,13919,534,927,2831,2832,13919,13919,3238,2831,
            2832,13919,13919,13919,13919,13919,3453,13919,542,543,
            544,545,546,547,1553,13919,612,808,13919,663,
            664,665,2429,13359,675,676,1526,681,682,2416,
            690,691,2523,1533,589,590,591,592,593,594,
            1564,833,612,3340,13919,663,664,665,2429,13359,
            675,676,1526,681,682,2416,690,691,2523,1533,
            3453,3821,13919,13919,2704,818,3821,820,819,2704,
            818,3821,820,819,2704,818,3401,820,819,199,
            837,1800,13919,13919,2367,13919,587,13919,589,590,
            591,592,593,594,1564,13919,612,13919,13919,663,
            664,665,2429,13359,675,676,1526,681,682,2416,
            690,691,2523,1533,1834,812,13919,13919,537,532,
            13919,539,540,541,550,551,2676,554,555,2674,
            13919,13919,13919,13919,808,13919,13919,566,13919,13919,
            587,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            821,822,2834,13919,13919,821,822,807,13919,13919,
            821,822,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,790,4321,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,833,13919,635,13919,
            13919,13919,13919,13919,1623,2831,2832,3234,13919,2289,
            2831,2832,13919,13919,831,2831,2832,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,535,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,1789,
            13919,1834,812,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,807,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,3233,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,3481,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,567,
            13919,0,340,342,0,14255,335,0,322,329,
            0,3871,335,0,330,336,0
        };
    };

    public final static char baseAction[] = new char[BaseAction0.baseAction0.length + BaseAction1.baseAction1.length];
    {
        int index = 0;
        System.arraycopy(BaseAction0.baseAction0, 0, baseAction, index, BaseAction0.baseAction0.length);
        index += BaseAction0.baseAction0.length;
        System.arraycopy(BaseAction1.baseAction1, 0, baseAction, index, BaseAction1.baseAction1.length);
    };
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static char termCheck[] = {0,
            0,1,2,3,4,0,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,0,55,56,57,58,59,
            60,61,62,0,0,0,0,2,0,3,
            2,66,6,7,8,75,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            0,25,26,0,0,2,96,3,5,0,
            6,7,8,37,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,54,25,
            26,121,0,55,56,57,58,59,60,61,
            62,66,67,0,69,0,1,2,3,4,
            140,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,126,
            55,56,57,58,59,60,61,62,0,109,
            2,3,67,0,6,7,8,0,86,2,
            3,112,5,6,7,8,83,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,0,25,26,3,0,1,6,7,8,
            0,0,1,2,3,0,0,0,1,2,
            3,4,117,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,94,55,56,57,58,59,60,61,62,
            0,1,105,106,68,80,76,77,78,79,
            75,75,75,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,67,55,56,
            57,58,59,60,61,62,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            0,55,56,57,58,59,60,61,62,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,63,55,56,57,58,59,60,
            61,62,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,0,55,56,57,
            58,59,60,61,62,0,1,2,3,4,
            0,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,0,
            55,56,57,58,59,60,61,62,0,1,
            2,3,67,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,68,55,56,
            57,58,59,60,61,62,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            0,55,56,57,58,59,60,61,62,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,63,55,56,57,58,59,60,
            61,62,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,0,55,56,57,
            58,59,60,61,62,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,0,
            55,56,57,58,59,60,61,62,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,0,55,56,57,58,59,60,61,
            62,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,0,55,56,57,58,
            59,60,61,62,0,1,2,3,4,0,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,0,55,
            56,57,58,59,60,61,62,0,1,2,
            0,67,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,68,55,56,57,
            58,59,60,61,62,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,119,
            55,56,57,58,59,60,61,62,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,0,55,56,57,58,59,60,61,
            62,0,1,2,3,4,0,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,0,55,56,57,58,
            59,60,61,62,0,73,2,3,67,0,
            1,2,3,4,68,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,68,55,56,57,58,59,60,
            61,62,0,1,2,3,4,82,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,0,55,56,57,
            58,59,60,61,62,0,1,2,3,4,
            0,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,0,
            55,56,57,58,59,60,61,62,0,1,
            2,3,4,0,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,0,55,56,57,58,59,60,61,
            62,0,1,2,3,4,0,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,0,55,56,57,58,
            59,60,61,62,0,1,2,3,4,0,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,0,55,
            56,57,58,59,60,61,62,0,1,2,
            3,4,0,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,0,55,56,57,58,59,60,61,62,
            0,1,2,3,4,0,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,0,55,56,57,58,59,
            60,61,62,0,1,2,3,4,0,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,0,55,56,
            57,58,59,60,61,62,0,1,2,3,
            4,0,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            0,55,56,57,58,59,60,61,62,0,
            1,2,3,4,0,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,0,55,56,57,58,59,60,
            61,62,0,1,2,3,4,0,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,0,55,56,57,
            58,59,60,61,62,0,1,2,3,4,
            0,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,0,
            55,56,57,58,59,60,61,62,0,1,
            2,3,4,0,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,0,55,56,57,58,59,60,61,
            62,0,1,2,3,4,0,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,0,55,56,57,58,
            59,60,61,62,0,1,0,3,4,3,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,0,55,
            56,57,58,59,60,61,62,0,1,0,
            3,4,0,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,0,55,56,57,58,59,60,61,62,
            0,1,0,3,4,0,6,7,8,67,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,115,55,56,57,58,59,
            60,61,62,0,1,0,1,67,3,4,
            0,6,7,8,83,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,0,
            55,56,57,58,59,60,61,62,0,1,
            0,1,67,3,4,130,6,7,8,69,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,0,55,56,57,58,59,
            60,61,62,0,0,0,1,67,3,4,
            0,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,55,
            56,57,58,59,60,61,62,0,139,0,
            3,68,0,6,7,8,66,67,0,1,
            75,0,0,89,2,3,92,0,6,7,
            8,24,0,24,2,3,24,94,6,7,
            8,96,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,0,25,26,0,
            0,0,1,4,3,4,121,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,0,95,0,97,98,
            99,4,101,102,103,0,94,67,107,0,
            108,72,76,77,78,79,75,105,106,0,
            0,24,2,0,27,28,29,30,31,32,
            0,0,0,1,0,3,4,96,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,66,67,83,0,
            95,2,97,98,99,0,101,102,103,0,
            69,70,0,1,73,3,4,75,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,67,0,1,2,
            0,66,67,3,0,1,67,3,4,67,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,0,1,
            0,3,4,3,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,0,1,0,3,4,120,6,7,
            8,0,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,0,1,0,1,
            0,1,0,3,4,3,6,7,8,67,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,0,1,2,0,0,1,
            3,3,4,67,6,7,8,67,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,0,0,2,3,0,5,2,3,
            0,1,0,3,4,67,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            0,1,50,3,4,0,6,7,8,0,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            0,0,2,3,0,0,6,7,8,4,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,25,26,0,4,2,
            3,0,27,0,3,4,3,6,7,8,
            9,86,0,84,85,0,87,0,24,2,
            5,27,28,29,30,31,32,0,0,2,
            2,3,5,0,33,34,35,36,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,0,25,26,0,1,2,0,1,
            0,0,88,3,94,0,6,7,8,4,
            69,54,71,72,9,105,106,76,77,78,
            79,0,81,66,83,4,0,86,2,88,
            9,0,91,2,3,0,1,6,7,8,
            0,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,0,25,26,0,54,
            0,93,94,0,66,2,68,75,63,64,
            65,73,0,105,106,54,71,72,80,24,
            82,0,1,2,63,64,65,0,1,2,
            69,70,71,72,0,74,104,76,77,78,
            79,100,81,68,83,0,66,86,73,88,
            118,90,91,0,9,80,0,82,24,93,
            0,95,82,97,98,99,100,101,102,103,
            104,68,0,107,108,54,110,111,75,113,
            80,69,0,0,2,73,3,66,67,6,
            7,8,126,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,141,25,26,
            144,0,114,147,3,0,71,6,7,8,
            0,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,0,25,26,3,0,
            80,6,7,8,91,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,0,
            25,26,0,4,2,3,84,85,9,87,
            0,0,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,0,25,26,3,
            0,76,77,78,79,24,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,54,142,76,77,78,79,0,
            1,0,63,64,65,0,0,0,69,70,
            71,72,5,74,0,76,77,78,79,69,
            81,0,83,9,0,86,0,88,0,3,
            91,81,6,7,8,93,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            0,0,0,3,0,0,0,1,88,93,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,25,26,3,54,80,
            6,7,8,0,0,71,0,4,64,65,
            4,86,9,0,70,9,3,91,74,6,
            7,8,0,0,2,2,54,33,34,35,
            0,0,38,39,0,4,64,65,4,9,
            9,66,67,69,0,0,125,2,3,73,
            0,6,7,8,0,81,80,54,82,0,
            54,0,1,93,90,0,63,64,65,63,
            64,65,69,125,71,72,0,71,72,76,
            77,78,79,0,81,54,83,4,54,86,
            67,68,9,90,63,64,65,63,64,65,
            69,71,71,72,0,1,72,76,77,78,
            79,0,81,54,83,4,0,67,2,0,
            9,90,63,64,65,131,132,133,134,135,
            136,137,138,89,69,70,92,54,73,117,
            95,0,0,89,2,0,63,64,65,0,
            0,2,69,0,71,72,0,0,1,76,
            77,78,79,0,81,54,83,0,0,86,
            2,0,0,2,63,64,65,0,0,1,
            69,116,71,72,0,66,67,76,77,78,
            79,75,81,148,149,54,151,152,122,123,
            124,90,0,0,63,64,65,4,66,93,
            68,95,9,97,98,99,100,101,102,103,
            104,0,69,70,75,4,110,111,0,113,
            80,0,69,0,66,4,73,0,1,68,
            9,84,93,75,95,73,97,98,99,100,
            101,102,103,104,112,0,100,54,80,110,
            111,0,113,0,96,4,63,64,65,116,
            9,0,69,89,71,72,92,120,0,76,
            77,78,79,0,81,54,83,0,0,0,
            88,2,4,72,63,64,65,9,127,143,
            69,68,71,72,0,1,2,76,77,78,
            79,0,81,2,0,54,2,80,0,5,
            0,66,0,1,63,64,65,94,0,0,
            146,2,71,72,5,0,0,76,77,78,
            79,0,54,80,24,0,0,76,77,78,
            79,63,64,65,0,66,67,68,54,71,
            72,0,75,2,76,77,78,79,0,0,
            66,67,89,145,54,92,0,66,67,68,
            4,0,68,63,64,65,0,0,2,2,
            70,5,0,89,74,0,92,68,109,54,
            89,112,80,92,69,69,88,0,63,64,
            65,122,123,124,73,70,81,81,0,74,
            0,75,54,69,70,90,90,66,67,68,
            54,63,64,65,0,54,67,0,70,63,
            64,65,74,115,63,64,65,0,72,54,
            89,70,0,92,68,74,128,0,63,64,
            65,54,75,0,0,70,0,0,5,74,
            63,64,65,0,54,2,84,70,0,0,
            0,74,0,63,64,65,0,0,54,2,
            70,54,5,75,74,9,0,63,64,65,
            63,64,65,0,70,2,54,70,74,0,
            0,74,0,1,4,63,64,65,54,0,
            0,54,70,0,4,68,74,63,64,65,
            63,64,65,54,70,0,54,70,74,82,
            67,74,63,64,65,63,64,65,0,70,
            54,0,70,74,0,68,74,71,80,63,
            64,65,0,54,0,0,70,0,0,66,
            74,91,63,64,65,0,0,54,75,70,
            0,0,72,74,0,0,63,64,65,54,
            0,0,72,70,75,0,5,74,63,64,
            65,0,54,2,0,70,5,0,0,74,
            0,63,64,65,0,0,54,0,70,54,
            0,67,74,104,9,63,64,65,63,64,
            65,0,70,0,1,84,74,118,87,54,
            76,77,78,79,76,77,78,79,63,64,
            65,76,77,78,79,0,76,77,78,79,
            84,85,0,87,9,84,85,0,87,68,
            0,1,88,66,84,85,69,87,0,84,
            85,0,87,2,3,0,71,70,84,85,
            73,87,84,85,0,87,2,66,84,85,
            69,87,0,1,84,85,0,87,2,24,
            0,1,0,80,0,0,4,107,108,0,
            0,0,0,9,9,4,71,0,66,0,
            68,0,5,0,5,4,69,4,0,0,
            0,0,1,0,0,0,1,9,81,9,
            80,66,9,9,0,1,0,1,0,0,
            66,0,1,0,0,1,0,0,0,1,
            0,5,66,0,1,0,1,0,0,2,
            0,1,80,5,72,71,71,0,69,69,
            80,0,1,72,0,68,0,68,0,5,
            81,0,80,72,0,72,0,0,0,71,
            0,71,73,0,71,71,0,0,0,0,
            0,5,0,0,66,66,0,5,5,66,
            24,5,0,0,0,0,0,5,5,5,
            73,0,1,0,1,75,0,0,0,0,
            0,5,0,0,0,68,0,0,0,5,
            0,5,5,5,66,0,0,0,0,73,
            5,0,5,66,73,0,0,73,0,69,
            5,73,69,5,0,68,68,68,0,5,
            0,0,0,73,0,5,0,5,0,0,
            0,0,0,0,5,0,5,0,1,0,
            5,0,1,0,5,0,69,82,66,66,
            5,0,73,73,24,0,66,0,1,0,
            5,0,0,0,5,3,0,0,0,0,
            0,73,0,0,96,109,0,5,82,0,
            0,80,0,0,5,0,68,0,82,68,
            0,0,5,0,68,0,1,0,5,0,
            0,0,5,75,5,5,82,0,0,66,
            0,0,0,0,0,5,5,85,5,5,
            0,0,0,0,0,5,75,66,0,0,
            0,0,0,5,0,0,66,0,0,0,
            0,0,0,0,0,0,83,0,0,83,
            0,69,119,86,86,82,0,66,82,0,
            91,0,82,73,0,82,0,0,0,0,
            85,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,88,
            83,69,0,0,86,0,0,0,0,0,
            0,0,73,0,0,0,0,0,0,85,
            0,0,82,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,114,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,129,0,0,0,0,0,0,0,
            0,0,150,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0
        };
    };
    public final static char termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            13919,715,14444,715,715,13919,715,715,715,715,
            715,715,715,715,715,715,715,715,715,715,
            715,715,715,715,715,715,715,715,715,715,
            715,715,715,715,715,715,715,715,715,715,
            715,715,715,715,715,715,715,715,715,715,
            715,715,715,715,588,715,715,715,715,715,
            715,715,715,13919,13919,13919,13919,14444,13919,2816,
            14444,14467,13955,2815,14699,715,13970,13972,13973,13971,
            13969,2705,13961,13962,13963,13964,13965,13966,13967,13968,
            707,2797,2706,13919,13919,14444,715,13953,14186,711,
            13955,14700,14699,14651,13970,13972,13973,13971,13969,2705,
            13961,13962,13963,13964,13965,13966,13967,13968,2382,2797,
            2706,715,154,756,756,756,756,756,756,756,
            756,14590,1408,13919,7739,13919,7651,14444,13953,14023,
            13155,13955,14700,14699,13100,13970,13972,13973,13971,13969,
            1405,13961,13962,13963,13964,13965,13966,13967,13968,14019,
            1751,1567,14017,14018,14022,14021,14025,14024,1209,974,
            1060,13045,13952,2492,1717,5463,2683,14421,1181,14422,
            1215,1726,2287,1056,2003,2510,6487,2226,1257,13903,
            755,755,755,755,755,755,755,755,13919,6633,
            14444,13953,1408,135,13955,14700,14699,13919,158,14444,
            811,12475,803,811,811,811,6317,811,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,13919,811,811,13953,143,135,13955,14700,14699,
            13919,13919,1180,14444,1591,13919,13919,13919,7651,14444,
            13953,14023,9059,13955,14700,14699,13100,13970,13972,13973,
            13971,13969,1405,13961,13962,13963,13964,13965,13966,13967,
            13968,14019,1751,1567,14017,14018,14022,14021,14025,14024,
            1209,974,1060,13045,13952,2492,1717,5612,2683,14421,
            1181,14422,1215,1726,2287,1056,2003,2510,6487,13360,
            1257,14732,755,755,755,755,755,755,755,755,
            13919,1516,14733,14734,2660,40,12417,12355,12293,12231,
            14440,14014,514,13919,7651,14444,13953,14023,136,13955,
            14700,14699,13100,13970,13972,13973,13971,13969,1405,13961,
            13962,13963,13964,13965,13966,13967,13968,14019,1751,1567,
            14017,14018,14022,14021,14025,14024,1209,974,1060,13045,
            13952,2492,1717,5463,2683,14421,1181,14422,1215,1726,
            2287,1056,2003,2510,6487,2226,1257,2840,755,755,
            755,755,755,755,755,755,13919,7651,14444,13953,
            14023,136,13955,14700,14699,13100,13970,13972,13973,13971,
            13969,1405,13961,13962,13963,13964,13965,13966,13967,13968,
            14019,1751,1567,14017,14018,14022,14021,14025,14024,1209,
            974,1060,13045,13952,2492,1717,5463,2683,14421,1181,
            14422,1215,1726,2287,1056,2003,2510,6487,2226,1257,
            13919,755,755,755,755,755,755,755,755,13919,
            7651,14444,13953,14023,136,13955,14700,14699,13100,13970,
            13972,13973,13971,13969,1405,13961,13962,13963,13964,13965,
            13966,13967,13968,14019,1751,1567,14017,14018,14022,14021,
            14025,14024,1209,974,1060,13045,13952,2492,1717,5463,
            2683,14421,1181,14422,1215,1726,2287,1056,2003,2510,
            6487,2226,1257,1527,755,755,755,755,755,755,
            755,755,13919,7651,14444,13953,14023,136,13955,14700,
            14699,13100,13970,13972,13973,13971,13969,1405,13961,13962,
            13963,13964,13965,13966,13967,13968,14019,1751,1567,14017,
            14018,14022,14021,14025,14024,1209,974,1060,13045,13952,
            2492,1717,5463,2683,14421,1181,14422,1215,1726,2287,
            1056,2003,2510,6487,2226,1257,634,755,755,755,
            755,755,755,755,755,13919,7651,14444,13953,14023,
            700,13955,14700,14699,13100,13970,13972,13973,13971,13969,
            1405,13961,13962,13963,13964,13965,13966,13967,13968,14019,
            1751,1567,14017,14018,14022,14021,14025,14024,1209,974,
            1060,13045,13952,2492,1717,5463,2683,14421,1181,14422,
            1215,1726,2287,1056,2003,2510,6487,2226,1257,82,
            755,755,755,755,755,755,755,755,13919,1195,
            14444,1591,1408,13919,7651,14444,13953,14023,136,13955,
            14700,14699,13100,13970,13972,13973,13971,13969,1405,13961,
            13962,13963,13964,13965,13966,13967,13968,14019,1751,1567,
            14017,14018,14022,14021,14025,14024,1209,974,1060,13045,
            13952,2492,1717,5463,2683,14421,1181,14422,1215,1726,
            2287,1056,2003,2510,6487,2226,1257,5702,755,755,
            755,755,755,755,755,755,13919,7651,14444,13953,
            14023,136,13955,14700,14699,13100,13970,13972,13973,13971,
            13969,1405,13961,13962,13963,13964,13965,13966,13967,13968,
            14019,1751,1567,14017,14018,14022,14021,14025,14024,1209,
            974,1060,13045,13952,2492,1717,5463,2683,14421,1181,
            14422,1215,1726,2287,1056,2003,2510,6487,2226,1257,
            642,755,755,755,755,755,755,755,755,13919,
            7651,14444,13953,14023,14041,13955,14700,14699,13100,13970,
            13972,13973,13971,13969,1405,13961,13962,13963,13964,13965,
            13966,13967,13968,14019,1751,1567,14017,14018,14022,14021,
            14025,14024,1209,974,1060,13045,13952,2492,1717,5463,
            2683,14421,1181,14422,1215,1726,2287,1056,2003,2510,
            6487,2226,1257,1534,755,755,755,755,755,755,
            755,755,13919,7651,14444,13953,14023,136,13955,14700,
            14699,13100,13970,13972,13973,13971,13969,1405,13961,13962,
            13963,13964,13965,13966,13967,13968,14019,1751,1567,14017,
            14018,14022,14021,14025,14024,1209,974,1060,13045,13952,
            2492,1717,5463,2683,14421,1181,14422,1215,1726,2287,
            1056,2003,2510,6487,2226,1257,13919,755,755,755,
            755,755,755,755,755,13919,7651,14444,13953,14023,
            136,13955,14700,14699,13100,13970,13972,13973,13971,13969,
            1405,13961,13962,13963,13964,13965,13966,13967,13968,14019,
            1751,1567,14017,14018,14022,14021,14025,14024,1209,974,
            1060,13045,13952,2492,1717,5463,2683,14421,1181,14422,
            1215,1726,2287,1056,2003,2510,6487,2226,1257,13919,
            755,755,755,755,755,755,755,755,13919,7651,
            14444,13953,14023,136,13955,14700,14699,13100,13970,13972,
            13973,13971,13969,1405,13961,13962,13963,13964,13965,13966,
            13967,13968,14019,1751,1567,14017,14018,14022,14021,14025,
            14024,1209,974,1060,13045,13952,2492,1717,5463,2683,
            14421,1181,14422,1215,1726,2287,1056,2003,2510,6487,
            2226,1257,13919,755,755,755,755,755,755,755,
            755,13919,7651,14444,13953,14023,136,13955,14700,14699,
            13100,13970,13972,13973,13971,13969,1405,13961,13962,13963,
            13964,13965,13966,13967,13968,14019,1751,1567,14017,14018,
            14022,14021,14025,14024,1209,974,1060,13045,13952,2492,
            1717,5463,2683,14421,1181,14422,1215,1726,2287,1056,
            2003,2510,6487,2226,1257,13919,755,755,755,755,
            755,755,755,755,13919,7651,14444,13953,14023,13919,
            13955,14700,14699,13100,13970,13972,13973,13971,13969,1405,
            13961,13962,13963,13964,13965,13966,13967,13968,14019,1751,
            1567,14017,14018,14022,14021,14025,14024,1209,974,1060,
            13045,13952,2492,1717,5463,2683,14421,1181,14422,1215,
            1726,2287,1056,2003,2510,6487,2226,1257,62,755,
            755,755,755,755,755,755,755,13919,13481,14444,
            13919,1408,13919,7651,14444,13953,14023,136,13955,14700,
            14699,13100,13970,13972,13973,13971,13969,1405,13961,13962,
            13963,13964,13965,13966,13967,13968,14019,1751,1567,14017,
            14018,14022,14021,14025,14024,1209,974,1060,13045,13952,
            2492,1717,5463,2683,14421,1181,14422,1215,1726,2287,
            1056,2003,2510,6487,2226,1257,2094,755,755,755,
            755,755,755,755,755,13919,7651,14444,13953,14023,
            136,13955,14700,14699,13100,13970,13972,13973,13971,13969,
            1405,13961,13962,13963,13964,13965,13966,13967,13968,14019,
            1751,1567,14017,14018,14022,14021,14025,14024,1209,974,
            1060,13045,13952,2492,1717,5463,2683,14421,1181,14422,
            1215,1726,2287,1056,2003,2510,6487,2226,1257,3242,
            755,755,755,755,755,755,755,755,13919,7651,
            14444,13953,14023,136,13955,14700,14699,13100,13970,13972,
            13973,13971,13969,1405,13961,13962,13963,13964,13965,13966,
            13967,13968,14019,1751,1567,14017,14018,14022,14021,14025,
            14024,1209,974,1060,13045,13952,2492,1717,5463,2683,
            14421,1181,14422,1215,1726,2287,1056,2003,2510,6487,
            2226,1257,13919,755,755,755,755,755,755,755,
            755,13919,311,1563,311,311,137,311,311,311,
            311,311,311,311,311,311,311,311,311,311,
            311,311,311,311,311,311,311,311,311,311,
            311,311,311,311,311,311,311,311,311,311,
            311,311,311,311,311,311,311,311,311,311,
            311,311,311,311,311,298,311,311,311,311,
            311,311,311,311,13919,11200,14444,2215,311,13919,
            7651,14444,13953,14023,7299,13955,14700,14699,13100,13970,
            13972,13973,13971,13969,1405,13961,13962,13963,13964,13965,
            13966,13967,13968,14019,1751,1567,14017,14018,14022,14021,
            14025,14024,1209,974,1060,13045,13952,2492,1717,5463,
            2683,14421,1181,14422,1215,1726,2287,1056,2003,2510,
            6487,2226,1257,3590,755,755,755,755,755,755,
            755,755,13919,7651,14444,13953,14023,7563,13955,14700,
            14699,13100,13970,13972,13973,13971,13969,1405,13961,13962,
            13963,13964,13965,13966,13967,13968,14019,1751,1567,14017,
            14018,14022,14021,14025,14024,1209,974,1060,13045,13952,
            2492,1717,5463,2683,14421,1181,14422,1215,1726,2287,
            1056,2003,2510,6487,2226,1257,13919,755,755,755,
            755,755,755,755,755,13919,7651,14444,13953,14023,
            13919,13955,14700,14699,13100,13970,13972,13973,13971,13969,
            1405,13961,13962,13963,13964,13965,13966,13967,13968,14019,
            1751,1567,14017,14018,14022,14021,14025,14024,1209,974,
            1060,13045,13952,2492,1717,5463,2683,14421,1181,14422,
            1215,1726,2287,1056,2003,2510,6487,2226,1257,13919,
            755,755,755,755,755,755,755,755,13919,7651,
            14444,13953,14023,13919,13955,14700,14699,13100,13970,13972,
            13973,13971,13969,1405,13961,13962,13963,13964,13965,13966,
            13967,13968,14019,1751,1567,14017,14018,14022,14021,14025,
            14024,1209,974,1060,13045,13952,2492,1717,5463,2683,
            14421,1181,14422,1215,1726,2287,1056,2003,2510,6487,
            2226,1257,13919,755,755,755,755,755,755,755,
            755,13919,8179,14444,13953,14023,13919,13955,14700,14699,
            13100,13970,13972,13973,13971,13969,1405,13961,13962,13963,
            13964,13965,13966,13967,13968,14019,1751,1567,14017,14018,
            14022,14021,14025,14024,1209,974,1060,13045,13952,2492,
            1717,5463,2683,14421,1181,14422,1215,1726,2287,1056,
            2003,2510,6487,2226,1257,13919,755,755,755,755,
            755,755,755,755,13919,7651,14444,13953,14023,13919,
            13955,14700,14699,13100,13970,13972,13973,13971,13969,1405,
            13961,13962,13963,13964,13965,13966,13967,13968,14019,1751,
            1567,14017,14018,14022,14021,14025,14024,1209,974,1060,
            13045,13952,2492,1717,5463,2683,14421,1181,14422,1215,
            1726,2287,1056,2003,2510,6487,2226,1257,13919,755,
            755,755,755,755,755,755,755,13919,7651,14444,
            13953,14023,13919,13955,14700,14699,13100,13970,13972,13973,
            13971,13969,1405,13961,13962,13963,13964,13965,13966,13967,
            13968,14019,1751,1567,14017,14018,14022,14021,14025,14024,
            1209,974,1060,13045,13952,2492,1717,5463,2683,14421,
            1181,14422,1215,1726,2287,1056,2003,2510,6487,2226,
            1257,13919,755,755,755,755,755,755,755,755,
            13919,7651,14444,13953,14023,13919,13955,14700,14699,13100,
            13970,13972,13973,13971,13969,1405,13961,13962,13963,13964,
            13965,13966,13967,13968,14019,1751,1567,14017,14018,14022,
            14021,14025,14024,1209,974,1060,13045,13952,2492,1717,
            5463,2683,14421,1181,14422,1215,1726,2287,1056,2003,
            2510,6487,2226,1257,13919,755,755,755,755,755,
            755,755,755,13919,7651,14444,13953,14023,13919,13955,
            14700,14699,13100,13970,13972,13973,13971,13969,1405,13961,
            13962,13963,13964,13965,13966,13967,13968,14019,1751,1567,
            14017,14018,14022,14021,14025,14024,1209,974,1060,13045,
            13952,2492,1717,5463,2683,14421,1181,14422,1215,1726,
            2287,1056,2003,2510,6487,2226,1257,13919,755,755,
            755,755,755,755,755,755,13919,7651,14444,13953,
            14023,13919,13955,14700,14699,13100,13970,13972,13973,13971,
            13969,1405,13961,13962,13963,13964,13965,13966,13967,13968,
            14019,1751,1567,14017,14018,14022,14021,14025,14024,1209,
            974,1060,13045,13952,2492,1717,5463,2683,14421,1181,
            14422,1215,1726,2287,1056,2003,2510,6487,2226,1257,
            13919,755,755,755,755,755,755,755,755,13919,
            7651,14444,13953,14023,13919,13955,14700,14699,13100,13970,
            13972,13973,13971,13969,1405,13961,13962,13963,13964,13965,
            13966,13967,13968,14019,1751,1567,14017,14018,14022,14021,
            14025,14024,1209,974,1060,13045,13952,2492,1717,5463,
            2683,14421,1181,14422,1215,1726,2287,1056,2003,2510,
            6487,2226,1257,13919,755,755,755,755,755,755,
            755,755,13919,7651,14444,13953,14023,13919,13955,14700,
            14699,13100,13970,13972,13973,13971,13969,1405,13961,13962,
            13963,13964,13965,13966,13967,13968,14019,1751,1567,14017,
            14018,14022,14021,14025,14024,1209,974,1060,13045,13952,
            2492,1717,5463,2683,14421,1181,14422,1215,1726,2287,
            1056,2003,2510,6487,2226,1257,13919,755,755,755,
            755,755,755,755,755,13919,7651,14444,13953,14023,
            13919,13955,14700,14699,13100,13970,13972,13973,13971,13969,
            1405,13961,13962,13963,13964,13965,13966,13967,13968,14019,
            1751,1567,14017,14018,14022,14021,14025,14024,1209,974,
            1060,13045,13952,2492,1717,5463,2683,14421,1181,14422,
            1215,1726,2287,1056,2003,2510,6487,2226,1257,13919,
            755,755,755,755,755,755,755,755,13919,10203,
            14444,13953,14023,13919,13955,14700,14699,13100,13970,13972,
            13973,13971,13969,1405,13961,13962,13963,13964,13965,13966,
            13967,13968,14019,1751,1567,14017,14018,14022,14021,14025,
            14024,1209,974,1060,13045,13952,2492,1717,5463,2683,
            14421,1181,14422,1215,1726,2287,1056,2003,2510,6487,
            2226,1257,13919,755,755,755,755,755,755,755,
            755,13919,10819,14444,13953,14023,13919,13955,14700,14699,
            13100,13970,13972,13973,13971,13969,1405,13961,13962,13963,
            13964,13965,13966,13967,13968,14019,1751,1567,14017,14018,
            14022,14021,14025,14024,1209,974,1060,13045,13952,2492,
            1717,5463,2683,14421,1181,14422,1215,1726,2287,1056,
            2003,2510,6487,2226,1257,13919,755,755,755,755,
            755,755,755,755,538,7651,13919,13953,14023,3033,
            13955,14700,14699,13100,13970,13972,13973,13971,13969,1405,
            13961,13962,13963,13964,13965,13966,13967,13968,14019,1751,
            1567,14017,14018,14022,14021,14025,14024,1209,974,1060,
            13045,13952,2492,1717,5463,2683,14421,1181,14422,1215,
            1726,2287,1056,2003,2510,6487,2226,1257,13919,755,
            755,755,755,755,755,755,755,260,7651,86,
            13953,14023,13919,13955,14700,14699,13100,13970,13972,13973,
            13971,13969,1405,13961,13962,13963,13964,13965,13966,13967,
            13968,14019,1751,1567,14017,14018,14022,14021,14025,14024,
            1209,974,1060,13045,13952,2492,1717,5463,2683,14421,
            1181,14422,1215,1726,2287,1056,2003,2510,6487,2226,
            1257,160,755,755,755,755,755,755,755,755,
            220,10115,13919,13953,19171,816,13955,14700,14699,1408,
            13970,13972,13973,13971,13969,1405,13961,13962,13963,13964,
            13965,13966,13967,13968,14019,1751,1567,14017,14018,14022,
            14021,14025,14024,1209,974,1060,12679,13952,2492,1717,
            6138,2683,14421,1181,14422,1215,1726,2287,1056,2003,
            2510,6487,2226,1257,8619,755,755,755,755,755,
            755,755,755,13919,6575,220,10115,1408,13953,19171,
            13919,13955,14700,14699,164,13970,13972,13973,13971,13969,
            1405,13961,13962,13963,13964,13965,13966,13967,13968,14019,
            1751,1567,14017,14018,14022,14021,14025,14024,1209,974,
            1060,12679,13952,2492,1717,6138,2683,14421,1181,14422,
            1215,1726,2287,1056,2003,2510,6487,2226,1257,471,
            755,755,755,755,755,755,755,755,13919,1401,
            220,10115,1408,13953,19171,3034,13955,14700,14699,8707,
            13970,13972,13973,13971,13969,1405,13961,13962,13963,13964,
            13965,13966,13967,13968,14019,1751,1567,14017,14018,14022,
            14021,14025,14024,1209,974,1060,12679,13952,2492,1717,
            6397,2683,14421,1181,14422,1215,1726,2287,1056,2003,
            2510,6487,2226,1257,573,755,755,755,755,755,
            755,755,755,13919,13919,755,7651,1408,13953,14023,
            13919,13955,14700,14699,13100,13970,13972,13973,13971,13969,
            1405,13961,13962,13963,13964,13965,13966,13967,13968,14019,
            1751,1567,14017,14018,14022,14021,14025,14024,1209,974,
            1060,13045,13952,2492,1717,5612,2683,14421,1181,14422,
            1215,1726,2287,1056,2003,2510,6487,13360,1257,14670,
            14672,14680,14682,14671,14673,14681,14683,13919,2836,90,
            13953,929,35,13955,14700,14699,14611,1771,13919,3628,
            719,13919,13919,1369,14444,13953,1988,13919,13955,14700,
            14699,14019,13919,14020,14444,811,13956,7827,811,811,
            811,719,811,811,811,811,811,811,811,811,
            811,811,811,811,811,811,172,811,811,13919,
            13919,755,7651,13303,13953,14023,13156,13955,14700,14699,
            13100,13970,13972,13973,13971,13969,1405,13961,13962,13963,
            13964,13965,13966,13967,13968,14019,1751,1567,14017,14018,
            14022,14021,14025,14024,1209,974,1060,13045,13952,2492,
            1717,5612,2683,14421,1181,14422,1215,1726,2287,1056,
            2003,2510,6487,13360,1257,13919,14715,239,2073,14589,
            14588,14023,14713,14714,13583,161,14732,3041,3334,13919,
            1397,13248,178,178,178,178,512,14733,14734,13919,
            13919,14019,14444,13919,14017,14018,14022,14021,14025,14024,
            13919,443,755,7651,13919,13953,14023,512,13955,14700,
            14699,13100,13970,13972,13973,13971,13969,1405,13961,13962,
            13963,13964,13965,13966,13967,13968,14019,1751,1567,14017,
            14018,14022,14021,14025,14024,1209,974,1060,13045,13952,
            2492,1717,5463,2683,14421,1181,14422,1215,1726,2287,
            1056,2003,2510,6487,2226,1257,14597,1408,6317,13919,
            14715,14444,2073,14589,14588,13919,14713,14714,13583,13919,
            9675,8531,755,7651,11427,13953,14023,81,13955,14700,
            14699,13100,13970,13972,13973,13971,13969,1405,13961,13962,
            13963,13964,13965,13966,13967,13968,14019,1751,1567,14017,
            14018,14022,14021,14025,14024,1209,974,1060,13045,13952,
            2492,1717,5463,2683,14421,1181,14422,1215,1726,2287,
            1056,2003,2510,6487,2226,1257,1327,13919,7095,14444,
            13919,14604,1408,1591,755,7651,1334,13953,14023,1408,
            13955,14700,14699,13100,13970,13972,13973,13971,13969,1405,
            13961,13962,13963,13964,13965,13966,13967,13968,14019,1751,
            1567,14017,14018,14022,14021,14025,14024,1209,974,1060,
            13045,13952,2492,1717,5463,2683,14421,1181,14422,1215,
            1726,2287,1056,2003,2510,6487,2226,1257,755,7651,
            13919,3029,14023,14736,13955,14700,14699,13100,13970,13972,
            13973,13971,13969,1405,13961,13962,13963,13964,13965,13966,
            13967,13968,14019,1751,1567,14017,14018,14022,14021,14025,
            14024,1209,974,1060,13045,13952,2492,1717,5463,2683,
            14421,1181,14422,1215,1726,2287,1056,2003,2510,6487,
            2226,1257,755,10115,13919,13953,14023,3031,13955,14700,
            14699,13919,13970,13972,13973,13971,13969,1405,13961,13962,
            13963,13964,13965,13966,13967,13968,14019,1751,1567,14017,
            14018,14022,14021,14025,14024,1209,974,1060,12679,13952,
            2492,1717,5612,2683,14421,1181,14422,1215,1726,2287,
            1056,2003,2510,6487,2226,1257,13919,1826,13919,3781,
            755,10115,496,13953,14023,19609,13955,14700,14699,1408,
            13970,13972,13973,13971,13969,1405,13961,13962,13963,13964,
            13965,13966,13967,13968,14019,1751,1567,14017,14018,14022,
            14021,14025,14024,1209,974,1060,12679,13952,2492,1717,
            6397,2683,14421,1181,14422,1215,1726,2287,1056,2003,
            2510,6487,2226,1257,13919,13364,14444,13919,755,10115,
            3466,13953,14023,11048,13955,14700,14699,1408,13970,13972,
            13973,13971,13969,1405,13961,13962,13963,13964,13965,13966,
            13967,13968,14019,1751,1567,14017,14018,14022,14021,14025,
            14024,1209,974,1060,12679,13952,2492,1717,6138,2683,
            14421,1181,14422,1215,1726,2287,1056,2003,2510,6487,
            2226,1257,746,13919,748,19608,13919,748,14444,14742,
            755,7651,13919,13953,14023,1408,13955,14700,14699,13100,
            13970,13972,13973,13971,13969,1405,13961,13962,13963,13964,
            13965,13966,13967,13968,14019,1751,1567,14017,14018,14022,
            14021,14025,14024,1209,974,1060,13045,13952,2492,1717,
            5463,2683,14421,1181,14422,1215,1726,2287,1056,2003,
            755,10115,2510,13953,14023,13919,13955,14700,14699,13919,
            13970,13972,13973,13971,13969,1405,13961,13962,13963,13964,
            13965,13966,13967,13968,14019,1751,1567,14017,14018,14022,
            14021,14025,14024,1209,974,1060,12679,13952,2492,1717,
            5463,2683,14421,1181,14422,1215,1726,2287,1056,2003,
            13919,13919,14444,811,13919,13919,811,811,811,14023,
            811,811,811,811,811,811,811,811,811,811,
            811,811,811,811,13919,811,811,13919,14023,14444,
            14747,755,14017,13919,13953,13933,14215,13955,14700,14699,
            13932,5954,13919,1870,14241,13919,3742,13919,14019,14444,
            14139,14017,14018,14022,14021,14025,14024,13919,13919,14444,
            14444,811,14676,13919,1254,1040,1060,13922,811,811,
            811,811,811,811,811,811,811,811,811,811,
            811,811,629,811,811,13919,1117,14444,143,135,
            468,13919,3136,13953,14732,179,13955,14700,14699,199,
            13929,2008,13931,13934,191,14733,14734,13928,13925,13927,
            13926,141,13930,536,13920,199,13919,13923,14444,13924,
            191,13919,13921,14444,13953,143,135,13955,14700,14699,
            13919,13970,13972,13973,13971,13969,2705,13961,13962,13963,
            13964,13965,13966,13967,13968,13919,2797,2706,13919,215,
            13919,811,14732,13919,65,14444,2708,620,215,215,
            215,12002,13919,14733,14734,215,191,199,40,14019,
            65,13919,13481,14444,215,215,215,13919,1529,14444,
            171,215,191,199,246,215,2089,179,179,179,
            179,2243,171,970,165,180,1066,159,11534,153,
            2239,171,147,144,190,40,13919,65,14020,1943,
            56,792,9851,792,792,792,1618,792,792,792,
            2089,911,652,792,13601,2008,2666,2668,238,2150,
            893,7915,13919,728,14444,1734,13953,789,789,13955,
            14700,14699,531,13970,13972,13973,13971,13969,2705,13961,
            13962,13963,13964,13965,13966,13967,13968,13456,2797,2706,
            1551,13919,14417,1508,3449,786,190,13955,14700,14699,
            13919,13970,13972,13973,13971,13969,2705,13961,13962,13963,
            13964,13965,13966,13967,13968,256,2797,2706,3455,174,
            914,13955,14700,14699,146,13970,13972,13973,13971,13969,
            2705,13961,13962,13963,13964,13965,13966,13967,13968,345,
            2797,2706,13919,405,14444,14745,312,312,397,9147,
            372,609,13970,13972,13973,13971,13969,2705,13961,13962,
            13963,13964,13965,13966,13967,13968,13919,2797,2706,14745,
            148,12417,12355,12293,12231,14019,13970,13972,13973,13971,
            13969,2705,13961,13962,13963,13964,13965,13966,13967,13968,
            14020,2797,2706,215,2522,12417,12355,12293,12231,248,
            7007,13919,215,215,215,155,13919,13919,377,215,
            397,405,2120,215,13919,385,385,385,385,376,
            377,13919,371,5551,493,365,13919,359,250,13953,
            353,376,13955,14700,14699,14746,13970,13972,13973,13971,
            13969,13947,13961,13962,13963,13964,13965,13966,13967,13968,
            13919,13919,493,14745,166,13919,143,135,152,14746,
            13970,13972,13973,13971,13969,2705,13961,13962,13963,13964,
            13965,13966,13967,13968,755,2797,2706,13953,1540,914,
            13955,14700,14699,153,13919,12970,385,199,1322,14413,
            405,5954,191,61,6831,397,13953,2935,6743,13955,
            14700,14699,13919,13919,14444,14444,1540,1254,1040,1060,
            184,159,3225,3226,191,199,1322,14413,199,5551,
            191,14475,1788,170,574,13919,3025,14444,13953,11534,
            13919,13955,14700,14699,615,170,40,215,65,207,
            215,13919,1516,14746,170,13919,215,215,215,215,
            215,215,171,3025,191,199,696,397,405,179,
            179,179,179,359,171,215,165,405,215,159,
            616,11994,397,171,215,215,215,215,215,215,
            171,12970,191,199,13919,1826,199,179,179,179,
            179,165,171,215,165,199,13919,1384,14444,13919,
            191,171,215,215,215,14395,14396,14397,14398,14399,
            14400,14213,14214,1369,14197,14198,1988,215,1496,9587,
            14560,199,13919,1763,14444,13919,215,215,215,13919,
            13919,14444,377,276,397,405,13919,455,7095,385,
            385,385,385,13919,377,215,371,13919,13919,365,
            14444,13919,781,14444,215,215,215,13919,13919,3890,
            171,14199,191,199,559,14471,2005,179,179,179,
            179,2686,171,14556,14559,215,14558,14557,14624,14623,
            14622,171,149,365,215,215,215,405,600,1943,
            1177,792,397,792,792,792,1618,792,792,792,
            2089,192,14197,14198,2688,198,2666,2668,13919,2150,
            3719,371,8091,13919,4217,405,11315,13919,3999,2562,
            397,4383,1943,513,792,731,792,792,792,1618,
            792,792,792,2089,2930,513,13387,215,914,2666,
            2668,171,2150,825,513,199,215,215,215,14199,
            191,173,377,1369,397,405,1988,3031,13919,385,
            385,385,385,561,377,215,371,13919,377,13919,
            3136,14444,405,198,215,215,215,397,14549,2378,
            377,898,397,405,13919,13481,14444,385,385,385,
            385,13919,377,14444,13919,215,14444,914,354,14685,
            434,14431,135,4472,215,215,215,6919,644,13919,
            908,14444,191,199,255,13919,167,179,179,179,
            179,34,215,3720,14020,208,13919,12417,12355,12293,
            12231,215,215,215,508,702,702,13593,2008,397,
            405,13919,13999,14444,385,385,385,385,431,13919,
            568,568,1369,1777,90,1988,397,578,578,1199,
            405,430,1326,90,90,90,13919,13919,14444,14444,
            90,14182,309,568,90,429,568,11994,702,214,
            578,702,41,578,11748,11748,358,428,214,214,
            214,702,702,702,733,214,11677,11677,13919,214,
            427,14149,226,9499,9411,5790,5790,577,577,1199,
            215,226,226,226,425,225,1628,424,226,215,
            215,215,226,2352,225,225,225,13919,405,224,
            577,225,437,577,1821,225,2363,13919,224,224,
            224,236,14367,13919,436,224,13919,435,2426,224,
            236,236,236,13919,235,14444,5865,236,13919,433,
            13919,236,432,235,235,235,183,13919,78,14444,
            235,77,14186,14152,235,5551,423,78,78,78,
            77,77,77,13919,78,14444,94,77,78,421,
            194,77,13919,1742,13303,94,94,94,93,629,
            193,91,94,419,13303,1953,94,93,93,93,
            91,91,91,89,93,418,88,91,93,10643,
            1408,91,89,89,89,88,88,88,422,89,
            227,311,88,89,13919,2535,88,12970,1035,227,
            227,227,220,219,378,413,227,13919,13919,1617,
            227,10995,219,219,219,380,340,217,513,219,
            379,335,13248,219,13919,405,217,217,217,216,
            13919,13919,13248,217,512,322,13978,217,216,216,
            216,13919,220,14444,335,216,3129,13919,336,216,
            579,220,220,220,13919,182,14023,13919,220,215,
            13919,1327,220,2089,5551,14023,14023,14023,215,215,
            215,13919,14023,13919,4814,16100,14023,2239,9147,215,
            384,384,384,384,12128,12025,11922,11819,215,215,
            215,12128,12025,11922,11819,181,12128,12025,11922,11819,
            342,13904,13919,342,5551,2012,13907,13919,3742,11994,
            13919,4923,11118,14579,1124,3870,9323,3742,13919,329,
            13910,746,329,748,19608,13919,12970,8531,1266,13913,
            11427,3742,330,13916,13919,330,14444,14580,2432,14248,
            10027,3742,606,2500,2432,14249,13919,3742,14444,14020,
            800,13481,398,1569,386,13919,404,14500,14501,373,
            688,13919,135,396,12479,12873,12970,13919,2663,13919,
            1953,400,14043,399,14044,12873,11570,12873,390,34,
            389,13919,1753,388,387,13919,4108,12479,11463,12479,
            1600,14710,12479,12479,13919,8003,13919,13481,13919,13919,
            14575,13919,11650,281,13919,8443,13919,13919,13919,13205,
            13919,13979,14448,13919,1206,499,2571,13919,13919,14444,
            483,3344,914,1537,404,396,12579,804,11570,8883,
            914,482,3352,12776,13919,7299,797,7299,13919,14721,
            11463,13919,40,12776,13919,12776,610,13919,13919,12579,
            13919,12579,11427,13919,12579,12579,13919,262,266,13919,
            13919,14168,13919,13919,14452,8267,13919,4313,14420,8355,
            14020,14148,13919,13919,13919,13919,463,14661,14660,14047,
            11534,13919,4596,134,4705,2682,13919,13919,724,34,
            34,1357,13919,13919,13919,1791,13919,13919,13919,2427,
            13919,840,2933,11812,14592,13919,743,13919,65,13598,
            5032,135,14048,14707,11542,13919,13919,11886,13919,7915,
            1579,1734,8971,1861,13919,1821,2535,11902,72,14042,
            13919,140,13919,14666,13919,14404,798,14403,13919,13919,
            611,749,13919,13919,14151,13919,14684,133,5121,13919,
            14045,13919,5245,13919,14046,13919,2493,14414,14578,14514,
            14657,13919,2142,12763,14020,13919,14442,13919,5354,13919,
            14656,13919,13919,366,2934,14216,13919,360,13919,350,
            13919,11534,13919,13919,13157,9235,13919,14036,7475,13919,
            13919,41,66,13919,14033,335,1811,13919,9763,6034,
            13919,13919,14526,13919,1791,13919,10731,13919,3748,13919,
            13919,355,14049,2692,14659,14658,9939,367,361,14577,
            13919,13919,651,13919,13919,982,14037,14236,14035,14034,
            13919,13919,627,655,335,2154,2694,14516,13919,746,
            496,13919,13919,2293,13919,13919,14445,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,370,13919,13919,11351,
            13919,8971,6228,364,11236,10291,13919,14581,10379,13919,
            352,13919,10467,12094,13919,10555,13919,13919,13919,13919,
            13907,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,11118,
            11351,10907,13919,13919,11236,13919,13919,13919,13919,13919,
            13919,13919,3349,13919,13919,13919,13919,13919,13919,13907,
            13919,13919,3442,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,14562,13919,13919,13919,13919,
            13919,13919,13919,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,14573,13919,13919,13919,13919,13919,13919,13919,
            13919,13919,14569
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            799,126,537,77,128,130,380,138,819,132,
            745,669,745,765,669,61,327,448,77,77,
            60,818,170,208,208,745,745,481,797,496,
            823,823,498,506,558,504,512,561,508,516,
            588,515,518,606,517,1027,602,201,164,669,
            498,533,61,1120,742,744,668,744,764,568,
            763,77,471,77,658,1024,1021,744,549,744,
            1122,661,661,389,823,823,823,823,823,823,
            823,823,942,496,170,385,275,819,667,80,
            669,671,669,669,669,669,691,668,668,796,
            796,765,646,723,723,729,1041,61,77,938,
            1041,1092,63,669,500,203,823,823,823,823,
            823,823,823,80,387,689,818,818,354,211,
            669,882,206,1102,743,765,392,1129,535,535,
            669,797,731,535,819,389,77,596,569,77,
            599,473,457,565,569,77,457,77,533,477,
            77,819,818,77,61,819,500,516,500,512,
            500,506,506,506,506,63,883,88,669,1100,
            602,818,530,942,533,622,776,665,818,669,
            942,645,882,80,61,61,568,141,882,882,
            1004,965,1100,749,750,942,750,942,646,789,
            1100,1100,614,719,496,882,500,504,504,500,
            508,508,508,500,515,500,517,161,818,1005,
            819,669,797,496,77,77,669,669,497,668,
            1025,668,668,819,942,789,77,611,765,1100,
            394,765,942,61,789,757,1024,1024,533,819,
            61,646,745,61,646,596,600,599,1021,594,
            457,569,669,475,457,533,646,614,614,942,
            922,80,717,717,819,1040,745,819,61,819,
            720,964,942,819,745,819,942,942,352,788,
            161,646,61,942,942,122,819,819,77,61,
            77,819,870,882,942,704,819,252,669,63,
            497,796,796,80,77,882,80,77,819,942,
            337,818,614,819,535,616,765,753,1130,1130,
            533,613,61,261,953,61,745,132,254,254,
            594,536,533,550,668,82,536,819,942,768,
            788,788,788,80,80,942,942,774,942,819,
            664,533,957,942,61,1005,648,1025,123,819,
            121,942,818,951,882,496,882,77,882,77,
            882,942,643,942,779,942,252,782,350,789,
            619,250,942,351,942,252,620,237,819,1120,
            765,61,736,819,532,1100,264,77,531,61,
            613,261,680,785,792,77,77,739,77,594,
            745,61,1,745,819,819,745,532,819,965,
            942,1025,161,818,124,21,729,942,497,942,
            669,942,669,942,745,819,60,819,77,819,
            77,818,818,61,942,80,818,77,77,819,
            77,747,879,533,535,264,960,261,819,1100,
            132,533,745,1120,592,590,592,739,788,122,
            98,98,98,98,98,98,98,98,98,98,
            179,98,98,98,819,98,98,98,104,108,
            106,114,112,98,116,115,606,588,562,558,
            27,138,380,130,128,526,527,818,533,21,
            882,882,882,745,942,252,942,252,789,252,
            789,620,944,745,252,251,646,77,533,535,
            942,77,569,745,22,527,669,942,27,27,
            27,27,27,27,100,27,27,27,27,27,
            27,27,27,819,942,942,942,819,819,819,
            819,819,61,737,529,22,819,98,100,116,
            100,114,100,108,108,100,104,104,100,106,
            106,106,106,100,112,100,115,942,942,942,
            942,608,569,529,942,1,609,876,22,122,
            610,951,949,818,527,527,22,611,652,876,
            876,819,527,22,527,819,77,942,685,1,
            122,22,122
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static char asr[] = {0,
            71,72,76,77,69,78,79,81,63,64,
            54,70,74,65,90,83,91,86,88,119,
            9,67,51,52,53,50,55,56,57,58,
            59,60,61,62,41,36,1,48,49,43,
            47,38,45,46,42,44,35,33,34,39,
            40,31,32,4,30,29,24,28,27,37,
            25,26,15,16,17,18,19,20,21,22,
            23,14,10,13,11,12,6,8,7,3,
            0,67,66,146,89,92,0,5,114,82,
            68,115,90,119,94,126,125,70,74,63,
            64,54,65,4,72,71,9,76,77,78,
            79,69,81,83,86,88,75,66,91,96,
            2,87,84,85,0,126,0,88,0,83,
            0,24,3,8,7,6,0,4,72,0,
            6,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,25,26,7,8,3,
            2,5,0,1,6,3,8,7,0,5,
            114,82,68,115,90,119,94,126,71,9,
            4,72,76,77,69,78,79,81,75,66,
            83,91,86,88,84,85,96,87,2,24,
            70,74,63,65,64,54,0,1,67,0,
            55,56,57,58,59,60,61,62,33,34,
            35,131,132,133,134,135,136,137,138,6,
            3,8,7,39,38,0,75,114,66,115,
            119,84,85,94,96,87,2,126,139,5,
            68,82,0,6,7,8,3,107,108,0,
            75,118,104,6,95,7,8,148,149,151,
            152,2,3,0,75,41,9,36,1,48,
            49,43,47,38,45,46,42,44,35,33,
            34,39,40,14,10,13,11,12,15,31,
            32,4,30,29,24,28,27,16,17,18,
            19,20,21,22,23,26,25,37,3,8,
            7,6,51,52,53,50,55,56,57,58,
            59,60,61,62,2,0,5,75,114,115,
            119,84,85,94,96,87,2,126,109,82,
            66,68,0,55,56,57,58,59,60,61,
            62,33,34,35,6,3,8,7,83,91,
            36,86,88,69,81,71,9,4,72,76,
            77,78,79,0,125,0,70,116,69,73,
            0,2,140,75,96,121,52,40,50,53,
            51,9,36,6,3,8,7,37,25,26,
            15,16,17,18,19,20,21,22,23,27,
            28,24,30,29,4,32,31,14,10,13,
            11,12,39,33,34,35,44,42,46,45,
            38,47,43,49,48,1,41,57,61,58,
            62,55,59,56,60,0,75,95,97,98,
            99,110,111,101,102,93,103,113,104,2,
            100,0,92,89,67,1,66,2,54,0,
            67,73,116,127,130,109,142,112,92,89,
            122,123,124,150,24,80,1,70,74,63,
            64,54,65,4,72,71,9,76,77,78,
            79,69,81,90,83,86,88,5,114,82,
            68,115,119,94,126,91,84,87,85,96,
            75,2,66,0,75,66,126,141,108,144,
            111,113,110,100,93,104,2,147,107,101,
            102,95,99,98,103,97,0,71,9,0,
            90,69,81,0,94,105,106,2,25,26,
            14,10,13,11,12,15,16,17,18,19,
            20,21,22,23,3,93,0,86,0,1,
            80,2,68,66,92,67,89,0,24,145,
            0,2,3,1,0,91,0,63,150,142,
            75,2,66,69,0,75,96,0,66,82,
            68,71,9,4,72,76,77,78,79,81,
            1,63,64,80,54,74,65,90,83,91,
            86,88,5,69,70,73,0,5,2,82,
            0,6,7,8,3,129,0,143,100,0,
            94,68,0,66,75,84,120,2,1,0,
            69,1,5,67,109,122,123,124,130,66,
            2,112,68,0,69,75,66,2,63,0,
            1,67,63,54,130,109,142,112,122,123,
            124,150,80,5,114,82,115,119,84,85,
            94,87,126,69,70,116,66,96,68,2,
            75,0,67,80,130,2,73,0,119,0,
            1,5,75,73,80,69,2,68,122,123,
            124,109,112,66,67,0,50,0,115,75,
            68,0,5,68,80,130,109,112,122,123,
            124,73,69,66,2,67,0,5,68,80,
            2,73,0,69,70,5,66,0,5,68,
            73,82,66,0,66,112,24,2,5,68,
            0,68,66,112,2,1,80,0,95,107,
            141,108,97,98,99,110,111,100,144,101,
            102,93,147,103,113,104,126,2,50,53,
            52,51,55,56,57,58,59,60,61,62,
            41,9,36,6,3,8,7,37,25,26,
            15,16,17,18,19,20,21,22,23,14,
            10,13,11,12,40,39,33,34,35,44,
            42,46,45,38,47,43,49,48,1,28,
            24,30,29,32,31,27,4,0,24,66,
            0,2,55,56,57,58,59,60,61,62,
            50,53,52,51,9,36,37,27,28,24,
            30,29,4,32,31,40,39,33,34,35,
            44,42,46,45,38,47,43,49,48,1,
            41,16,17,18,19,20,21,22,23,14,
            10,13,11,12,15,26,25,6,3,8,
            7,5,0,82,68,66,69,0,128,115,
            114,0,67,2,68,0,2,117,0,2,
            127,68,0,117,55,56,57,58,59,60,
            61,62,50,53,52,51,9,36,37,27,
            28,24,30,29,4,32,31,40,39,33,
            34,35,44,42,46,45,38,47,43,49,
            48,1,41,67,16,17,18,19,20,21,
            22,23,14,10,13,11,12,15,26,25,
            6,8,7,3,2,0,5,114,82,68,
            66,115,119,84,85,94,87,2,126,96,
            55,56,57,58,59,60,61,62,50,53,
            52,51,9,36,6,3,8,7,37,25,
            26,15,16,17,18,19,20,21,22,23,
            14,10,13,11,12,40,39,33,34,35,
            44,42,46,45,38,47,43,49,48,1,
            41,27,28,24,30,29,4,32,31,75,
            0,25,26,14,10,13,11,12,15,16,
            17,18,19,20,21,22,23,3,93,24,
            0,2,3,8,7,6,108,0,5,6,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,25,26,7,8,3,2,
            94,105,106,0
        };
    };
    public final static char asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static char nasb[] = {0,
            219,315,465,192,315,315,315,315,311,357,
            230,315,230,172,315,313,187,33,314,314,
            105,232,315,315,315,315,315,315,315,18,
            454,454,315,315,315,315,315,315,315,315,
            315,315,315,315,315,311,148,100,314,315,
            315,315,313,358,77,315,129,230,229,476,
            229,314,315,314,315,89,504,315,91,315,
            498,315,315,315,204,256,404,404,404,404,
            454,454,315,58,315,87,183,262,52,69,
            315,315,315,315,315,315,315,187,187,315,
            315,229,315,315,315,315,311,313,291,126,
            311,55,314,315,315,100,238,238,244,244,
            244,250,198,483,98,315,183,183,81,39,
            315,311,315,477,31,229,109,501,152,152,
            130,315,315,152,311,315,314,96,477,314,
            358,116,114,120,477,314,114,314,315,187,
            11,311,183,1,313,311,315,315,315,315,
            315,315,315,315,315,314,311,7,315,315,
            481,232,151,315,315,315,315,36,183,315,
            315,315,311,315,313,313,476,25,311,311,
            313,210,315,315,315,315,315,315,315,315,
            315,315,315,187,18,311,315,315,315,315,
            315,315,315,315,315,315,315,187,183,185,
            73,18,315,18,314,314,315,315,315,187,
            187,315,315,311,315,315,314,9,229,315,
            311,229,315,313,315,166,187,187,315,311,
            313,315,315,313,315,96,315,315,186,112,
            485,477,130,123,485,315,315,315,315,315,
            313,482,315,315,311,311,142,311,313,311,
            187,225,315,311,230,311,315,315,315,187,
            187,315,313,315,315,23,311,311,189,313,
            137,311,4,311,315,98,311,315,315,314,
            315,315,315,463,314,181,75,216,311,315,
            79,183,315,311,152,156,229,315,119,501,
            315,315,313,64,187,313,315,357,62,62,
            67,152,315,91,129,112,152,311,315,315,
            187,187,187,483,483,315,315,315,315,311,
            152,315,187,315,313,49,168,94,132,311,
            460,315,183,315,311,18,311,314,311,314,
            311,315,315,315,315,315,315,315,315,315,
            18,16,315,315,315,315,18,60,311,358,
            229,313,315,311,187,315,158,314,151,313,
            315,64,163,315,315,314,314,14,314,67,
            230,313,295,142,311,311,142,187,311,225,
            315,187,315,183,315,311,315,315,315,315,
            315,315,315,315,173,311,105,311,11,311,
            314,311,311,313,315,315,183,314,189,311,
            314,196,315,315,152,494,187,102,311,315,
            357,315,230,358,187,140,187,28,187,135,
            315,315,315,315,315,315,315,315,315,315,
            315,315,315,315,311,315,315,315,315,315,
            315,315,315,315,315,315,315,315,315,315,
            432,315,315,315,315,315,315,232,315,311,
            311,311,311,230,315,315,315,315,315,315,
            315,18,315,230,315,315,315,314,315,152,
            315,314,477,230,295,20,315,315,269,316,
            360,360,410,410,315,432,432,382,382,382,
            382,338,294,311,315,315,315,311,311,311,
            311,311,313,187,71,295,311,315,315,315,
            315,315,315,315,315,315,315,315,315,315,
            315,315,315,315,315,315,315,315,315,315,
            315,154,477,71,315,295,175,402,295,134,
            177,315,315,232,315,144,295,170,179,160,
            160,311,315,295,71,311,314,315,154,295,
            134,295,145
        };
    };
    public final static char nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            2,145,0,8,202,0,204,0,316,0,
            2,136,0,320,0,255,0,132,0,146,
            142,0,260,0,234,235,0,323,321,0,
            319,0,335,336,0,263,211,0,16,272,
            273,253,2,252,271,19,233,0,236,234,
            0,262,58,0,247,8,0,248,0,270,
            0,221,0,228,182,0,152,0,209,0,
            170,0,278,0,254,0,318,0,266,0,
            16,2,241,19,233,0,250,0,306,0,
            231,237,0,257,0,226,0,206,0,214,
            0,182,181,0,2,3,232,0,327,58,
            0,220,0,219,0,298,58,0,198,155,
            58,0,294,58,0,243,2,0,58,139,
            0,258,0,149,169,0,2,119,0,302,
            0,166,0,146,149,142,0,140,58,0,
            58,118,0,229,0,329,0,308,0,9,
            10,0,305,58,0,339,0,334,0,311,
            0,58,208,0,309,0,310,0,315,0,
            119,136,16,8,3,2,58,0,2,160,
            0,337,2,245,0,62,0,3,8,16,
            2,82,0,16,3,8,2,79,0,2,
            3,8,16,256,0,2,276,0,2,3,
            8,16,281,0,2,3,8,16,58,88,
            0,16,3,8,2,148,0,3,8,16,
            2,57,0,3,8,16,2,70,0,3,
            8,16,2,76,0,16,3,8,2,73,
            0,65,2,16,3,8,167,0,24,35,
            38,39,16,3,9,12,8,13,14,15,
            22,23,4,6,7,40,41,2,122,0,
            2,244,0,117,24,35,38,39,9,12,
            13,14,15,22,23,40,41,4,6,7,
            16,8,3,2,0,24,35,38,39,16,
            3,9,12,8,13,14,15,22,23,4,
            6,7,40,41,2,114,0,24,35,38,
            39,9,12,13,14,15,22,23,40,41,
            4,6,7,3,16,111,2,8,0,24,
            35,38,39,16,3,9,12,8,13,14,
            15,22,23,4,6,7,40,41,2,106,
            0,24,35,38,39,12,8,13,14,15,
            22,23,40,41,4,6,7,3,16,2,
            102,9,0,16,3,8,2,61,0,24,
            35,38,39,16,3,9,12,8,13,14,
            15,22,23,4,6,7,40,41,2,99,
            0,24,35,38,39,2,16,3,9,12,
            8,13,14,15,22,23,4,6,7,40,
            41,93,0,2,3,8,16,54,0,207,
            58,0,261,0,290,178,293,186,187,190,
            193,197,144,282,0,58,3,135,134,0,
            58,205,140,0,186,187,178,190,193,197,
            144,224,0,2,313,58,0,2,284,0,
            238,155,0,2,300,0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            11,162,163,3,12,37,134,136,2,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,40,73,74,38,39,54,55,
            56,57,115,116,117,45,58,76,99,48,
            52,75,88,89,93,94,146,155,159,90,
            84,87,91,23,118,119,120,121,122,123,
            124,125,15,17,27,22,13,19,7,25,
            1,4,20,26,14,5,6,8,9,21,
            10,18,43,50,51,46,147,47,131,34,
            44,130,135,53,96,97,104,105,106,111,
            132,133,142,158,98,107,100,102,108,109,
            110,128,150,16,24,28,29,30,49,77,
            114,138,139,140,149,164,31,32,33,35,
            78,79,80,81,82,83,85,86,92,95,
            101,112,113,126,127,129,137,141,145,153,
            156,157,41,42,103,143,144,148,151,152,
            154,160,161
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            168,169,166,167,171,173,174,188,186,190,
            0,187,189,191,192,0,0,0,345,0,
            0,182,183,194,0,0,0,0,195,0,
            0,0,0,198,199,225,0,226,228,229,
            230,0,0,0,0,0,0,0,0,0,
            0,0,0,224,220,221,222,234,217,218,
            219,293,0,0,243,0,0,214,215,216,
            211,212,213,208,209,210,205,206,207,202,
            203,204,178,196,200,0,201,235,0,0,
            172,0,285,0,0,0,281,282,283,278,
            279,280,197,275,276,277,322,0,272,273,
            274,269,270,271,266,267,268,0,176,263,
            264,265,0,260,0,0,261,0,262,0,
            181,0,328,350,351,179,256,0,312,241,
            255,259,301,307,177,0,223,252,258,306,
            313,315,0,0,0,0,0,0,170,180,
            185,0,238,239,0,244,245,249,257,0,
            284,0,0,0,0,0,0,0,321,0,
            324,0,0,0,0,329,330,0,0,333,
            0,0,334,0,0,335,336,349,0,184,
            231,232,0,237,240,242,254,286,288,289,
            291,292,300,0,0,0,302,304,0,311,
            0,316,0,317,320,0,0,323,0,331,
            332,340,341,0,0,342,347,348,0,0,
            165,0,175,193,227,0,233,0,0,236,
            0,246,247,248,0,250,251,0,0,253,
            287,290,0,0,0,0,0,0,0,0,
            294,295,296,297,298,299,0,0,0,0,
            0,303,0,305,0,0,0,0,0,308,
            0,0,309,310,0,0,0,0,0,314,
            0,0,0,318,0,319,0,0,0,0,
            0,325,326,327,0,0,0,0,0,0,
            337,0,338,339,0,0,0,0,0,0,
            0,0,0,0,343,344,346,0,0,0,
            0,0,0,0,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            576,612,622,510,544,552,598,632,586,15,
            24,48,55,237,237,334,530,537,237,84,
            107,246,246,246,429,519,570,163,246,246,
            246,365,380,246,560,606,246,33,33,38,
            43,62,67,102,525,137,321,353,72,72,
            122,126,159,159,409,409,413,413,425,443,
            447,640,644,648,652,115,130,145,152,152,
            230,255,358,255,255,255,435,255,255,255,
            371,386,255,255,97,78,417,422,78,6,
            6,78,315,347,451,78,315,315,95,1,
            172,172,180,180,188,188,188,188,202,202,
            210,215,220,225,390,390,390,390,404,454,
            454,462,462,470,470,470,470,1,1,490,
            495,500,505
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            31,31,31,31,31,31,31,31,594,22,
            31,31,31,244,268,244,31,31,282,76,
            113,244,268,244,31,31,31,169,252,270,
            304,362,362,282,566,594,286,22,31,31,
            31,31,31,31,31,142,326,134,22,76,
            31,31,22,100,22,31,22,31,100,100,
            31,100,100,31,31,119,134,149,81,156,
            234,312,362,264,278,264,439,259,273,307,
            375,375,298,291,100,31,420,31,31,9,
            12,81,318,350,12,90,329,341,76,3,
            174,177,182,185,190,193,196,199,204,207,
            212,217,222,227,392,395,398,401,406,456,
            459,464,467,472,475,478,481,484,487,492,
            497,502,507
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            28,27,27,30,30,30,28,27,28,18,
            18,233,233,138,138,38,30,30,123,211,
            28,138,138,123,90,30,30,28,138,138,
            123,44,44,123,30,28,123,17,17,52,
            52,233,233,48,30,67,38,252,264,264,
            271,271,208,208,64,64,165,165,41,40,
            89,23,22,7,6,276,47,62,211,211,
            142,123,44,138,138,123,90,138,138,123,
            44,44,123,123,88,94,43,249,36,37,
            37,211,38,207,37,211,38,38,212,73,
            99,99,102,102,106,106,106,106,111,111,
            114,117,122,128,65,65,65,65,205,57,
            57,61,61,70,70,70,70,73,73,76,
            79,82,86
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static char scopeLa[] = {
            5,5,5,5,5,5,5,5,82,2,
            5,5,5,85,84,85,5,5,84,66,
            114,85,84,85,5,5,5,5,87,87,
            87,5,5,84,68,82,87,2,5,5,
            5,5,5,5,5,5,84,5,2,66,
            5,5,2,75,2,5,2,5,75,75,
            5,75,75,5,5,82,5,5,5,5,
            5,5,5,5,5,5,68,5,5,5,
            66,66,5,5,75,5,125,5,5,94,
            94,5,119,119,94,5,119,119,66,90,
            72,4,9,71,79,78,77,76,81,69,
            83,86,88,91,74,74,70,70,68,72,
            4,9,71,79,78,77,76,81,69,83,
            86,88,91
        };
    };
    public final static char scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static char scopeStateSet[] = {
            248,248,248,248,248,248,248,248,248,373,
            373,41,41,207,207,248,248,248,490,44,
            248,207,207,490,49,248,248,248,207,207,
            490,248,248,490,248,248,490,373,373,248,
            248,41,41,248,248,407,248,42,45,45,
            42,42,83,83,407,407,369,369,248,248,
            49,248,248,215,215,33,248,121,44,44,
            1,490,248,207,207,490,49,207,207,490,
            248,248,490,490,86,8,248,47,248,248,
            248,44,248,35,248,44,248,248,118,285,
            11,11,13,13,17,17,17,17,19,19,
            20,21,22,205,407,407,407,407,38,276,
            276,278,278,282,282,282,282,285,285,286,
            287,288,289
        };
    };
    public final static char scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            235,0,90,233,0,500,41,0,94,221,
            0,94,246,0,398,68,296,1,499,179,
            0,221,0,399,68,296,1,499,179,0,
            5,0,398,1,498,179,0,271,1,168,
            34,0,271,1,168,33,0,271,1,164,
            80,164,34,0,271,1,164,80,164,33,
            0,271,1,164,34,0,271,1,164,33,
            0,246,117,84,0,66,0,246,1,0,
            5,221,0,246,117,5,246,1,0,5,
            117,246,66,0,246,0,442,67,0,75,
            0,271,1,306,46,0,246,441,63,377,
            192,0,114,0,323,66,376,0,82,246,
            0,439,1,436,0,438,1,435,0,372,
            1,45,0,5,251,0,246,1,431,53,
            0,5,433,0,271,1,50,0,5,429,
            0,246,1,120,0,5,375,0,426,425,
            67,0,424,1,38,64,192,0,5,371,
            0,261,0,72,256,0,4,256,0,264,
            0,9,262,0,71,262,0,268,0,79,
            265,0,78,265,0,77,265,0,76,265,
            0,273,0,81,269,0,69,269,0,276,
            0,83,274,0,279,0,86,277,0,284,
            0,88,280,0,292,0,91,285,0,246,
            1,87,0,5,300,0,332,300,5,246,
            1,40,0,85,0,300,5,246,1,40,
            0,332,85,0,246,1,40,0,5,300,
            332,85,0,5,300,85,0,312,0,332,
            312,0,5,300,332,312,0,5,300,312,
            0,84,304,333,0,332,84,304,333,0,
            5,300,332,84,304,333,0,5,300,84,
            304,333,0,332,309,0,5,300,332,309,
            0,5,304,0,246,40,0,119,419,0,
            331,119,246,40,0,84,420,0,119,331,
            84,420,0,421,422,331,119,246,40,0,
            119,331,422,421,85,0,246,87,0,119,
            331,0,418,417,1,416,0,246,1,43,
            0,5,329,0,246,66,228,1,43,0,
            228,1,43,0,66,246,5,329,0,246,
            66,330,1,43,0,330,1,43,0,192,
            0,74,221,0,74,246,0,70,221,0,
            70,246,0,303,0,68,303,0,303,1,
            52,0,368,1,52,0,251,49,0,413,
            0,366,1,0,409,67,25,0,254,68,
            254,1,25,0,254,1,25,0,68,254,
            5,0,362,67,26,0,254,1,26,0,
            408,41,0,219,0,72,217,0,4,217,
            0,223,0,9,220,0,71,220,0,232,
            0,79,224,0,78,224,0,77,224,0,
            76,224,0,81,233,0,69,233,0,238,
            0,83,236,0,241,0,86,239,0,244,
            0,88,242,0,250,0,91,245,0,271,
            1,295,322,80,168,54,192,0,271,1,
            322,80,168,0,271,1,295,164,0,271,
            1,295,164,54,192,0,271,1,295,404,
            54,192,0,266,68,164,1,164,64,192,
            0,266,68,247,1,164,64,192,0,247,
            1,164,64,192,0,68,266,5,0,246,
            1,164,64,192,0,246,82,299,66,294,
            1,164,64,192,0,299,66,294,1,164,
            64,192,0,82,246,5,0,246,82,299,
            1,164,64,192,0,299,1,164,64,192,
            0,246,82,294,68,282,1,164,64,192,
            0,246,82,294,68,164,1,164,64,192,
            0,246,82,294,1,164,64,192,0,407,
            67,15,0,362,67,166,0,405,1,15,
            0,254,1,166,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            973,2227,2222,2065,1085,1063,0,12873,12776,12679,
            12579,12479,12128,12025,11922,11819,11570,11463,11351,11236,
            11118,2432,2293,1266,1124,2154,982,2012,10995,1870,
            840,0,3344,0,13162,1114,0,1195,13360,0,
            1540,1322,0,1327,1319,0,1355,0,13593,12094,
            13373,12002,1861,12763,11994,2142,11902,11886,11542,11534,
            11435,11427,11650,13588,1763,11315,1834,1496,11200,13364,
            1753,1742,1734,13583,13387,13382,1516,13359,1508,1717,
            1726,0,1579,2492,0,2432,2293,1266,1124,2154,
            982,2012,1870,3129,2934,2931,6228,2930,5865,11812,
            2933,840,2427,13157,13156,2426,2120,13155,12475,3242,
            6633,4275,2429,1526,2416,2287,2003,5032,4383,0,
            10907,10819,6397,10731,10643,10555,10467,10379,10291,10203,
            5354,5245,5121,6228,6138,10115,10027,2836,9939,7563,
            2708,6034,9851,9763,9675,5865,7475,5032,9587,9499,
            9411,9323,9235,4923,4814,4705,4596,7387,9147,9059,
            8971,8883,7299,3352,2571,8795,4472,8707,5702,8619,
            8531,8443,4383,8355,8267,4217,8179,8091,1629,8003,
            7211,4108,3242,3999,3890,3781,7095,5612,7007,7915,
            6919,7827,7739,3628,6831,6743,3041,2840,6575,1408,
            6487,5463,7651,3499,2012,1870,2432,2293,1266,1124,
            2154,982,840,0,13593,12094,13373,12002,1861,12763,
            11994,2142,11902,11886,11542,11534,11435,11427,11650,13588,
            1763,11315,1834,1496,11200,13364,1753,1742,1734,13583,
            13387,13382,1516,13359,1508,1717,1726,2432,2293,1266,
            1124,2154,982,2012,11118,11351,12128,12025,11922,11819,
            12873,12776,12579,12479,11570,11463,11236,10995,1870,12679,
            840,13303,13248,13100,13045,12970,5551,12417,12355,12293,
            12231,11748,11677,5790,6317,5954,3136,2935,10907,10819,
            6397,10731,10643,10555,10467,10379,10291,10203,5354,5245,
            5121,6228,6138,10115,10027,9939,7563,2708,6034,9851,
            9763,9675,5865,7475,5032,9587,9499,9411,9323,9235,
            4923,4814,4705,4596,7387,9147,9059,8971,8883,7299,
            3352,2571,8795,4472,8707,5702,8619,8531,8443,4383,
            8355,8267,8179,8091,8003,7211,4108,3242,3999,3890,
            3781,7095,5612,7007,7915,6919,7827,7739,3628,6831,
            6743,3041,2840,6575,6487,5463,7651,3499,4217,1629,
            1408,0,11118,11351,12128,12025,11922,11819,12873,12776,
            12579,12479,11570,11463,11236,10995,12679,1322,1540,2935,
            5954,11748,11677,5790,12970,5551,13303,13248,12417,12355,
            12293,12231,6317,3136,13100,13045,2432,2293,10907,10819,
            6397,2154,10731,10643,10555,10467,10379,10291,10203,5354,
            5245,5121,6228,6138,10115,10027,9939,7563,2708,6034,
            9851,9763,9675,5865,7475,5032,9587,9499,9411,9323,
            9235,4923,4814,4705,4596,7387,9147,9059,8971,8883,
            7299,3352,2571,8795,4472,8707,5702,8619,8531,8443,
            4383,8355,8267,8179,8091,8003,7211,4108,3242,3999,
            3890,3781,7095,5612,7007,7915,6919,7827,7739,3628,
            6831,6743,3041,2840,6575,6487,5463,7651,3499,1266,
            1124,982,2012,1870,840,4217,1629,1408,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,402,444,41,244,238,232,219,1,48,
            49,43,47,38,45,46,35,179,34,33,
            39,40,171,166,15,26,25,165,168,164,
            36,9,199,222,223,218,234,235,231,240,
            241,237,248,250,243,51,52,192,53,50,
            197,307,147,104,360,359,93,356,353,350,
            349,100,110,113,111,144,108,456,341,453,
            141,408,500,164,88,83,79,78,77,76,
            72,4,246,168,171,251,67,1,67,1,
            306,254,166,15,26,25,168,499,498,168,
            168,373,395,7,3,246,67,1,67,1,
            67,67,80,295,197,192,9,71,90,81,
            69,86,91,1,3,377,74,70,54,64,
            431,1,254,171,481,109,67,1,251,251,
            296,297,298,251,69,270,100,270,100,143,
            3,313,67,97,103,107,67,108,381,313,
            68,94,94,68,73,69,197,241,197,235,
            197,223,223,223,223,80,1,413,125,442,
            52,40,380,246,330,3,228,425,1,120,
            372,3,1,130,1,1,1,1,1,1,
            73,119,362,246,363,254,407,405,164,406,
            362,409,364,410,322,1,197,219,219,197,
            232,232,232,197,238,197,244,303,369,73,
            63,404,168,164,34,33,38,39,164,416,
            437,436,435,1,271,266,54,296,112,480,
            490,140,503,318,401,302,80,80,246,69,
            73,270,389,89,296,270,466,171,54,461,
            382,318,296,313,382,381,164,164,254,366,
            1,1,368,303,1,66,5,66,73,66,
            426,84,246,1,5,70,271,254,254,296,
            398,3,397,271,271,331,115,68,68,73,
            68,69,68,1,271,254,441,3,295,80,
            295,164,164,1,1,1,1,1,1,246,
            5,68,270,69,75,491,121,3,68,73,
            246,254,73,67,326,73,389,145,89,92,
            383,75,307,341,296,457,75,69,414,3,
            326,368,303,68,68,246,246,254,246,117,
            251,246,5,246,68,68,254,84,422,87,
            423,271,369,246,1,322,1,80,1,80,
            1,424,3,294,164,246,299,294,282,247,
            164,417,439,376,438,294,164,5,109,69,
            96,73,401,69,254,390,345,118,391,68,
            254,67,467,171,168,384,384,393,146,383,
            5,73,5,5,70,69,5,246,117,5,
            254,398,399,82,421,84,246,271,295,271,
            164,271,164,271,5,69,5,82,66,82,
            68,68,68,73,418,68,82,68,66,82,
            68,139,171,246,75,471,475,66,69,390,
            68,468,112,1,385,168,385,483,326,300,
            170,169,167,204,203,186,185,178,177,176,
            171,175,172,202,1,201,198,187,260,267,
            263,275,272,197,283,278,292,279,273,264,
            36,261,268,276,284,290,287,40,246,119,
            1,1,1,373,246,299,246,294,266,294,
            266,164,254,5,323,376,270,68,246,75,
            342,68,486,5,84,332,87,246,91,86,
            81,69,9,71,197,72,4,79,78,77,
            76,83,88,1,271,271,271,82,82,82,
            82,82,73,487,304,84,1,5,197,284,
            197,276,197,268,268,197,261,261,197,264,
            264,264,264,197,273,197,279,246,246,246,
            246,254,68,304,246,5,392,63,5,300,
            472,477,172,40,85,332,84,473,142,115,
            128,1,85,84,300,69,478,246,270,5,
            300,84,332
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "", //$NON-NLS-1$
            "+", //$NON-NLS-1$
            "-", //$NON-NLS-1$
            "*", //$NON-NLS-1$
            "/", //$NON-NLS-1$
            ">", //$NON-NLS-1$
            "<", //$NON-NLS-1$
            "=", //$NON-NLS-1$
            ">=", //$NON-NLS-1$
            "<=", //$NON-NLS-1$
            "<>", //$NON-NLS-1$
            "(", //$NON-NLS-1$
            ")", //$NON-NLS-1$
            "{", //$NON-NLS-1$
            "}", //$NON-NLS-1$
            "[", //$NON-NLS-1$
            "]", //$NON-NLS-1$
            "->", //$NON-NLS-1$
            "|", //$NON-NLS-1$
            ",", //$NON-NLS-1$
            ":", //$NON-NLS-1$
            "::", //$NON-NLS-1$
            ";", //$NON-NLS-1$
            ".", //$NON-NLS-1$
            "..", //$NON-NLS-1$
            ":=", //$NON-NLS-1$
            "+=", //$NON-NLS-1$
            "!", //$NON-NLS-1$
            "::=", //$NON-NLS-1$
            "?", //$NON-NLS-1$
            "<<", //$NON-NLS-1$
            ">>", //$NON-NLS-1$
            "...", //$NON-NLS-1$
            "~", //$NON-NLS-1$
            "!=", //$NON-NLS-1$
            "@", //$NON-NLS-1$
            "$empty", //$NON-NLS-1$
            "QUOTED_IDENTIFIER", //$NON-NLS-1$
            "INTEGER_LITERAL", //$NON-NLS-1$
            "REAL_LITERAL", //$NON-NLS-1$
            "STRING_LITERAL", //$NON-NLS-1$
            "SINGLE_LINE_COMMENT", //$NON-NLS-1$
            "MULTI_LINE_COMMENT", //$NON-NLS-1$
            "and", //$NON-NLS-1$
            "implies", //$NON-NLS-1$
            "not", //$NON-NLS-1$
            "or", //$NON-NLS-1$
            "xor", //$NON-NLS-1$
            "if", //$NON-NLS-1$
            "then", //$NON-NLS-1$
            "else", //$NON-NLS-1$
            "endif", //$NON-NLS-1$
            "let", //$NON-NLS-1$
            "in", //$NON-NLS-1$
            "false", //$NON-NLS-1$
            "true", //$NON-NLS-1$
            "null", //$NON-NLS-1$
            "invalid", //$NON-NLS-1$
            "self", //$NON-NLS-1$
            "Bag", //$NON-NLS-1$
            "Collection", //$NON-NLS-1$
            "OrderedSet", //$NON-NLS-1$
            "Sequence", //$NON-NLS-1$
            "Set", //$NON-NLS-1$
            "Tuple", //$NON-NLS-1$
            "Boolean", //$NON-NLS-1$
            "Integer", //$NON-NLS-1$
            "Real", //$NON-NLS-1$
            "String", //$NON-NLS-1$
            "UnlimitedNatural", //$NON-NLS-1$
            "OclAny", //$NON-NLS-1$
            "OclInvalid", //$NON-NLS-1$
            "OclVoid", //$NON-NLS-1$
            "Dict", //$NON-NLS-1$
            "List", //$NON-NLS-1$
            "break", //$NON-NLS-1$
            "switch", //$NON-NLS-1$
            "case", //$NON-NLS-1$
            "xselect", //$NON-NLS-1$
            "xcollect", //$NON-NLS-1$
            "selectOne", //$NON-NLS-1$
            "collectOne", //$NON-NLS-1$
            "collectselect", //$NON-NLS-1$
            "collectselectOne", //$NON-NLS-1$
            "return", //$NON-NLS-1$
            "forEach", //$NON-NLS-1$
            "forOne", //$NON-NLS-1$
            "var", //$NON-NLS-1$
            "while", //$NON-NLS-1$
            "continue", //$NON-NLS-1$
            "log", //$NON-NLS-1$
            "assert", //$NON-NLS-1$
            "with", //$NON-NLS-1$
            "compute", //$NON-NLS-1$
            "new", //$NON-NLS-1$
            "init", //$NON-NLS-1$
            "static", //$NON-NLS-1$
            "end", //$NON-NLS-1$
            "out", //$NON-NLS-1$
            "object", //$NON-NLS-1$
            "transformation", //$NON-NLS-1$
            "import", //$NON-NLS-1$
            "library", //$NON-NLS-1$
            "metamodel", //$NON-NLS-1$
            "mapping", //$NON-NLS-1$
            "query", //$NON-NLS-1$
            "helper", //$NON-NLS-1$
            "inout", //$NON-NLS-1$
            "when", //$NON-NLS-1$
            "configuration", //$NON-NLS-1$
            "intermediate", //$NON-NLS-1$
            "property", //$NON-NLS-1$
            "opposites", //$NON-NLS-1$
            "class", //$NON-NLS-1$
            "population", //$NON-NLS-1$
            "map", //$NON-NLS-1$
            "xmap", //$NON-NLS-1$
            "late", //$NON-NLS-1$
            "resolve", //$NON-NLS-1$
            "resolveone", //$NON-NLS-1$
            "resolveIn", //$NON-NLS-1$
            "resolveoneIn", //$NON-NLS-1$
            "invresolve", //$NON-NLS-1$
            "invresolveone", //$NON-NLS-1$
            "invresolveIn", //$NON-NLS-1$
            "invresolveoneIn", //$NON-NLS-1$
            "modeltype", //$NON-NLS-1$
            "uses", //$NON-NLS-1$
            "where", //$NON-NLS-1$
            "refines", //$NON-NLS-1$
            "access", //$NON-NLS-1$
            "extends", //$NON-NLS-1$
            "blackbox", //$NON-NLS-1$
            "abstract", //$NON-NLS-1$
            "result", //$NON-NLS-1$
            "main", //$NON-NLS-1$
            "this", //$NON-NLS-1$
            "rename", //$NON-NLS-1$
            "disjuncts", //$NON-NLS-1$
            "merges", //$NON-NLS-1$
            "inherits", //$NON-NLS-1$
            "composes", //$NON-NLS-1$
            "constructor", //$NON-NLS-1$
            "datatype", //$NON-NLS-1$
            "default", //$NON-NLS-1$
            "derived", //$NON-NLS-1$
            "do", //$NON-NLS-1$
            "elif", //$NON-NLS-1$
            "enum", //$NON-NLS-1$
            "except", //$NON-NLS-1$
            "exception", //$NON-NLS-1$
            "from", //$NON-NLS-1$
            "literal", //$NON-NLS-1$
            "ordered", //$NON-NLS-1$
            "primitive", //$NON-NLS-1$
            "raise", //$NON-NLS-1$
            "readonly", //$NON-NLS-1$
            "references", //$NON-NLS-1$
            "tag", //$NON-NLS-1$
            "try", //$NON-NLS-1$
            "typedef", //$NON-NLS-1$
            "unlimited", //$NON-NLS-1$
            "ERROR_TOKEN", //$NON-NLS-1$
            "IDENTIFIER", //$NON-NLS-1$
            "EOF_TOKEN", //$NON-NLS-1$
            "conceptualOperationNameCS", //$NON-NLS-1$
            "CollectionTypeIdentifierCS", //$NON-NLS-1$
            "primitiveTypeCS", //$NON-NLS-1$
            "simpleNameCS", //$NON-NLS-1$
            "QuotedSimpleNameCS", //$NON-NLS-1$
            "unreservedSimpleNameCS", //$NON-NLS-1$
            "pathNameCS", //$NON-NLS-1$
            "typeCS", //$NON-NLS-1$
            "collectionTypeCS", //$NON-NLS-1$
            "tupleTypeCS", //$NON-NLS-1$
            "tupleTypePartsCS", //$NON-NLS-1$
            "typedUninitializedVariableCS", //$NON-NLS-1$
            "untypedInitializedVariableCS", //$NON-NLS-1$
            "OclExpressionCS", //$NON-NLS-1$
            "typedInitializedVariableCS", //$NON-NLS-1$
            "initializedVariableCS", //$NON-NLS-1$
            "uninitializedVariableCS", //$NON-NLS-1$
            "CollectionLiteralExpCS", //$NON-NLS-1$
            "TupleLiteralExpCS", //$NON-NLS-1$
            "CollectionLiteralPartsCS", //$NON-NLS-1$
            "CollectionLiteralPartCS", //$NON-NLS-1$
            "IntegerLiteralExpCS", //$NON-NLS-1$
            "RealLiteralExpCS", //$NON-NLS-1$
            "StringLiteralExpCS", //$NON-NLS-1$
            "BooleanLiteralExpCS", //$NON-NLS-1$
            "UnlimitedNaturalLiteralExpCS", //$NON-NLS-1$
            "InvalidLiteralExpCS", //$NON-NLS-1$
            "NullLiteralExpCS", //$NON-NLS-1$
            "TupleLiteralPartsCS", //$NON-NLS-1$
            "CallExpCS", //$NON-NLS-1$
            "primaryExpCS", //$NON-NLS-1$
            "notNameExpressionCS", //$NON-NLS-1$
            "argumentsCS", //$NON-NLS-1$
            "SimpleNameExpCS", //$NON-NLS-1$
            "VariableExpCS", //$NON-NLS-1$
            "impliesNotNameNotLetCS", //$NON-NLS-1$
            "impliesNotLetCS", //$NON-NLS-1$
            "xorNotNameNotLetCS", //$NON-NLS-1$
            "xorNotLetCS", //$NON-NLS-1$
            "xorWithLetCS", //$NON-NLS-1$
            "orNotNameNotLetCS", //$NON-NLS-1$
            "orNotLetCS", //$NON-NLS-1$
            "orWithLetCS", //$NON-NLS-1$
            "andNotNameNotLetCS", //$NON-NLS-1$
            "andNotLetCS", //$NON-NLS-1$
            "andWithLetCS", //$NON-NLS-1$
            "equalityNotNameNotLetCS", //$NON-NLS-1$
            "equalityNotLetCS", //$NON-NLS-1$
            "equalityWithLetCS", //$NON-NLS-1$
            "relationalNotNameNotLetCS", //$NON-NLS-1$
            "relationalNotLetCS", //$NON-NLS-1$
            "relationalWithLetCS", //$NON-NLS-1$
            "additiveNotNameNotLetCS", //$NON-NLS-1$
            "additiveNotLetCS", //$NON-NLS-1$
            "additiveWithLetCS", //$NON-NLS-1$
            "multiplicativeNotNameNotLetCS", //$NON-NLS-1$
            "multiplicativeNotLetCS", //$NON-NLS-1$
            "multiplicativeWithLetCS", //$NON-NLS-1$
            "unaryNotLetCS", //$NON-NLS-1$
            "unaryWithLetCS", //$NON-NLS-1$
            "primaryNotNameCS", //$NON-NLS-1$
            "IfExpCS", //$NON-NLS-1$
            "letVariablesCS", //$NON-NLS-1$
            "ImperativeExpCS", //$NON-NLS-1$
            "listLiteralCS", //$NON-NLS-1$
            "dictLiteralCS", //$NON-NLS-1$
            "literalSimpleCS", //$NON-NLS-1$
            "dictLiteralPartCS", //$NON-NLS-1$
            "dictLiteralPartListCS", //$NON-NLS-1$
            "qvtErrorToken", //$NON-NLS-1$
            "expression_block", //$NON-NLS-1$
            "CatchExp_list", //$NON-NLS-1$
            "CatchExp", //$NON-NLS-1$
            "type_list", //$NON-NLS-1$
            "expression_semi_list_element", //$NON-NLS-1$
            "var_init_declarator_list", //$NON-NLS-1$
            "var_init_declarator", //$NON-NLS-1$
            "var_init_op", //$NON-NLS-1$
            "assignStatementCS", //$NON-NLS-1$
            "whileBodyCS", //$NON-NLS-1$
            "declarator1", //$NON-NLS-1$
            "forExpCS", //$NON-NLS-1$
            "forOpCode", //$NON-NLS-1$
            "forExpDeclaratorList", //$NON-NLS-1$
            "ifExpBodyCS", //$NON-NLS-1$
            "ifThenPart", //$NON-NLS-1$
            "ifElsePart", //$NON-NLS-1$
            "ifExpression", //$NON-NLS-1$
            "ifElif_list", //$NON-NLS-1$
            "ifElif_listElem", //$NON-NLS-1$
            "notUMinus_ifExpBodyCS", //$NON-NLS-1$
            "notUMinus_ifExpBodyCS_full", //$NON-NLS-1$
            "ifElif_ext_list", //$NON-NLS-1$
            "mandatory_elsePart", //$NON-NLS-1$
            "ifElif_ext_listElem", //$NON-NLS-1$
            "notUMinus_statement", //$NON-NLS-1$
            "notUMinus_impliesNotNameNotLet" + //$NON-NLS-1$
            "CS", //$NON-NLS-1$
            "notUMinus_impliesNotLetCS", //$NON-NLS-1$
            "notUMinus_xorNotNameNotLetCS", //$NON-NLS-1$
            "notUMinus_xorNotLetCS", //$NON-NLS-1$
            "notUMinus_xorWithLetCS", //$NON-NLS-1$
            "notUMinus_orNotNameNotLetCS", //$NON-NLS-1$
            "notUMinus_orNotLetCS", //$NON-NLS-1$
            "notUMinus_orWithLetCS", //$NON-NLS-1$
            "notUMinus_andNotNameNotLetCS", //$NON-NLS-1$
            "notUMinus_andNotLetCS", //$NON-NLS-1$
            "notUMinus_andWithLetCS", //$NON-NLS-1$
            "notUMinus_equalityNotNameNotLe" + //$NON-NLS-1$
            "tCS", //$NON-NLS-1$
            "notUMinus_equalityNotLetCS", //$NON-NLS-1$
            "notUMinus_equalityWithLetCS", //$NON-NLS-1$
            "notUMinus_relationalNotNameNot" + //$NON-NLS-1$
            "LetCS", //$NON-NLS-1$
            "notUMinus_relationalNotLetCS", //$NON-NLS-1$
            "notUMinus_relationalWithLetCS", //$NON-NLS-1$
            "notUMinus_additiveNotNameNotLe" + //$NON-NLS-1$
            "tCS", //$NON-NLS-1$
            "notUMinus_additiveNotLetCS", //$NON-NLS-1$
            "notUMinus_additiveWithLetCS", //$NON-NLS-1$
            "notUMinus_multiplicativeNotNam" + //$NON-NLS-1$
            "eNotLetCS", //$NON-NLS-1$
            "notUMinus_multiplicativeNotLet" + //$NON-NLS-1$
            "CS", //$NON-NLS-1$
            "notUMinus_multiplicativeWithLe" + //$NON-NLS-1$
            "tCS", //$NON-NLS-1$
            "notUMinus_unaryNotLetCS", //$NON-NLS-1$
            "notUMinus_unaryWithLetCS", //$NON-NLS-1$
            "switchBodyExpCS", //$NON-NLS-1$
            "switchDeclaratorCS", //$NON-NLS-1$
            "declarator", //$NON-NLS-1$
            "objectDeclCS", //$NON-NLS-1$
            "switchAltExpCSList", //$NON-NLS-1$
            "switchAltExpCS", //$NON-NLS-1$
            "expression_statement", //$NON-NLS-1$
            "logExpCS", //$NON-NLS-1$
            "imperativeIterateExpCS", //$NON-NLS-1$
            "imperativeIteratorExpCSToken12", //$NON-NLS-1$
            "imperativeIteratorExpCSToken3", //$NON-NLS-1$
            "imperativeIteratorExpCSToken", //$NON-NLS-1$
            "imperativeIterContents12", //$NON-NLS-1$
            "imperativeIterContents3", //$NON-NLS-1$
            "variableDeclarationListCS", //$NON-NLS-1$
            "typespec", //$NON-NLS-1$
            "expression_semi_list", //$NON-NLS-1$
            "unit_element", //$NON-NLS-1$
            "unit", //$NON-NLS-1$
            "importDeclaration", //$NON-NLS-1$
            "qualifiedNameCS", //$NON-NLS-1$
            "_tag", //$NON-NLS-1$
            "transformation_h", //$NON-NLS-1$
            "library_h", //$NON-NLS-1$
            "transformation_signature", //$NON-NLS-1$
            "module_usageList", //$NON-NLS-1$
            "simple_signature", //$NON-NLS-1$
            "moduleref", //$NON-NLS-1$
            "libraryDeclaration", //$NON-NLS-1$
            "module_usage", //$NON-NLS-1$
            "moduleref_list", //$NON-NLS-1$
            "module_element", //$NON-NLS-1$
            "packageref_list", //$NON-NLS-1$
            "modeltypeDeclaration", //$NON-NLS-1$
            "packageref", //$NON-NLS-1$
            "uri", //$NON-NLS-1$
            "qvtIdentifierCS", //$NON-NLS-1$
            "classifierFeatureList", //$NON-NLS-1$
            "classifierFeatureCS", //$NON-NLS-1$
            "identifier_list", //$NON-NLS-1$
            "feature_key", //$NON-NLS-1$
            "multiplicity_range", //$NON-NLS-1$
            "scoped_identifier", //$NON-NLS-1$
            "helper_header", //$NON-NLS-1$
            "helper_info", //$NON-NLS-1$
            "complete_signature", //$NON-NLS-1$
            "helper_kind", //$NON-NLS-1$
            "constructor_header", //$NON-NLS-1$
            "entry_header", //$NON-NLS-1$
            "mapping_full_header", //$NON-NLS-1$
            "mapping_header", //$NON-NLS-1$
            "mapping_extra", //$NON-NLS-1$
            "mapping_extension_key", //$NON-NLS-1$
            "scoped_identifier_list", //$NON-NLS-1$
            "objectIdentifierCS", //$NON-NLS-1$
            "featureMappingCallExpCS", //$NON-NLS-1$
            "resolveOpArgsExpCS", //$NON-NLS-1$
            "resolveOp", //$NON-NLS-1$
            "resolveInOp", //$NON-NLS-1$
            "resolveResolveInExpCS", //$NON-NLS-1$
            "letExpSubCS3", //$NON-NLS-1$
            "qualifier", //$NON-NLS-1$
            "param_list", //$NON-NLS-1$
            "param", //$NON-NLS-1$
            "typeCS2", //$NON-NLS-1$
            "scoped_identifier2" //$NON-NLS-1$
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
